/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.dicomdir.Dicomdir;
import com.ge.med.terra.tap.dm.dicomdir.DicomdirComposite;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryEntityLevel;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecord;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.sessionFile.fileImageManager;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;

public class DicomdirObject
implements DMiObject,
DMTagValueInterface {
    private long offset = -1L;
    private String level;
    private Set<tagValue> tags;
    private DicomdirComposite repComposite = null;
    private Dicomdir dicomdir = null;
    private DirectoryRecord thisDR;

    public DicomdirObject(String deLevel, Dicomdir dicomdir, long offset, Set<tagValue> tags) {
        if (deLevel == null) {
            throw new DMException("Directory Entity Level cannot be null.");
        }
        this.level = deLevel.trim().toUpperCase(Locale.ENGLISH);
        this.dicomdir = dicomdir;
        this.offset = offset;
        this.tags = tags;
        this.thisDR = dicomdir.getDirectoryRecord(this.level, offset);
    }

    @Override
    public String getID() {
        return Long.toString(this.offset);
    }

    @Override
    public String getType() {
        return this.level;
    }

    @Override
    public Object getValue(DMTag t) {
        if (this.tags != null && this.tags.size() > 0) {
            for (tagValue tv : this.tags) {
                if (tv.group != t.getGroup() || tv.element != t.getElement()) continue;
                return tv.value;
            }
        }
        Object val = this.getRepComposite().getValue(t);
        return val;
    }

    @Override
    public void getValues(DMElement[] elements) {
        this.getRepComposite().getValues(elements);
    }

    @Override
    public void setValues(DMElement[] elements) {
        if (this.dicomdir.isReadOnly()) {
            throw new RuntimeException("Can't update: READ-ONLY Media");
        }
        throw new UnsupportedOperationException("Method setValues() is unsupported.");
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q) {
        DirectoryRecord thisDR = this.dicomdir.getDirectoryRecord(this.level, this.offset);
        DirectoryRecord[] drs = this.dicomdir.getAllCompositeDirectoryRecords(thisDR);
        ArrayList<DicomdirComposite> compList = new ArrayList<DicomdirComposite>(drs.length);
        for (int i = 0; i < drs.length; ++i) {
            DicomdirObject obj = new DicomdirObject(drs[i].getLevel(), this.dicomdir, drs[i].getOffset(), drs[i].getTags());
            if (q != null && !q.valid(obj)) continue;
            compList.add(new DicomdirComposite(drs[i].getType(), new File(drs[i].getRepCompositePath()), this.dicomdir));
        }
        if (compList.size() > 0) {
            this.repComposite = (DicomdirComposite)compList.get(0);
        }
        return compList.toArray(new DMiComposite[compList.size()]);
    }

    @Override
    public int getNumberOfComposites(DMQuery q) {
        return this.getComposites(q).length;
    }

    public DicomdirComposite getRepComposite() {
        File fl;
        if (null != this.repComposite && (fl = new File(this.repComposite.getFilePath())).exists()) {
            return this.repComposite;
        }
        String compositePath = this.thisDR.getRepCompositePath();
        if (null != compositePath) {
            this.repComposite = new DicomdirComposite(new File(compositePath), this.dicomdir);
        } else {
            this.thisDR = this.dicomdir.getAllCompositeDirectoryRecords(this.thisDR)[0];
            this.repComposite = new DicomdirComposite(new File(this.thisDR.getRepCompositePath()), this.dicomdir);
        }
        Set<tagValue> tvs = this.thisDR.getTags();
        for (tagValue tv : tvs) {
            if (tv.group == 4) continue;
            this.repComposite.elemCache.put(new DMTag(tv.group, tv.element), tv);
        }
        return this.repComposite;
    }

    @Override
    public DMTag[] getTags() {
        DMTag[] dmts = new DMTag[this.tags.size()];
        int i = 0;
        for (tagValue tv : this.tags) {
            dmts[i] = new DMTag(tv.group, tv.element);
            ++i;
        }
        return dmts;
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        DMiComposite[] comp = this.getComposites(null);
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>(comp.length);
        for (int i = 0; i < comp.length; ++i) {
            BufferedImage[] imgs = comp[i].getPixelData(tags);
            for (int k = 0; k < imgs.length; ++k) {
                list.add(imgs[k]);
            }
        }
        return list.toArray(new BufferedImage[list.size()]);
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        fileImageManager.getInstance().setPause(true);
        DMiComposite[] comp = this.getComposites(null);
        ArrayList<DMiImage> al = new ArrayList<DMiImage>(comp.length);
        for (int i = 0; i < comp.length; ++i) {
            DMiImage[] imgs = comp[i].getImages(tags);
            for (int k = 0; k < imgs.length; ++k) {
                al.add(imgs[k]);
            }
        }
        fileImageManager.getInstance().setPause(false);
        return al.toArray(new DMiImage[al.size()]);
    }

    @Override
    public DMiObject[] getRelated(String deLevel, DMQuery q) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject ob) {
                list.add(ob);
                return true;
            }
        };
        this.getRelated(deLevel, q, rcvr);
        return list.toArray(new DMiObject[list.size()]);
    }

    @Override
    public void getRelated(String deLevel, DMQuery q, DMiObjectReceiver cb) {
        String queryLevelName;
        int queryLevel;
        int myLevel = DirectoryEntityLevel.getIndex(this.level);
        if (myLevel == (queryLevel = DirectoryEntityLevel.getIndex(queryLevelName = deLevel.trim().toUpperCase(Locale.ENGLISH)))) {
            if ((q == null || q.valid(this)) && !cb.gotOne(this)) {
                return;
            }
        } else if (queryLevel > myLevel) {
            DirectoryRecord dr = this.dicomdir.getDirectoryRecord(this.level, this.offset);
            DirectoryRecord[] drs = this.dicomdir.getChildDirectoryRecords(dr, queryLevelName);
            for (int i = 0; i < drs.length; ++i) {
                DicomdirObject obj = new DicomdirObject(queryLevelName, this.dicomdir, drs[i].getOffset(), drs[i].getTags());
                if (q != null && !q.valid(obj) || cb.gotOne(obj)) continue;
                return;
            }
        } else {
            DirectoryRecord dr = this.dicomdir.getDirectoryRecord(this.level, this.offset);
            DirectoryRecord parentDR = this.dicomdir.getParentDirectoryRecord(dr, queryLevelName);
            if (null == parentDR) {
                return;
            }
            DicomdirObject obj = new DicomdirObject(queryLevelName, this.dicomdir, parentDR.getOffset(), parentDR.getTags());
            if ((q == null || q.valid(obj)) && !cb.gotOne(obj)) {
                return;
            }
        }
    }

    @Override
    public int getNumberOfRelated(String deLevel, DMQuery q) {
        return this.getRelated(deLevel, q).length;
    }

    @Override
    public void delete() {
        if (this.dicomdir.isReadOnly()) {
            throw new RuntimeException("Can't Delete: READ-ONLY Media");
        }
        DirectoryRecord dr = this.dicomdir.getDirectoryRecord(this.level, this.offset);
        if ("PATIENT".equalsIgnoreCase(this.level)) {
            this.dicomdir.deletePatient(dr);
            return;
        }
        DirectoryRecord parentDR = this.getParentDirectoryRecord(dr);
        if (dr.getNextSiblingOffset() > 0L) {
            if (parentDR != null) {
                DirectoryRecord[] childDRs = this.dicomdir.getChildDirectoryRecords(parentDR);
                for (int i = 0; i < childDRs.length; ++i) {
                    if (childDRs[i].getNextSiblingOffset() != this.offset) continue;
                    childDRs[i].writeNextSiblingOffsetToDICOMDIR(dr.getNextSiblingOffset());
                    this.dicomdir.deletePhysicalFiles(dr);
                    return;
                }
                if (parentDR.getFirstChildOffset() == this.offset) {
                    parentDR.writeChildOffsetToDICOMDIR(dr.getNextSiblingOffset());
                }
                this.dicomdir.deletePhysicalFiles(dr);
                return;
            }
        } else if (parentDR != null) {
            DirectoryRecord[] childDRs = this.dicomdir.getChildDirectoryRecords(parentDR);
            for (int i = 0; i < childDRs.length; ++i) {
                if (childDRs[i].getOffset() != this.offset && childDRs[i].getNextSiblingOffset() != this.offset) continue;
                childDRs[i].writeNextSiblingOffsetToDICOMDIR(0L);
                this.dicomdir.deletePhysicalFiles(dr);
                break;
            }
            if (childDRs.length == 1) {
                new DicomdirObject(parentDR.getLevel(), this.dicomdir, parentDR.getOffset(), parentDR.getTags()).delete();
            }
        }
    }

    private DirectoryRecord getParentDirectoryRecord(DirectoryRecord child) {
        if ("PATIENT".equalsIgnoreCase(child.getLevel())) {
            return null;
        }
        if ("STUDY".equalsIgnoreCase(child.getLevel())) {
            return this.dicomdir.getParentDirectoryRecord(child, "PATIENT");
        }
        if ("SERIES".equalsIgnoreCase(child.getLevel())) {
            return this.dicomdir.getParentDirectoryRecord(child, "STUDY");
        }
        if ("IMAGE".equalsIgnoreCase(child.getLevel())) {
            return this.dicomdir.getParentDirectoryRecord(child, "SERIES");
        }
        return null;
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }

    @Override
    public void setLock(int lockType) {
        throw new UnsupportedOperationException("Method setLock() not yet implemented.");
    }

    @Override
    public int getLock() {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    public String toString() {
        String str = "[id=" + this.getID() + ", type=" + this.getType() + "]";
        return str;
    }
}

