/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.idc.XjLoader;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMJob;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMObjectReceiver;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.dm.peer.DMiSessionFactory;
import com.ge.med.terra.tap.dm.ram.RAMSessionFactory;
import com.ge.med.terra.tap.dm.sessionNull.nullSession;
import com.ge.med.terra.tap.util.SimpleUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

public class DMSession {
    DMiSession peer;
    public static boolean TAP_TRACE_FLAG;
    private static HashMap<String, DMiSessionFactory> sessFactories;
    private static HashMap<List<String>, DMSession> factorymap;
    private Hashtable properties = new Hashtable();

    public static void insertSession(String type, String className) {
        sessFactories.put(type, new LocalSessionFactory(className));
    }

    public static void insertSession(String type, DMiSessionFactory sessFactory) {
        sessFactories.put(type, sessFactory);
    }

    private static DMiSession getSession(String type) {
        DMiSessionFactory sessFactory = sessFactories.get(type);
        if (sessFactory == null) {
            String classname = type;
            sessFactory = new LocalSessionFactory(classname);
        }
        return sessFactory.createSession();
    }

    public static DMSession getSession(String[] args) {
        List<String> l = Arrays.asList(args);
        if (!factorymap.containsKey(l)) {
            factorymap.put(l, new DMSession(args));
        }
        return factorymap.get(l);
    }

    public static void removeSession(DMSession dms) {
        if (!factorymap.containsValue(dms)) {
            return;
        }
        List<String> theKey = null;
        for (List<String> key : factorymap.keySet()) {
            DMSession d = factorymap.get(key);
            if (d != dms) continue;
            theKey = key;
            break;
        }
        if (theKey != null) {
            factorymap.remove(theKey);
        }
    }

    public static void removeSession(DMiSession dms) {
        List<String> theKey = null;
        for (List<String> key : factorymap.keySet()) {
            DMSession d = factorymap.get(key);
            if (d.peer != dms) continue;
            theKey = key;
            break;
        }
        if (theKey != null) {
            factorymap.remove(theKey);
        }
    }

    public DMSession() {
        this.peer = DMSession.getSession("default");
    }

    public DMSession(DMiSession peer) {
        this.peer = peer;
    }

    public DMSession(String[] config) {
        String type = null;
        String rep = null;
        String[] args = null;
        if (config.length > 0) {
            type = config[0];
        }
        if (config.length > 1) {
            rep = config[1];
        }
        if (config.length > 2) {
            args = new String[config.length - 2];
            for (int i = 2; i < config.length; ++i) {
                args[i - 2] = config[i];
            }
        }
        this.setup(type, rep, args);
    }

    public DMSession(String type, String rep, String[] args) {
        this.setup(type, rep, args);
    }

    public DMSession(String type, String rep, String name, String[] args) {
        String[] nargs = null;
        if (name != null) {
            if (args == null) {
                nargs = new String[]{name};
            } else {
                nargs = new String[1 + args.length];
                nargs[0] = name;
                System.arraycopy(args, 0, nargs, 1, args.length);
            }
        }
        this.setup(type, rep, nargs);
    }

    private void setup(String type, String rep, String[] args) {
        if (type != null) {
            this.setProperty(DMUtils.PROPERTY_SESSION_TYPE, type);
        }
        if (rep != null) {
            this.setProperty(DMUtils.PROPERTY_SESSION_REP, rep);
        }
        if (args != null) {
            this.setProperty(DMUtils.PROPERTY_SESSION_ARGS, args);
        }
        this.peer = DMSession.getSession(type);
        this.peer.init(rep, args);
    }

    public DMComposite[] getComposites() {
        DMiComposite[] ci = this.peer.getComposites();
        DMComposite[] c = new DMComposite[ci.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = new DMComposite(ci[i], this);
        }
        return c;
    }

    public DMComposite getComposite(String id) {
        DMiComposite ci = this.peer.getComposite(id);
        if (ci == null) {
            return null;
        }
        return new DMComposite(ci, this);
    }

    public int getNumberOfComposites() {
        return this.peer.getNumberOfComposites();
    }

    public DMObject[] getChildren() {
        return this.getChildren(null);
    }

    public DMObject[] getChildren(DMQuery q) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("getChildren(" + q + ")");
        }
        DMiObject[] oi = this.peer.getChildren(q);
        DMObject[] o = new DMObject[oi.length];
        for (int i = 0; i < o.length; ++i) {
            o[i] = new DMObject(oi[i], this);
        }
        return o;
    }

    public void getChildren(DMQuery q, final DMObjectReceiver cb) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("getChildren(" + q + ",cb)");
        }
        final DMSession session = this;
        this.peer.getChildren(q, new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject o) {
                return cb.gotOne(new DMObject(o, session));
            }
        });
    }

    public DMObject[] getRelated(String ieType) {
        return this.getRelated(ieType, null);
    }

    public DMObject[] getRelated(String ieType, DMQuery q) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("getRelated(" + ieType + "," + q + ")");
        }
        DMiObject[] oi = this.peer.getRelated(ieType, q);
        DMObject[] o = new DMObject[oi.length];
        for (int i = 0; i < o.length; ++i) {
            o[i] = new DMObject(oi[i], this);
        }
        return o;
    }

    public void getRelated(String ieType, DMQuery q, final DMObjectReceiver cb) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("getRelated(" + ieType + "," + q + ",cb)");
        }
        final DMSession session = this;
        this.peer.getRelated(ieType, q, new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject o) {
                return cb.gotOne(new DMObject(o, session));
            }
        });
    }

    public void save(DMObject dmo) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("save(dmo)");
        }
        Hashtable<String, Object> prop = new Hashtable<String, Object>();
        prop.put("To", this);
        prop.put("From", dmo.getSession());
        prop.put("Date", new Date());
        prop.put("Object", dmo);
        this.peer.save(dmo.peer, prop);
    }

    public void save(DMObject[] dmo) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("save([]dmo)");
        }
        Hashtable<String, Object> prop = new Hashtable<String, Object>();
        prop.put("To", this);
        prop.put("From", dmo[0].getSession());
        prop.put("Date", new Date());
        prop.put("Object", dmo);
        DMiObject[] obj = new DMiObject[dmo.length];
        for (int i = 0; i < dmo.length; ++i) {
            obj[i] = dmo[i].getPeer();
        }
        this.peer.save(obj, prop);
    }

    public void save(DMComposite dmc) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("save(DMComposite dmc)");
        }
        Hashtable<String, Object> prop = new Hashtable<String, Object>();
        prop.put("To", this);
        prop.put("From", dmc.getSession());
        prop.put("Date", new Date());
        prop.put("Composite", dmc);
        this.peer.save(dmc.peer, prop);
    }

    public void addDMEventListener(int eventType, DMEventListener listener) {
        this.addDMEventListener(eventType, 0, listener);
    }

    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("addDMEventListener(" + eventType + "," + freq + ",listener)");
        }
        this.peer.addDMEventListener(eventType, freq, listener);
    }

    public void removeDMEventListener(DMEventListener listener) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("removeDMEventListener(listener)");
        }
        this.peer.removeDMEventListener(listener);
    }

    public DMiSession getPeer() {
        return this.peer;
    }

    public void ClearCache() {
        this.peer.ClearCache();
    }

    public void install(InputStream is) throws IOException {
        this.peer.install(is);
    }

    public void installFiles(File[] files) throws FileNotFoundException, IOException {
        this.peer.installFiles(files, false);
    }

    public void installFiles(File[] files, boolean destroy) throws FileNotFoundException, IOException {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("installFiles([" + (files.length > 0 ? files[0] + "..." + files.length : "") + "]," + destroy);
        }
        Vector<Object> vect = new Vector<Object>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                vect.add(SimpleUtilities.getFilesRecursively(files[i]));
                continue;
            }
            vect.add(files[i]);
        }
        File[] actualFiles = new File[vect.size()];
        for (int i = 0; i < actualFiles.length; ++i) {
            actualFiles[i] = (File)vect.get(i);
        }
        this.peer.installFiles(actualFiles, destroy);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public String[] getSessionArgs() {
        String type = (String)this.getProperty(DMUtils.PROPERTY_SESSION_TYPE);
        String rep = (String)this.getProperty(DMUtils.PROPERTY_SESSION_REP);
        String[] args = (String[])this.getProperty(DMUtils.PROPERTY_SESSION_ARGS);
        if (args == null) {
            args = new String[]{};
        }
        String[] ret = new String[2 + args.length];
        ret[0] = type;
        ret[1] = rep;
        System.arraycopy(args, 0, ret, 2, args.length);
        return ret;
    }

    public DMObject getDMObject(String type, String id) {
        DMiObject object = this.peer.getDMiObject(type, id);
        if (object == null) {
            return null;
        }
        return new DMObject(object, this);
    }

    public String[] send(String str) {
        return this.peer.send(str);
    }

    public DMJob asyncSend(String str) {
        return new DMJob(this.peer.asynSend(str));
    }

    public DMJob[] getJobs() {
        DMiJob[] iJobs = this.peer.getJobs();
        if (iJobs != null) {
            DMJob[] jobs = new DMJob[iJobs.length];
            for (int i = 0; i < jobs.length; ++i) {
                jobs[i] = new DMJob(iJobs[i]);
            }
            return jobs;
        }
        return null;
    }

    public void close() {
        this.peer.close();
        DMSession.removeSession(this);
    }

    static {
        XjLoader.initialize();
        TAP_TRACE_FLAG = Tap.logLevel == Tap.LEVEL_FINEST;
        sessFactories = new HashMap(13);
        DMSession.insertSession("default", new LocalSessionFactory("com.ge.med.terra.tap.dm.sessionNull.nullSession"));
        DMSession.insertSession("file", new LocalSessionFactory("com.ge.med.terra.tap.dm.sessionFile.fileSession"));
        DMSession.insertSession("terra", new LocalSessionFactory("com.ge.med.xjplugins.tap.dm.terra.terraSession"));
        DMSession.insertSession("archive", new LocalSessionFactory("com.ge.med.terra.tap.dm.dicomdir.DicomdirSession"));
        DMSession.insertSession("dicomdir", new LocalSessionFactory("com.ge.med.terra.tap.dm.dicomdir.DicomdirSession"));
        DMSession.insertSession("remote", new LocalSessionFactory("com.ge.med.terra.tap.dm.rm.RmSession"));
        DMSession.insertSession("network", new LocalSessionFactory("com.ge.med.terra.tap.dm.network.networkSession"));
        DMSession.insertSession("dicomnetwork", new LocalSessionFactory("com.ge.med.terra.tap.dm.dicomnetwork.NetworkSession"));
        DMSession.insertSession("aw", new LocalSessionFactory("com.ge.med.terra.tap.dm.aw.AWSession"));
        DMSession.insertSession("pesi", new LocalSessionFactory("com.ge.med.terra.tap.dm.pesi.PesiSession"));
        DMSession.insertSession("umai", new LocalSessionFactory("com.ge.med.xjplugins.tap.dm.umai.UMAISession"));
        DMSession.insertSession("sql", new LocalSessionFactory("com.ge.med.terra.tap.dm.sql.SqlSession"));
        DMSession.insertSession("list", new LocalSessionFactory("com.ge.med.terra.tap.dm.list.ListSession"));
        DMSession.insertSession("hyper", new LocalSessionFactory("com.ge.med.terra.tap.dm.hyperpesi.HyperPesiSession"));
        DMSession.insertSession("ram", new RAMSessionFactory());
        try {
            if (System.getProperty("TAP_TRACE_FLAG", "false").equals("true")) {
                TAP_TRACE_FLAG = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        factorymap = new HashMap();
    }

    private static class LocalSessionFactory
    implements DMiSessionFactory {
        private String sessClassName = null;

        private LocalSessionFactory(String className) {
            this.sessClassName = className;
        }

        @Override
        public DMiSession createSession() {
            DMiSession se = new nullSession();
            try {
                Class<?> c = SimpleUtilities.loadClassFromLoader(this.sessClassName, null);
                if (c == null) {
                    Tap.log.log(Level.WARNING, "Error: Unable to find session. Using \"null\" session.");
                } else {
                    se = (DMiSession)c.newInstance();
                }
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Error: Unable to create session. Using \"null\" session. ", ex);
            }
            return se;
        }
    }
}

