/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class DMQueryUtil {
    public static final SimpleDateFormat DA_FORMAT = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat TM_FORMAT = new SimpleDateFormat("HHmmss");
    public static final SimpleDateFormat DT_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    public static String[] META_CHARACTERS = new String[]{"(", ".", ")", "[", "]", "{", "}", "|", "^", "$", "+"};

    public static boolean matchDA(String date, String dateRange) {
        try {
            String v1 = date.replaceAll("\\.", "");
            String v2 = dateRange.replaceAll("\\.", "");
            int rangeIndex = v2.indexOf("-");
            if (rangeIndex >= 0) {
                String low = v2.substring(0, rangeIndex).trim();
                String high = v2.substring(rangeIndex + 1).trim();
                int iv1 = Integer.parseInt(DA_FORMAT.format(DA_FORMAT.parse(v1)));
                int ilow = 0;
                int ihigh = 0;
                if (!low.equals("")) {
                    ilow = Integer.parseInt(DA_FORMAT.format(DA_FORMAT.parse(low)));
                }
                if (!high.equals("")) {
                    ihigh = Integer.parseInt(DA_FORMAT.format(DA_FORMAT.parse(high)));
                }
                if (ilow != 0 && iv1 < ilow) {
                    return false;
                }
                if (ihigh == 0) {
                    return true;
                }
                return ihigh >= iv1;
            }
            return DA_FORMAT.format(DA_FORMAT.parse(v1)).equals(DA_FORMAT.format(DA_FORMAT.parse(v2)));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean matchTM(String time, String timeRange) {
        try {
            int[] v1t = DMQueryUtil.parseTime(time);
            int rangeIndex = timeRange.indexOf("-");
            if (rangeIndex >= 0) {
                String low = timeRange.substring(0, rangeIndex).trim();
                String high = timeRange.substring(rangeIndex + 1).trim();
                boolean match = false;
                if (!low.equals("")) {
                    int[] vlowt = DMQueryUtil.parseTime(low);
                    if (vlowt[0] < v1t[0]) {
                        match = true;
                    } else if (vlowt[0] == v1t[0] && vlowt[1] <= v1t[1]) {
                        match = true;
                    } else {
                        return false;
                    }
                }
                if (high.equals("")) {
                    return true;
                }
                int[] vhigh = DMQueryUtil.parseTime(high);
                if (vhigh[0] > v1t[0]) {
                    return true;
                }
                return vhigh[0] == v1t[0] && vhigh[1] >= v1t[1];
            }
            int[] v2t = DMQueryUtil.parseTime(timeRange);
            return v1t[0] == v2t[0] && v1t[1] == v2t[1];
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean matchDT(String datetime, String datetimeRange) {
        try {
            long[] v1t = DMQueryUtil.parseDateTime(datetime);
            int rangeIndex = datetimeRange.indexOf("-");
            if (rangeIndex >= 0) {
                String low = datetimeRange.substring(0, rangeIndex).trim();
                String high = datetimeRange.substring(rangeIndex + 1).trim();
                boolean match = false;
                if (!low.equals("")) {
                    long[] vlowt = DMQueryUtil.parseDateTime(low);
                    if (vlowt[0] < v1t[0]) {
                        match = true;
                    } else if (vlowt[0] == v1t[0] && vlowt[1] <= v1t[1]) {
                        match = true;
                    } else {
                        return false;
                    }
                }
                if (high.equals("")) {
                    return true;
                }
                long[] vhigh = DMQueryUtil.parseDateTime(high);
                if (vhigh[0] > v1t[0]) {
                    return true;
                }
                if (vhigh[0] == v1t[0] && vhigh[1] >= v1t[1]) {
                    return true;
                }
            } else {
                long[] v2t = DMQueryUtil.parseDateTime(datetimeRange);
                if (v1t[0] == v2t[0] && v1t[1] == v2t[1]) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static int[] parseTime(String timeStr) {
        String time = timeStr.replaceAll("\\:", "");
        int[] times = new int[2];
        try {
            times[1] = -1;
            int dotIndex = time.indexOf(46);
            if (dotIndex >= 0) {
                times[1] = DMQueryUtil.fracInUS(time.substring(dotIndex + 1));
                times[0] = Integer.parseInt(TM_FORMAT.format(TM_FORMAT.parse(time.substring(0, dotIndex))));
            } else {
                times[0] = Integer.parseInt(TM_FORMAT.format(TM_FORMAT.parse(time)));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return times;
    }

    public static long[] parseDateTime(String dtt) {
        long[] times = new long[2];
        try {
            int offset = 0;
            int plusIndex = dtt.indexOf(43);
            if (plusIndex >= 0) {
                offset = Integer.parseInt(dtt.substring(plusIndex + 1));
            } else {
                plusIndex = dtt.indexOf(45);
                if (plusIndex >= 0) {
                    offset = -Integer.parseInt(dtt.substring(plusIndex + 1));
                } else {
                    plusIndex = dtt.length();
                }
            }
            times[1] = -1L;
            int dotIndex = dtt.indexOf(46);
            if (dotIndex >= 0) {
                times[1] = DMQueryUtil.fracInUS(dtt.substring(dotIndex + 1, plusIndex));
                times[0] = Long.parseLong(DT_FORMAT.format(DT_FORMAT.parse(dtt.substring(0, dotIndex))));
            } else {
                times[0] = Long.parseLong(DT_FORMAT.format(DT_FORMAT.parse(dtt)));
            }
            times[0] = times[0] + (long)offset;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return times;
    }

    private static int fracInUS(String frac) {
        String padded = frac + "000000".substring(frac.length());
        return Integer.parseInt(padded);
    }

    public static boolean matchString(String dicomValue, String queryValue, boolean caseS) {
        if (queryValue.indexOf(92) != -1 || dicomValue.indexOf(92) != -1) {
            String[] dvs = DMQueryUtil.splitMultiValueString(queryValue);
            String qString = "";
            for (int i = 0; i < dvs.length; ++i) {
                dvs[i] = DMQueryUtil.dicomToJavaRegExp(dvs[i], caseS);
                qString = i == 0 ? dvs[i] : qString + "|" + dvs[i];
            }
            String[] dcv = DMQueryUtil.splitMultiValueString(dicomValue);
            for (int i = 0; i < dcv.length; ++i) {
                if (!dcv[i].matches(qString)) continue;
                return true;
            }
            return false;
        }
        return DMQueryUtil.matches(dicomValue, queryValue, caseS);
    }

    public static String[] splitMultiValueString(String value) {
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, "\\");
        while (st.hasMoreTokens()) {
            al.add(st.nextToken().trim());
        }
        return al.toArray(new String[al.size()]);
    }

    public static String escapeMetaCharacters(String orig) {
        String newString = orig;
        for (int i = 0; i < META_CHARACTERS.length; ++i) {
            newString = newString.replaceAll("\\" + META_CHARACTERS[i], "\\\\\\" + META_CHARACTERS[i]);
        }
        return newString;
    }

    private static String dicomToJavaRegExp(String str, boolean caseS) {
        String val = DMQueryUtil.escapeMetaCharacters(str);
        val = val.replace('?', '.');
        val = val.replaceAll("\\*", ".*");
        if (!caseS) {
            val = "(?i)" + val;
        }
        return val;
    }

    private static boolean matches(String dicomValue, String queryValue, boolean caseS) {
        String val = DMQueryUtil.dicomToJavaRegExp(queryValue, caseS);
        return dicomValue.matches(val);
    }
}

