/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.TagValue;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMQueryUtil;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import com.ge.med.terra.tap.util.dicom.DicomData;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.vr;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;

public class DMQuery {
    public int qtype;
    public static final int BOOLEAN_OP = 0;
    public static final int RELATION_OP = 1;
    public static final int IOD_ID_TYPE = 2;
    public static final int OBJECT_ID = 3;
    public static final int SEQ_OP = 4;
    public static final int AND_OP = 10;
    public static final int OR_OP = 11;
    public static final int GE_OP = 20;
    public static final int GT_OP = 21;
    public static final int EQ_OP = 22;
    public static final int LT_OP = 23;
    public static final int LE_OP = 24;
    public static final int NE_OP = 25;
    public static final int RESULT_OP = 26;
    public int group;
    public int element;
    public String sval;
    public DMQuery lhs;
    public DMQuery rhs;
    public int relation;

    public DMQuery(int group, int element, String value) {
        this.setQuery(group, element, value);
    }

    public DMQuery(String str) {
        this.setQuery(str);
    }

    public DMQuery(DMQuery left, DMQuery right) {
        this.qtype = 10;
        this.lhs = left;
        this.rhs = right;
    }

    public DMQuery(DicomData obj) {
        this(obj, 0);
    }

    public DMQuery(DicomData obj, int offset) {
        this(obj, offset, obj.dicomCharsets());
    }

    public DMQuery(DicomData obj, int offset, DicomCharSet[] dicomCharsets) {
        try {
            int counter = 0;
            Enumeration elements = obj.enumerateVRs(true);
            if (!elements.hasMoreElements()) {
                throw new IllegalArgumentException("DicomData object should not be empty");
            }
            while (counter < offset) {
                if (!elements.hasMoreElements()) continue;
                elements.nextElement();
                ++counter;
            }
            TagValue dicomObj = (TagValue)elements.nextElement();
            ++counter;
            if (dicomObj.getElement() == 0) {
                dicomObj = (TagValue)elements.nextElement();
                ++counter;
            }
            int g = dicomObj.getGroup();
            int e = dicomObj.getElement();
            if (elements.hasMoreElements()) {
                DicomData left = new DicomData();
                obj.copyValue(g, e, left);
                this.lhs = new DMQuery(left, 0, dicomCharsets);
                this.qtype = 10;
                this.rhs = new DMQuery(obj, counter, dicomCharsets);
            } else {
                Object dicomVal;
                Object object = dicomVal = dicomObj.size() > 0 ? dicomObj.getValue() : null;
                if (dicomVal instanceof DicomObject) {
                    this.group = g;
                    this.element = e;
                    this.qtype = 4;
                    this.rhs = new DMQuery(new DicomData(dicomVal), 0, dicomCharsets);
                } else {
                    obj.setDicomCharsets(dicomCharsets);
                    this.setQuery(g, e, obj.getString(g, e));
                }
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Error when creating query: ", ex);
        }
    }

    public void setQuery(int group, int element, String value) {
        this.group = group;
        this.element = element;
        this.sval = value;
        if (this.sval != null) {
            this.qtype = 1;
            this.relation = 22;
        } else {
            this.qtype = 26;
            this.relation = 26;
        }
    }

    public void setQuery(String str) {
        try {
            if (str.indexOf(")[") >= 0) {
                this.parseBrocket(str);
                return;
            }
            int offset = str.indexOf(" AND ");
            if (offset >= 0) {
                this.qtype = 10;
                this.lhs = new DMQuery(str.substring(0, offset));
                this.rhs = new DMQuery(str.substring(offset + 5));
                return;
            }
            offset = str.indexOf(" OR ");
            if (offset >= 0) {
                boolean nonDicomRelations = Tap.getProperty("tap.dm.query.nondicom", "false").equalsIgnoreCase("true");
                if (nonDicomRelations) {
                    this.qtype = 11;
                    this.lhs = new DMQuery(str.substring(0, offset));
                    this.rhs = new DMQuery(str.substring(offset + 4));
                    return;
                }
                throw new IllegalArgumentException("Unsupported OR operator");
            }
            if (str.indexOf("TYPE ") >= 0) {
                this.qtype = 2;
                if (str.indexOf(" != ") >= 0) {
                    this.sval = str.substring(str.indexOf("!=") + 2).trim();
                    this.relation = 25;
                }
                if (str.indexOf(" = ") >= 0) {
                    this.sval = str.substring(str.indexOf("=") + 2).trim();
                    this.relation = 22;
                }
            }
            if (str.startsWith("(")) {
                int i;
                this.qtype = 1;
                int leftparen = str.indexOf("(");
                int rightparen = str.indexOf(")");
                String g_e = str.substring(leftparen + 1, rightparen);
                int sep = g_e.indexOf(",");
                this.element = Integer.decode(g_e.substring(sep + 1).trim());
                this.group = Integer.decode(g_e.substring(0, sep).trim());
                for (i = rightparen + 1; i < str.length() && (str.charAt(i) == ' ' || str.charAt(i) == '\t'); ++i) {
                }
                if (str.length() == i) {
                    this.relation = 26;
                    this.qtype = 26;
                } else if (str.charAt(i) == '=') {
                    this.relation = 22;
                } else if (str.charAt(i) == '!' && i + 1 < str.length() && str.charAt(i + 1) == '=') {
                    this.relation = 25;
                } else if (str.charAt(i) == '>') {
                    this.relation = i + 1 < str.length() && str.charAt(i + 1) == '=' ? 20 : 21;
                } else if (str.charAt(i) == '<') {
                    this.relation = i + 1 < str.length() && str.charAt(i + 1) == '=' ? 24 : 23;
                } else {
                    throw new IllegalArgumentException("Invalid query string");
                }
                if (this.relation == 20 || this.relation == 24 || this.relation == 25) {
                    ++i;
                }
                if (this.relation != 26) {
                    boolean nonDicomRelations = Tap.getProperty("tap.dm.query.nondicom", "false").equalsIgnoreCase("true");
                    if (!nonDicomRelations && this.relation != 22) {
                        throw new IllegalArgumentException("Unsupported " + this.relString() + " relation");
                    }
                    String tmpValue = str.substring(i + 1).trim();
                    if (tmpValue.length() > 0 && tmpValue.charAt(0) == '\"') {
                        tmpValue = tmpValue.substring(1, tmpValue.length() - 1).trim();
                    }
                    this.sval = tmpValue;
                }
            }
            if (str.indexOf("ID =") >= 0) {
                this.sval = str.substring(5);
                this.qtype = 3;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("error in parsing \"" + str + "\"", ex);
        }
    }

    private void parseBrocket(String str) {
        int indexAND = 0;
        Stack<Integer> stack = new Stack<Integer>();
        int i = 0;
        while ((indexAND = str.indexOf(" AND ", indexAND)) >= 0) {
            while (i < indexAND) {
                if (str.charAt(i) == '[') {
                    stack.push(new Integer(1));
                } else if (str.charAt(i) == ']') {
                    stack.pop();
                }
                ++i;
            }
            if (stack.empty()) {
                this.qtype = 10;
                this.lhs = new DMQuery(str.substring(0, indexAND));
                this.rhs = new DMQuery(str.substring(indexAND + 5));
                return;
            }
            if ((indexAND += 5) <= str.length()) continue;
        }
        if (str.indexOf(")[") < 0) {
            throw new RuntimeException("[] are allowed only with sequence query: (G,E)[...]; no space allowed between (G,E) and [");
        }
        String g_e = str.substring(str.indexOf("(") + 1, str.indexOf(")"));
        this.element = Integer.decode(g_e.substring(g_e.indexOf(",") + 1).trim());
        this.group = Integer.decode(g_e.substring(0, g_e.indexOf(",")).trim());
        this.qtype = 4;
        this.lhs = null;
        this.rhs = new DMQuery(str.substring(str.indexOf(91) + 1, str.lastIndexOf(93)));
    }

    public int[][] getTags() {
        ArrayList<int[]> al = new ArrayList<int[]>();
        this.putTags(al);
        int[][] array = (int[][])al.toArray((T[])new int[al.size()][]);
        return array;
    }

    public static void pl(int[][] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.print((i == 0 ? "" : ",") + "(" + a[i][0] + "," + a[i][1] + ")");
        }
        System.out.println();
    }

    private void putTags(ArrayList<int[]> al) {
        if (this.qtype == 26) {
            al.add(new int[]{this.group, this.element});
        }
        if (this.qtype == 10) {
            this.lhs.putTags(al);
            this.rhs.putTags(al);
        }
    }

    public Vector<int[]> getResultValues() {
        if (this.qtype == 26) {
            Vector<int[]> v = new Vector<int[]>(1);
            v.add(new int[]{this.group, this.element});
            return v;
        }
        if (this.qtype == 10) {
            Vector<int[]> l = this.lhs.getResultValues();
            Vector<int[]> r = this.rhs.getResultValues();
            if (l == null) {
                return r;
            }
            if (r == null) {
                return l;
            }
            l.addAll(r);
            return l;
        }
        return null;
    }

    public static String getValue(int group, int element, DMQuery root) {
        String value = null;
        if (null == root) {
            return null;
        }
        if (1 == root.qtype && group == root.group && element == root.element) {
            value = root.sval;
        } else {
            value = DMQuery.getValue(group, element, root.lhs);
            if (null == value) {
                value = DMQuery.getValue(group, element, root.rhs);
            }
        }
        return value;
    }

    public void writeDicom(DicomData obj) {
        if (this.qtype == 4) {
            DicomData seq = new DicomData();
            this.rhs.writeDicom(seq);
            obj.setValue(this.group, this.element, seq);
        } else {
            if (this.lhs != null) {
                this.lhs.writeDicom(obj);
            }
            if (this.qtype == 1) {
                obj.setValue(this.group, this.element, this.sval);
            } else if (this.qtype == 26) {
                obj.setValue(this.group, this.element, null);
            }
            if (this.rhs != null) {
                this.rhs.writeDicom(obj);
            }
        }
    }

    public boolean valid(DMTagValueInterface dbo) {
        try {
            switch (this.qtype) {
                case 2: {
                    if (dbo.getType().equalsIgnoreCase(this.sval)) {
                        return this.relation == 22;
                    }
                    return this.relation != 22;
                }
                case 0: {
                    return false;
                }
                case 1: {
                    if (8 == this.group && 5 == this.element) {
                        return true;
                    }
                    Object v = dbo.getValue(new DMTag(this.group, this.element));
                    if (v instanceof Long) {
                        return this.comp((Long)v, Long.parseLong(this.sval));
                    }
                    if (v instanceof String) {
                        String svr = vr.toString(dicomParser.dict.getVR(this.group, this.element));
                        if (svr.equals("PN")) {
                            return DMQueryUtil.matchString((String)v, this.sval, false);
                        }
                        if (svr.equals("DA")) {
                            return DMQueryUtil.matchDA((String)v, this.sval);
                        }
                        if (svr.equals("TM")) {
                            return DMQueryUtil.matchTM((String)v, this.sval);
                        }
                        if (svr.equals("DT")) {
                            return DMQueryUtil.matchDT((String)v, this.sval);
                        }
                        return DMQueryUtil.matchString((String)v, this.sval, true);
                    }
                    if (v instanceof Integer) {
                        return this.comp(((Integer)v).intValue(), Integer.parseInt(this.sval.trim()));
                    }
                    if (v instanceof Short) {
                        return this.comp(((Short)v).intValue(), Integer.parseInt(this.sval.trim()));
                    }
                    if (v instanceof Float) {
                        return this.comp(((Float)v).doubleValue(), Double.parseDouble(this.sval.trim()));
                    }
                    if (v instanceof Double) {
                        return this.comp((Double)v, Double.parseDouble(this.sval.trim()));
                    }
                    if (v == null) break;
                    Tap.log.log(Level.WARNING, "value: {0} not handled", v.getClass().getName());
                    break;
                }
                case 10: {
                    return this.lhs.valid(dbo) && this.rhs.valid(dbo);
                }
                case 11: {
                    return this.lhs.valid(dbo) || this.rhs.valid(dbo);
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return this.evaluateSeqQuery(dbo);
                }
                case 26: {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            Tap.log.fine(ex.toString());
        }
        return false;
    }

    private boolean comp(long v1, long v2) {
        switch (this.relation) {
            case 20: {
                return v1 >= v2;
            }
            case 21: {
                return v1 > v2;
            }
            case 24: {
                return v1 <= v2;
            }
            case 23: {
                return v1 < v2;
            }
            case 25: {
                return v1 != v2;
            }
            case 22: {
                return v1 == v2;
            }
        }
        return false;
    }

    private boolean comp(double v1, double v2) {
        switch (this.relation) {
            case 20: {
                return v1 >= v2;
            }
            case 21: {
                return v1 > v2;
            }
            case 24: {
                return v1 <= v2;
            }
            case 23: {
                return v1 < v2;
            }
            case 25: {
                return v1 != v2;
            }
            case 22: {
                return v1 == v2;
            }
        }
        return false;
    }

    private boolean evaluateSeqQuery(DMTagValueInterface dbo) {
        block4: {
            Object obj;
            block3: {
                obj = dbo.getValue(new DMTag(this.group, this.element));
                if (obj == null || this.rhs == null) {
                    return false;
                }
                if (!(obj instanceof DMSequence)) break block3;
                DMSequence dmSeq = (DMSequence)obj;
                int numItems = dmSeq.getNumberOfItems();
                for (int i = 0; i < numItems; ++i) {
                    if (!this.rhs.valid(dmSeq.getItem(i))) continue;
                    return true;
                }
                break block4;
            }
            if (!(obj instanceof DMiSequence)) break block4;
            DMiSequence dmiSeq = (DMiSequence)obj;
            int numItems = dmiSeq.getNumberOfItems();
            for (int i = 0; i < numItems; ++i) {
                if (!this.rhs.valid(dmiSeq.getItem(i))) continue;
                return true;
            }
        }
        return false;
    }

    public String boolString() {
        return DMQuery.boolString(this.qtype);
    }

    public static String boolString(int operator) {
        switch (operator) {
            case 10: {
                return " AND ";
            }
            case 11: {
                return " OR ";
            }
        }
        return "";
    }

    public String relString() {
        return DMQuery.relString(this.relation);
    }

    public static String relString(int relation) {
        switch (relation) {
            case 20: {
                return ">=";
            }
            case 21: {
                return ">";
            }
            case 24: {
                return "<=";
            }
            case 23: {
                return "<";
            }
            case 25: {
                return "!=";
            }
            case 22: {
                return "=";
            }
        }
        return "";
    }

    public String toString() {
        String str = "";
        switch (this.qtype) {
            case 2: {
                str = str + "TYPE " + this.relString() + this.sval;
                break;
            }
            case 0: {
                str = str + "";
                break;
            }
            case 1: {
                str = str + "( 0x" + Integer.toHexString(this.group) + ", 0x" + Integer.toHexString(this.element) + ")" + this.relString() + this.sval;
                break;
            }
            case 10: {
                str = str + this.lhs + " AND " + this.rhs;
                break;
            }
            case 11: {
                str = str + "(" + this.lhs + ") OR (" + this.rhs + ")";
                break;
            }
            case 3: {
                str = str + "ID = " + this.sval;
                break;
            }
            case 26: {
                str = str + "( 0x" + Integer.toHexString(this.group) + ", 0x" + Integer.toHexString(this.element) + " )";
                break;
            }
            case 4: {
                str = str + "( 0x" + Integer.toHexString(this.group) + ", 0x" + Integer.toHexString(this.element) + ")[" + this.rhs + "]";
            }
        }
        return str;
    }
}

