/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;

public final class version {
    private String versionNo = "JAMI_XXXXXXXX";
    private static Properties prop = new Properties();
    private static version singleton = null;

    private version() {
        this.loadPropertyValues("version.properties");
    }

    private void loadPropertyValues(String propertyFile) {
        try {
            prop.load(this.getClass().getResourceAsStream(propertyFile));
            this.versionNo = prop.getProperty("jami.version", "XXXXXX");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final version getVersion() {
        if (singleton == null) {
            singleton = new version();
        }
        return singleton;
    }

    public final String getVersionString() {
        return this.versionNo;
    }

    public final String getProperty(String key) {
        return prop.getProperty(key);
    }

    public final void print() {
        System.out.println("JAMI (Java Medical Imaging Toolkit)");
        System.out.println("GE Healthcare.  Clinical Software Engineering");
        System.out.println("Authors    : Fausto Espinal, Dave Deaven, Arun C. Kumar");
        System.out.println("Version    : " + this.versionNo);
    }

    public static void main(String[] args) {
        version v = version.getVersion();
        v.printVersion();
    }

    public String getBuildDate() {
        return prop.getProperty("jami.build_date", "99999999");
    }

    public String getComponentName() {
        return "JAMI";
    }

    public String getDependency() {
        final StringBuffer buf = new StringBuffer();
        Writer out = new Writer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                buf.append(cbuf, off, len);
            }
        };
        PrintWriter pw = new PrintWriter(out);
        prop.list(pw);
        pw.close();
        return buf.toString();
    }

    public void printVersion() {
        this.print();
        System.out.println("JAMI Build Date: " + this.getBuildDate());
        prop.list(System.out);
    }
}

