/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.seg;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.seg.SegGrid;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class LabelGrid
extends SegGrid {
    public LabelGrid(Object voldata, int vol_offset, int dx, int dy, int dz) {
        super(voldata, vol_offset, dx, dy, dz);
    }

    public static SegAlgorithm createSegAlgorithm(String className) {
        try {
            Class<?> cl = Class.forName(className);
            Constructor<?> c = cl.getConstructor(null);
            SegAlgorithm sa = (SegAlgorithm)c.newInstance(null);
            return sa;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public JFrame display() {
        return this.display("Label Segmentation");
    }

    public JFrame display(String title) {
        JFrame jf = new JFrame(title);
        ImgPanel ip = new ImgPanel(jf, this, title);
        ip.setPreferredSize(new Dimension(this.dx, this.dy));
        jf.setContentPane(ip);
        jf.pack();
        jf.setVisible(true);
        return jf;
    }

    public static void main(String[] args) {
        int dx = 256;
        int dy = 256;
        int dz = 128;
        int PAD = 131072;
        short[] data = new short[0x840000];
        int mx = 128;
        int my = 128;
        int mz = 64;
        for (int z = 0; z < 128; ++z) {
            int pgsize = 65536;
            int PGOFFSET = 131072 + z * 65536;
            for (int y = 0; y < 256; ++y) {
                int ry = Math.abs(128 - y);
                int OFFSET = PGOFFSET + y * 256;
                for (int x = 0; x < 256; ++x) {
                    int rx = Math.abs(128 - x);
                    double rad = Math.sqrt(rx * rx + ry * ry);
                    if (rad < 48.0) {
                        data[OFFSET + x] = 30000;
                        continue;
                    }
                    if (rad < 96.0) {
                        data[OFFSET + x] = 16000;
                        continue;
                    }
                    if (rad < 132.0) {
                        data[OFFSET + x] = 12000;
                        continue;
                    }
                    if (!(rad < 126.0)) continue;
                    data[OFFSET + x] = 8000;
                }
            }
        }
        Byte bseg = new Byte(data, 131072, 256, 256, 128);
        for (int i = 0; i < 0x800000; ++i) {
            if (data[131072 + i] < 8001) {
                bseg.labels[131072 + i] = 1;
                continue;
            }
            if (data[131072 + i] < 12001) {
                bseg.labels[131072 + i] = 2;
                continue;
            }
            if (data[131072 + i] < 16001) {
                bseg.labels[131072 + i] = 3;
                continue;
            }
            if (data[131072 + i] >= 30001) continue;
            bseg.labels[131072 + i] = 4;
        }
        bseg.display("cmap").setDefaultCloseOperation(3);
    }

    private static class ImgPanel
    extends JPanel
    implements KeyListener,
    MouseListener {
        private BufferedImage labimg = null;
        private LabelGrid lg = null;
        private int sliceNo = 0;
        private String origTitle = "";
        private JFrame jf = null;
        private static int[] cmap = new int[]{-16777216, -65536, -16711936, -16776961, -256, -16711681, -65281, -1, -16740608, -7405568, -16777073, -7368817, -7368960, -16740465};

        public ImgPanel(JFrame jf, LabelGrid lg, String title) {
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.lg = lg;
            this.jf = jf;
            this.origTitle = title;
            this.labimg = new BufferedImage(lg.dx, lg.dy, 1);
            this.sync();
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.jf != null) {
                this.jf.setTitle(this.origTitle + "  [" + this.sliceNo + "]");
            }
            g2.drawRenderedImage(this.labimg, null);
        }

        private void sync() {
            block4: {
                int[] ldata = ((DataBufferInt)this.labimg.getRaster().getDataBuffer()).getData();
                Arrays.fill(ldata, 0);
                int dz = this.lg.dz;
                int dy = this.lg.dy;
                int dx = this.lg.dx;
                if (this.sliceNo < 0 || this.sliceNo >= dz) break block4;
                int offset = this.lg.vol_offset + this.sliceNo * dx * dy;
                if (this.lg instanceof Byte) {
                    byte[] data = ((Byte)this.lg).labels;
                    for (int i = 0; i < dx * dy; ++i) {
                        int idx = (data[offset + i] & 0xFF) % cmap.length;
                        ldata[i] = cmap[idx];
                    }
                } else {
                    short[] data = ((Short)this.lg).labels;
                    for (int i = 0; i < dx * dy; ++i) {
                        short v = data[offset + i];
                        if (v < 0) continue;
                        int idx = v % cmap.length;
                        ldata[i] = cmap[idx];
                    }
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            switch (key) {
                case 34: 
                case 40: {
                    ++this.sliceNo;
                    if (this.sliceNo < this.lg.dz) break;
                    this.sliceNo = 0;
                    break;
                }
                case 33: 
                case 38: {
                    --this.sliceNo;
                    if (this.sliceNo >= 0) break;
                    this.sliceNo = this.lg.dz - 1;
                }
            }
            this.sync();
            this.repaint();
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.requestFocus();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.requestFocus();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    public static class Short
    extends LabelGrid {
        public short[] labels = null;

        public Short(Object voldata, int vol_offset, int dx, int dy, int dz) {
            super(voldata, vol_offset, dx, dy, dz);
            int len = dx * dy * dz;
            this.labels = new short[2 * vol_offset + len];
            Arrays.fill(this.labels, (short)0);
        }
    }

    public static class Byte
    extends LabelGrid {
        public byte[] labels = null;

        public Byte(Object voldata, int vol_offset, int dx, int dy, int dz) {
            super(voldata, vol_offset, dx, dy, dz);
            int len = dx * dy * dz;
            this.labels = new byte[2 * vol_offset + len];
            Arrays.fill(this.labels, (byte)0);
        }
    }

    public static interface SegAlgorithm {
        public String getName();

        public LabelGrid segment(Object[] var1, TaskMonitor var2);
    }
}

