/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.seg;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.seg.BinVolume;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class BinGrid
extends BinVolume {
    public int rowlen = 0;
    public byte[] bingrid = null;

    public BinGrid(BinGrid src) {
        super(src.voldata, src.vol_offset, src.dx, src.dy, src.dz);
        this.rowlen = src.rowlen;
        this.bingrid = new byte[src.bingrid.length];
        System.arraycopy(src.bingrid, 0, this.bingrid, 0, this.bingrid.length);
    }

    public BinGrid(Object voldata, int vol_offset, int dx, int dy, int dz) {
        super(voldata, vol_offset, dx, dy, dz);
        this.init(true);
    }

    public BinGrid(Object voldata, int vol_offset, byte[] bingrid, int dx, int dy, int dz) {
        super(voldata, vol_offset, dx, dy, dz);
        this.bingrid = bingrid;
        this.rowlen = dx >> 3;
        if ((dx & 7) != 0) {
            ++this.rowlen;
        }
    }

    public static SegAlgorithm createSegAlgorithm(String className) {
        try {
            Class<?> cl = Class.forName(className);
            Constructor<?> c = cl.getConstructor(null);
            SegAlgorithm sa = (SegAlgorithm)c.newInstance(null);
            return sa;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void init(boolean in) {
        this.rowlen = this.dx >> 3;
        if ((this.dx & 7) != 0) {
            ++this.rowlen;
        }
        this.bingrid = new byte[this.rowlen * this.dy * this.dz];
        if (in) {
            Arrays.fill(this.bingrid, (byte)-1);
        } else {
            Arrays.fill(this.bingrid, (byte)0);
        }
    }

    public BinGrid not() {
        BinGrid result = new BinGrid(this);
        for (int i = 0; i < result.bingrid.length; ++i) {
            byte v = result.bingrid[i];
            result.bingrid[i] = ~v;
        }
        return result;
    }

    public void dilate() {
        int PGLEN;
        byte[] tempgrid = new byte[this.bingrid.length];
        System.arraycopy(this.bingrid, 0, tempgrid, 0, this.bingrid.length);
        for (int z = 0; z < this.dz; ++z) {
            int zoffset = z * this.dy * this.rowlen;
            for (int y = 1; y < this.dy - 1; ++y) {
                int offset0 = zoffset + y * this.rowlen;
                int offset1 = zoffset + (y - 1) * this.rowlen;
                int offset2 = zoffset + (y + 1) * this.rowlen;
                for (int x = 0; x < this.rowlen; ++x) {
                    int idx0 = offset0 + x;
                    int idx1 = offset1 + x;
                    int idx2 = offset2 + x;
                    tempgrid[idx0] = (byte)(this.bingrid[idx0] | this.bingrid[idx1] | this.bingrid[idx2]);
                }
            }
        }
        for (int i = 0; i < this.bingrid.length; i += this.rowlen) {
            for (int idx = i + 1; idx < i + this.rowlen - 1; ++idx) {
                int b0 = tempgrid[idx] & 0xFF;
                int b1 = tempgrid[idx - 1] & 0xFF;
                int b2 = tempgrid[idx + 1] & 0xFF;
                int m1 = b0 | b0 >> 1 | b0 << 1 | (b1 & 0x80) >> 7 | (b2 & 1) << 7;
                this.bingrid[idx] = (byte)(m1 & 0xFF);
            }
        }
        for (int z = PGLEN = this.rowlen * this.dy; z < this.bingrid.length - PGLEN; z += PGLEN) {
            for (int i = z; i < z + PGLEN; ++i) {
                tempgrid[i] = (byte)(this.bingrid[i] | this.bingrid[i - PGLEN] | this.bingrid[i + PGLEN]);
            }
        }
        System.arraycopy(tempgrid, PGLEN, this.bingrid, PGLEN, this.bingrid.length - 2 * PGLEN);
    }

    public void erode() {
        int PGLEN;
        byte[] tempgrid = new byte[this.bingrid.length];
        System.arraycopy(this.bingrid, 0, tempgrid, 0, this.bingrid.length);
        for (int z = 0; z < this.dz; ++z) {
            int zoffset = z * this.dy * this.rowlen;
            for (int y = 1; y < this.dy - 1; ++y) {
                int offset0 = zoffset + y * this.rowlen;
                int offset1 = zoffset + (y - 1) * this.rowlen;
                int offset2 = zoffset + (y + 1) * this.rowlen;
                for (int x = 0; x < this.rowlen; ++x) {
                    int idx0 = offset0 + x;
                    int idx1 = offset1 + x;
                    int idx2 = offset2 + x;
                    tempgrid[idx0] = (byte)(this.bingrid[idx0] & this.bingrid[idx1] & this.bingrid[idx2]);
                }
            }
        }
        for (int i = 0; i < this.bingrid.length; i += this.rowlen) {
            for (int idx = i + 1; idx < i + this.rowlen - 1; ++idx) {
                int b0 = tempgrid[idx] & 0xFF;
                int b1 = tempgrid[idx - 1] & 0xFF;
                int b2 = tempgrid[idx + 1] & 0xFF;
                int m1 = b0 & (b0 >> 1 | 0x80) & (b0 << 1 | 1) & (0xFFFFFFFE | (b1 & 0x80) >> 7) & (0xFFFFFF7F | (b2 & 1) << 7);
                this.bingrid[idx] = (byte)(m1 & 0xFF);
            }
        }
        for (int z = PGLEN = this.rowlen * this.dy; z < this.bingrid.length - PGLEN; z += PGLEN) {
            for (int i = z; i < z + PGLEN; ++i) {
                tempgrid[i] = (byte)(this.bingrid[i] & this.bingrid[i - PGLEN] & this.bingrid[i + PGLEN]);
            }
        }
        System.arraycopy(tempgrid, PGLEN, this.bingrid, PGLEN, this.bingrid.length - 2 * PGLEN);
        Arrays.fill(this.bingrid, 0, PGLEN - 1, (byte)0);
        Arrays.fill(this.bingrid, this.bingrid.length - 1 - PGLEN, this.bingrid.length - 1, (byte)0);
    }

    public void threshold(int v0, int v1) {
        short[] vol_data = (short[])this.voldata;
        if (this.voldata == null) {
            throw new RuntimeException("Volume data is null within BinGrid object.");
        }
        int nout = 0;
        for (int z = 0; z < this.dz; ++z) {
            int zoffset = this.vol_offset + z * this.dy * this.dx;
            int zboffset = z * this.dy * this.rowlen;
            for (int y = 0; y < this.dy; ++y) {
                int offset = zoffset + y * this.dx;
                int boffset = zboffset + y * this.rowlen;
                for (int x = 0; x < this.dx; ++x) {
                    int bidx = boffset + (x >> 3);
                    int mod = x & 7;
                    int idx = offset + x;
                    if ((this.bingrid[bidx] & 1 << mod) == 0 || vol_data[idx] >= v0 && vol_data[idx] <= v1) continue;
                    this.bingrid[bidx] = (byte)(this.bingrid[bidx] & ~(1 << mod));
                    ++nout;
                }
            }
        }
    }

    @Override
    public boolean getBoundingBox(int[] bbox_origin, int[] bbox_dims) {
        int min_x = this.dx;
        int min_y = this.dy;
        int min_z = this.dz;
        int max_x = 0;
        int max_y = 0;
        int max_z = 0;
        boolean empty = true;
        for (int z = 0; z < this.dz; ++z) {
            int zboffset = z * this.dy * this.rowlen;
            for (int y = 0; y < this.dy; ++y) {
                int boffset = zboffset + y * this.rowlen;
                for (int x = 0; x < this.dx; ++x) {
                    int bidx = boffset + (x >> 3);
                    int mod = x & 7;
                    if ((this.bingrid[bidx] & 1 << mod) == 0) continue;
                    if (x < min_x) {
                        min_x = x;
                    }
                    if (y < min_y) {
                        min_y = y;
                    }
                    if (z < min_z) {
                        min_z = z;
                    }
                    if (x > max_x) {
                        max_x = x;
                    }
                    if (y > max_y) {
                        max_y = y;
                    }
                    if (z > max_z) {
                        max_z = z;
                    }
                    empty = false;
                }
            }
        }
        if (!empty) {
            bbox_origin[0] = min_x;
            bbox_origin[1] = min_y;
            bbox_origin[2] = min_z;
            bbox_dims[0] = max_x - min_x + 1;
            bbox_dims[1] = max_y - min_y + 1;
            bbox_dims[2] = max_z - min_z + 1;
        }
        return !empty;
    }

    public void connectedComponents() {
        Queue queue = new Queue();
        short[] coords = new short[3];
        byte[] bvisit = new byte[this.bingrid.length];
        int ncc = 0;
        this.rowlen = this.dx >> 3;
        if ((this.dx & 7) != 0) {
            ++this.rowlen;
        }
        int pgsize = this.rowlen * this.dy;
        for (int z = 1; z < this.dz - 1; ++z) {
            int zboffset = z * pgsize;
            for (int y = 1; y < this.dy - 1; ++y) {
                int boffset = zboffset + y * this.rowlen;
                for (int x = 1; x < this.dx - 1; ++x) {
                    int bidx = boffset + (x >> 3);
                    int mod = x & 7;
                    int mask = 1 << mod;
                    if ((this.bingrid[bidx] & mask) == 0 || (bvisit[bidx] & mask) != 0) continue;
                    ++ncc;
                    bvisit[bidx] = (byte)(bvisit[bidx] | 1 << mod);
                    queue.add_neighbors(bvisit, this.rowlen, x, y, z);
                    while (!queue.empty()) {
                        boolean status = queue.dequeue(coords);
                        int bvidx = coords[2] * pgsize + coords[1] * this.rowlen + (coords[0] >> 3);
                        int bvmod = coords[0] & 7;
                        bvisit[bvidx] = (byte)(bvisit[bvidx] | 1 << bvmod);
                        queue.add_neighbors(bvisit, this.rowlen, coords[0], coords[1], coords[2]);
                    }
                }
            }
        }
    }

    public BinGrid extractRegion(int[] boundingBox, BinGrid inplaceBinGrid) {
        int dimx = boundingBox[3] - boundingBox[0] + 1;
        int dimy = boundingBox[4] - boundingBox[1] + 1;
        int dimz = boundingBox[5] - boundingBox[2] + 1;
        BinGrid regionBinGrid = inplaceBinGrid;
        if (regionBinGrid == null) {
            regionBinGrid = new BinGrid(null, 0, dimx, dimy, dimz);
        } else {
            int gridlen;
            regionBinGrid.vol_offset = 0;
            regionBinGrid.voldata = null;
            int new_rowlen = dimx >> 3;
            if ((dimx & 7) != 0) {
                ++new_rowlen;
            }
            if (regionBinGrid.bingrid.length != (gridlen = new_rowlen * dimy * dimz)) {
                regionBinGrid.bingrid = new byte[gridlen];
            }
        }
        Arrays.fill(regionBinGrid.bingrid, (byte)0);
        int z = boundingBox[2];
        int rz = 0;
        while (z <= boundingBox[5]) {
            int zboffset = z * this.dy * this.rowlen;
            int rzboffset = rz * regionBinGrid.dy * regionBinGrid.rowlen;
            int y = boundingBox[1];
            int ry = 0;
            while (y <= boundingBox[4]) {
                int boffset = zboffset + y * this.rowlen;
                int rboffset = rzboffset + ry * regionBinGrid.rowlen;
                int x = boundingBox[0];
                int rx = 0;
                while (x <= boundingBox[3]) {
                    int bidx = boffset + (x >> 3);
                    int mod = x & 7;
                    int rbidx = rboffset + (rx >> 3);
                    int rmod = rx & 7;
                    if ((this.bingrid[bidx] & 1 << mod) != 0) {
                        regionBinGrid.bingrid[rbidx] = (byte)(regionBinGrid.bingrid[rbidx] | 1 << rmod);
                    }
                    ++x;
                    ++rx;
                }
                ++y;
                ++ry;
            }
            ++z;
            ++rz;
        }
        return regionBinGrid;
    }

    public void insertRegion(int[] boundingBox, BinGrid regionBinGrid) {
        int z = boundingBox[2];
        int rz = 0;
        while (z <= boundingBox[5]) {
            int zboffset = z * this.dy * this.rowlen;
            int rzboffset = rz * regionBinGrid.dy * regionBinGrid.rowlen;
            int y = boundingBox[1];
            int ry = 0;
            while (y <= boundingBox[4]) {
                int boffset = zboffset + y * this.rowlen;
                int rboffset = rzboffset + ry * regionBinGrid.rowlen;
                int x = boundingBox[0];
                int rx = 0;
                while (x <= boundingBox[3]) {
                    int bidx = boffset + (x >> 3);
                    int mod = x & 7;
                    int rbidx = rboffset + (rx >> 3);
                    int rmod = rx & 7;
                    this.bingrid[bidx] = (regionBinGrid.bingrid[rbidx] & 1 << rmod) != 0 ? (byte)(this.bingrid[bidx] | 1 << mod) : (byte)(this.bingrid[bidx] & ~(1 << mod));
                    ++x;
                    ++rx;
                }
                ++y;
                ++ry;
            }
            ++z;
            ++rz;
        }
    }

    public static final void bitwiseOr(byte[] bgrid1, byte[] bgrid2, byte[] output) {
        for (int i = 0; i < output.length; ++i) {
            output[i] = (byte)(bgrid1[i] | bgrid2[i]);
        }
    }

    public static final void bitwiseAnd(byte[] bgrid1, byte[] bgrid2, byte[] output) {
        for (int i = 0; i < output.length; ++i) {
            output[i] = (byte)(bgrid1[i] & bgrid2[i]);
        }
    }

    public JFrame display() {
        return this.display("Binary Segmentation");
    }

    public JFrame display(String title) {
        JFrame jf = new JFrame(title);
        jf.setDefaultCloseOperation(3);
        ImgPanel ip = new ImgPanel(jf, this, title);
        ip.setPreferredSize(new Dimension(this.dx, this.dy));
        jf.setContentPane(ip);
        jf.pack();
        jf.setVisible(true);
        return jf;
    }

    public static void main(String[] args) {
        int dx = 512;
        int dy = 512;
        int dz = 263;
        int PAD = 524288;
        short[] data = new short[69992448];
        int mx = 256;
        int my = 256;
        int mz = 131;
        for (int z = 0; z < 263; ++z) {
            int rz = Math.abs(131 - z);
            int pgsize = 262144;
            int PGOFFSET = 524288 + z * 262144;
            for (int y = 0; y < 512; ++y) {
                int ry = Math.abs(256 - y);
                int OFFSET = PGOFFSET + y * 512;
                for (int x = 0; x < 512; ++x) {
                    int rx = Math.abs(256 - x);
                    double rad = Math.sqrt(rx * rx + ry * ry);
                    if (rad < 48.0) {
                        data[OFFSET + x] = 30000;
                        continue;
                    }
                    if (rad < 96.0) {
                        data[OFFSET + x] = 16000;
                        continue;
                    }
                    if (rad < 132.0) {
                        data[OFFSET + x] = 12000;
                        continue;
                    }
                    if (!(rad < 261.0)) continue;
                    data[OFFSET + x] = 8000;
                }
            }
        }
        BinGrid bseg = new BinGrid(data, 524288, 512, 512, 263);
        bseg.threshold(29000, 31000);
        BinGrid copybseg = new BinGrid(bseg);
        copybseg.display("thresh").setDefaultCloseOperation(3);
        long t0 = System.currentTimeMillis();
        int ITERATIONS = 7;
        for (int i = 0; i < 7; ++i) {
            bseg.erode();
        }
        long t1 = System.currentTimeMillis();
        double avg = (double)(t1 - t0) / 7.0;
        System.err.println("^^^ time erode = " + avg);
        bseg.display("erode").setDefaultCloseOperation(3);
    }

    private static class ImgPanel
    extends JPanel
    implements KeyListener,
    MouseListener {
        private BufferedImage bitimg = null;
        private BinGrid bb = null;
        private int sliceNo = 0;
        private String origTitle = "";
        private JFrame jf = null;

        public ImgPanel(JFrame jf, BinGrid bb, String title) {
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.bb = bb;
            this.jf = jf;
            this.origTitle = title;
            this.bitimg = new BufferedImage(bb.dx, bb.dy, 12);
            this.sync();
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.jf != null) {
                this.jf.setTitle(this.origTitle + "  [" + this.sliceNo + "]");
            }
            g2.drawRenderedImage(this.bitimg, null);
        }

        private void sync() {
            byte[] bitdata = ((DataBufferByte)this.bitimg.getRaster().getDataBuffer()).getData();
            Arrays.fill(bitdata, (byte)0);
            int dz = this.bb.dz;
            int dy = this.bb.dy;
            int dx = this.bb.dx;
            byte[] data = this.bb.bingrid;
            int rowlen = this.bb.rowlen;
            if (this.sliceNo >= 0 && this.sliceNo < dz) {
                int nones = 0;
                for (int yy = 0; yy < dy; ++yy) {
                    for (int xx = 0; xx < dx; ++xx) {
                        int blockidx = this.sliceNo * (dy * rowlen) + yy * rowlen + (xx >> 3);
                        int blockbit = xx & 7;
                        int imgpos = yy * dx + xx;
                        int pos = imgpos >> 3;
                        int bit = imgpos & 7;
                        if (data[blockidx] != 0) {
                            ++nones;
                        }
                        if ((data[blockidx] & 1 << blockbit) == 0) continue;
                        bitdata[pos] = (byte)(bitdata[pos] | 1 << 7 - bit);
                        ++nones;
                    }
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            switch (key) {
                case 34: 
                case 40: {
                    ++this.sliceNo;
                    if (this.sliceNo < this.bb.dz) break;
                    this.sliceNo = 0;
                    break;
                }
                case 33: 
                case 38: {
                    --this.sliceNo;
                    if (this.sliceNo >= 0) break;
                    this.sliceNo = this.bb.dz - 1;
                }
            }
            this.sync();
            this.repaint();
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.requestFocus();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.requestFocus();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class Queue {
        private short[] queue = new short[3072];
        private int write_pos = 0;
        private int read_pos = 0;

        private Queue() {
        }

        public final int add_neighbors(byte[] bvisit, int rowlen, int x, int y, int z) {
            int pgsize = BinGrid.this.dy * rowlen;
            int nadded = 0;
            if (x <= 0 || x > BinGrid.this.dx - 2) {
                return 0;
            }
            if (y <= 0 || y > BinGrid.this.dy - 2) {
                return 0;
            }
            if (z <= 0 || z > BinGrid.this.dz - 2) {
                return 0;
            }
            for (int nz = -1; nz <= 1; ++nz) {
                int iz = z + nz;
                int zboffset = iz * pgsize;
                for (int ny = -1; ny <= 1; ++ny) {
                    int iy = y + ny;
                    int boffset = zboffset + iy * rowlen;
                    for (int nx = -1; nx <= 1; ++nx) {
                        int mod;
                        int mask;
                        int bidx;
                        int ix = x + nx;
                        if (iz == z && iy == y && ix == x || (bvisit[bidx = boffset + (ix >> 3)] & (mask = 1 << (mod = ix & 7))) != 0) continue;
                        ++nadded;
                        this.queue[this.write_pos] = (short)ix;
                        this.queue[this.write_pos + 1] = (short)iy;
                        this.queue[this.write_pos + 2] = (short)iz;
                        this.write_pos = (this.write_pos + 3) % this.queue.length;
                    }
                }
            }
            return nadded;
        }

        public final boolean empty() {
            return this.write_pos == this.read_pos;
        }

        public final boolean dequeue(short[] coords) {
            if (this.write_pos != this.read_pos) {
                coords[0] = this.queue[this.read_pos];
                coords[1] = this.queue[this.read_pos + 1];
                coords[2] = this.queue[this.read_pos + 2];
                this.read_pos = (this.read_pos + 3) % this.queue.length;
                return true;
            }
            return false;
        }
    }

    public static interface SegAlgorithm {
        public String getName();

        public BinGrid segment(BinGrid var1, Object[] var2, TaskMonitor var3);
    }
}

