/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.jnu.statistics.JnHistogram;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.roi.RoiStatistics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Arrays;

public class Java2DRoiStatistics
implements RoiStatistics {
    private XpImage img = null;
    private XpPixelStatistics ps = new XpPixelStatistics();
    private BufferedImage bitimg = null;
    private int width = 0;
    private int height = 0;
    private int numPixels = -1;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private Point2D tmpPoint1 = new Point2D.Double();

    @Override
    public void setImage(XpImage img) {
        this.img = img;
        if (img != null) {
            this.width = img.getSlice().width;
            this.height = img.getSlice().height;
            this.rescaleSlope = img.getRescaleSlope();
            this.rescaleIntercept = img.getRescaleIntercept();
            if (this.bitimg == null || this.width != this.bitimg.getWidth() || this.height != this.bitimg.getHeight()) {
                this.bitimg = new BufferedImage(this.width, this.height, 12);
            }
        }
    }

    @Override
    public double getArea(Shape s, double angle) {
        if (this.img != null) {
            double pdx = this.img.getPixelDimensionX();
            double pdy = this.img.getPixelDimensionY();
            if (this.numPixels == -1) {
                this.getPixelStatistics(s, angle);
            }
            return (double)this.numPixels * pdx * pdy;
        }
        return -1.0;
    }

    @Override
    public double getLength(Shape s, double angle) {
        if (this.img != null) {
            double pdx = this.img.getPixelDimensionX();
            double pdy = this.img.getPixelDimensionY();
            return XpImageUtils.calcShapeLength(s, pdx, pdy);
        }
        return -1.0;
    }

    @Override
    public XpPixelStatistics getPixelStatistics(Shape s, double angle) {
        if (this.img != null) {
            this.drawBitmap(s, angle);
            Rectangle2D r2d = s.getBounds2D();
            double w = r2d.getWidth();
            double h = r2d.getHeight();
            double x = r2d.getX();
            double y = r2d.getY();
            if (angle != 0.0) {
                double hw = r2d.getWidth() * 0.5;
                double hh = r2d.getHeight() * 0.5;
                double maxDist = Math.sqrt(hw * hw + hh * hh);
                double cx = r2d.getX() + hw;
                double cy = r2d.getY() + hh;
                w = h = 2.0 * maxDist;
                x = cx - maxDist;
                y = cy - maxDist;
            }
            int x1 = (int)x;
            int y1 = (int)y;
            int x2 = (int)(x + w);
            int y2 = (int)(y + h);
            this.calcStats(x1 -= 2, y1 -= 2, x2 += 2, y2 += 2);
            this.numPixels = this.ps.getNumPixels();
        }
        return this.ps;
    }

    private static Raster getRaster(RenderedImage ri) {
        Raster r = null;
        if (ri != null) {
            r = ri instanceof BufferedImage ? ((BufferedImage)ri).getRaster() : ri.getData();
        }
        return r;
    }

    private void calcStats() {
        Raster r = Java2DRoiStatistics.getRaster(this.img.getPixelData());
        if (r != null) {
            int w = r.getWidth();
            int h = r.getHeight();
            int x1 = r.getMinX();
            int y1 = r.getMinY();
            this.calcStats(x1, y1, x1 + w, y1 + h);
        }
    }

    private void calcStats(int x1, int y1, int x2, int y2) {
        if (this.img != null) {
            int pixelRepresentation = XpImageUtils.getPixelRepresentation(this.img);
            XpImageUtils.calcStats(this.img.getPixelData(), this.bitimg, this.rescaleSlope, this.rescaleIntercept, pixelRepresentation, x1, y1, x2, y2, this.ps);
        }
    }

    @Override
    public BufferedImage getPixels(Shape s, double angle) {
        if (this.img != null) {
            this.drawBitmap(s, angle);
            return this.bitimg;
        }
        return null;
    }

    @Override
    public JnHistogram calcHistogram(Shape s, double angle, JnHistogram hist) {
        if (this.img != null) {
            Raster r;
            if (hist == null) {
                hist = new JnHistogram(80);
            }
            int[] histogram = hist.histogram;
            Point maximumPt = hist.maximumPt;
            Arrays.fill(histogram, 0);
            XpPixelStatistics ps = this.getPixelStatistics(s, angle);
            int nHistogramPts = histogram.length;
            double bucketSize = (ps.max - ps.min) / (double)nHistogramPts;
            int rowByteLength = this.width / 8;
            if (this.width % 8 != 0) {
                ++rowByteLength;
            }
            if ((r = Java2DRoiStatistics.getRaster(this.img.getPixelData())) != null) {
                DataBuffer db = r.getDataBuffer();
                short[] sdata = null;
                byte[] bdata = null;
                int[] idata = null;
                if (db instanceof DataBufferUShort) {
                    sdata = ((DataBufferUShort)db).getData();
                } else if (db instanceof DataBufferShort) {
                    sdata = ((DataBufferShort)db).getData();
                } else if (db instanceof DataBufferByte) {
                    bdata = ((DataBufferByte)db).getData();
                } else if (db instanceof DataBufferInt) {
                    idata = ((DataBufferInt)db).getData();
                }
                int maxX = 0;
                int maxY = 0;
                byte[] bitmap = ((DataBufferByte)this.bitimg.getRaster().getDataBuffer()).getData();
                int sX = ps.bounds.x;
                int sY = ps.bounds.y;
                int eX = ps.bounds.x + ps.bounds.width;
                int eY = ps.bounds.y + ps.bounds.height;
                for (int y = sY; y <= eY; ++y) {
                    int idx_offset = y * rowByteLength;
                    for (int x = sX; x <= eX; ++x) {
                        int bit = x % 8;
                        int idx = idx_offset + x / 8;
                        int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx];
                        if (on == 0) continue;
                        int pval = 0;
                        if (sdata != null) {
                            pval = sdata[y * this.width + x];
                        } else if (bdata != null) {
                            pval = bdata[y * this.width + x];
                        } else if (idata != null) {
                            pval = idata[y * this.width + x];
                        }
                        int bucket = (int)(((double)pval - ps.min) / bucketSize);
                        if (bucket >= nHistogramPts) {
                            bucket = nHistogramPts - 1;
                        }
                        try {
                            int n = bucket;
                            histogram[n] = histogram[n] + 1;
                            if (histogram[bucket] <= maxY) continue;
                            maxY = histogram[bucket];
                            maxX = bucket;
                            continue;
                        }
                        catch (Exception ex) {
                            XpLog.logger().warning("Histogram Array Indexing problem: " + bucket + " min=" + ps.min + " pval=" + pval + " bSize=" + bucketSize);
                        }
                    }
                }
                hist.bucketSize = bucketSize;
                hist.startX = ps.min;
                hist.endX = ps.max;
                maximumPt.setLocation(maxX, maxY);
            }
        }
        return hist;
    }

    private final void drawBitmap(Shape shape, double angle) {
        if (this.bitimg != null) {
            Java2DRoiStatistics.getCenter(shape, this.tmpPoint1);
            double cx = this.tmpPoint1.getX();
            double cy = this.tmpPoint1.getY();
            Graphics2D g2 = (Graphics2D)this.bitimg.getGraphics();
            byte[] data = ((DataBufferByte)this.bitimg.getRaster().getDataBuffer()).getData();
            Arrays.fill(data, (byte)0);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.rotate(-angle, cx, cy);
            g2.fill(shape);
        }
    }

    private static void getCenter(Shape shape, Point2D center) {
        Rectangle2D bounds = shape.getBounds2D();
        double cx = bounds.getX() + bounds.getWidth() / 2.0;
        double cy = bounds.getY() + bounds.getHeight() / 2.0;
        center.setLocation(cx, cy);
    }
}

