/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.terra.jami.Draw2DUtilsBase;
import com.ge.med.terra.jami.XpGeomUtils;
import java.util.Arrays;

public abstract class XpPipeline {
    private static final int SHIFT = 12;
    private static final int SCALE = 4096;
    private static final int MASK = 4095;
    private static final int ALPHA = -16777216;
    private boolean changeRender = false;
    private boolean changeAffine = false;
    protected XpGeomUtils geomUtils = new XpGeomUtils();
    protected XjFusionPixelCombiner cfpc = null;
    private static long cnt = 0L;
    private static long sum = 0L;

    public void dispose() {
    }

    public final boolean isChangeRender() {
        return this.changeRender;
    }

    public final void setChangeRender(boolean changeRender) {
        this.changeRender = changeRender;
    }

    public final boolean isChangeAffine() {
        return this.changeAffine;
    }

    public final void setChangeAffine(boolean changeAffine) {
        this.changeAffine = changeAffine;
    }

    public static void doBilinearToBYTE(double[] tx, int[] input, int iw, int ih, byte[] output, int ow, int oh, int x1, int x2, int y1, int y2, byte background) {
        int m00 = (int)(tx[0] * 4096.0);
        int m10 = (int)(tx[1] * 4096.0);
        int m01 = (int)(tx[2] * 4096.0);
        int m11 = (int)(tx[3] * 4096.0);
        int m02 = (int)(tx[4] * 4096.0);
        int m12 = (int)(tx[5] * 4096.0);
        int pix = background;
        int OW = ow * 1;
        int X1 = x1 * 1;
        int X2 = x2 * 1;
        if (y1 > 0) {
            int len = y1 * OW;
            Arrays.fill(output, 0, len, (byte)background);
        }
        for (int y = y1; y <= y2; ++y) {
            int offset = y * OW;
            int tr_1 = m01 * y + m02;
            int tr_2 = m11 * y + m12;
            if (X1 > 0) {
                Arrays.fill(output, offset, offset + X1, (byte)background);
            }
            for (int x = x1; x <= x2; ++x) {
                boolean inside = true;
                boolean val = false;
                pix = background;
                int tx_x = m00 * x + tr_1;
                int tx_y = m10 * x + tr_2;
                int dxx = tx_x & 0xFFF;
                int dyy = tx_y & 0xFFF;
                int xx = tx_x >> 12;
                int yy = tx_y >> 12;
                if (xx < 0) {
                    inside = false;
                } else if (xx >= iw - 1) {
                    inside = false;
                }
                if (yy < 0) {
                    inside = false;
                } else if (yy >= ih - 1) {
                    inside = false;
                }
                if (inside) {
                    int xx_1 = xx + 1;
                    int yy_1 = yy + 1;
                    int offset1 = yy * iw;
                    int offset2 = yy_1 * iw;
                    int ul = offset1 + xx;
                    int ur = offset1 + xx_1;
                    int bl = offset2 + xx;
                    int br = offset2 + xx_1;
                    int p_ul = input[ul] & 0xFF;
                    int p_ur = input[ur] & 0xFF;
                    int p_bl = input[bl] & 0xFF;
                    int p_br = input[br] & 0xFF;
                    int ry1 = (p_bl - p_ul) * dyy;
                    int ry2 = (p_br - p_ur) * dyy;
                    int p1 = (p_ul << 12) + ry1;
                    int p2 = (p_ur << 12) + ry2;
                    int rx = ((p2 >>= 12) - (p1 >>= 12)) * dxx;
                    pix = p1 + (rx >>= 12);
                    pix &= 0xFF;
                }
                int idx = offset + x;
                output[idx] = (byte)pix;
            }
            int start = X2 + 3;
            if (start >= OW) continue;
            Arrays.fill(output, offset + start, offset + OW, (byte)background);
        }
        if (y2 < oh - 1) {
            int idx1 = (y2 + 1) * OW;
            int idx2 = output.length;
            Arrays.fill(output, idx1, idx2, (byte)background);
        }
    }

    public static void doBilinearToINT_RGBUpright(double[] tx, double[] itx, int[] input, int ioffset, int iw, int ih, int[] output, int ow, int oh, JnPoint2D iul, JnPoint2D ibl, JnPoint2D iur, JnPoint2D ibr, int background) {
        long t1 = System.currentTimeMillis();
        iul.setLocation(1.0, 1.0);
        ibl.setLocation(1.0, ih - 2);
        iur.setLocation(iw - 2, 1.0);
        ibr.setLocation(iw - 2, ih - 2);
        double xxul = tx[0] * iul.getX() + tx[2] * iul.getY() + tx[4];
        double yyul = tx[1] * iul.getX() + tx[3] * iul.getY() + tx[5];
        double dx1 = xxul;
        double dy1 = yyul;
        double dx2 = xxul;
        double dy2 = yyul;
        double xxbl = tx[0] * ibl.getX() + tx[2] * ibl.getY() + tx[4];
        double yybl = tx[1] * ibl.getX() + tx[3] * ibl.getY() + tx[5];
        dx1 = Math.min(dx1, xxbl);
        dx2 = Math.max(dx2, xxbl);
        dy1 = Math.min(dy1, yybl);
        dy2 = Math.max(dy2, yybl);
        double xxur = tx[0] * iur.getX() + tx[2] * iur.getY() + tx[4];
        double yyur = tx[1] * iur.getX() + tx[3] * iur.getY() + tx[5];
        dx1 = Math.min(dx1, xxur);
        dx2 = Math.max(dx2, xxur);
        dy1 = Math.min(dy1, yyur);
        dy2 = Math.max(dy2, yyur);
        double xxbr = tx[0] * ibr.getX() + tx[2] * ibr.getY() + tx[4];
        double yybr = tx[1] * ibr.getX() + tx[3] * ibr.getY() + tx[5];
        dx1 = Math.min(dx1, xxbr);
        dx2 = Math.max(dx2, xxbr);
        dy1 = Math.min(dy1, yybr);
        dy2 = Math.max(dy2, yybr);
        dx1 = Math.max(dx1, 1.0);
        dx2 = Math.min(dx2, (double)(ow - 2));
        dy1 = Math.max(dy1, 1.0);
        dy2 = Math.min(dy2, (double)(oh - 2));
        int BORDER_OFFSET = 2;
        int x1 = (int)(Math.ceil(dx1) + 2.0);
        int y1 = (int)(Math.ceil(dy1) + 2.0);
        int x2 = (int)(Math.floor(dx2) - 2.0);
        int y2 = (int)(Math.floor(dy2) - 2.0);
        if (y2 < 0 || x2 < 0 || x1 >= ow || y1 >= oh) {
            Arrays.fill(output, background);
            return;
        }
        if (y1 > 0) {
            int len = Math.min(y1 * ow, output.length - 1);
            Arrays.fill(output, 0, len, background);
        }
        double lx = itx[0] * (double)x1 + itx[2] * (double)y1 + itx[4];
        double ly = itx[1] * (double)x1 + itx[3] * (double)y1 + itx[5];
        double dxx = itx[0] * 1.0 + itx[2] * 0.0;
        double dxy = itx[1] * 1.0 + itx[3] * 0.0;
        double dyx = itx[0] * 0.0 + itx[2] * 1.0;
        double dyy = itx[1] * 0.0 + itx[3] * 1.0;
        int idxx = (int)(dxx * 4096.0);
        int idxy = (int)(dxy * 4096.0);
        int idyx = (int)(dyx * 4096.0);
        int idyy = (int)(dyy * 4096.0);
        int posx = (int)(lx * 4096.0);
        int posy = (int)(ly * 4096.0);
        for (int y = y1; y < y2; ++y) {
            int offset = y * ow;
            int ilx = posx;
            int ily = posy;
            if (x1 > 0) {
                Arrays.fill(output, offset, offset + x1, background);
            }
            for (int x = x1; x < x2; ++x) {
                int xx = ilx >> 12;
                int yy = ily >> 12;
                int deltax = ilx & 0xFFF;
                int deltay = ily & 0xFFF;
                int xx_1 = xx + 1;
                int yy_1 = yy + 1;
                int offset1 = yy * iw;
                int offset2 = yy_1 * iw;
                int ul = offset1 + xx;
                int ur = offset1 + xx_1;
                int bl = offset2 + xx;
                int br = offset2 + xx_1;
                int p_ul = input[ioffset + ul] & 0xFF;
                int p_ur = input[ioffset + ur] & 0xFF;
                int p_bl = input[ioffset + bl] & 0xFF;
                int p_br = input[ioffset + br] & 0xFF;
                int ry1 = (p_bl - p_ul) * deltay;
                int ry2 = (p_br - p_ur) * deltay;
                int p1 = (p_ul << 12) + ry1;
                int p2 = (p_ur << 12) + ry2;
                int rx = ((p2 >>= 12) - (p1 >>= 12)) * deltax;
                int pix = p1 + (rx >>= 12) & 0xFF;
                int val = 0xFF000000 | pix << 16 | pix << 8 | pix;
                int idx = offset + x;
                output[idx] = val;
                ilx += idxx;
                ily += idxy;
            }
            if (x2 >= 0 && x2 < ow - 1) {
                int idx1 = offset + x2 + 1;
                int idx2 = offset + ow - 1;
                if (idx2 >= output.length) {
                    idx2 = output.length - 1;
                }
                if (idx1 <= idx2) {
                    Arrays.fill(output, idx1, idx2, background);
                }
            }
            posx += idyx;
            posy += idyy;
        }
        if (y2 < oh - 1) {
            int idx1 = (y2 + 1) * ow;
            int idx2 = output.length;
            Arrays.fill(output, idx1, idx2, background);
        }
    }

    public static void doBilinearToINT_RGB(double[] tx, int[] input, int iw, int ih, int[] output, int ow, int oh, int x1, int x2, int y1, int y2, int background) {
        int m00 = (int)(tx[0] * 4096.0);
        int m10 = (int)(tx[1] * 4096.0);
        int m01 = (int)(tx[2] * 4096.0);
        int m11 = (int)(tx[3] * 4096.0);
        int m02 = (int)(tx[4] * 4096.0);
        int m12 = (int)(tx[5] * 4096.0);
        if (y1 > 0) {
            int len = y1 * ow;
            Arrays.fill(output, 0, len, background);
        }
        for (int y = y1; y <= y2; ++y) {
            int offset = y * ow;
            int tr_1 = m01 * y + m02;
            int tr_2 = m11 * y + m12;
            if (x1 > 0) {
                Arrays.fill(output, offset, offset + x1, background);
            }
            for (int x = x1; x <= x2; ++x) {
                boolean inside = true;
                int val = background;
                int tx_x = m00 * x + tr_1;
                int tx_y = m10 * x + tr_2;
                int dxx = tx_x & 0xFFF;
                int dyy = tx_y & 0xFFF;
                int xx = tx_x >> 12;
                int yy = tx_y >> 12;
                if (xx < 0) {
                    inside = false;
                } else if (xx >= iw - 1) {
                    inside = false;
                }
                if (yy < 0) {
                    inside = false;
                } else if (yy >= ih - 1) {
                    inside = false;
                }
                if (inside) {
                    int xx_1 = xx + 1;
                    int yy_1 = yy + 1;
                    int offset1 = yy * iw;
                    int offset2 = yy_1 * iw;
                    int ul = offset1 + xx;
                    int ur = offset1 + xx_1;
                    int bl = offset2 + xx;
                    int br = offset2 + xx_1;
                    int p_ul = input[ul] & 0xFF;
                    int p_ur = input[ur] & 0xFF;
                    int p_bl = input[bl] & 0xFF;
                    int p_br = input[br] & 0xFF;
                    int ry1 = (p_bl - p_ul) * dyy;
                    int ry2 = (p_br - p_ur) * dyy;
                    int p1 = (p_ul << 12) + ry1;
                    int p2 = (p_ur << 12) + ry2;
                    int rx = ((p2 >>= 12) - (p1 >>= 12)) * dxx;
                    int pix = p1 + (rx >>= 12);
                    val = 0xFF000000 | (pix &= 0xFF) << 16 | pix << 8 | pix;
                }
                output[offset + x] = val;
            }
            int start = x2 + 1;
            if (start >= ow) continue;
            Arrays.fill(output, offset + start, offset + ow, background);
        }
        if (y2 < oh - 1) {
            int idx1 = (y2 + 1) * ow;
            int idx2 = output.length;
            Arrays.fill(output, idx1, idx2, background);
        }
    }

    public static void doNearestNeighborINT_RGB(double[] tx, int[] input, int iw, int ih, int[] output, int ow, int oh, int x1, int x2, int y1, int y2, int background) {
        int m00 = (int)(tx[0] * 4096.0);
        int m10 = (int)(tx[1] * 4096.0);
        int m01 = (int)(tx[2] * 4096.0);
        int m11 = (int)(tx[3] * 4096.0);
        int m02 = (int)(tx[4] * 4096.0);
        int m12 = (int)(tx[5] * 4096.0);
        if (y1 > 0) {
            int len = y1 * ow;
            Arrays.fill(output, 0, len, background);
        }
        for (int y = y1; y <= y2; ++y) {
            int offset = y * ow;
            int tr_1 = m01 * y + m02;
            int tr_2 = m11 * y + m12;
            if (x1 > 0) {
                Arrays.fill(output, offset, offset + x1, background);
            }
            for (int x = x1; x <= x2; ++x) {
                boolean inside = true;
                int val = background;
                int tx_x = m00 * x + tr_1;
                int tx_y = m10 * x + tr_2;
                int xx = tx_x >> 12;
                int yy = tx_y >> 12;
                if (xx < 0) {
                    inside = false;
                } else if (xx >= iw - 1) {
                    inside = false;
                }
                if (yy < 0) {
                    inside = false;
                } else if (yy >= ih - 1) {
                    inside = false;
                }
                if (inside) {
                    int offset1 = yy * iw;
                    int ul = offset1 + xx;
                    int p_ul = input[ul] & 0xFF;
                    int pix = p_ul & 0xFF;
                    val = 0xFF000000 | pix << 16 | pix << 8 | pix;
                }
                output[offset + x] = val;
            }
            int start = x2 + 1;
            if (start >= ow) continue;
            Arrays.fill(output, offset + start, offset + ow, background);
        }
        if (y2 < oh - 1) {
            int idx1 = (y2 + 1) * ow;
            int idx2 = output.length;
            Arrays.fill(output, idx1, idx2, background);
        }
    }

    public static void doBilinearByteToByte(double[] tx, byte[] input, int ioffset, int iw, int ih, byte[] output, int ow, int oh, int x1, int x2, int y1, int y2, byte background) {
        int m00 = (int)(tx[0] * 4096.0);
        int m10 = (int)(tx[1] * 4096.0);
        int m01 = (int)(tx[2] * 4096.0);
        int m11 = (int)(tx[3] * 4096.0);
        int m02 = (int)(tx[4] * 4096.0);
        int m12 = (int)(tx[5] * 4096.0);
        int OW = ow * 1;
        int X1 = x1 * 1;
        int X2 = x2 * 1;
        if (y1 > 0) {
            int len = y1 * OW;
            Arrays.fill(output, 0, len, (byte)background);
        }
        for (int y = y1; y <= y2; ++y) {
            int offset = y * OW;
            int pix = background;
            int tr_1 = m01 * y + m02;
            int tr_2 = m11 * y + m12;
            if (X1 > 0) {
                Arrays.fill(output, offset, offset + X1, (byte)background);
            }
            for (int x = x1; x <= x2; ++x) {
                boolean inside = true;
                boolean val = false;
                pix = background;
                int tx_x = m00 * x + tr_1;
                int tx_y = m10 * x + tr_2;
                int dxx = tx_x & 0xFFF;
                int dyy = tx_y & 0xFFF;
                int xx = tx_x >> 12;
                int yy = tx_y >> 12;
                if (xx < 0) {
                    inside = false;
                } else if (xx >= iw - 1) {
                    inside = false;
                }
                if (yy < 0) {
                    inside = false;
                } else if (yy >= ih - 1) {
                    inside = false;
                }
                if (inside) {
                    int xx_1 = xx + 1;
                    int yy_1 = yy + 1;
                    int offset1 = yy * iw;
                    int offset2 = yy_1 * iw;
                    int ul = offset1 + xx;
                    int ur = offset1 + xx_1;
                    int bl = offset2 + xx;
                    int br = offset2 + xx_1;
                    int p_ul = input[ioffset + ul] & 0xFF;
                    int p_ur = input[ioffset + ur] & 0xFF;
                    int p_bl = input[ioffset + bl] & 0xFF;
                    int p_br = input[ioffset + br] & 0xFF;
                    int ry1 = (p_bl - p_ul) * dyy;
                    int ry2 = (p_br - p_ur) * dyy;
                    int p1 = (p_ul << 12) + ry1;
                    int p2 = (p_ur << 12) + ry2;
                    int rx = ((p2 >>= 12) - (p1 >>= 12)) * dxx;
                    pix = p1 + (rx >>= 12);
                }
                int idx = offset + x;
                output[idx] = (byte)pix;
            }
            if (x2 >= OW - 1) continue;
            Arrays.fill(output, offset + x2 + 1, offset + OW - 1, (byte)background);
        }
        if (y2 < oh - 1) {
            int idx1 = (y2 + 1) * OW;
            int idx2 = output.length;
            Arrays.fill(output, idx1, idx2, (byte)background);
        }
    }

    public static void doBilinearShortToShortUpright(double[] tx, double[] itx, short[] input, int ioffset, int iw, int ih, int pixelRepresentation, int bpp, short[] output, int ow, int oh, short background) {
        int py;
        int idx2;
        int idx1;
        int br;
        int bl;
        int ur;
        int ul;
        int offset2;
        int offset1;
        int yy_1;
        int xx_1;
        int deltay;
        int deltax;
        int yy;
        int xx;
        int x;
        int ily;
        int ilx;
        int offset;
        int y;
        long t1 = System.currentTimeMillis();
        double iul_x = 0.0;
        double iul_y = 0.0;
        double xxul = tx[0] * 0.0 + tx[2] * 0.0 + tx[4];
        double yyul = tx[1] * 0.0 + tx[3] * 0.0 + tx[5];
        double bbx1 = xxul;
        double bby1 = yyul;
        double bbx2 = xxul;
        double bby2 = yyul;
        double ibl_x = 0.0;
        double ibl_y = ih - 1;
        double xxbl = tx[0] * 0.0 + tx[2] * ibl_y + tx[4];
        double yybl = tx[1] * 0.0 + tx[3] * ibl_y + tx[5];
        bbx1 = Math.min(bbx1, xxbl);
        bbx2 = Math.max(bbx2, xxbl);
        bby1 = Math.min(bby1, yybl);
        bby2 = Math.max(bby2, yybl);
        double iur_x = iw - 1;
        double iur_y = 0.0;
        double xxur = tx[0] * iur_x + tx[2] * 0.0 + tx[4];
        double yyur = tx[1] * iur_x + tx[3] * 0.0 + tx[5];
        bbx1 = Math.min(bbx1, xxur);
        bbx2 = Math.max(bbx2, xxur);
        bby1 = Math.min(bby1, yyur);
        bby2 = Math.max(bby2, yyur);
        double ibr_x = iw - 1;
        double ibr_y = ih - 1;
        double xxbr = tx[0] * ibr_x + tx[2] * ibr_y + tx[4];
        double yybr = tx[1] * ibr_x + tx[3] * ibr_y + tx[5];
        bbx1 = Math.min(bbx1, xxbr);
        bbx2 = Math.max(bbx2, xxbr);
        bby1 = Math.min(bby1, yybr);
        bby2 = Math.max(bby2, yybr);
        double EPSILON = 1.0E-10;
        int x1 = Math.max((int)Math.ceil(bbx1 - 1.0E-10), 0);
        int x2 = Math.min((int)Math.floor(bbx2 + 1.0E-10), ow - 1);
        int y1 = Math.max((int)Math.ceil(bby1 - 1.0E-10), 0);
        int y2 = Math.min((int)Math.floor(bby2 + 1.0E-10), oh - 1);
        Arrays.fill(output, background);
        if (y2 < 0 || x2 < 0 || x1 >= ow || y1 >= oh) {
            Arrays.fill(output, background);
            return;
        }
        if (y1 > 0) {
            int len = Math.min(y1 * ow, output.length - 1);
            Arrays.fill(output, 0, len, background);
        }
        double lx = itx[0] * (double)x1 + itx[2] * (double)y1 + itx[4];
        double ly = itx[1] * (double)x1 + itx[3] * (double)y1 + itx[5];
        double dxx = itx[0];
        double dxy = itx[1];
        double dyx = itx[2];
        double dyy = itx[3];
        int idxx = (int)(dxx * 4096.0);
        int idxy = (int)(dxy * 4096.0);
        int idyx = (int)(dyx * 4096.0);
        int idyy = (int)(dyy * 4096.0);
        if (lx < 0.0) {
            lx = 0.0;
        }
        if (ly < 0.0) {
            ly = 0.0;
        }
        if (lx > (double)(iw - 1)) {
            lx = iw - 1;
        }
        if (ly > (double)(ih - 1)) {
            ly = ih - 1;
        }
        int posx = (int)(lx * 4096.0);
        int posy = (int)(ly * 4096.0);
        int mask = (1 << bpp) - 1;
        if (pixelRepresentation == 0) {
            for (y = y1; y < y2; ++y) {
                offset = y * ow;
                ilx = posx;
                ily = posy;
                if (x1 > 0) {
                    Arrays.fill(output, offset, offset + x1, background);
                }
                for (x = x1; x < x2; ++x) {
                    xx = ilx >> 12;
                    yy = ily >> 12;
                    deltax = ilx & 0xFFF;
                    deltay = ily & 0xFFF;
                    xx_1 = xx + 1;
                    yy_1 = yy + 1;
                    offset1 = yy * iw;
                    offset2 = yy_1 * iw;
                    ul = offset1 + xx;
                    ur = offset1 + xx_1;
                    bl = offset2 + xx;
                    br = offset2 + xx_1;
                    int v0 = input[ioffset + ul] & mask;
                    int v1 = input[ioffset + ur] & mask;
                    int v2 = input[ioffset + bl] & mask;
                    int v3 = input[ioffset + br] & mask;
                    int p_ul = v0 & 0xFFFF;
                    int p_ur = v1 & 0xFFFF;
                    int p_bl = v2 & 0xFFFF;
                    int p_br = v3 & 0xFFFF;
                    int ry1 = (p_bl - p_ul) * deltay;
                    int ry2 = (p_br - p_ur) * deltay;
                    int p1 = (p_ul << 12) + ry1;
                    int p2 = (p_ur << 12) + ry2;
                    int rx = ((p2 >>= 12) - (p1 >>= 12)) * deltax;
                    int pix = p1 + (rx >>= 12);
                    int idx = offset + x;
                    output[idx] = (short)pix;
                    ilx += idxx;
                }
                if (x2 >= 0 && x2 < ow - 1) {
                    idx1 = offset + x2 + 1;
                    idx2 = offset + ow - 1;
                    if (idx2 >= output.length) {
                        idx2 = output.length - 1;
                    }
                    if (idx1 <= idx2) {
                        Arrays.fill(output, idx1, idx2, background);
                    }
                }
                posy += idyy;
            }
        } else {
            for (y = y1; y < y2; ++y) {
                offset = y * ow;
                ilx = posx;
                ily = posy;
                if (x1 > 0) {
                    Arrays.fill(output, offset, offset + x1, background);
                }
                for (x = x1; x < x2; ++x) {
                    xx = ilx >> 12;
                    yy = ily >> 12;
                    deltax = ilx & 0xFFF;
                    deltay = ily & 0xFFF;
                    xx_1 = xx + 1;
                    yy_1 = yy + 1;
                    offset1 = yy * iw;
                    offset2 = yy_1 * iw;
                    ul = offset1 + xx;
                    ur = offset1 + xx_1;
                    bl = offset2 + xx;
                    br = offset2 + xx_1;
                    short p_ul = input[ioffset + ul];
                    short p_ur = input[ioffset + ur];
                    short p_bl = input[ioffset + bl];
                    short p_br = input[ioffset + br];
                    int ry1 = (p_bl - p_ul) * deltay;
                    int ry2 = (p_br - p_ur) * deltay;
                    int p1 = (p_ul << 12) + ry1;
                    int p2 = (p_ur << 12) + ry2;
                    int rx = ((p2 >>= 12) - (p1 >>= 12)) * deltax;
                    int pix = p1 + (rx >>= 12);
                    int idx = offset + x;
                    output[idx] = (short)pix;
                    ilx += idxx;
                }
                if (x2 >= 0 && x2 < ow - 1) {
                    idx1 = offset + x2 + 1;
                    idx2 = offset + ow - 1;
                    if (idx2 >= output.length) {
                        idx2 = output.length - 1;
                    }
                    if (idx1 <= idx2) {
                        Arrays.fill(output, idx1, idx2, background);
                    }
                }
                posy += idyy;
            }
        }
        if ((py = posy >> 12) < ih && y2 >= 0) {
            int ur2;
            int ul2;
            int offset12;
            int xx_12;
            int deltax2;
            int ilx2 = posx;
            int yy2 = posy >> 12;
            int offset3 = y2 * ow;
            if (x1 > 0) {
                int ex = x1 < ow - 1 ? x1 : ow - 1;
                Arrays.fill(output, offset3, offset3 + ex, background);
            }
            if (pixelRepresentation == 0) {
                for (x = x1; x < x2; ++x) {
                    xx = ilx2 >> 12;
                    deltax2 = ilx2 & 0xFFF;
                    xx_12 = xx + 1;
                    offset12 = yy2 * iw;
                    ul2 = offset12 + xx;
                    ur2 = offset12 + xx_12;
                    int v0 = input[ioffset + ul2] & mask;
                    int v1 = input[ioffset + ur2] & mask;
                    int p_ul = v0 & 0xFFFF;
                    int p_ur = v1 & 0xFFFF;
                    int rx = (p_ur - p_ul) * deltax2;
                    int pix = p_ul + (rx >> 12);
                    int idx = offset3 + x;
                    output[idx] = (short)pix;
                    ilx2 += idxx;
                }
            } else {
                for (x = x1; x < x2; ++x) {
                    xx = ilx2 >> 12;
                    deltax2 = ilx2 & 0xFFF;
                    xx_12 = xx + 1;
                    offset12 = yy2 * iw;
                    ul2 = offset12 + xx;
                    ur2 = offset12 + xx_12;
                    short p_ul = input[ioffset + ul2];
                    short p_ur = input[ioffset + ur2];
                    int rx = (p_ur - p_ul) * deltax2;
                    int pix = p_ul + (rx >> 12);
                    int idx = offset3 + x;
                    output[idx] = (short)pix;
                    ilx2 += idxx;
                }
            }
            if (x2 < ow - 1) {
                idx1 = offset3 + x2 + 1;
                idx2 = offset3 + ow - 1;
                if (idx2 >= output.length) {
                    idx2 = output.length - 1;
                }
                if (idx1 <= idx2) {
                    Arrays.fill(output, idx1, idx2, background);
                }
            }
        } else {
            --y2;
        }
        if (y2 < oh - 1) {
            int idx12 = (y2 + 1) * ow;
            int idx22 = output.length;
            Arrays.fill(output, idx12, idx22, background);
        }
    }

    public static void doBilinearShortToShort(double[] tx, short[] input, int ioffset, int iw, int ih, int pixelRepresentation, int bpp, short[] output, int ow, int oh, int x1, int x2, int y1, int y2, short background) {
        int offset;
        int y;
        if (y1 > 0) {
            int len = Math.min(y1 * ow, output.length - 1);
            Arrays.fill(output, 0, len, (short)background);
        }
        int mask = (1 << bpp) - 1;
        int m00 = (int)(tx[0] * 4096.0);
        int m10 = (int)(tx[1] * 4096.0);
        int m01 = (int)(tx[2] * 4096.0);
        int m11 = (int)(tx[3] * 4096.0);
        int m02 = (int)(tx[4] * 4096.0);
        int m12 = (int)(tx[5] * 4096.0);
        if (pixelRepresentation == 0) {
            for (y = y1; y <= y2; ++y) {
                int idx2;
                int idx1;
                offset = y * ow;
                int tr_1 = m01 * y + m02;
                int tr_2 = m11 * y + m12;
                if (x1 > 0) {
                    Arrays.fill(output, offset, offset + x1, (short)background);
                }
                for (int x = x1; x <= x2; ++x) {
                    boolean inside = true;
                    int pix = background;
                    int tx_x = m00 * x + tr_1;
                    int tx_y = m10 * x + tr_2;
                    int dxx = tx_x & 0xFFF;
                    int dyy = tx_y & 0xFFF;
                    int xx = tx_x >> 12;
                    int yy = tx_y >> 12;
                    if (xx < 0) {
                        inside = false;
                    } else if (xx >= iw - 1) {
                        inside = false;
                    }
                    if (yy < 0) {
                        inside = false;
                    } else if (yy >= ih - 1) {
                        inside = false;
                    }
                    if (inside) {
                        int xx_1 = xx + 1;
                        int yy_1 = yy + 1;
                        int offset1 = yy * iw;
                        int offset2 = yy_1 * iw;
                        int ul = offset1 + xx;
                        int ur = offset1 + xx_1;
                        int bl = offset2 + xx;
                        int br = offset2 + xx_1;
                        int v0 = input[ioffset + ul] & mask;
                        int v1 = input[ioffset + ur] & mask;
                        int v2 = input[ioffset + bl] & mask;
                        int v3 = input[ioffset + br] & mask;
                        int p_ul = v0 & 0xFFFF;
                        int p_ur = v1 & 0xFFFF;
                        int p_bl = v2 & 0xFFFF;
                        int p_br = v3 & 0xFFFF;
                        int ry1 = (p_bl - p_ul) * dyy;
                        int ry2 = (p_br - p_ur) * dyy;
                        int p1 = (p_ul << 12) + ry1;
                        int p2 = (p_ur << 12) + ry2;
                        int rx = ((p2 >>= 12) - (p1 >>= 12)) * dxx;
                        pix = p1 + (rx >>= 12);
                    }
                    int idx = offset + x;
                    output[idx] = (short)pix;
                }
                if (x2 >= ow - 1 || (idx1 = offset + x2 + 1) > (idx2 = Math.min(offset + ow - 1, output.length - 1))) continue;
                Arrays.fill(output, offset + x2 + 1, offset + ow - 1, (short)background);
            }
        } else {
            for (y = y1; y <= y2; ++y) {
                int idx2;
                int idx1;
                offset = y * ow;
                int tr_1 = m01 * y + m02;
                int tr_2 = m11 * y + m12;
                if (x1 > 0) {
                    Arrays.fill(output, offset, offset + x1, (short)background);
                }
                for (int x = x1; x <= x2; ++x) {
                    boolean inside = true;
                    int pix = background;
                    int tx_x = m00 * x + tr_1;
                    int tx_y = m10 * x + tr_2;
                    int dxx = tx_x & 0xFFF;
                    int dyy = tx_y & 0xFFF;
                    int xx = tx_x >> 12;
                    int yy = tx_y >> 12;
                    if (xx < 0) {
                        inside = false;
                    } else if (xx >= iw - 1) {
                        inside = false;
                    }
                    if (yy < 0) {
                        inside = false;
                    } else if (yy >= ih - 1) {
                        inside = false;
                    }
                    if (inside) {
                        int xx_1 = xx + 1;
                        int yy_1 = yy + 1;
                        int offset1 = yy * iw;
                        int offset2 = yy_1 * iw;
                        int ul = offset1 + xx;
                        int ur = offset1 + xx_1;
                        int bl = offset2 + xx;
                        int br = offset2 + xx_1;
                        short p_ul = input[ioffset + ul];
                        short p_ur = input[ioffset + ur];
                        short p_bl = input[ioffset + bl];
                        short p_br = input[ioffset + br];
                        int ry1 = (p_bl - p_ul) * dyy;
                        int ry2 = (p_br - p_ur) * dyy;
                        int p1 = (p_ul << 12) + ry1;
                        int p2 = (p_ur << 12) + ry2;
                        int rx = ((p2 >>= 12) - (p1 >>= 12)) * dxx;
                        pix = p1 + (rx >>= 12);
                    }
                    int idx = offset + x;
                    output[idx] = (short)pix;
                }
                if (x2 >= ow - 1 || (idx1 = offset + x2 + 1) > (idx2 = Math.min(offset + ow - 1, output.length - 1))) continue;
                Arrays.fill(output, offset + x2 + 1, offset + ow - 1, (short)background);
            }
        }
        if (y2 < oh - 1) {
            int idx1 = (y2 + 1) * ow;
            int idx2 = output.length;
            Arrays.fill(output, idx1, idx2, (short)background);
        }
    }

    public static void doNearestNeighborShortToShort(double[] tx, short[] input, int ioffset, int iw, int ih, int pixelRepresentation, int bpp, short[] output, int ow, int oh, int x1, int x2, int y1, int y2, short background) {
        int offset;
        int y;
        if (y1 > 0) {
            int len = Math.min(y1 * ow, output.length - 1);
            Arrays.fill(output, 0, len, (short)background);
        }
        int mask = (1 << bpp) - 1;
        int m00 = (int)(tx[0] * 4096.0);
        int m10 = (int)(tx[1] * 4096.0);
        int m01 = (int)(tx[2] * 4096.0);
        int m11 = (int)(tx[3] * 4096.0);
        int m02 = (int)(tx[4] * 4096.0);
        int m12 = (int)(tx[5] * 4096.0);
        if (pixelRepresentation == 0) {
            for (y = y1; y <= y2; ++y) {
                int idx2;
                int idx1;
                offset = y * ow;
                int tr_1 = m01 * y + m02;
                int tr_2 = m11 * y + m12;
                if (x1 > 0) {
                    Arrays.fill(output, offset, offset + x1, (short)background);
                }
                for (int x = x1; x <= x2; ++x) {
                    boolean inside = true;
                    int pix = background;
                    int tx_x = m00 * x + tr_1;
                    int tx_y = m10 * x + tr_2;
                    int xx = tx_x >> 12;
                    int yy = tx_y >> 12;
                    if (xx < 0) {
                        inside = false;
                    } else if (xx >= iw - 1) {
                        inside = false;
                    }
                    if (yy < 0) {
                        inside = false;
                    } else if (yy >= ih - 1) {
                        inside = false;
                    }
                    if (inside) {
                        int p_ul;
                        int offset1 = yy * iw;
                        int ul = offset1 + xx;
                        int v0 = input[ioffset + ul] & mask;
                        pix = p_ul = v0 & 0xFFFF;
                    }
                    int idx = offset + x;
                    output[idx] = (short)pix;
                }
                if (x2 >= ow - 1 || (idx1 = offset + x2 + 1) > (idx2 = Math.min(offset + ow - 1, output.length - 1))) continue;
                Arrays.fill(output, offset + x2 + 1, offset + ow - 1, (short)background);
            }
        } else {
            for (y = y1; y <= y2; ++y) {
                int idx2;
                int idx1;
                offset = y * ow;
                int tr_1 = m01 * y + m02;
                int tr_2 = m11 * y + m12;
                if (x1 > 0) {
                    Arrays.fill(output, offset, offset + x1, (short)background);
                }
                for (int x = x1; x <= x2; ++x) {
                    boolean inside = true;
                    int pix = background;
                    int tx_x = m00 * x + tr_1;
                    int tx_y = m10 * x + tr_2;
                    int xx = tx_x >> 12;
                    int yy = tx_y >> 12;
                    if (xx < 0) {
                        inside = false;
                    } else if (xx >= iw - 1) {
                        inside = false;
                    }
                    if (yy < 0) {
                        inside = false;
                    } else if (yy >= ih - 1) {
                        inside = false;
                    }
                    if (inside) {
                        int p_ul;
                        int offset1 = yy * iw;
                        int ul = offset1 + xx;
                        pix = p_ul = input[ioffset + ul];
                    }
                    int idx = offset + x;
                    output[idx] = (short)pix;
                }
                if (x2 >= ow - 1 || (idx1 = offset + x2 + 1) > (idx2 = Math.min(offset + ow - 1, output.length - 1))) continue;
                Arrays.fill(output, offset + x2 + 1, offset + ow - 1, (short)background);
            }
        }
        if (y2 < oh - 1) {
            int idx1 = (y2 + 1) * ow;
            int idx2 = output.length;
            Arrays.fill(output, idx1, idx2, (short)background);
        }
    }

    public static void toIntegerMath(double[] vec, int[] ivec) {
        for (int i = 0; i < vec.length; ++i) {
            ivec[i] = (int)(vec[i] * 4096.0);
        }
    }

    public static void doBilinearShortToShortBox(double[] tx, double[] itx, short[] input, int ioffset, int iw, int ih, int pixelRepresentation, int bpp, short[] output, int ow, int oh, RowBuffer rb, short background) {
        int pix;
        int rx;
        int p2;
        int p1;
        int ry2;
        int ry1;
        int p_br;
        int p_bl;
        int p_ur;
        int p_ul;
        int br;
        int bl;
        int ur;
        int ul;
        int offset2;
        int offset1;
        boolean check;
        int idx;
        int yy_1;
        int xx_1;
        int yy;
        int xx;
        int dyy;
        int dxx;
        int offset;
        int tx_y;
        int tx_x;
        short y;
        short x;
        int i;
        int idx2;
        int idx1;
        int br2;
        int bl2;
        int ur2;
        int ul2;
        int offset22;
        int offset12;
        int yy_12;
        int xx_12;
        int yy2;
        int xx2;
        int dyy2;
        int dxx2;
        int tx_y2;
        int tx_x2;
        int pix2;
        int x2;
        int YY;
        int XX;
        short endx;
        int startx;
        int tr_2;
        int tr_1;
        int offset3;
        int y2;
        rb.iul.setLocation(0.0, 0.0);
        rb.ibl.setLocation(0.0, ih - 1);
        rb.iur.setLocation(iw - 1, 0.0);
        rb.ibr.setLocation(iw - 1, ih - 1);
        double xxul = tx[0] * rb.iul.getX() + tx[2] * rb.iul.getY() + tx[4];
        double yyul = tx[1] * rb.iul.getX() + tx[3] * rb.iul.getY() + tx[5];
        int ixxul = (int)xxul;
        int iyyul = (int)yyul;
        double xxbl = tx[0] * rb.ibl.getX() + tx[2] * rb.ibl.getY() + tx[4];
        double yybl = tx[1] * rb.ibl.getX() + tx[3] * rb.ibl.getY() + tx[5];
        int ixxbl = (int)xxbl;
        int iyybl = (int)yybl;
        double xxur = tx[0] * rb.iur.getX() + tx[2] * rb.iur.getY() + tx[4];
        double yyur = tx[1] * rb.iur.getX() + tx[3] * rb.iur.getY() + tx[5];
        int ixxur = (int)xxur;
        int iyyur = (int)yyur;
        double xxbr = tx[0] * rb.ibr.getX() + tx[2] * rb.ibr.getY() + tx[4];
        double yybr = tx[1] * rb.ibr.getX() + tx[3] * rb.ibr.getY() + tx[5];
        int ixxbr = (int)xxbr;
        int iyybr = (int)yybr;
        rb.clear();
        Draw2DUtilsBase.lineBresenham(ixxul, iyyul, ixxur, iyyur, rb);
        Draw2DUtilsBase.lineBresenham(ixxul, iyyul, ixxbl, iyybl, rb);
        Draw2DUtilsBase.lineBresenham(ixxbl, iyybl, ixxbr, iyybr, rb);
        Draw2DUtilsBase.lineBresenham(ixxur, iyyur, ixxbr, iyybr, rb);
        if (rb.Ymax < 0 || rb.Ymin >= oh || rb.xmin >= ow || rb.xmax < 0) {
            Arrays.fill(output, (short)background);
            return;
        }
        int m00 = (int)(itx[0] * 4096.0);
        int m10 = (int)(itx[1] * 4096.0);
        int m01 = (int)(itx[2] * 4096.0);
        int m11 = (int)(itx[3] * 4096.0);
        int m02 = (int)(itx[4] * 4096.0);
        int m12 = (int)(itx[5] * 4096.0);
        rb.nEdgePts = 0;
        for (int y3 = rb.Ymin; y3 <= rb.Ymax; ++y3) {
            int yy3;
            int xx3;
            int tx_y3;
            int tx_x3;
            int x3 = rb.Xmin[y3];
            do {
                tx_x3 = m00 * x3 + m01 * y3 + m02;
                tx_y3 = m10 * x3 + m11 * y3 + m12;
                xx3 = tx_x3 >> 12;
                yy3 = tx_y3 >> 12;
                if (xx3 >= 0 && xx3 < iw - 1 && yy3 >= 0 && yy3 < ih - 1) break;
                if (xx3 <= 0 || yy3 <= 0) continue;
                rb.xedge[rb.nEdgePts] = (short)x3;
                rb.yedge[rb.nEdgePts] = (short)y3;
                rb.tx_xedge[rb.nEdgePts] = tx_x3;
                rb.tx_yedge[rb.nEdgePts] = tx_y3;
                ++rb.nEdgePts;
            } while (++x3 < rb.Xmax[y3]);
            rb.Xmin[y3] = (short)x3;
            x3 = rb.Xmax[y3];
            do {
                tx_x3 = m00 * x3 + m01 * y3 + m02;
                tx_y3 = m10 * x3 + m11 * y3 + m12;
                xx3 = tx_x3 >> 12;
                yy3 = tx_y3 >> 12;
                if (xx3 >= 0 && xx3 < iw - 1 && yy3 >= 0 && yy3 < ih - 1) break;
                if (xx3 <= 0 || yy3 <= 0) continue;
                rb.xedge[rb.nEdgePts] = (short)x3;
                rb.yedge[rb.nEdgePts] = (short)y3;
                rb.tx_xedge[rb.nEdgePts] = tx_x3;
                rb.tx_yedge[rb.nEdgePts] = tx_y3;
                ++rb.nEdgePts;
            } while (--x3 > rb.Xmin[y3]);
            rb.Xmax[y3] = (short)x3;
        }
        int y1 = rb.Ymin;
        int y22 = rb.Ymax;
        short[] xmin = rb.Xmin;
        short[] xmax = rb.Xmax;
        if (y1 > 0) {
            int len = Math.min(y1 * ow, output.length - 1);
            Arrays.fill(output, 0, len, (short)background);
        }
        int mask = (1 << bpp) - 1;
        if (pixelRepresentation == 0) {
            for (y2 = y1; y2 <= y22; ++y2) {
                offset3 = y2 * ow;
                tr_1 = m01 * y2 + m02;
                tr_2 = m11 * y2 + m12;
                if (xmin[y2] > 0) {
                    Arrays.fill(output, offset3, offset3 + xmin[y2], (short)background);
                }
                startx = xmin[y2];
                endx = xmax[y2];
                XX = m00 * startx;
                YY = m10 * startx;
                for (x2 = startx; x2 <= endx; ++x2) {
                    pix2 = background;
                    tx_x2 = XX + tr_1;
                    tx_y2 = YY + tr_2;
                    XX += m00;
                    YY += m10;
                    dxx2 = tx_x2 & 0xFFF;
                    dyy2 = tx_y2 & 0xFFF;
                    xx2 = tx_x2 >> 12;
                    yy2 = tx_y2 >> 12;
                    xx_12 = xx2 + 1;
                    yy_12 = yy2 + 1;
                    offset12 = yy2 * iw;
                    offset22 = offset12 + iw;
                    ul2 = offset12 + xx2;
                    ur2 = offset12 + xx_12;
                    bl2 = offset22 + xx2;
                    br2 = offset22 + xx_12;
                    int v0 = input[ioffset + ul2] & mask;
                    int v1 = input[ioffset + ur2] & mask;
                    int v2 = input[ioffset + bl2] & mask;
                    int v3 = input[ioffset + br2] & mask;
                    int p_ul2 = v0 & 0xFFFF;
                    int p_ur2 = v1 & 0xFFFF;
                    int p_bl2 = v2 & 0xFFFF;
                    int p_br2 = v3 & 0xFFFF;
                    int ry12 = (p_bl2 - p_ul2) * dyy2;
                    int ry22 = (p_br2 - p_ur2) * dyy2;
                    int p12 = (p_ul2 << 12) + ry12;
                    int p22 = (p_ur2 << 12) + ry22;
                    int rx2 = ((p22 >>= 12) - (p12 >>= 12)) * dxx2;
                    pix2 = p12 + (rx2 >>= 12);
                    int idx3 = offset3 + x2;
                    output[idx3] = (short)pix2;
                }
                if (xmax[y2] >= ow - 1 || (idx1 = offset3 + xmax[y2] + 1) > (idx2 = Math.min(offset3 + ow - 1, output.length - 1))) continue;
                Arrays.fill(output, offset3 + xmax[y2] + 1, offset3 + ow - 1, (short)background);
            }
        } else {
            for (y2 = y1; y2 <= y22; ++y2) {
                offset3 = y2 * ow;
                tr_1 = m01 * y2 + m02;
                tr_2 = m11 * y2 + m12;
                if (xmin[y2] > 0) {
                    Arrays.fill(output, offset3, offset3 + xmin[y2], (short)background);
                }
                startx = xmin[y2];
                endx = xmax[y2];
                XX = m00 * startx;
                YY = m10 * startx;
                for (x2 = startx; x2 <= endx; ++x2) {
                    pix2 = background;
                    tx_x2 = XX + tr_1;
                    tx_y2 = YY + tr_2;
                    XX += m00;
                    YY += m10;
                    dxx2 = tx_x2 & 0xFFF;
                    dyy2 = tx_y2 & 0xFFF;
                    xx2 = tx_x2 >> 12;
                    yy2 = tx_y2 >> 12;
                    xx_12 = xx2 + 1;
                    yy_12 = yy2 + 1;
                    offset12 = yy2 * iw;
                    offset22 = offset12 + iw;
                    ul2 = offset12 + xx2;
                    ur2 = offset12 + xx_12;
                    bl2 = offset22 + xx2;
                    br2 = offset22 + xx_12;
                    short p_ul3 = input[ioffset + ul2];
                    short p_ur3 = input[ioffset + ur2];
                    short p_bl3 = input[ioffset + bl2];
                    short p_br3 = input[ioffset + br2];
                    int ry13 = (p_bl3 - p_ul3) * dyy2;
                    int ry23 = (p_br3 - p_ur3) * dyy2;
                    int p13 = (p_ul3 << 12) + ry13;
                    int p23 = (p_ur3 << 12) + ry23;
                    int rx3 = ((p23 >>= 12) - (p13 >>= 12)) * dxx2;
                    pix2 = p13 + (rx3 >>= 12);
                    int idx4 = offset3 + x2;
                    output[idx4] = (short)pix2;
                }
                if (xmax[y2] >= ow - 1 || (idx1 = offset3 + xmax[y2] + 1) > (idx2 = Math.min(offset3 + ow - 1, output.length - 1))) continue;
                Arrays.fill(output, offset3 + xmax[y2] + 1, offset3 + ow - 1, (short)background);
            }
        }
        if (y22 < oh - 1) {
            int idx12 = (y22 + 1) * ow;
            int idx22 = output.length;
            Arrays.fill(output, idx12, idx22, (short)background);
        }
        if (pixelRepresentation == 0) {
            for (i = 0; i < rb.nEdgePts; ++i) {
                x = rb.xedge[i];
                y = rb.yedge[i];
                tx_x = rb.tx_xedge[i];
                tx_y = rb.tx_yedge[i];
                offset = y * ow;
                dxx = tx_x & 0xFFF;
                dyy = tx_y & 0xFFF;
                xx = tx_x >> 12;
                yy = tx_y >> 12;
                xx_1 = xx + 1;
                yy_1 = yy + 1;
                idx = offset + x;
                boolean bl3 = check = xx > 0 && xx < iw && yy > 0 && yy < ih && xx_1 > 0 && xx_1 < iw && yy_1 > 0 && yy_1 < ih;
                if (check) {
                    offset1 = yy * iw;
                    offset2 = yy_1 * iw;
                    ul = offset1 + xx;
                    ur = offset1 + xx_1;
                    bl = offset2 + xx;
                    br = offset2 + xx_1;
                    p_ul = input[ioffset + ul] & mask & 0xFFFF;
                    p_ur = input[ioffset + ur] & mask & 0xFFFF;
                    p_bl = input[ioffset + bl] & mask & 0xFFFF;
                    p_br = input[ioffset + br] & mask & 0xFFFF;
                    ry1 = (p_bl - p_ul) * dyy;
                    ry2 = (p_br - p_ur) * dyy;
                    p1 = (p_ul << 12) + ry1;
                    p2 = (p_ur << 12) + ry2;
                    rx = ((p2 >>= 12) - (p1 >>= 12)) * dxx;
                    pix = p1 + (rx >>= 12);
                    output[idx] = (short)pix;
                    continue;
                }
                output[idx] = background;
            }
        } else {
            for (i = 0; i < rb.nEdgePts; ++i) {
                x = rb.xedge[i];
                y = rb.yedge[i];
                tx_x = rb.tx_xedge[i];
                tx_y = rb.tx_yedge[i];
                offset = y * ow;
                dxx = tx_x & 0xFFF;
                dyy = tx_y & 0xFFF;
                xx = tx_x >> 12;
                yy = tx_y >> 12;
                xx_1 = xx + 1;
                yy_1 = yy + 1;
                idx = offset + x;
                boolean bl4 = check = xx > 0 && xx < iw && yy > 0 && yy < ih && xx_1 > 0 && xx_1 < iw && yy_1 > 0 && yy_1 < ih;
                if (check) {
                    offset1 = yy * iw;
                    offset2 = yy_1 * iw;
                    ul = offset1 + xx;
                    ur = offset1 + xx_1;
                    bl = offset2 + xx;
                    br = offset2 + xx_1;
                    p_ul = input[ioffset + ul];
                    p_ur = input[ioffset + ur];
                    p_bl = input[ioffset + bl];
                    p_br = input[ioffset + br];
                    ry1 = (p_bl - p_ul) * dyy;
                    ry2 = (p_br - p_ur) * dyy;
                    p1 = (p_ul << 12) + ry1;
                    p2 = (p_ur << 12) + ry2;
                    rx = ((p2 >>= 12) - (p1 >>= 12)) * dxx;
                    pix = p1 + (rx >>= 12);
                    output[idx] = (short)pix;
                    continue;
                }
                output[idx] = background;
            }
        }
    }

    public static void doBilinearIntToIntBox(double[] tx, double[] itx, int[] input, int ioffset, int iw, int ih, int[] output, int ow, int oh, RowBuffer rb, short background) {
        long t1 = System.currentTimeMillis();
        int ilen = iw * ih;
        int olen = output.length;
        rb.iul.setLocation(0.0, 0.0);
        rb.ibl.setLocation(0.0, ih - 1);
        rb.iur.setLocation(iw - 1, 0.0);
        rb.ibr.setLocation(iw - 1, ih - 1);
        double xxul = tx[0] * rb.iul.getX() + tx[2] * rb.iul.getY() + tx[4];
        double yyul = tx[1] * rb.iul.getX() + tx[3] * rb.iul.getY() + tx[5];
        int ixxul = (int)xxul;
        int iyyul = (int)yyul;
        double xxbl = tx[0] * rb.ibl.getX() + tx[2] * rb.ibl.getY() + tx[4];
        double yybl = tx[1] * rb.ibl.getX() + tx[3] * rb.ibl.getY() + tx[5];
        int ixxbl = (int)xxbl;
        int iyybl = (int)yybl;
        double xxur = tx[0] * rb.iur.getX() + tx[2] * rb.iur.getY() + tx[4];
        double yyur = tx[1] * rb.iur.getX() + tx[3] * rb.iur.getY() + tx[5];
        int ixxur = (int)xxur;
        int iyyur = (int)yyur;
        double xxbr = tx[0] * rb.ibr.getX() + tx[2] * rb.ibr.getY() + tx[4];
        double yybr = tx[1] * rb.ibr.getX() + tx[3] * rb.ibr.getY() + tx[5];
        int ixxbr = (int)xxbr;
        int iyybr = (int)yybr;
        rb.clear();
        Draw2DUtilsBase.lineBresenham(ixxul, iyyul, ixxur, iyyur, rb);
        Draw2DUtilsBase.lineBresenham(ixxul, iyyul, ixxbl, iyybl, rb);
        Draw2DUtilsBase.lineBresenham(ixxbl, iyybl, ixxbr, iyybr, rb);
        Draw2DUtilsBase.lineBresenham(ixxur, iyyur, ixxbr, iyybr, rb);
        int m00 = (int)(itx[0] * 4096.0);
        int m10 = (int)(itx[1] * 4096.0);
        int m01 = (int)(itx[2] * 4096.0);
        int m11 = (int)(itx[3] * 4096.0);
        int m02 = (int)(itx[4] * 4096.0);
        int m12 = (int)(itx[5] * 4096.0);
        rb.nEdgePts = 0;
        for (int y = rb.Ymin; y <= rb.Ymax; ++y) {
            int yy;
            int xx;
            int tx_y;
            int tx_x;
            int x = rb.Xmin[y];
            do {
                tx_x = m00 * x + m01 * y + m02;
                tx_y = m10 * x + m11 * y + m12;
                xx = tx_x >> 12;
                yy = tx_y >> 12;
                if (xx >= 0 && xx < iw - 1 && yy >= 0 && yy < ih - 1) break;
                if (xx <= 0 || yy <= 0) continue;
                rb.xedge[rb.nEdgePts] = (short)x;
                rb.yedge[rb.nEdgePts] = (short)y;
                rb.tx_xedge[rb.nEdgePts] = tx_x;
                rb.tx_yedge[rb.nEdgePts] = tx_y;
                ++rb.nEdgePts;
            } while (++x < rb.Xmax[y]);
            rb.Xmin[y] = (short)x;
            x = rb.Xmax[y];
            do {
                tx_x = m00 * x + m01 * y + m02;
                tx_y = m10 * x + m11 * y + m12;
                xx = tx_x >> 12;
                yy = tx_y >> 12;
                if (xx >= 0 && xx < iw - 1 && yy >= 0 && yy < ih - 1) break;
                if (xx <= 0 || yy <= 0) continue;
                rb.xedge[rb.nEdgePts] = (short)x;
                rb.yedge[rb.nEdgePts] = (short)y;
                rb.tx_xedge[rb.nEdgePts] = tx_x;
                rb.tx_yedge[rb.nEdgePts] = tx_y;
                ++rb.nEdgePts;
            } while (--x > rb.Xmin[y]);
            rb.Xmax[y] = (short)x;
        }
        int y1 = rb.Ymin;
        int y2 = rb.Ymax;
        short[] xmin = rb.Xmin;
        short[] xmax = rb.Xmax;
        if (y1 > 0) {
            int len = Math.min(y1 * ow, output.length - 1);
            Arrays.fill(output, 0, len, background);
        }
        for (int y = y1; y <= y2; ++y) {
            int idx2;
            int idx1;
            int offset = y * ow;
            int tr_1 = m01 * y + m02;
            int tr_2 = m11 * y + m12;
            if (xmin[y] > 0) {
                Arrays.fill(output, offset, offset + xmin[y], background);
            }
            int startx = xmin[y];
            short endx = xmax[y];
            int XX = startx * m00;
            int YY = startx * m10;
            for (int x = startx; x <= endx; ++x) {
                int pix = background;
                int tx_x = XX + tr_1;
                int tx_y = YY + tr_2;
                XX += m00;
                YY += m10;
                int dxx = tx_x & 0xFFF;
                int dyy = tx_y & 0xFFF;
                int xx = tx_x >> 12;
                int yy = tx_y >> 12;
                int xx_1 = xx + 1;
                int yy_1 = yy + 1;
                int offset1 = yy * iw;
                int offset2 = offset1 + iw;
                int ul = offset1 + xx;
                int ur = offset1 + xx_1;
                int bl = offset2 + xx;
                int br = offset2 + xx_1;
                int p_ul = input[ioffset + ul] & 0xFF;
                int p_ur = input[ioffset + ur] & 0xFF;
                int p_bl = input[ioffset + bl] & 0xFF;
                int p_br = input[ioffset + br] & 0xFF;
                int ry1 = (p_bl - p_ul) * dyy;
                int ry2 = (p_br - p_ur) * dyy;
                int p1 = (p_ul << 12) + ry1;
                int p2 = (p_ur << 12) + ry2;
                int rx = ((p2 >>= 12) - (p1 >>= 12)) * dxx;
                pix = p1 + (rx >>= 12);
                int idx = offset + x;
                output[idx] = 0xFF000000 | pix << 16 | pix << 8 | pix;
            }
            if (xmax[y] >= ow - 1 || (idx1 = offset + xmax[y] + 1) > (idx2 = Math.min(offset + ow - 1, output.length - 1))) continue;
            Arrays.fill(output, offset + xmax[y] + 1, offset + ow - 1, background);
        }
        if (y2 < oh - 1) {
            int idx1 = (y2 + 1) * ow;
            int idx2 = output.length;
            Arrays.fill(output, idx1, idx2, background);
        }
        for (int i = 0; i < rb.nEdgePts; ++i) {
            short x = rb.xedge[i];
            short y = rb.yedge[i];
            int tx_x = rb.tx_xedge[i];
            int tx_y = rb.tx_yedge[i];
            int offset = y * ow;
            int dxx = tx_x & 0xFFF;
            int dyy = tx_y & 0xFFF;
            int xx = tx_x >> 12;
            int yy = tx_y >> 12;
            int xx_1 = xx + 1;
            int yy_1 = yy + 1;
            int offset1 = yy * iw;
            int offset2 = yy_1 * iw;
            int ul = offset1 + xx;
            int ur = offset1 + xx_1;
            int bl = offset2 + xx;
            int br = offset2 + xx_1;
            int p_ul = ul < ilen ? input[ioffset + ul] & 0xFF : 0;
            int p_ur = ur < ilen ? input[ioffset + ur] & 0xFF : 0;
            int p_bl = bl < ilen ? input[ioffset + bl] & 0xFF : 0;
            int p_br = br < ilen ? input[ioffset + br] & 0xFF : 0;
            int ry1 = (p_bl - p_ul) * dyy;
            int ry2 = (p_br - p_ur) * dyy;
            int p1 = (p_ul << 12) + ry1;
            int p2 = (p_ur << 12) + ry2;
            int rx = ((p2 >>= 12) - (p1 >>= 12)) * dxx;
            int pix = p1 + (rx >>= 12);
            int idx = offset + x;
            output[idx] = 0xFF000000 | pix << 16 | pix << 8 | pix;
        }
    }

    public static class RowBuffer
    implements Draw2DUtilsBase.Raster2D {
        private int width = 0;
        private int height = 0;
        public short[] Xmin = null;
        public short[] Xmax = null;
        public short[] xedge = null;
        public short[] yedge = null;
        public int[] tx_xedge = null;
        public int[] tx_yedge = null;
        public int nEdgePts = 0;
        public int Ymin = Integer.MAX_VALUE;
        public int Ymax = Integer.MIN_VALUE;
        public int xmin = Integer.MAX_VALUE;
        public int xmax = Integer.MIN_VALUE;
        public JnPoint2D iul = new JnPoint2D.Double(0.0, 0.0);
        public JnPoint2D ibl = new JnPoint2D.Double(0.0, 0.0);
        public JnPoint2D iur = new JnPoint2D.Double(0.0, 0.0);
        public JnPoint2D ibr = new JnPoint2D.Double(0.0, 0.0);

        public RowBuffer(int w, int h) {
            this.width = w;
            this.height = h;
            this.Xmin = new short[this.height];
            this.Xmax = new short[this.height];
            this.nEdgePts = 0;
            int dim = this.width > this.height ? this.width : this.height;
            this.xedge = new short[3 * dim];
            this.yedge = new short[3 * dim];
            this.tx_xedge = new int[3 * dim];
            this.tx_yedge = new int[3 * dim];
        }

        @Override
        public final int getWidth() {
            return this.width;
        }

        @Override
        public final int getHeight() {
            return this.height;
        }

        @Override
        public final void clear() {
            Arrays.fill(this.Xmin, (short)Short.MAX_VALUE);
            Arrays.fill(this.Xmax, (short)Short.MIN_VALUE);
            this.Ymin = Short.MAX_VALUE;
            this.Ymax = Short.MIN_VALUE;
        }

        @Override
        public final void setPixel(int x, int y) {
            if (y < 0) {
                this.Ymin = 0;
                return;
            }
            if (y >= this.height) {
                this.Ymax = this.height - 1;
                return;
            }
            if (x < 0) {
                x = 0;
            } else if (x >= this.width) {
                x = this.width - 1;
            }
            if (y < this.Ymin) {
                this.Ymin = y;
            }
            if (y > this.Ymax) {
                this.Ymax = y;
            }
            if (x < this.Xmin[y]) {
                this.Xmin[y] = (short)x;
            }
            if (x > this.Xmax[y]) {
                this.Xmax[y] = (short)x;
            }
            if (x < this.xmin) {
                this.xmin = x;
            }
            if (x > this.xmax) {
                this.xmax = x;
            }
        }
    }
}

