/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.jnu.geom.ConversionUtility;
import com.ge.med.jnu.geom.JnAffineTransform;
import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;

public abstract class XpOffscreenRendererBase {
    protected XpGeomUtils geomUtils = new XpGeomUtils();
    protected IndexColorModel icm = null;
    protected int bitsAllocated = 0;
    protected int bitsStored = 0;

    public final void setImage(XpImage image, AffineTransform at) {
        this.setImage(image, ConversionUtility.toJnAffineTransform(at));
    }

    public abstract void setImage(XpImage var1, JnAffineTransform var2);

    public final AffineTransform getAffineTransform() {
        return ConversionUtility.toAffineTransform(this.getJnAffineTransform());
    }

    public abstract JnAffineTransform getJnAffineTransform();

    protected boolean isIdentity(AffineTransform at) {
        return this.isIdentity(ConversionUtility.toJnAffineTransform(at));
    }

    protected abstract boolean isIdentity(JnAffineTransform var1);

    public final void setImage(XpImage image, Point2D UL, Point2D UR, Point2D BR) {
        this.setImage(image, ConversionUtility.toJnPoint2D(UL), ConversionUtility.toJnPoint2D(UR), ConversionUtility.toJnPoint2D(BR));
    }

    public abstract void setImage(XpImage var1, JnPoint2D var2, JnPoint2D var3, JnPoint2D var4);

    protected final void calcInverse(AffineTransform src, AffineTransform dest) {
        this.geomUtils.calcInverse(src, dest);
    }

    public int getBitsAllocated() {
        RenderedImage inputImage;
        if (this.bitsAllocated < 0 && (inputImage = this.getImage().getPixelData()) != null) {
            int[] cc = inputImage.getColorModel().getComponentSize();
            this.bitsAllocated = cc[0];
        }
        return this.bitsAllocated;
    }

    public int getBitsStored() {
        RenderedImage inputImage;
        if (this.bitsStored < 0 && (inputImage = this.getImage().getPixelData()) != null) {
            int[] cc = inputImage.getColorModel().getComponentSize();
            this.bitsStored = cc[0];
        }
        return this.bitsStored;
    }

    public abstract XpImage getImage();

    protected short[] getLuminanceRasterARGBWWWLAffine() {
        BufferedImage img = (BufferedImage)this.getImage().getPixelData();
        DataBufferUShort dbus = (DataBufferUShort)img.getRaster().getDataBuffer();
        return dbus.getData();
    }

    protected int getLuminanceRasterOffsetARGBWWWLAffine() {
        BufferedImage img = (BufferedImage)this.getImage().getPixelData();
        DataBufferUShort dbus = (DataBufferUShort)img.getRaster().getDataBuffer();
        return dbus.getOffset();
    }

    protected boolean interpolationHintIsNearestNeighbor(Object interpolationHint) {
        return interpolationHint == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
    }
}

