/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.jnu.geom.ConversionUtility;
import com.ge.med.jnu.geom.JnAffineTransform;
import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImage2DRenderer;
import com.ge.med.terra.jami.render.XpImageDrawable;
import com.ge.med.terra.jami.render.XpJImage2DRenderer;
import com.ge.med.terra.jami.render.XpPipeline;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;

public abstract class XpJPipeline
extends XpPipeline {
    protected BufferedImage fusedImage = null;

    public final void doRender(Graphics2D g2, Rectangle viewport, XpJImage2DRenderer r, AffineTransform tx) {
        this.renderImage(g2, viewport, r, tx);
        this.setChangeRender(false);
        this.setChangeAffine(false);
    }

    protected abstract void renderImage(Graphics2D var1, Rectangle var2, XpJImage2DRenderer var3, AffineTransform var4);

    protected final void calcInverse(AffineTransform src, AffineTransform dest) {
        this.geomUtils.calcInverse(src, dest);
    }

    protected final BufferedImage fuseIt(BufferedImage image, XpJImage2DRenderer r, boolean didPixelTransfer) {
        BufferedImage result = image;
        XjFusionPixelCombiner fpc = r.getPixelCombiner();
        if (fpc != null && r.getNumImageLayers() > 1) {
            boolean imgLayerChange = r.isImageLayerRenderChange();
            if (this.cfpc != fpc || didPixelTransfer || imgLayerChange) {
                int w = image.getWidth();
                int h = image.getHeight();
                if (this.fusedImage == null || w != this.fusedImage.getWidth() || h != this.fusedImage.getHeight()) {
                    this.fusedImage = new BufferedImage(w, h, image.getType());
                }
                int[] output = ((DataBufferInt)this.fusedImage.getRaster().getDataBuffer()).getData();
                r.blendImageLayers(image, output);
            }
            result = this.fusedImage;
            this.cfpc = fpc;
        }
        return result;
    }

    public static void doBilinearToINT_RGBUpright(double[] tx, double[] itx, int[] input, int ioffset, int iw, int ih, int[] output, int ow, int oh, Point2D iul, Point2D ibl, Point2D iur, Point2D ibr, int background) {
        XpJPipeline.doBilinearToINT_RGBUpright(tx, itx, input, ioffset, iw, ih, output, ow, oh, ConversionUtility.toJnPoint2D(iul), ConversionUtility.toJnPoint2D(ibl), ConversionUtility.toJnPoint2D(iur), ConversionUtility.toJnPoint2D(ibr), background);
    }

    public static class LuminanceI2Pipeline
    extends XpJPipeline {
        private int outWidth = 0;
        private int outHeight = 0;
        private int inWidth;
        private int inHeight;
        private BufferedImage cacheImage = null;
        private JnAffineTransform inverse = new JnAffineTransform();
        private double[] tx = new double[6];
        private double[] itx = new double[6];
        private JnPoint2D iul = new JnPoint2D.Double(0.0, 0.0);
        private JnPoint2D ibl = new JnPoint2D.Double(0.0, 0.0);
        private JnPoint2D iur = new JnPoint2D.Double(0.0, 0.0);
        private JnPoint2D ibr = new JnPoint2D.Double(0.0, 0.0);
        private JnPoint2D tx_iul = new JnPoint2D.Double();
        private JnPoint2D tx_ibl = new JnPoint2D.Double();
        private JnPoint2D tx_iur = new JnPoint2D.Double();
        private JnPoint2D tx_ibr = new JnPoint2D.Double();
        private int outputType = 1;

        @Override
        protected void renderImage(Graphics2D g2, Rectangle viewport, XpJImage2DRenderer r, AffineTransform at) {
            BufferedImage src;
            double miny = 0.0;
            double maxy = 0.0;
            double minx = 0.0;
            double maxx = 0.0;
            int iminy = 0;
            int imaxy = 0;
            int iminx = 0;
            int imaxx = 0;
            XpImageDrawable drawable = r.getDrawable();
            JnAffineTransform jat = ConversionUtility.toJnAffineTransform(at);
            if (drawable == null) {
                return;
            }
            if (this.outWidth != viewport.width || this.outHeight != viewport.height) {
                this.outWidth = viewport.width;
                this.outHeight = viewport.height;
                int type = this.outputType == 0 ? 10 : 1;
                this.cacheImage = new BufferedImage(this.outWidth, this.outHeight, type);
                this.setChangeRender(true);
            }
            BufferedImage image = drawable.getBufferedImage();
            int w = image.getWidth();
            int h = image.getHeight();
            if (this.inWidth != w || this.inHeight != h) {
                this.inWidth = w;
                this.inHeight = h;
            }
            boolean didPixelTransfer = false;
            if (r.isComputePixelTransfer()) {
                r.computePixelTransfer();
                r.setComputePixelTransfer(false);
                didPixelTransfer = true;
            }
            if ((src = image) != (image = this.fuseIt(src, r, didPixelTransfer))) {
                this.setChangeRender(true);
            }
            jat.getMatrix(this.tx);
            if (w == this.outWidth && h == this.outHeight && this.tx[0] == 1.0 && this.tx[1] == 0.0 && this.tx[2] == 0.0 && this.tx[3] == 1.0) {
                int itx = (int)this.tx[4];
                int ity = (int)this.tx[5];
                g2.drawImage((Image)image, itx, ity, null);
                return;
            }
            if (this.isChangeRender()) {
                boolean uprightFlag;
                this.geomUtils.calcInverse(jat, this.inverse);
                this.inverse.getMatrix(this.itx);
                double dxx = this.itx[0] * 1.0 + this.itx[2] * 0.0;
                double dxy = this.itx[1] * 1.0 + this.itx[3] * 0.0;
                double dyx = this.itx[0] * 0.0 + this.itx[2] * 1.0;
                double dyy = this.itx[1] * 0.0 + this.itx[3] * 1.0;
                double dot = Math.abs(dxx * dyx + dxy * dyy);
                double angle = Math.acos((dxx * 1.0 + dxy * 0.0) / Math.sqrt(dxx * dxx + dxy * dxy));
                double angleDeg = Math.toDegrees(angle);
                double deg = angleDeg * 10000.0;
                int ideg = (int)deg;
                boolean bl = uprightFlag = ideg % 900000 == 0;
                if (uprightFlag && dot < 1.0E-4) {
                    DataBuffer db = image.getRaster().getDataBuffer();
                    int[] input = ((DataBufferInt)db).getData();
                    int[] output = ((DataBufferInt)this.cacheImage.getRaster().getDataBuffer()).getData();
                    LuminanceI2Pipeline.doBilinearToINT_RGBUpright(this.tx, this.itx, input, db.getOffset(), w, h, output, this.outWidth, this.outHeight, this.iul, this.ibl, this.iur, this.ibr, 0);
                } else {
                    double yy;
                    this.ibl.setLocation(0.0, h);
                    this.iur.setLocation(w, 0.0);
                    this.ibr.setLocation(w, h);
                    jat.transform(this.iul, this.tx_iul);
                    double xx = this.tx_iul.getX();
                    miny = yy = this.tx_iul.getY();
                    maxy = yy;
                    minx = xx;
                    maxx = xx;
                    jat.transform(this.ibl, this.tx_ibl);
                    xx = this.tx_ibl.getX();
                    yy = this.tx_ibl.getY();
                    miny = Math.min(miny, yy);
                    maxy = Math.max(maxy, yy);
                    minx = Math.min(minx, xx);
                    maxx = Math.max(maxx, xx);
                    jat.transform(this.iur, this.tx_iur);
                    xx = this.tx_iur.getX();
                    yy = this.tx_iur.getY();
                    miny = Math.min(miny, yy);
                    maxy = Math.max(maxy, yy);
                    minx = Math.min(minx, xx);
                    maxx = Math.max(maxx, xx);
                    jat.transform(this.ibr, this.tx_ibr);
                    xx = this.tx_ibr.getX();
                    yy = this.tx_ibr.getY();
                    miny = Math.min(miny, yy);
                    maxy = Math.max(maxy, yy);
                    minx = Math.min(minx, xx);
                    maxx = Math.max(maxx, xx);
                    miny = Math.max(miny, 0.0);
                    iminy = (int)miny;
                    maxy = Math.min(maxy, (double)(this.outHeight - 1));
                    imaxy = (int)maxy;
                    minx = Math.max(minx, 0.0);
                    iminx = (int)minx;
                    maxx = Math.min(maxx, (double)(this.outWidth - 1));
                    imaxx = (int)maxx;
                    DataBuffer db = image.getRaster().getDataBuffer();
                    int[] input = ((DataBufferInt)db).getData();
                    if (this.outputType == 0) {
                        byte[] output = ((DataBufferByte)this.cacheImage.getRaster().getDataBuffer()).getData();
                        LuminanceI2Pipeline.doBilinearToBYTE(this.itx, input, w, h, output, this.outWidth, this.outHeight, iminx, imaxx, iminy, imaxy, (byte)0);
                    } else {
                        int[] output = ((DataBufferInt)this.cacheImage.getRaster().getDataBuffer()).getData();
                        LuminanceI2Pipeline.doBilinearToINT_RGB(this.itx, input, w, h, output, this.outWidth, this.outHeight, iminx, imaxx, iminy, imaxy, 0);
                    }
                }
            }
            g2.drawImage((Image)this.cacheImage, 0, 0, null);
        }
    }

    public static class LuminanceCachePipeline
    extends XpJPipeline {
        private int outWidth = 0;
        private int outHeight = 0;
        private BufferedImage cacheImage = null;
        private boolean cacheRender = false;
        private int noChangeRun = 0;

        @Override
        public final void dispose() {
            this.outHeight = 0;
            this.outWidth = 0;
            this.cacheImage = null;
            this.cacheRender = false;
        }

        @Override
        protected void renderImage(Graphics2D g2, Rectangle viewport, XpJImage2DRenderer r, AffineTransform tx) {
            BufferedImage src;
            BufferedImage image;
            XpImageDrawable drawable = r.getDrawable();
            if (drawable == null) {
                return;
            }
            if (this.outWidth != viewport.width || this.outHeight != viewport.height) {
                this.outWidth = viewport.width;
                this.outHeight = viewport.height;
                int type = drawable.getBufferedImageType();
                this.cacheImage = new BufferedImage(this.outWidth, this.outHeight, type);
                this.setChangeRender(true);
            }
            if (this.isChangeRender()) {
                this.noChangeRun = 0;
                this.cacheRender = false;
            } else {
                ++this.noChangeRun;
            }
            boolean didPixelTransfer = false;
            if (r.isComputePixelTransfer()) {
                r.computePixelTransfer();
                r.setComputePixelTransfer(false);
                didPixelTransfer = true;
                this.noChangeRun = 0;
            }
            if ((image = this.fuseIt(src = drawable.getBufferedImage(), r, didPixelTransfer)) != src) {
                this.cacheRender = false;
                this.noChangeRun = 0;
            }
            if (this.noChangeRun == 2) {
                Graphics2D bg2 = (Graphics2D)this.cacheImage.getGraphics();
                bg2.setBackground(r.getBackground());
                bg2.clearRect(0, 0, this.outWidth, this.outHeight);
                Object iHint = r.getInterpolationHint();
                if (iHint != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                    bg2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, iHint);
                }
                r.applyClip(bg2);
                bg2.drawRenderedImage(image, tx);
                r.clearClip(bg2);
                this.cacheRender = true;
            }
            if (this.cacheRender) {
                g2.drawImage((Image)this.cacheImage, 0, 0, null);
            } else {
                g2.drawRenderedImage(image, tx);
            }
        }
    }

    public static class LuminancePipeline
    extends XpJPipeline {
        private AffineTransform inverse = new AffineTransform();

        @Override
        protected void renderImage(Graphics2D g2, Rectangle viewport, XpJImage2DRenderer r, AffineTransform tx) {
            boolean didPixelTransfer = false;
            if (r.isComputePixelTransfer()) {
                r.computePixelTransfer();
                r.setComputePixelTransfer(false);
                didPixelTransfer = true;
            }
            BufferedImage image = r.getDrawable().getBufferedImage();
            image = this.fuseIt(image, r, didPixelTransfer);
            this.calcInverse(tx, this.inverse);
            g2.transform(tx);
            g2.drawImage((Image)image, 0, 0, null);
            g2.transform(this.inverse);
        }
    }

    public static class GenericPipeline
    extends XpJPipeline {
        private BufferedImage cacheImage = null;

        @Override
        protected void renderImage(Graphics2D g2, Rectangle viewport, XpJImage2DRenderer r, AffineTransform tx) {
            BufferedImage bimg;
            RenderedImage ri = r.getSourceImage();
            boolean didPixelTransfer = false;
            if (r.isComputePixelTransfer()) {
                r.setComputePixelTransfer(false);
                didPixelTransfer = true;
                if (ri instanceof BufferedImage) {
                    XpColorOverlay co;
                    bimg = (BufferedImage)ri;
                    int width = bimg.getWidth();
                    int height = bimg.getHeight();
                    int type = bimg.getType();
                    if (type == 0) {
                        if (this.cacheImage == null || this.cacheImage.getWidth() != width || this.cacheImage.getHeight() != height) {
                            this.cacheImage = new BufferedImage(width, height, 1);
                        }
                        if (XpImage2DRenderer.computeRGBOverlay(bimg, this.cacheImage)) {
                            ri = this.cacheImage;
                        }
                    }
                    if ((co = r.getAttributes().getColorOverlay()) != null) {
                        if (this.cacheImage == null || this.cacheImage.getWidth() != ri.getWidth() || this.cacheImage.getHeight() != ri.getHeight()) {
                            this.cacheImage = new BufferedImage(ri.getWidth(), ri.getHeight(), 1);
                        }
                        XpImage2DRenderer.applyColorOverlay(bimg, this.cacheImage, co);
                        ri = this.cacheImage;
                    }
                }
            } else if (this.cacheImage != null) {
                ri = this.cacheImage;
            }
            if (ri instanceof BufferedImage) {
                bimg = (BufferedImage)ri;
                ri = this.fuseIt(bimg, r, didPixelTransfer);
            }
            g2.drawRenderedImage(ri, tx);
        }
    }
}

