/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.DICOMLut;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageLayer;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.image.XpImage2DModel;
import com.ge.med.terra.jami.image.XpImageData;
import com.ge.med.terra.jami.render.PixelWindowing;
import com.ge.med.terra.jami.render.VoiType;
import com.ge.med.terra.jami.render.VoiUtils;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpDicomOverlays;
import com.ge.med.terra.jami.render.XpDrawableFactory;
import com.ge.med.terra.jami.render.XpImageDrawable;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpOffscreenRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public abstract class XpImage2DRenderer
extends ComponentUI {
    public static final int MONOCHROME1 = 100;
    public static final int MONOCHROME2 = 101;
    private static final int RGB = 102;
    private static final int PALETTECOLOR = 103;
    public final double ZOOM_NUDGE = 1.000000000001;
    public final double INV_NUDGE = 0.9999999999989999;
    private static final String noImageMessage;
    private static final String emptyFontName;
    private static final int emptyFontSize;
    private static final Font emptyMsgFont;
    public static boolean needClipNudge;
    public static final int WWWL_STAGE = 0;
    private static int renderIdPool;
    private static XpDrawableFactory defaultFactory;
    private static double DPINCH;
    private boolean transformDirty = true;
    private boolean pixelTransferDirty = true;
    private Rectangle lastViewport = new Rectangle();
    private boolean _didTransformOp = false;
    private XpImage2DModel model = new XpImage2DModel();
    private Shape clipShape = null;
    private Shape imageClipShape = null;
    private Object interpolationHint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private XpImage image = null;
    private XpGeomUtils gu = new XpGeomUtils();
    private List currentOpList = new ArrayList();
    private BufferedImage opImg1 = null;
    private BufferedImage opImg2 = null;
    private XpDrawableFactory drwFactory = defaultFactory;
    private boolean wwwlStage = true;
    private boolean fitToViewport = true;
    private int rendererId = 0;
    private double azimuth = 0.0;
    private int bitsAllocated = 0;
    private int bitsStored = 0;
    private int pixelRepresentation = 1;
    private int pixelPaddingValue = 0;
    private int photometricInterpretation = 101;
    private long lastRenderTimeStamp = 0L;
    private Rectangle viewport = new Rectangle();
    private boolean pixelsLoaded = false;
    private DICOMLut modlut = null;
    protected DICOMLut[] voiluts = null;
    protected VoiType voiType = VoiType.VOI_LINEAR;
    private PixelWindowing pixwin = new PixelWindowing();
    private Component component = null;
    private int imageLayer = 0;
    private int[][] img_layers = null;
    private XjFusionPixelCombiner fpc = null;
    private Point2D[] ptsClippedArea = new Point2D[4];
    private Point2D[] ptsImgBorder = new Point2D[4];
    public static boolean removeSawtooth;
    private double[] dPtCoords = new double[6];
    private Stroke STROKE_OUTER = new BasicStroke(2.0f);
    private CPoint cpImg1 = new CPoint(1);
    private CPoint cpImg2 = new CPoint(1);
    private CPoint cpImg3 = new CPoint(1);
    private CPoint cpImg4 = new CPoint(1);
    private CPoint cpImg = new CPoint(0);
    private static final int BITS_ALLOCATED = 0;
    private static final int BITS_STORED = 1;
    private static final int PIXEL_REPRESENTATION = 2;
    private static final int PIXEL_PADDING = 3;
    private static final int PHOTOMETRIC_INTERPRETATION = 4;
    private XpDicomElement[] pixvalues = new XpDicomElement[]{new XpDicomElement(40, 256), new XpDicomElement(40, 257), new XpDicomElement(40, 259), new XpDicomElement(40, 288), new XpDicomElement(40, 4)};
    private XpDicomOverlays dicomOverlays = null;
    private AffineTransform inv_tx = new AffineTransform();
    private Shape saveClip = null;
    private BufferedImage colorPaletteImage = null;
    private CPoint ras_pt = new CPoint(2);
    private CPoint tempImg = new CPoint(0);

    public XpImage2DRenderer() {
        this.rendererId = renderIdPool++;
        for (int i = 0; i < this.ptsClippedArea.length; ++i) {
            this.ptsClippedArea[i] = new Point2D.Double();
            this.ptsImgBorder[i] = new Point2D.Double();
        }
    }

    protected int getPhotometricInterpretation() {
        return this.photometricInterpretation;
    }

    public final int getRendererId() {
        return this.rendererId;
    }

    public final Color getBackground() {
        if (this.component != null) {
            return this.component.getBackground();
        }
        return Color.black;
    }

    protected XpDicomOverlays getDicomOverlays() {
        return this.dicomOverlays;
    }

    public void dispose() {
        List layers = this.getImageLayers();
        if (layers != null) {
            for (int i = 0; i < layers.size(); ++i) {
                XpImageLayer il = (XpImageLayer)layers.get(i);
                if (il == null) continue;
                il.dispose();
            }
            layers.clear();
        }
    }

    public final void configPipeline(int pipelineStage, boolean execute) {
        switch (pipelineStage) {
            case 0: {
                this.wwwlStage = execute;
            }
        }
    }

    public final boolean isClip() {
        Shape iraImageClipShape = null;
        Shape iraClipShape = null;
        if (this.model.attributes != null) {
            iraImageClipShape = this.model.attributes.getImageClip();
            iraClipShape = this.model.attributes.getClipShape();
        }
        return this.imageClipShape != null || iraImageClipShape != null || this.clipShape != null || iraClipShape != null;
    }

    public final void applyClip(Graphics2D g2) {
        this.saveClip = g2.getClip();
        Shape iraImageClipShape = null;
        Shape iraClipShape = null;
        if (this.model.attributes != null) {
            iraImageClipShape = this.model.attributes.getImageClip();
            iraClipShape = this.model.attributes.getClipShape();
        }
        if (this.imageClipShape != null || iraImageClipShape != null) {
            AffineTransform tx = this.getAffineTransform();
            this.gu.calcInverse(tx, this.inv_tx);
            g2.transform(tx);
            if (this.imageClipShape != null) {
                g2.clip(this.imageClipShape);
            }
            if (iraImageClipShape != null) {
                g2.clip(iraImageClipShape);
            }
            g2.transform(this.inv_tx);
        }
        if (this.clipShape != null) {
            g2.clip(this.clipShape);
        }
        if (iraClipShape != null) {
            g2.clip(iraClipShape);
        }
        if (needClipNudge && (this.clipShape != null || this.imageClipShape != null || iraImageClipShape != null || iraClipShape != null)) {
            g2.scale(1.000000000001, 1.000000000001);
        }
    }

    private void calcClipPoints(Point2D[] ptsClippedArea) {
        AffineTransform tx = this.getAffineTransform();
        PathIterator pIter = this.imageClipShape.getPathIterator(tx);
        int iCounter = 0;
        while (!pIter.isDone()) {
            int iSegmentType = pIter.currentSegment(this.dPtCoords);
            switch (iSegmentType) {
                case 0: {
                    ptsClippedArea[iCounter].setLocation(this.dPtCoords[0], this.dPtCoords[1]);
                    ++iCounter;
                    break;
                }
                case 1: {
                    ptsClippedArea[iCounter].setLocation(this.dPtCoords[0], this.dPtCoords[1]);
                    ++iCounter;
                    break;
                }
            }
            pIter.next();
        }
    }

    private void drawBorders(Graphics2D g2) {
        g2.setColor(Color.black);
        g2.setStroke(this.STROKE_OUTER);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Line2D.Double l = new Line2D.Double();
        for (int i = 0; i < this.ptsImgBorder.length; ++i) {
            if (this.isClip()) {
                ((Line2D)l).setLine(this.ptsClippedArea[i].getX(), this.ptsClippedArea[i].getY(), this.ptsClippedArea[(i + 1) % this.ptsClippedArea.length].getX(), this.ptsClippedArea[(i + 1) % this.ptsClippedArea.length].getY());
                g2.draw(l);
            }
            ((Line2D)l).setLine(this.ptsImgBorder[i].getX(), this.ptsImgBorder[i].getY(), this.ptsImgBorder[(i + 1) % this.ptsImgBorder.length].getX(), this.ptsImgBorder[(i + 1) % this.ptsImgBorder.length].getY());
            g2.draw(l);
        }
    }

    private void calcImageBorder(Point2D[] ptsImgBorder) {
        double x1 = this.getImage().getMinX();
        double x2 = this.getImage().getMinX() + this.getImage().getWidth();
        double y1 = this.getImage().getMinY();
        double y2 = this.getImage().getMinY() + this.getImage().getHeight();
        this.cpImg1.x = x1;
        this.cpImg1.y = y1;
        this.cpImg2.x = x2;
        this.cpImg2.y = y1;
        this.cpImg3.x = x2;
        this.cpImg3.y = y2;
        this.cpImg4.x = x1;
        this.cpImg4.y = y2;
        this.getTransform().transform(this.cpImg1, this.cpImg);
        ptsImgBorder[0].setLocation(this.cpImg.x, this.cpImg.y);
        this.getTransform().transform(this.cpImg2, this.cpImg);
        ptsImgBorder[1].setLocation(this.cpImg.x, this.cpImg.y);
        this.getTransform().transform(this.cpImg3, this.cpImg);
        ptsImgBorder[2].setLocation(this.cpImg.x, this.cpImg.y);
        this.getTransform().transform(this.cpImg4, this.cpImg);
        ptsImgBorder[3].setLocation(this.cpImg.x, this.cpImg.y);
    }

    public final void clearClip(Graphics2D g2) {
        if (this.isClip()) {
            g2.setClip(this.saveClip);
            if (needClipNudge) {
                g2.scale(0.9999999999989999, 0.9999999999989999);
            }
        }
    }

    protected void setChangeRender() {
    }

    public final void renderImage(Graphics graphics, Rectangle viewport) {
        Graphics2D g2 = (Graphics2D)graphics;
        if (this.getImage() != null) {
            this.computeTransform(viewport);
            if (this.isClip()) {
                g2.setColor(this.getBackground());
                g2.fillRect(0, 0, viewport.width, viewport.height);
            }
            this.applyClip(g2);
            this.render(g2, viewport);
            if (removeSawtooth) {
                if (this.isClip()) {
                    this.calcClipPoints(this.ptsClippedArea);
                }
                this.calcImageBorder(this.ptsImgBorder);
                this.drawBorders(g2);
            }
            this.clearClip(g2);
            this.lastRenderTimeStamp = System.currentTimeMillis();
        }
    }

    public abstract void render(Graphics var1, Rectangle var2);

    public final void setImageRenderAttributes(XpImageRenderAttributes attr) {
        this.model.attributes = attr;
        this.transformDirty = true;
        this.newImageRenderAttributesCB(attr);
        if (!this.sameList(this.currentOpList, attr.getImageOperations())) {
            this.assignList(this.currentOpList, attr.getImageOperations());
            this.loadPixelData();
        }
    }

    public void newImageRenderAttributesCB(XpImageRenderAttributes attr) {
    }

    public final XpImageRenderAttributes getImageRenderAttributes() {
        return this.model.attributes;
    }

    public XpImagePixelAttributes getImagePixelAttributes(int layer) {
        if (layer == 0) {
            return this.model.attributes.getImagePixelAttributes();
        }
        int len = this.model.imgLayers.size();
        if (layer <= len) {
            XpImageLayer il = (XpImageLayer)this.model.imgLayers.get(layer - 1);
            return il.getImagePixelAttributes();
        }
        return null;
    }

    public void refreshImageRenderAttributes() {
        this.pixelTransferDirty = true;
        this.setImageRenderAttributes(this.model.attributes);
    }

    public void refreshImage() {
        this.loadXpImage(this.image);
    }

    public final long getRenderTimeStamp() {
        return this.lastRenderTimeStamp;
    }

    private void loadPixelData() {
        XpImage theImage = this.image;
        if (theImage != null) {
            RenderedImage ri = null;
            if (this.photometricInterpretation == 103 && theImage instanceof XpMedicalImage) {
                this.colorPaletteImage = XpImageUtils.loadColorPalette((XpMedicalImage)theImage, this.colorPaletteImage);
                ri = this.colorPaletteImage;
            } else {
                ri = theImage.getPixelData();
            }
            ColorModel cm = ri.getColorModel();
            this.pixwin.loadColorOverrides(cm);
            this.transformDirty = true;
            this.pixelsLoaded = true;
            this.voiluts = null;
            this.modlut = null;
            this.voiType = VoiType.VOI_LINEAR;
            RenderedImage opImage = this.doImageOperations(ri);
            if (theImage instanceof XpMedicalImage) {
                XpMedicalImage mimg = (XpMedicalImage)theImage;
                this.voiluts = DICOMLut.loadVoiLuts(mimg);
                this.voiType = VoiUtils.getVoiFunctionType(mimg);
            }
            this.newImageCB(opImage);
        }
    }

    public String[] getVOILutDescriptions() {
        if (this.voiluts != null) {
            String[] desc = new String[this.voiluts.length];
            for (int i = 0; i < this.voiluts.length; ++i) {
                desc[i] = this.voiluts[i].getLutExplanation();
            }
            return desc;
        }
        return null;
    }

    protected void cleanImage() {
    }

    private void loadXpImage(XpImage img) {
        List layers;
        if (img != null) {
            int oldW = -99;
            int oldH = -99;
            XpImage theImage = this.image;
            if (theImage != null) {
                XpSlice s = theImage.getSlice();
                oldW = s.width;
                oldH = s.height;
            }
            XpSlice newSl = img.getSlice();
            if (oldW != newSl.width || oldH != newSl.height) {
                this.transformDirty = true;
            }
            this.azimuth = img.getAzimuth();
            this.model.width = newSl.width;
            this.model.height = newSl.height;
            boolean loadBitsAlloc = false;
            boolean loadBitsStored = false;
            boolean loadPixelRep = false;
            boolean loadPixelPadding = false;
            boolean loadPhotometric = false;
            if (img instanceof XpDicomObject) {
                XpDicomObject dobj = (XpDicomObject)((Object)img);
                loadBitsAlloc = dobj.getValue(this.pixvalues[0]) == 0;
                loadBitsStored = dobj.getValue(this.pixvalues[1]) == 0;
                loadPixelRep = dobj.getValue(this.pixvalues[2]) == 0;
                loadPixelPadding = dobj.getValue(this.pixvalues[3]) == 0;
                boolean bl = loadPhotometric = dobj.getValue(this.pixvalues[4]) == 0;
                if (loadBitsAlloc) {
                    String bits_alloc = "" + this.pixvalues[0].value;
                    try {
                        this.bitsAllocated = Integer.parseInt(bits_alloc);
                        if (this.bitsAllocated <= 0) {
                            loadBitsAlloc = false;
                        }
                    }
                    catch (NumberFormatException ne) {
                        loadBitsAlloc = false;
                    }
                }
                if (loadBitsStored) {
                    String bits_stored = "" + this.pixvalues[1].value;
                    try {
                        this.bitsStored = Integer.parseInt(bits_stored);
                        if (this.bitsStored <= 0) {
                            loadBitsStored = false;
                        }
                    }
                    catch (NumberFormatException ne) {
                        loadBitsStored = false;
                    }
                }
                if (loadPixelRep) {
                    try {
                        this.pixelRepresentation = Integer.parseInt("" + this.pixvalues[2].value);
                    }
                    catch (NumberFormatException ne) {
                        loadPixelRep = false;
                    }
                }
                if (loadPixelPadding) {
                    try {
                        this.pixelPaddingValue = Integer.parseInt("" + this.pixvalues[3].value);
                    }
                    catch (NumberFormatException ne) {
                        loadPixelPadding = false;
                    }
                }
                if (loadPhotometric) {
                    String sphotometric = ("" + this.pixvalues[4].value).toUpperCase();
                    if (sphotometric.indexOf("MONOCHROME2") >= 0) {
                        this.photometricInterpretation = 101;
                    } else if (sphotometric.indexOf("RGB") >= 0) {
                        this.photometricInterpretation = 102;
                    } else if (sphotometric.indexOf("MONOCHROME1") >= 0) {
                        this.photometricInterpretation = 100;
                    } else if (sphotometric.indexOf("PALETTE COLOR") >= 0) {
                        this.photometricInterpretation = 103;
                    }
                }
            }
            if (!loadBitsAlloc) {
                this.bitsAllocated = -1;
            }
            if (!loadBitsStored) {
                this.bitsStored = -1;
            }
            if (!loadPixelRep) {
                this.pixelRepresentation = 1;
            }
            if (!loadPixelPadding) {
                this.pixelPaddingValue = -2000;
            }
            if (!loadPhotometric) {
                this.photometricInterpretation = 101;
            }
        } else {
            this.cleanImage();
        }
        this.image = img;
        this.pixelsLoaded = false;
        String showDicomOverlays = XpPropertiesManager.getProperty("jami.dicomoverlays.show", "true");
        if (showDicomOverlays.compareToIgnoreCase("true") == 0 && img instanceof XpMedicalImage) {
            this.dicomOverlays = XpDicomOverlays.createDicomOverlays((XpMedicalImage)img);
        }
        if ((layers = this.model.imgLayers) != null) {
            int len = layers.size();
            for (int i = 0; i < len; ++i) {
                XpImageLayer il = (XpImageLayer)layers.get(i);
                XpOffscreenRenderer offscreen = il.getOffscreenRenderer();
                if (offscreen == null) continue;
                offscreen.refresh();
            }
        }
    }

    public final double getAzimuth() {
        return this.azimuth;
    }

    public final double getRescaleSlope() {
        if (this.image != null) {
            return this.image.getRescaleSlope();
        }
        return 1.0;
    }

    public final double getRescaleIntercept() {
        if (this.image != null) {
            return this.image.getRescaleIntercept();
        }
        return 0.0;
    }

    public final void setImage(XpImage image) {
        if (image == this.image) {
            return;
        }
        this.loadXpImage(image);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public final List getImageLayers() {
        return this.model.imgLayers;
    }

    public int getNumImageLayers() {
        if (this.model.imgLayers != null) {
            return this.model.imgLayers.size() + 1;
        }
        return 1;
    }

    public final void setImageLayers(List imgLayers) {
        this.model.imgLayers = imgLayers;
    }

    protected boolean renderImageLayers() {
        boolean toFuse = false;
        List layers = this.model.imgLayers;
        if (layers != null && this.image != null) {
            int len = layers.size();
            for (int i = 0; i < len; ++i) {
                XpImageLayer il = (XpImageLayer)layers.get(i);
                int[] outbuffer = null;
                if (il.frame == null) continue;
                XpOffscreenRenderer offscreen = il.getOffscreenRenderer();
                if (offscreen == null) {
                    int iw = this.model.width;
                    int ih = this.model.height;
                    XpSlice baseSlice = this.image.getSlice();
                    il.resizeOffscreenRenderer(iw, ih);
                    offscreen = il.getOffscreenRenderer();
                    XpImage img = il.frame;
                    XpSlice slice = img.getSlice();
                    CTransform img2ras = (CTransform)baseSlice.getImageToRasTransform().clone();
                    CTransform txRAS2Image = img2ras.inverse();
                    this.ras_pt.scaleAdd(-slice.pixelSizeX * 0.5, slice.I, slice.ul);
                    this.ras_pt.scaleAdd(-slice.pixelSizeY * 0.5, slice.J, this.ras_pt);
                    txRAS2Image.transform(this.ras_pt, this.tempImg);
                    Point2D.Double ul = new Point2D.Double(this.tempImg.x, this.tempImg.y);
                    this.ras_pt.scaleAdd((double)slice.width * slice.pixelSizeX, slice.I);
                    txRAS2Image.transform(this.ras_pt, this.tempImg);
                    Point2D.Double ur = new Point2D.Double(this.tempImg.x, this.tempImg.y);
                    this.ras_pt.scaleAdd((double)slice.height * slice.pixelSizeY, slice.J);
                    txRAS2Image.transform(this.ras_pt, this.tempImg);
                    Point2D.Double br = new Point2D.Double(this.tempImg.x, this.tempImg.y);
                    offscreen.setImage(img, ul, ur, br);
                    il.loadImagePixelAttributes();
                } else if (this.isPixelTransferDirty()) {
                    il.loadImagePixelAttributes();
                }
                offscreen.render(this.getInterpolationHint(), 0.0);
                outbuffer = offscreen.getRaster();
                toFuse = true;
            }
        }
        this.setPixelTransferDirty(false);
        return toFuse;
    }

    public boolean isImageLayerRenderChange() {
        List layers = this.model.imgLayers;
        if (layers != null) {
            int len = layers.size();
            for (int i = 0; i < len; ++i) {
                XpImageLayer il = (XpImageLayer)layers.get(i);
                XpOffscreenRenderer or = il.getOffscreenRenderer();
                if (or == null || !or.isPixelTransfer()) continue;
                return true;
            }
        }
        return false;
    }

    public final void blendImageLayers(BufferedImage bimg, int[] output) {
        List layers = this.model.imgLayers;
        if (this.fpc != null && layers != null) {
            boolean toFuse = this.renderImageLayers();
            int len = layers.size();
            int nlayers = len + 1;
            int width = bimg.getWidth();
            int height = bimg.getHeight();
            if (this.img_layers == null || this.img_layers.length != nlayers) {
                this.img_layers = new int[nlayers][];
            }
            for (int i = 0; i < len; ++i) {
                XpOffscreenRenderer offscreen;
                XpImageLayer il = (XpImageLayer)layers.get(i);
                if (il.frame == null || (offscreen = il.getOffscreenRenderer()) == null) continue;
                this.img_layers[i + 1] = offscreen.getRaster();
            }
            DataBuffer db = bimg.getRaster().getDataBuffer();
            if (db instanceof DataBufferInt) {
                this.img_layers[0] = ((DataBufferInt)db).getData();
                if (toFuse) {
                    this.fpc.blendRGB(this.img_layers, width, height, output);
                } else {
                    System.arraycopy(this.img_layers[0], 0, output, 0, output.length);
                }
            }
        }
    }

    public static void applyColorOverlay(BufferedImage srcImage, BufferedImage dstImage, XpColorOverlay co) {
        block17: {
            int ALPHA_MAX;
            int endoffset;
            int offset;
            int[] cmap;
            int co_offset;
            Object overlaydata;
            DataBuffer srcdb;
            block15: {
                int[] srcpixels;
                block16: {
                    srcdb = srcImage.getRaster().getDataBuffer();
                    int[] dstpixels = ((DataBufferInt)dstImage.getRaster().getDataBuffer()).getData();
                    overlaydata = co.getOverlay();
                    co_offset = co.getOffset();
                    cmap = co.getColorMap();
                    DataBuffer buffer = srcImage.getData().getDataBuffer();
                    int length = buffer.getSize();
                    offset = buffer.getOffset();
                    endoffset = offset + length;
                    ALPHA_MAX = 255;
                    if (!(srcdb instanceof DataBufferInt)) break block15;
                    srcpixels = ((DataBufferInt)srcdb).getData();
                    if (!(overlaydata instanceof byte[])) break block16;
                    byte[] overlay = (byte[])overlaydata;
                    int srcIdx = offset;
                    int overlayIdx = co_offset;
                    while (srcIdx < endoffset) {
                        int pixVal = srcpixels[srcIdx] & 0xFFFFFFFF;
                        byte maskIdx = overlay[overlayIdx];
                        if (maskIdx > -1) {
                            int maskVal = cmap[maskIdx];
                            int red = (pixVal & 0xFF0000) >> 16;
                            int green = (pixVal & 0xFF00) >> 8;
                            int blue = pixVal & 0xFF;
                            int malpha = (maskVal & 0xFF000000) >> 24;
                            int mred = (maskVal & 0xFF0000) >> 16;
                            int mgreen = (maskVal & 0xFF00) >> 8;
                            int mblue = maskVal & 0xFF;
                            malpha = malpha < 0 ? ALPHA_MAX + malpha : malpha;
                            int ONE_MINALPHA = ALPHA_MAX - malpha;
                            int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                            int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                            int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                            pixVal = 0xFF000000 | (pred &= 0xFF) << 16 | (pgreen &= 0xFF) << 8 | (pblue &= 0xFF);
                        }
                        dstpixels[srcIdx] = pixVal;
                        ++srcIdx;
                        ++overlayIdx;
                    }
                    break block17;
                }
                if (!(overlaydata instanceof short[])) break block17;
                short[] overlay = (short[])overlaydata;
                int srcIdx = offset;
                int overlayIdx = co_offset;
                while (srcIdx < endoffset) {
                    int pixVal = srcpixels[srcIdx] & 0xFFFFFFFF;
                    short maskIdx = overlay[overlayIdx];
                    if (maskIdx > -1) {
                        int maskVal = cmap[maskIdx];
                        int red = (pixVal & 0xFF0000) >> 16;
                        int green = (pixVal & 0xFF00) >> 8;
                        int blue = pixVal & 0xFF;
                        int malpha = (maskVal & 0xFF000000) >> 24;
                        int mred = (maskVal & 0xFF0000) >> 16;
                        int mgreen = (maskVal & 0xFF00) >> 8;
                        int mblue = maskVal & 0xFF;
                        malpha = malpha < 0 ? ALPHA_MAX + malpha : malpha;
                        int ONE_MINALPHA = ALPHA_MAX - malpha;
                        int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                        int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                        int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                        pixVal = 0xFF000000 | (pred &= 0xFF) << 16 | (pgreen &= 0xFF) << 8 | (pblue &= 0xFF);
                    }
                    dstpixels[srcIdx] = pixVal;
                    ++srcIdx;
                    ++overlayIdx;
                }
                break block17;
            }
            if (srcdb instanceof DataBufferByte) {
                byte[] srcpixels = ((DataBufferByte)srcdb).getData();
                int numOfBanks = 4;
                int bankOffset = 1;
                if (srcImage.getType() == 5) {
                    numOfBanks = 3;
                    bankOffset = 0;
                }
                if (overlaydata instanceof byte[]) {
                    byte[] overlay = (byte[])overlaydata;
                    int overlayIdx = co_offset;
                    int srcIdx = offset + bankOffset;
                    int dstIdx = offset;
                    while (srcIdx < endoffset) {
                        byte maskIdx = overlay[overlayIdx];
                        if (maskIdx > -1) {
                            int maskVal = cmap[maskIdx];
                            int blue = srcpixels[srcIdx] & 0xFF;
                            int green = srcpixels[srcIdx + 1] & 0xFF;
                            int red = srcpixels[srcIdx + 2] & 0xFF;
                            int malpha = (maskVal & 0xFF000000) >> 24;
                            int mred = (maskVal & 0xFF0000) >> 16;
                            int mgreen = (maskVal & 0xFF00) >> 8;
                            int mblue = maskVal & 0xFF;
                            malpha = malpha < 0 ? ALPHA_MAX + malpha : malpha;
                            int ONE_MINALPHA = ALPHA_MAX - malpha;
                            int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                            int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                            int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                            dstpixels[dstIdx] = 0xFF000000 | (pred &= 0xFF) << 16 | (pgreen &= 0xFF) << 8 | (pblue &= 0xFF);
                        } else {
                            int blue = srcpixels[srcIdx] & 0xFF;
                            int green = srcpixels[srcIdx + 1] & 0xFF;
                            int red = srcpixels[srcIdx + 2] & 0xFF;
                            dstpixels[dstIdx] = 0xFF000000 | red << 16 | green << 8 | blue;
                        }
                        srcIdx += numOfBanks;
                        ++dstIdx;
                        ++overlayIdx;
                    }
                } else if (overlaydata instanceof short[]) {
                    short[] overlay = (short[])overlaydata;
                    int overlayIdx = co_offset + bankOffset;
                    int srcIdx = offset;
                    int dstIdx = offset;
                    while (srcIdx < endoffset) {
                        short maskIdx = overlay[overlayIdx];
                        if (maskIdx > -1) {
                            int maskVal = cmap[maskIdx];
                            int blue = srcpixels[srcIdx] & 0xFF;
                            int green = srcpixels[srcIdx + 1] & 0xFF;
                            int red = srcpixels[srcIdx + 2] & 0xFF;
                            int malpha = (maskVal & 0xFF000000) >> 24;
                            int mred = (maskVal & 0xFF0000) >> 16;
                            int mgreen = (maskVal & 0xFF00) >> 8;
                            int mblue = maskVal & 0xFF;
                            malpha = malpha < 0 ? ALPHA_MAX + malpha : malpha;
                            int ONE_MINALPHA = ALPHA_MAX - malpha;
                            int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                            int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                            int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                            dstpixels[dstIdx] = 0xFF000000 | (pred &= 0xFF) << 16 | (pgreen &= 0xFF) << 8 | (pblue &= 0xFF);
                        } else {
                            int blue = srcpixels[srcIdx] & 0xFF;
                            int green = srcpixels[srcIdx + 1] & 0xFF;
                            int red = srcpixels[srcIdx + 2] & 0xFF;
                            dstpixels[dstIdx] = 0xFF000000 | red << 16 | green << 8 | blue;
                        }
                        srcIdx += numOfBanks;
                        ++dstIdx;
                        ++overlayIdx;
                    }
                }
            }
        }
    }

    protected static boolean computeRGBOverlay(BufferedImage bimg, BufferedImage cacheImage) {
        DataBuffer db = bimg.getRaster().getDataBuffer();
        if (db instanceof DataBufferByte) {
            int pixelStride;
            int[] bandOffsets;
            DataBufferByte dbb = (DataBufferByte)db;
            byte[] pixels = dbb.getData();
            int[] dstpixels = ((DataBufferInt)cacheImage.getRaster().getDataBuffer()).getData();
            int idx = 0;
            SampleModel sampleModel = bimg.getRaster().getSampleModel();
            if (sampleModel instanceof ComponentSampleModel) {
                bandOffsets = ((ComponentSampleModel)sampleModel).getBandOffsets();
                pixelStride = ((ComponentSampleModel)sampleModel).getPixelStride();
            } else {
                bandOffsets = new int[]{0, 1, 2};
                pixelStride = 3;
            }
            int i = 0;
            while (i < dstpixels.length) {
                int red = pixels[bandOffsets[0] + idx] & 0xFF;
                int green = pixels[bandOffsets[1] + idx] & 0xFF;
                int blue = pixels[bandOffsets[2] + idx] & 0xFF;
                dstpixels[i] = 0xFF000000 | red << 16 | green << 8 | blue;
                ++i;
                idx += pixelStride;
            }
            return true;
        }
        return false;
    }

    public final XpImage getFrame() {
        return this.image;
    }

    public final void setImage(RenderedImage image) {
        this.model.width = image.getWidth();
        this.model.height = image.getHeight();
        this.transformDirty = true;
        this.azimuth = 0.0;
        RenderedImage opImage = this.doImageOperations(image);
        this.newImageCB(opImage);
    }

    public abstract void newImageCB(RenderedImage var1);

    private RenderedImage doImageOperations(RenderedImage inputImage) {
        int w = inputImage.getWidth();
        int h = inputImage.getHeight();
        int opListLen = this.currentOpList.size();
        if (opListLen > 0) {
            int oph;
            int opw;
            boolean createOpImage = false;
            if (this.opImg1 != null) {
                opw = this.opImg1.getWidth();
                oph = this.opImg1.getHeight();
                if (opw != w || oph != h) {
                    createOpImage = true;
                }
            } else {
                createOpImage = true;
            }
            if (createOpImage) {
                this.opImg1 = XpImageData.createCompatibleBufferedImage(inputImage);
            }
            if (opListLen > 1) {
                createOpImage = false;
                if (this.opImg2 != null) {
                    opw = this.opImg2.getWidth();
                    oph = this.opImg2.getHeight();
                    if (opw != w || oph != h) {
                        createOpImage = true;
                    }
                } else {
                    createOpImage = true;
                }
                if (createOpImage) {
                    this.opImg2 = XpImageData.createCompatibleBufferedImage(inputImage);
                }
            }
            RenderedImage input = inputImage;
            RenderedImage output = this.opImg1;
            RenderedImage result = input;
            for (int i = 0; i < opListLen; ++i) {
                XpImageOp iop = (XpImageOp)this.currentOpList.get(i);
                if (iop == null) continue;
                iop.execute(input, output);
                result = output;
                if (i == 0) {
                    input = this.opImg1;
                    output = this.opImg2;
                    continue;
                }
                RenderedImage tmp = input;
                input = output;
                output = tmp;
            }
            return result;
        }
        return inputImage;
    }

    private boolean sameList(List l1, List l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        int len = l1.size();
        for (int i = 0; i < len; ++i) {
            Object o2;
            Object o1 = l1.get(i);
            if (o1 == (o2 = l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private void assignList(List l1, List l2) {
        l1.clear();
        int len = l2.size();
        for (int i = 0; i < len; ++i) {
            Object o = l2.get(i);
            l1.add(o);
        }
    }

    public final RenderedImage getImage() {
        RenderedImage rimg = null;
        XpImage theImage = this.image;
        if (theImage != null) {
            rimg = theImage.getPixelData();
        }
        return rimg;
    }

    public CTransform getTransform() {
        return this.model.transform;
    }

    public final XpImageOrientation getDisplayOrientation() {
        XpImage theImage = this.image;
        if (theImage != null) {
            double angle = theImage.getAzimuth();
            if (angle != 0.0) {
                XpImageOrientation ior = this.gu.getEffectiveRotation(angle);
                XpImageOrientation ori = this.model.attributes.getImageOrientation();
                ior.apply(ori);
                return ior;
            }
            return this.model.attributes.getImageOrientation();
        }
        return null;
    }

    protected final boolean didTransformOp() {
        return this._didTransformOp;
    }

    protected void calcAffineTransform(Component component, Rectangle viewport, XpImage image, int w, int h, XpImageRenderAttributes ira, AffineTransform tx) {
        int psmode = ira.getPresentationSizeMode();
        double px = image.getPixelDimensionX();
        double py = image.getPixelDimensionY();
        if (psmode == 101 && component != null) {
            double dpinch = DPINCH > 0.0 ? DPINCH : (double)component.getToolkit().getScreenResolution();
            double dpmm = dpinch / XpGeomUtils.MM_PER_INCH;
            this.gu.calcAffineTransform(viewport, ira, w, h, this.azimuth, this.fitToViewport, dpmm, px, py, this.model.tx);
        } else {
            this.gu.calcAffineTransform(viewport, ira, w, h, this.azimuth, this.fitToViewport, px, py, this.model.tx);
        }
    }

    private void computeTransform(Rectangle viewport) {
        this._didTransformOp = false;
        if (this.transformDirty || !viewport.equals(this.lastViewport)) {
            this._didTransformOp = true;
            int w = this.model.width;
            int h = this.model.height;
            XpImageRenderAttributes ira = this.model.attributes;
            this.calcAffineTransform(this.component, viewport, this.image, w, h, ira, this.model.tx);
            this.model.transform.load(this.model.tx);
            this.transformDirty = false;
            this.lastViewport.setBounds(viewport);
        }
    }

    public final AffineTransform getTransform2D() {
        this.getTransform();
        AffineTransform at = this.getAffineTransform();
        return (AffineTransform)at.clone();
    }

    public final XpImageRenderAttributes getAttributes() {
        return this.model.attributes;
    }

    public AffineTransform getAffineTransform() {
        return this.model.tx;
    }

    public final int getWidth() {
        return this.model.width;
    }

    public final int getHeight() {
        return this.model.height;
    }

    public final void fillColorTable(XpImageRenderAttributes attr, int[] rgb) {
        int idx = attr.getActiveVoiLutIndex();
        this.fillColorTable(attr, rgb, this.voiType, this.voiluts != null && idx >= 0 && idx < this.voiluts.length ? this.voiluts[idx] : null);
    }

    public final void fillColorTable(XpImageRenderAttributes attr, int[] rgb, VoiType voiType, DICOMLut voiLut) {
        if (!this.wwwlStage) {
            return;
        }
        if (this.photometricInterpretation == 100) {
            this.pixwin.fillColorTable(attr, rgb, !attr.isVideoInverted(), this.getRescaleSlope(), this.getRescaleIntercept(), this.getPixelRepresentation(), voiType, voiLut);
        } else {
            this.pixwin.fillColorTable(attr, rgb, this.getRescaleSlope(), this.getRescaleIntercept(), this.getPixelRepresentation(), voiType, voiLut);
        }
    }

    private void paintEmptyMessage(Graphics g, Component c) {
        if (noImageMessage != null) {
            g.setColor(Color.WHITE);
            g.setFont(emptyMsgFont);
            FontMetrics fntMetrics = g.getFontMetrics();
            int iStrWidth = fntMetrics.stringWidth(noImageMessage);
            int iStartPos = c.getSize().width / 2 - iStrWidth / 2;
            if (iStartPos < 1) {
                iStartPos = 1;
            }
            g.drawString(noImageMessage, iStartPos, c.getSize().height / 2);
        }
    }

    @Override
    public final void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.component = c;
        this.paintAWT(g, c);
    }

    public void paintAWT(Graphics g, Component c) {
        c.getBounds(this.viewport);
        if (this.image == null) {
            g.setColor(c.getBackground());
            g.fillRect(this.viewport.x, this.viewport.y, this.viewport.width, this.viewport.height);
            this.paintEmptyMessage(g, c);
        } else {
            if (!this.pixelsLoaded) {
                this.loadPixelData();
            }
            if (this.pixelsLoaded) {
                this.renderImage(g, this.viewport);
            }
        }
    }

    public static ComponentUI createUI(JComponent c) {
        ComponentUI cui = (ComponentUI)XpPropertiesManager.create("com.ge.med.terra.jami.render.XpJImage2DRenderer");
        return cui;
    }

    public final void setImageClip(Shape s) {
        this.imageClipShape = s;
        this.setChangeRender();
    }

    public final Shape getImageClip() {
        return this.imageClipShape;
    }

    public Shape getClipShape() {
        return this.clipShape;
    }

    public void setClipShape(Shape clipShape) {
        this.clipShape = clipShape;
        this.setChangeRender();
    }

    public final Object getInterpolationHint() {
        return this.interpolationHint;
    }

    public final void setInterpolationHint(Object interpolationHint) {
        if (this.interpolationHint != interpolationHint) {
            this.interpolationHint = interpolationHint;
            this.setChangeRender();
        }
    }

    public final void setFitToViewport(boolean fToViewport) {
        if (this.fitToViewport != fToViewport) {
            this.transformDirty = true;
            this.fitToViewport = fToViewport;
            this.newImageRenderAttributesCB(this.model.attributes);
        }
    }

    public final boolean getFitToViewport() {
        return this.fitToViewport;
    }

    protected void setPixelTransferDirty(boolean pixelTransferDirty) {
        this.pixelTransferDirty = pixelTransferDirty;
    }

    protected boolean isPixelTransferDirty() {
        return this.pixelTransferDirty;
    }

    public void selectImageLayer(int layer) {
        this.imageLayer = layer;
    }

    public int getImageLayer() {
        return this.imageLayer;
    }

    public void setPixelCombiner(XjFusionPixelCombiner fpc) {
        this.fpc = fpc;
    }

    public XjFusionPixelCombiner getPixelCombiner() {
        return this.fpc;
    }

    public int getBitsAllocated() {
        RenderedImage inputImage;
        if (this.bitsAllocated < 0 && (inputImage = this.getImage()) != null) {
            int[] cc = inputImage.getColorModel().getComponentSize();
            this.bitsAllocated = cc[0];
        }
        return this.bitsAllocated;
    }

    public int getBitsStored() {
        RenderedImage inputImage;
        if (this.bitsStored < 0 && (inputImage = this.getImage()) != null) {
            int[] cc = inputImage.getColorModel().getComponentSize();
            this.bitsStored = cc[0];
        }
        return this.bitsStored;
    }

    public int getPixelRepresentation() {
        return this.pixelRepresentation;
    }

    public int getPixelPaddingValue() {
        return this.pixelPaddingValue;
    }

    public final void setDrawableFactory(XpDrawableFactory drwF) {
        this.drwFactory = drwF;
    }

    public final XpDrawableFactory getDrawableFactory() {
        return this.drwFactory;
    }

    static {
        String sawTooth;
        String dpinch;
        noImageMessage = XpPropertiesManager.getProperty("jami.noimage.message");
        emptyFontName = XpPropertiesManager.getProperty("jami.noimage.fontname", "Monospaced");
        emptyFontSize = Integer.parseInt(XpPropertiesManager.getProperty("jami.noimage.fontsize", "16"));
        emptyMsgFont = new Font(emptyFontName, 3, emptyFontSize);
        needClipNudge = false;
        renderIdPool = 0;
        defaultFactory = new DefaultDrawableFactory();
        DPINCH = 0.0;
        removeSawtooth = false;
        String jvmVersion = XpPropertiesManager.getProperty("java.vm.version", "XXX");
        if (jvmVersion.indexOf("1.4.2") != -1) {
            XpLog.logger().info("--- MUST APPLY CLIP/ZOOM NUDGE Java Bug(4887054): " + jvmVersion);
            needClipNudge = true;
        }
        if ((dpinch = XpPropertiesManager.getProperty("jami.dotsperinch")) != null) {
            DPINCH = Double.parseDouble(dpinch);
            XpLog.logger().config("JAMI: Overriding Screen Dots/Inch with: " + DPINCH);
        }
        if ((sawTooth = XpPropertiesManager.getProperty("jami.removeSawtooth")).compareTo("true") == 0) {
            removeSawtooth = true;
        }
    }

    private static class DefaultDrawableFactory
    implements XpDrawableFactory {
        private static final int BIG_DIM = 2500;

        private DefaultDrawableFactory() {
        }

        @Override
        public final XpImageDrawable createDrawable(int bpp, int w, int h) {
            XpImageDrawable.IntRGB drawable = null;
            drawable = new XpImageDrawable.IntRGB(w, h);
            return drawable;
        }

        @Override
        public final int getDrawableType(int bpp, int w, int h) {
            int type = 0;
            switch (bpp) {
                case 8: {
                    type = 10;
                    break;
                }
                default: {
                    type = w > 2500 && h > 2500 ? 10 : 1;
                }
            }
            return type;
        }
    }
}

