/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpDicomOverlay;
import java.util.ArrayList;
import java.util.Arrays;

public class XpDicomOverlays {
    public static final int[] dicomOverlayGroups = new int[]{24576, 24578, 24580, 24582, 24584, 24586, 24588, 24590, 24592, 24594, 24596, 24598, 24600, 24602, 24604, 24606};
    public static final byte TRANSPARENT_VAL = -1;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private XpDicomOverlay[] overlays = null;
    private XpColorOverlay colorOverlay = null;

    public XpDicomOverlays(XpMedicalImage img) {
        this(img, dicomOverlayGroups);
    }

    public XpDicomOverlays(XpMedicalImage img, int[] groups) {
        ArrayList<XpDicomOverlay> overlaylist = new ArrayList<XpDicomOverlay>();
        for (int group : groups) {
            XpDicomOverlay ov = new XpDicomOverlay(img, group);
            if (ov.getRows() == 0 || ov.getCols() == 0) continue;
            overlaylist.add(ov);
        }
        int ovcount = overlaylist.size();
        if (ovcount > 0) {
            this.overlays = new XpDicomOverlay[ovcount];
            for (int i = 0; i < ovcount; ++i) {
                this.overlays[i] = (XpDicomOverlay)overlaylist.get(i);
            }
        }
        this.imageWidth = img.getSlice().width;
        this.imageHeight = img.getSlice().height;
    }

    public static XpDicomOverlays createDicomOverlays(XpMedicalImage img) {
        return XpDicomOverlays.createDicomOverlays(img, dicomOverlayGroups);
    }

    public static XpDicomOverlays createDicomOverlays(XpMedicalImage img, int[] groups) {
        for (int group : groups) {
            XpDicomElement dcm = new XpDicomElement(group, 16);
            if (img.getValue(dcm) != 0 || !(dcm.value instanceof Number)) continue;
            return new XpDicomOverlays(img, groups);
        }
        return null;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public byte[] combineOverlays(int[] validIndices) {
        int[] selectedIndices = validIndices;
        if (selectedIndices == null) {
            selectedIndices = new int[this.overlays.length];
            for (int i = 0; i < this.overlays.length; ++i) {
                selectedIndices[i] = i;
            }
        }
        byte[] combinedOverlayMask = new byte[this.imageWidth * this.imageHeight];
        Arrays.fill(combinedOverlayMask, (byte)-1);
        int packedBitsSize = 16;
        for (int idx : selectedIndices) {
            int col;
            int row;
            byte bval;
            int j;
            short sval;
            int i;
            Object overlayData;
            int maxCol;
            XpDicomOverlay ov;
            if (idx < 0 || idx > this.overlays.length || (ov = this.overlays[idx]).getOverlayData() == null) continue;
            int minRow = ov.getOriginRow() - 1;
            int minCol = ov.getOriginCol() - 1;
            int maxRow = ov.getRows() + minRow;
            if (maxRow > this.imageHeight) {
                maxRow = this.imageHeight;
            }
            if ((maxCol = ov.getCols() + minCol) > this.imageWidth) {
                maxCol = this.imageWidth;
            }
            if ((overlayData = ov.getOverlayData()) instanceof byte[]) {
                byte[] byteOverlay = (byte[])overlayData;
                for (i = 0; i < byteOverlay.length; ++i) {
                    sval = byteOverlay[i];
                    if (sval == 0) continue;
                    for (j = 0; j < 16; ++j) {
                        bval = (byte)(sval >> j & 1);
                        if (bval == 0) continue;
                        row = (i * 16 + j) / ov.getCols() + minRow;
                        col = (i * 16 + j) % ov.getCols() + minCol;
                        if (row <= -1 || row >= maxRow || col <= -1 || col >= maxCol) continue;
                        combinedOverlayMask[row * this.imageWidth + col] = 0;
                    }
                }
                continue;
            }
            short[] shortOverlay = (short[])overlayData;
            for (i = 0; i < shortOverlay.length; ++i) {
                sval = shortOverlay[i];
                if (sval == 0) continue;
                for (j = 0; j < 16; ++j) {
                    bval = (byte)(sval >> j & 1);
                    if (bval == 0) continue;
                    row = (i * 16 + j) / ov.getCols() + minRow;
                    col = (i * 16 + j) % ov.getCols() + minCol;
                    if (row <= -1 || row >= maxRow || col <= -1 || col >= maxCol) continue;
                    combinedOverlayMask[row * this.imageWidth + col] = 0;
                }
            }
        }
        return combinedOverlayMask;
    }

    public XpDicomOverlay[] getOverlays() {
        return this.overlays;
    }

    public XpColorOverlay getColorOverlay(XpColorOverlay co) {
        if (null == co) {
            if (null == this.colorOverlay) {
                byte[] overlayMask = this.combineOverlays(null);
                int[] colorMap = new int[]{-1};
                this.colorOverlay = new XpColorOverlay(overlayMask, colorMap, this.imageWidth, this.imageHeight);
            }
        } else {
            int[] colorMap = co.getColorMap();
            int[] combinedColorMap = new int[colorMap.length + 1];
            System.arraycopy(colorMap, 0, combinedColorMap, 0, colorMap.length);
            combinedColorMap[colorMap.length] = -1;
            byte[] dicomOverlayMask = this.combineOverlays(null);
            Object colorOverlayMask = co.getOverlay();
            if (colorOverlayMask instanceof byte[]) {
                byte[] colorMask = (byte[])colorOverlayMask;
                if (colorMask.length != dicomOverlayMask.length) {
                    XpLog.severe("Color Overlay (length=" + colorMask.length + ") does not match Dicom Overlay(length=" + dicomOverlayMask.length + "). Image dimensions=(" + this.imageWidth + "," + this.imageHeight + ")");
                }
                byte maxval = colorMask[0];
                for (int i = 1; i < colorMask.length; ++i) {
                    if (maxval >= colorMask[i]) continue;
                    maxval = colorMask[i];
                }
                if ((maxval = (byte)(maxval + 1)) < 255) {
                    byte[] combinedMask = Arrays.copyOf(colorMask, colorMask.length);
                    for (int i = 0; i < dicomOverlayMask.length; ++i) {
                        if (dicomOverlayMask[i] == -1) continue;
                        combinedMask[i] = maxval;
                    }
                    this.colorOverlay = new XpColorOverlay(combinedMask, combinedColorMap, this.imageWidth, this.imageHeight);
                } else {
                    short[] combinedMask = new short[colorMask.length];
                    System.arraycopy(colorMask, 0, combinedMask, 0, colorMask.length);
                    for (int i = 0; i < dicomOverlayMask.length; ++i) {
                        if (dicomOverlayMask[i] == -1) continue;
                        combinedMask[i] = maxval;
                    }
                    this.colorOverlay = new XpColorOverlay(combinedMask, combinedColorMap, this.imageWidth, this.imageHeight);
                }
            } else {
                int i;
                short[] colorMask = (short[])colorOverlayMask;
                short[] combinedMask = new short[colorMask.length];
                if (colorMask.length != dicomOverlayMask.length) {
                    XpLog.severe("Color Overlay (length=" + colorMask.length + ") does not match Dicom Overlay(length=" + dicomOverlayMask.length + "). Image dimensions=(" + this.imageWidth + "," + this.imageHeight + ")");
                }
                short maxval = colorMask[0];
                for (i = 1; i < colorMask.length; ++i) {
                    if (maxval >= colorMask[i]) continue;
                    maxval = colorMask[i];
                }
                maxval = (short)(maxval + 1);
                System.arraycopy(colorMask, 0, combinedMask, 0, colorMask.length);
                for (i = 0; i < dicomOverlayMask.length; ++i) {
                    if (dicomOverlayMask[i] == -1) continue;
                    combinedMask[i] = maxval;
                }
                this.colorOverlay = new XpColorOverlay(combinedMask, combinedColorMap, this.imageWidth, this.imageHeight);
            }
        }
        return this.colorOverlay;
    }
}

