/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpMedicalImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;

public class XpDicomOverlay {
    private int rows;
    private int cols;
    private int originRow;
    private int originCol;
    private DicomOverlayType type;
    private String description;
    private String subtype;
    private String label;
    private int roiArea;
    private double roiMean;
    private double roiStd;
    private short[] overlayShortData;
    private byte[] overlayByteData;

    public XpDicomOverlay(XpMedicalImage img, int group) {
        block32: {
            block33: {
                Object dataval;
                block31: {
                    Object stdval;
                    Object meanval;
                    Object areaval;
                    Object labelval;
                    Object subtypeval;
                    Object descval;
                    Object typeval;
                    Object originval;
                    Object colval;
                    this.rows = 0;
                    this.cols = 0;
                    this.originRow = Integer.MIN_VALUE;
                    this.originCol = Integer.MIN_VALUE;
                    this.type = null;
                    this.description = null;
                    this.subtype = null;
                    this.label = null;
                    this.roiArea = Integer.MIN_VALUE;
                    this.roiMean = -2.147483648E9;
                    this.roiStd = -2.147483648E9;
                    this.overlayShortData = null;
                    this.overlayByteData = null;
                    Object rowval = this.getVal(img, group, 16);
                    if (null != rowval) {
                        if (rowval instanceof Number) {
                            this.rows = ((Number)rowval).intValue();
                        } else {
                            try {
                                this.rows = Integer.parseInt(rowval.toString());
                            }
                            catch (NumberFormatException e) {
                                throw new RuntimeException("XpDicomOverlay: Cannot parse string " + rowval + " to integer.", e);
                            }
                        }
                    }
                    if (null != (colval = this.getVal(img, group, 17))) {
                        if (colval instanceof Number) {
                            this.cols = ((Number)colval).intValue();
                        } else {
                            try {
                                this.cols = Integer.parseInt(colval.toString());
                            }
                            catch (NumberFormatException e) {
                                throw new RuntimeException("XpDicomOverlay: Cannot parse string " + colval + " to integer.", e);
                            }
                        }
                    }
                    if ((originval = this.getVal(img, group, 80)) instanceof Number[]) {
                        Number[] originStr = (Number[])originval;
                        this.originRow = originStr[0].intValue();
                        this.originCol = originStr[1].intValue();
                    }
                    if ((typeval = this.getVal(img, group, 64)) != null) {
                        if ("G".equals(typeval)) {
                            this.type = DicomOverlayType.GRAPHICS;
                        } else if ("R".equals(typeval)) {
                            this.type = DicomOverlayType.ROI;
                        }
                    }
                    if ((descval = this.getVal(img, group, 34)) != null) {
                        this.description = (String)descval;
                    }
                    if ((subtypeval = this.getVal(img, group, 69)) != null) {
                        this.subtype = (String)subtypeval;
                    }
                    if ((labelval = this.getVal(img, group, 5376)) != null) {
                        this.label = (String)labelval;
                    }
                    if ((areaval = this.getVal(img, group, 4865)) instanceof Number) {
                        this.roiArea = ((Number)areaval).intValue();
                    }
                    if ((meanval = this.getVal(img, group, 4866)) instanceof Number) {
                        this.roiMean = ((Number)meanval).doubleValue();
                    }
                    if ((stdval = this.getVal(img, group, 4867)) instanceof Number) {
                        this.roiStd = ((Number)stdval).doubleValue();
                    }
                    if (!((dataval = this.getVal(img, group, 12288)) instanceof byte[])) break block31;
                    this.overlayByteData = (byte[])dataval;
                    break block32;
                }
                if (!(dataval instanceof short[])) break block33;
                this.overlayShortData = (short[])dataval;
                break block32;
            }
            Object bitPositionVal = this.getVal(img, group, 258);
            if (!(bitPositionVal instanceof Number)) break block32;
            int bitPosition = ((Number)bitPositionVal).intValue();
            int bitsAllocated = 0;
            Object bitsAllocatedVal = this.getVal(img, group, 256);
            if (bitsAllocatedVal instanceof Number) {
                bitsAllocated = ((Number)bitsAllocatedVal).intValue();
            }
            int pixelRepresentation = 0;
            Object pixelRepresentationVal = this.getVal(img, 40, 259);
            if (pixelRepresentationVal instanceof Number) {
                pixelRepresentation = ((Number)pixelRepresentationVal).intValue();
            }
            if (bitsAllocated > 8) {
                DataBuffer dataBuf;
                short[] sdata = null;
                if (pixelRepresentation == 0) {
                    dataBuf = (DataBufferUShort)img.getPixelData().getData().getDataBuffer();
                    sdata = ((DataBufferUShort)dataBuf).getData();
                } else {
                    dataBuf = (DataBufferShort)img.getPixelData().getData().getDataBuffer();
                    sdata = ((DataBufferShort)dataBuf).getData();
                }
                int bitsPerVal = 16;
                this.overlayShortData = new short[Math.round(sdata.length / 16)];
                for (int i = 0; i < sdata.length; i += 16) {
                    short val = 0;
                    for (int j = 0; j < 16; ++j) {
                        byte bval = (byte)(sdata[i + j] >> bitPosition & 1);
                        if (bval == 0) continue;
                        val = (short)(val | 1 << j);
                    }
                    this.overlayShortData[i / 16] = val;
                }
            } else {
                DataBufferByte dataBuf = (DataBufferByte)img.getPixelData().getData().getDataBuffer();
                byte[] bdata = dataBuf.getData();
                int bitsPerVal = 8;
                this.overlayByteData = new byte[Math.round(bdata.length / 8)];
                for (int i = 0; i < bdata.length; i += 8) {
                    byte val = 0;
                    for (int j = 0; j < 8; ++j) {
                        byte bval = (byte)(bdata[i + j] >> bitPosition & 1);
                        if (bval == 0) continue;
                        val = (byte)(val | 1 << j);
                    }
                    this.overlayByteData[i / 8] = val;
                }
            }
        }
    }

    private Object getVal(XpMedicalImage img, int group, int element) {
        XpDicomElement tag2 = new XpDicomElement(group, element);
        img.getValue(tag2);
        return tag2.value;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public int getOriginRow() {
        return this.originRow;
    }

    public int getOriginCol() {
        return this.originCol;
    }

    public DicomOverlayType getType() {
        return this.type;
    }

    public Object getOverlayData() {
        if (this.overlayShortData != null) {
            return this.overlayShortData;
        }
        return this.overlayByteData;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getLabel() {
        return this.label;
    }

    public int getRoiArea() {
        return this.roiArea;
    }

    public double getRoiMean() {
        return this.roiMean;
    }

    public double getRoiStd() {
        return this.roiStd;
    }

    public void print() {
        System.out.print("===XpDicomOverlay Object===");
        System.out.print(" Rows=" + this.rows + " Cols=" + this.cols + " Origin=(" + this.originRow + "," + this.originCol + ")");
        int myLength = 0;
        if (this.overlayShortData != null) {
            myLength = this.overlayShortData.length;
        } else if (this.overlayByteData != null) {
            myLength = this.overlayByteData.length;
        }
        System.out.println(" Type=" + (this.type != null ? this.type : "Unknown") + " DataLength=" + myLength);
    }

    public static enum DicomOverlayType {
        GRAPHICS,
        ROI;

    }
}

