/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.render.VoiType;

public class VoiUtils {
    private static int[] sigmoidTable_16bit = null;

    public static VoiType getVoiFunctionType(XpDicomObject img) {
        XpDicomElement voiLutFunction = new XpDicomElement(40, 4182);
        voiLutFunction.value = null;
        img.getValue(voiLutFunction);
        if (null != voiLutFunction.value) {
            if ("SIGMOID".equals(voiLutFunction.value)) {
                return VoiType.VOI_SIGMOID;
            }
            if ("LINEAR".equals(voiLutFunction.value)) {
                return VoiType.VOI_LINEAR;
            }
        }
        return VoiType.VOI_LINEAR;
    }

    private static int[] computeSigmoidTable(int numBits) {
        int tableLength = 1 << numBits;
        int half = tableLength >> 1;
        int[] sigmoidTable = new int[tableLength];
        for (int i = 0; i < tableLength; ++i) {
            sigmoidTable[i] = (int)((double)tableLength / (1.0 + Math.exp(-4.0 * (double)(i - half) / (double)tableLength)));
        }
        return sigmoidTable;
    }

    public static int[] getSigmoidTable() {
        if (sigmoidTable_16bit == null) {
            sigmoidTable_16bit = VoiUtils.computeSigmoidTable(16);
        }
        return sigmoidTable_16bit;
    }
}

