/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.DICOMLut;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.render.PixelWindowingBase;
import com.ge.med.terra.jami.render.VoiType;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;

public class PixelWindowing
extends PixelWindowingBase {
    private ColorOverrides cover = null;

    public final void fillColorTable(XpImageRenderAttributes attr, int[] rgb, double rescaleSlope, double rescaleIntercept, int pixelRepresentation, VoiType voiType, DICOMLut voiLut) {
        this.fillColorTable(attr.getWindowWidth(), attr.getWindowLevel(), attr.isVideoInverted(), attr.getColormap(), rgb, rescaleSlope, rescaleIntercept, pixelRepresentation, voiType, voiLut);
    }

    public final void fillColorTable(XpImagePixelAttributes attr, int[] rgb, double rescaleSlope, double rescaleIntercept, int pixelRepresentation, VoiType voiType, DICOMLut voiLut) {
        this.fillColorTable(attr.getWindowWidth(), attr.getWindowLevel(), attr.isVideoInverted(), attr.getColormap(), rgb, rescaleSlope, rescaleIntercept, pixelRepresentation, voiType, voiLut);
    }

    public final void fillColorTable(XpImageRenderAttributes attr, int[] rgb, boolean invVideo, double rescaleSlope, double rescaleIntercept, int pixelRepresentation, VoiType voiType, DICOMLut voiLut) {
        this.fillColorTable(attr.getWindowWidth(), attr.getWindowLevel(), invVideo, attr.getColormap(), rgb, rescaleSlope, rescaleIntercept, pixelRepresentation, voiType, voiLut);
    }

    public final void fillColorTable(XpImagePixelAttributes attr, int[] rgb, boolean invVideo, double rescaleSlope, double rescaleIntercept, int pixelRepresentation, VoiType voiType, DICOMLut voiLut) {
        this.fillColorTable(attr.getWindowWidth(), attr.getWindowLevel(), invVideo, attr.getColormap(), rgb, rescaleSlope, rescaleIntercept, pixelRepresentation, voiType, voiLut);
    }

    public final void fillColorTable(XpImageRenderAttributes attr, int[] rgb, double rescaleSlope, double rescaleIntercept, int pixelRepresentation) {
        this.fillColorTable(attr.getWindowWidth(), attr.getWindowLevel(), attr.isVideoInverted(), attr.getColormap(), rgb, rescaleSlope, rescaleIntercept, pixelRepresentation, VoiType.VOI_LINEAR, null);
    }

    public final void fillColorTable(XpImagePixelAttributes attr, int[] rgb, double rescaleSlope, double rescaleIntercept, int pixelRepresentation) {
        this.fillColorTable(attr.getWindowWidth(), attr.getWindowLevel(), attr.isVideoInverted(), attr.getColormap(), rgb, rescaleSlope, rescaleIntercept, pixelRepresentation, VoiType.VOI_LINEAR, null);
    }

    public final void fillColorTable(XpImageRenderAttributes attr, int[] rgb, boolean invVideo, double rescaleSlope, double rescaleIntercept, int pixelRepresentation) {
        this.fillColorTable(attr.getWindowWidth(), attr.getWindowLevel(), invVideo, attr.getColormap(), rgb, rescaleSlope, rescaleIntercept, pixelRepresentation, VoiType.VOI_LINEAR, null);
    }

    public final void fillColorTable(XpImagePixelAttributes attr, int[] rgb, boolean invVideo, double rescaleSlope, double rescaleIntercept, int pixelRepresentation) {
        this.fillColorTable(attr.getWindowWidth(), attr.getWindowLevel(), invVideo, attr.getColormap(), rgb, rescaleSlope, rescaleIntercept, pixelRepresentation, VoiType.VOI_LINEAR, null);
    }

    @Override
    protected final void fillColorTable(double winwidth, double winlevel, boolean ivideo, boolean isCMAP, boolean changeCM, int[] rgb, double rescaleSlope, double rescaleIntercept, int pixelRepresentation, VoiType voiType, DICOMLut voilut) {
        int MAXVALUE;
        boolean videoInverted = ivideo;
        double ww = winwidth / rescaleSlope;
        double wl = (winlevel - rescaleIntercept) / rescaleSlope;
        double plo = wl - 0.5 * ww;
        int ilo = (int)plo;
        int[] voilutdata = null;
        double voiRange = 0.0;
        if (ilo >= rgb.length) {
            ilo = rgb.length - 1;
        }
        int half = rgb.length >> 1;
        int X_LO = pixelRepresentation == 0 ? 0 : -half;
        int X_HI = pixelRepresentation == 0 ? rgb.length - 1 : half - 1;
        int lIdx = X_LO;
        int hIdx = X_HI;
        if (ilo <= lIdx) {
            lIdx = Math.max(ilo, X_LO);
        }
        int i = Math.max(lIdx, X_LO);
        int overflowIdx = X_HI;
        int len = isCMAP ? this.cmap.length : 256;
        int OFFSET = 0;
        int SIGN = 1;
        int MINRGB = -16777216;
        int MAXRGB = -1;
        if (voilut != null) {
            voilutdata = voilut.getLutdata();
            voiRange = 1 << voilut.getNumBits();
            if (null != voilutdata) {
                int min_rgb = (int)(255.0 / voiRange * (double)voilutdata[0]);
                int max_rgb = (int)(255.0 / voiRange * (double)voilutdata[voilutdata.length - 1]);
                MINRGB = 0xFF000000 | min_rgb << 16 | min_rgb << 8 | min_rgb;
                MAXRGB = 0xFF000000 | max_rgb << 16 | max_rgb << 8 | max_rgb;
            }
        }
        int MINVALUE = isCMAP ? this.cmap[0] : MINRGB;
        int n = MAXVALUE = isCMAP ? this.cmap[len - 1] : MAXRGB;
        if (videoInverted) {
            OFFSET = len - 1;
            SIGN = -1;
            int TEMP = MINVALUE;
            MINVALUE = MAXVALUE;
            MAXVALUE = TEMP;
        }
        int M_VALUE = rgb.length - 1;
        try {
            while (i <= ilo && VoiType.VOI_SIGMOID != voiType) {
                rgb[i & M_VALUE] = MINVALUE;
                ++i;
            }
            if (null != voilutdata) {
                int rgbidx;
                int b;
                double d_dp;
                double dp = (double)voilutdata.length / ww;
                double d = d_dp = isCMAP ? (double)this.cmap.length / voiRange : 255.0 / voiRange;
                if (isCMAP) {
                    while (i <= X_HI) {
                        b = (int)((double)(i - ilo) * dp);
                        if (b > voilutdata.length - 1) {
                            overflowIdx = i;
                            break;
                        }
                        rgbidx = (int)((double)voilutdata[b] * d_dp);
                        rgbidx = OFFSET + SIGN * rgbidx;
                        rgb[i & M_VALUE] = this.cmap[rgbidx];
                        ++i;
                    }
                } else {
                    while (i <= X_HI) {
                        int rgbval;
                        b = (int)((double)(i - ilo) * dp);
                        if (b > voilutdata.length - 1) {
                            overflowIdx = i;
                            break;
                        }
                        rgbidx = (int)((double)voilutdata[b] * d_dp);
                        rgbidx = OFFSET + SIGN * rgbidx;
                        rgb[i & M_VALUE] = rgbval = 0xFF000000 | rgbidx << 16 | rgbidx << 8 | rgbidx;
                        ++i;
                    }
                }
            } else if (VoiType.VOI_SIGMOID == voiType) {
                if (isCMAP) {
                    while (i <= hIdx) {
                        int rgbidx = (int)(256.0 / (1.0 + Math.exp(-4.0 * ((double)i - wl) / ww)));
                        rgbidx = OFFSET + SIGN * rgbidx;
                        rgb[i & M_VALUE] = this.cmap[rgbidx];
                        ++i;
                    }
                } else {
                    while (i <= hIdx) {
                        int rgbval;
                        int rgbidx = (int)(256.0 / (1.0 + Math.exp(-4.0 * ((double)i - wl) / ww)));
                        rgbidx = OFFSET + SIGN * rgbidx;
                        rgb[i & M_VALUE] = rgbval = 0xFF000000 | rgbidx << 16 | rgbidx << 8 | rgbidx;
                        ++i;
                    }
                }
            } else {
                double dp;
                double d = dp = isCMAP ? (double)this.cmap.length / ww : 255.0 / ww;
                if (isCMAP) {
                    while (i <= X_HI) {
                        int b = (int)((double)(i - ilo) * dp);
                        if (b > len - 1) {
                            overflowIdx = i;
                            break;
                        }
                        b = OFFSET + SIGN * b;
                        rgb[i & M_VALUE] = this.cmap[b];
                        ++i;
                    }
                } else {
                    while (i <= X_HI) {
                        int x;
                        int b = (int)((double)(i - ilo) * dp);
                        if (b > 255) {
                            overflowIdx = i;
                            break;
                        }
                        b = OFFSET + SIGN * b;
                        rgb[i & M_VALUE] = x = 0xFF000000 | b << 16 | b << 8 | b;
                        ++i;
                    }
                }
            }
            while (i <= hIdx && voiType != VoiType.VOI_SIGMOID) {
                rgb[i & M_VALUE] = MAXVALUE;
                ++i;
            }
            if (this.cover != null && this.cover.length > 0) {
                this.applyColorOverride(rgb);
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            int idx = i & M_VALUE;
            XpLog.logger().severe("Exception: WW/WL bad index=" + i + " uindex=" + idx + " ilo=" + ilo);
        }
    }

    private static String printRGB(int idx, int v) {
        int r = (v & 0xFF0000) >> 16;
        int g = (v & 0xFF00) >> 8;
        int b = v & 0xFF;
        String rgb = "(" + r + "," + g + "," + b + ")";
        short val = (short)idx;
        return rgb;
    }

    private void applyColorOverride(int[] rgb) {
        for (int j = 0; j < this.cover.length; ++j) {
            int color;
            int idx = this.cover.luminance[j] & 0xFFFF;
            rgb[idx] = color = this.cover.color[j];
        }
    }

    @Override
    protected void initializeColorOverrides(int size) {
        if (this.cmTable == null || this.cmTable.length != size) {
            this.cmTable = new int[size];
            this.cover = new ColorOverrides(size);
        }
        this.cover.reset();
    }

    @Override
    protected void loadColorOverrides(int size) {
        for (int i = 0; i < size; ++i) {
            int pixVal = this.cmTable[i];
            int red = (pixVal & 0xFF0000) >> 16;
            int green = (pixVal & 0xFF00) >> 8;
            int blue = pixVal & 0xFF;
            if (red == green && red == blue) continue;
            this.cover.overrideColors(i, pixVal);
        }
    }

    private static class ColorOverrides {
        public int[] luminance = null;
        public int[] color = null;
        public int length = 0;

        public ColorOverrides(int size) {
            this.luminance = new int[size];
            this.color = new int[size];
        }

        public final void reset() {
            this.length = 0;
        }

        public final void overrideColors(int lumIndex, int colorVal) {
            this.luminance[this.length] = lumIndex;
            this.color[this.length] = colorVal;
            ++this.length;
        }
    }
}

