/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote.session;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.terra.jami.CodecUtils;
import com.ge.med.terra.jami.j3d.remote.Rm3DClientServerIF;
import com.ge.med.terra.jami.j3d.remote.Rm3DDispatcher;
import com.ge.med.terra.jami.j3d.remote.XmVolume;
import com.ge.med.terra.jami.remote.RmCommand;
import com.ge.med.terra.jami.remote.RmPixelBuffer;
import com.ge.med.terra.jami.remote.RmPixelBufferCodec;
import com.ge.med.terra.jami.remote.RmRenderConnection;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.remote.codec.PassThruPBCodec;
import com.ge.med.terra.jami.remote.session.ForkXMS;
import com.ge.med.terra.jami.remote.session.XmPixelTransferService;
import com.ge.med.terra.jami.render.remote.Rm2DClientDispatcher;
import com.ge.med.terra.jami.render.remote.Rm2DClientServerIF;
import com.ge.med.terra.jami.render.remote.Rm2DServerDispatcher;
import com.ge.med.terra.jami.render.remote.XmImageSet;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class XmRenderSession
implements RmRenderSession {
    private XmSession xms = null;
    private ForkXMS fxms = null;
    private static int installedServices = 0;
    private static Object servicesCtrLock = new Object();

    public static void main(String[] args) {
        XmRenderSession s = new XmRenderSession("localhost", 7483);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        XmRenderSession s2 = new XmRenderSession("localhost", 7483);
        System.err.println("$$$$$$$$$$$$$$$$$XmRenderSession.main(): trying to close");
        s.close();
        System.err.println("$$$$$$$$$$$$$$$$$$$$$$XmRenderSession.main(): close complete");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.err.println("$$$$$$$$$$$$$$$$$XmRenderSession.main(): trying to close#2");
        s2.close();
        System.err.println("$$$$$$$$$$$$$$$$$$$$$$XmRenderSession.main(): close complete#2");
        System.exit(0);
    }

    public XmRenderSession(String hostname, int port) {
        this.createDedicatedXMS(hostname, port);
    }

    public XmRenderSession(XmSession session) {
        this.xms = session;
    }

    private void createDedicatedXMS(String hostname, int port) {
        XmSession xmsForker = new XmSession(hostname, port);
        this.fxms = new ForkXMS(xmsForker);
        xmsForker.close();
        this.xms = this.fxms.getXmSession();
    }

    public static RmRenderSession newRenderSession() {
        ForkXMS fxms = ForkXMS.createXmSession();
        XmRenderSession rsession = new XmRenderSession(fxms.getXmSession());
        rsession.fxms = fxms;
        return rsession;
    }

    @Override
    public RmRenderConnection createConnection(String connectionType, String[] args) {
        RmRenderConnection crc = null;
        if (this.xms != null) {
            if (connectionType.equalsIgnoreCase("3D")) {
                crc = new Xm3DRenderConnection(this.xms, args[0]);
            } else if (connectionType.equalsIgnoreCase("2D")) {
                crc = new Xm2DRenderConnection(this.xms, args[0]);
            }
        }
        return crc;
    }

    private static void printVolumeInfo(XjVolumeInfo vol) {
        int[] dims = vol.getVolumeDimensions(null);
        System.err.println(Arrays.toString(dims));
        System.err.println(vol.getBitsPerVoxel());
        System.err.println(Arrays.toString(vol.getXDirectionRAS(null)));
        System.err.println(Arrays.toString(vol.getYDirectionRAS(null)));
        System.err.println(Arrays.toString(vol.getZDirectionRAS(null)));
        System.err.println(Arrays.toString(vol.getRASOfOrigin(null)));
        System.err.println(vol.getRelatedComposite());
        System.err.println(vol.getValue(40, 16));
        System.err.println(vol.getValue(16, 16));
        System.err.println(vol.getVSliceValue(2, 16, 16));
    }

    @Override
    public Object getRemoteData(String[] args) {
        if (args[0].equalsIgnoreCase("volume")) {
            XmVolume vol = new XmVolume(this.xms, args[1]);
            return vol;
        }
        if (args[0].equalsIgnoreCase("images")) {
            XmImageSet imgSet = new XmImageSet(this.xms, args[1]);
            XjImage[] imgs = imgSet.getImages();
            return imgs;
        }
        return null;
    }

    @Override
    public void close() {
        System.err.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXmRenderSession.close(): now sending signal to terminate server");
        this.fxms.terminate();
        System.err.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXmRenderSession.close(): terminate complete");
        this.xms.close();
        this.xms = null;
    }

    public XmSession getSession() {
        return this.xms;
    }

    private static class Xm3DRenderConnection
    implements RmRenderConnection,
    Rm3DClientServerIF {
        private Render3DService rservice = null;
        private int id = -1;
        private List tmonitors = new ArrayList();
        private RmPixelBufferCodec codec = new PassThruPBCodec();

        public Xm3DRenderConnection(XmSession xms, String rengineClass) {
            this.rservice = new Render3DService(xms);
            int id = this.rservice.createRemoteEngine(rengineClass);
            this.setId(id);
        }

        @Override
        public Object execute(RmCommand cmd) {
            return this.rservice.rmcommand(cmd);
        }

        @Override
        public int getId() {
            return this.id;
        }

        protected void setId(int id) {
            this.id = id;
        }

        @Override
        public void close() {
            this.rservice.close();
        }

        @Override
        public void addTaskMonitor(TaskMonitor tm) {
            this.tmonitors.add(tm);
        }

        @Override
        public void removeTaskMonitor(TaskMonitor tm) {
            this.tmonitors.remove(tm);
        }

        @Override
        public String[] getSupportedCodecs() {
            return (String[])this.rservice.rmcommand(new RmCommand(35, null));
        }

        @Override
        public String getCodec() {
            if (this.codec != null) {
                return this.codec.getName();
            }
            return null;
        }

        @Override
        public boolean setCodec(String codecName) {
            Class<?> codecClass = null;
            String currCodec = this.getCodec();
            try {
                codecClass = Class.forName(codecName);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            String[] supportedCodecs = this.getSupportedCodecs();
            boolean found = false;
            for (int i = 0; i < supportedCodecs.length; ++i) {
                if (!supportedCodecs[i].equals(codecName)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            boolean success = (Boolean)this.rservice.rmcommand(new RmCommand(36, new Object[]{codecName}));
            if (success) {
                try {
                    Constructor<?> con = codecClass.getConstructor(null);
                    this.codec = (RmPixelBufferCodec)con.newInstance(null);
                }
                catch (Exception e) {
                    success = false;
                    this.rservice.rmcommand(new RmCommand(36, new Object[]{currCodec}));
                }
            }
            return success;
        }

        @Override
        public RmPixelBuffer render(int renderOutputLayer, int passno, byte renderType) {
            byte[] pbstream = (byte[])this.rservice.rmcommand(new RmCommand(5, new Object[]{new Integer(renderOutputLayer), new Integer(passno), new Byte(renderType)}, true));
            return this.codec.decode(pbstream, 0, pbstream.length);
        }
    }

    private static class Xm2DRenderConnection
    implements RmRenderConnection,
    Rm2DClientServerIF {
        private Render2DService rservice = null;
        private int id = -1;
        private List tmonitors = new ArrayList();
        private RmPixelBufferCodec codec = new PassThruPBCodec();

        public Xm2DRenderConnection(XmSession xms, String rengineClass) {
            this.rservice = new Render2DService(xms);
            int id = this.rservice.createRemoteEngine(rengineClass);
            this.setId(id);
        }

        @Override
        public Object execute(RmCommand cmd) {
            return this.rservice.rmcommand(cmd);
        }

        @Override
        public int getId() {
            return this.id;
        }

        protected void setId(int id) {
            this.id = id;
        }

        @Override
        public void close() {
            this.rservice.close();
        }

        @Override
        public void addTaskMonitor(TaskMonitor tm) {
            this.tmonitors.add(tm);
        }

        @Override
        public void removeTaskMonitor(TaskMonitor tm) {
            this.tmonitors.remove(tm);
        }

        @Override
        public String[] getSupportedCodecs() {
            return (String[])this.rservice.rmcommand(new RmCommand(13, null));
        }

        @Override
        public String getCodec() {
            if (this.codec != null) {
                return this.codec.getName();
            }
            return null;
        }

        @Override
        public boolean setCodec(String codecName) {
            Class<?> codecClass = null;
            String currCodec = this.getCodec();
            try {
                codecClass = Class.forName(codecName);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            String[] supportedCodecs = this.getSupportedCodecs();
            boolean found = false;
            for (int i = 0; i < supportedCodecs.length; ++i) {
                if (!supportedCodecs[i].equals(codecName)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            boolean success = (Boolean)this.rservice.rmcommand(new RmCommand(14, new Object[]{codecName}));
            if (success) {
                try {
                    Constructor<?> con = codecClass.getConstructor(null);
                    this.codec = (RmPixelBufferCodec)con.newInstance(null);
                }
                catch (Exception e) {
                    success = false;
                    this.rservice.rmcommand(new RmCommand(14, new Object[]{currCodec}));
                }
            }
            return success;
        }

        @Override
        public RmPixelBuffer render(int renderOutputLayer, int passno, byte renderType) {
            byte[] pbstream = (byte[])this.rservice.rmcommand(new RmCommand(1, new Object[]{new Integer(renderOutputLayer), new Integer(passno), new Byte(renderType)}, true));
            return this.codec.decode(pbstream, 0, pbstream.length);
        }
    }

    public static class Render3DService
    extends XmPixelTransferService
    implements Rm3DDispatcher.RemoteCaller {
        private Rm3DDispatcher dispatcher = new Rm3DDispatcher(this);
        public static final byte CREATE_RENDERENGINE = 0;
        public static final byte RMCOMMAND = 1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Render3DService(XmSession xms) {
            this.setMethods(new String[]{"__createRemoteEngine", "__rmcommand"});
            xms.installHandle(this);
            Object object = servicesCtrLock;
            synchronized (object) {
                installedServices++;
            }
        }

        public Render3DService() {
            this.setMethods(new String[]{"__createRemoteEngine", "__rmcommand"});
        }

        public int createRemoteEngine(String rengineClass) {
            byte[] b = new byte[CodecUtils.getStringLengthInBytes(rengineClass)];
            CodecUtils.putString(b, 0, rengineClass);
            byte[] _id = this.callSync((byte)0, b);
            return CodecUtils.getInt(_id, 0);
        }

        public byte[] __createRemoteEngine(byte[] in) throws IOException {
            String rengine = CodecUtils.getString(in, 0);
            int rengineId = this.dispatcher.createEngine(rengine);
            byte[] retval = new byte[4];
            CodecUtils.putInt(retval, 0, rengineId);
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionLost() {
            super.connectionLost();
            if (this.onServer) {
                Object object = servicesCtrLock;
                synchronized (object) {
                    System.err.println("-- Notifying service: " + this.getClass());
                    installedServices--;
                    if (installedServices <= 0) {
                        System.err.println(">>>> KILL THE XM-SERVER");
                        System.exit(0);
                    }
                }
            }
        }

        public Object rmcommand(RmCommand rmc) {
            return this.dispatcher.remoteCommand(rmc);
        }

        public ByteBuffer __rmcommand(byte[] in) throws IOException {
            return this.dispatcher.processCommand(in);
        }

        @Override
        public byte[] call(byte[] data, int offset, int length) {
            return this.callSync((byte)1, data, offset, length);
        }
    }

    public static class Render2DService
    extends XmPixelTransferService
    implements Rm2DClientDispatcher.RemoteCaller {
        private Rm2DClientDispatcher clientDispatcher = new Rm2DClientDispatcher(this);
        private Rm2DServerDispatcher serverDispatcher = new Rm2DServerDispatcher();
        public static final byte CREATE_RENDERENGINE = 0;
        public static final byte RMCOMMAND = 1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Render2DService(XmSession xms) {
            this.setMethods(new String[]{"__createRemoteEngine", "__rmcommand"});
            xms.installHandle(this);
            Object object = servicesCtrLock;
            synchronized (object) {
                installedServices++;
            }
        }

        public Render2DService() {
            this.setMethods(new String[]{"__createRemoteEngine", "__rmcommand"});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionLost() {
            super.connectionLost();
            if (this.onServer) {
                Object object = servicesCtrLock;
                synchronized (object) {
                    System.err.println("-- Notifying service: " + this.getClass());
                    installedServices--;
                    if (installedServices <= 0) {
                        System.err.println(">>>> KILL THE XM-SERVER");
                        System.exit(0);
                    }
                }
            }
        }

        public int createRemoteEngine(String rengineClass) {
            byte[] b = new byte[CodecUtils.getStringLengthInBytes(rengineClass)];
            CodecUtils.putString(b, 0, rengineClass);
            byte[] _id = this.callSync((byte)0, b);
            return CodecUtils.getInt(_id, 0);
        }

        public byte[] __createRemoteEngine(byte[] in) throws IOException {
            String rengine = CodecUtils.getString(in, 0);
            int rengineId = this.serverDispatcher.createEngine(rengine);
            byte[] retval = new byte[4];
            CodecUtils.putInt(retval, 0, rengineId);
            return retval;
        }

        public Object rmcommand(RmCommand rmc) {
            return this.clientDispatcher.remoteCommand(rmc);
        }

        public ByteBuffer __rmcommand(byte[] in) throws IOException {
            return this.serverDispatcher.processCommand(in);
        }

        @Override
        public byte[] call(byte[] data, int offset, int length) {
            return this.callSync((byte)1, data, offset, length);
        }
    }
}

