/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote;

import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.remote.RmPixelBuffer;
import com.ge.med.terra.jami.remote.RmPixelBufferCodec;
import com.ge.med.terra.jami.remote.RmServerEngine;

public class RmServerThreadRender {
    private static int idCounter = 0;
    private static final int MAX_LAYERS = 4;
    private static final int MAX_ITERATIONS = 128;
    private RmServerEngine engine = null;
    private ServerPixelBuffers spb = null;
    private transient boolean doRender = false;
    private Object doRenderLock = new Object();
    private transient int renderKeyCtr = 0;
    private transient int renderKey = 0;
    private transient Object[] renderBuffLock = new Object[8];
    private transient int[] renderBuffIdx = new int[this.renderBuffLock.length];
    private transient boolean keeprunning = true;

    public RmServerThreadRender(RmServerEngine engine) {
        this.engine = engine;
        this.spb = new ServerPixelBuffers(engine);
        for (int i = 0; i < this.renderBuffLock.length; ++i) {
            this.renderBuffLock[i] = new Object();
        }
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                RmServerThreadRender.this.renderThread();
            }
        });
        int id = idCounter++;
        th.setName("ThreadRender::ServerEngine[" + id + "]");
        th.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderThread() {
        System.err.println("ThreadRender:: Starting Server-side RenderThread");
        block10: while (this.keeprunning) {
            int renderSlot = -1;
            Object object = this.doRenderLock;
            synchronized (object) {
                while (!this.doRender) {
                    try {
                        this.doRenderLock.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                renderSlot = this.renderKey % this.renderBuffIdx.length;
            }
            this.doRender = false;
            this.syncPixelBuffers();
            this.engine.clearBuffers();
            int nengineoutputs = this.engine.getNumOutputs();
            try {
                this.engine.initRender();
                int width = this.engine.getBufferWidth();
                int height = this.engine.getBufferHeight();
                int passno = 0;
                while (true) {
                    boolean donerender = false;
                    for (int layer = 0; layer < nengineoutputs; ++layer) {
                        MultipassAlgorithm ma = this.engine.getMultipassAlgorithm(layer);
                        this.spb.setMultipass(ma);
                        int rempasses = ma.render(0, 0, width, height, layer, passno);
                        if (rempasses != -99999) {
                            this.spb.encodePixelBuffer(ma, layer, passno, rempasses);
                        }
                        if (rempasses == -99999 || this.doRender) {
                            donerender = true;
                            break;
                        }
                        if (rempasses != 0) continue;
                        donerender = true;
                    }
                    Object object2 = this.renderBuffLock[renderSlot];
                    synchronized (object2) {
                        int n = renderSlot;
                        this.renderBuffIdx[n] = this.renderBuffIdx[n] + 1;
                        this.renderBuffLock[renderSlot].notifyAll();
                    }
                    if (donerender) continue block10;
                    ++passno;
                }
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        XpLog.logger().fine("-- Goodbye ServerRenderEngine thread.");
    }

    public void syncPixelBuffers() {
        int w = this.engine.getBufferWidth();
        int h = this.engine.getBufferHeight();
        this.spb.resetPixelBuffers(w, h);
        this.engine.syncRender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int beginRender() {
        Object object = this.doRenderLock;
        synchronized (object) {
            this.renderKey = this.renderKeyCtr++;
            int renderSlot = this.renderKey % this.renderBuffIdx.length;
            this.renderBuffIdx[renderSlot] = -1;
            this.doRender = true;
            this.doRenderLock.notifyAll();
            return this.renderKey;
        }
    }

    public byte[] getBuffer() {
        return this.spb.getBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] requestBufferInfo(int rKey, int layerNo, int passno) {
        int renderSlot = rKey % this.renderBuffIdx.length;
        Object object = this.renderBuffLock[renderSlot];
        synchronized (object) {
            while (passno > this.renderBuffIdx[renderSlot]) {
                try {
                    this.renderBuffLock[renderSlot].wait();
                }
                catch (InterruptedException e) {}
            }
        }
        int[] buffInfo = this.spb.getBufferInfo(layerNo, passno);
        return buffInfo;
    }

    public int[] getBufferInfo(int layerNo, int passno) {
        int[] buffInfo = this.spb.getBufferInfo(layerNo, passno);
        return buffInfo;
    }

    public void encodePixelBuffer(MultipassAlgorithm ma, int layerNo, int passno, int remPasses) {
        this.spb.setMultipass(ma);
        this.spb.encodePixelBuffer(ma, layerNo, passno, remPasses);
    }

    private static class ServerPixelBuffers {
        private RmServerEngine engine = null;
        private RmPixelBufferCodec pbcodec = null;
        private int[] rgbbuff = null;
        private short[] lumbuff = null;
        private byte[] txbuffer = null;
        private int[][][] pixbuffInfo = new int[4][128][2];
        private RmPixelBuffer pixbuff = new RmPixelBuffer();
        private int offset = 0;

        public ServerPixelBuffers(RmServerEngine engine) {
            this.engine = engine;
        }

        public void resetPixelBuffers(int w, int h) {
            int len = w * h;
            if (len > 0 && (this.rgbbuff == null || this.rgbbuff.length != len || this.lumbuff == null || this.lumbuff.length != len)) {
                this.rgbbuff = new int[w * h];
                this.lumbuff = new short[w * h];
                this.txbuffer = new byte[6 * w * h];
            }
            this.offset = 0;
        }

        public final byte[] getBuffer() {
            return this.txbuffer;
        }

        public final int[] getBufferInfo(int layerNo, int passno) {
            return this.pixbuffInfo[layerNo][passno];
        }

        public final void setMultipass(MultipassAlgorithm ma) {
            Object out_pixelbuffer = this.engine.getPixelBuffer();
            if (out_pixelbuffer instanceof short[]) {
                this.pixbuff.setPixelBuffer(this.lumbuff, 0);
            } else {
                this.pixbuff.setPixelBuffer(this.rgbbuff, 0);
            }
            MultipassAlgorithm[] supp_ma = this.engine.getSupportedMultipassAlgorithms();
            for (int i = 0; i < supp_ma.length; ++i) {
                if (ma != supp_ma[i]) continue;
                this.pixbuff.mpAlgorithmId = i;
                break;
            }
            this.pbcodec = this.engine.getPixelBufferCodec();
        }

        public final void encodePixelBuffer(MultipassAlgorithm ma, int layerNo, int passno, int remPasses) {
            this.pixbuff.remainingPasses = remPasses;
            int npixels = this.pixbuff.encodeMultipass(ma, passno);
            int nbytes = this.pbcodec.encode(this.pixbuff, this.txbuffer, this.offset);
            this.pixbuffInfo[layerNo][passno][0] = this.offset;
            this.pixbuffInfo[layerNo][passno][1] = nbytes;
            this.offset += nbytes;
        }
    }
}

