/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote;

import com.ge.med.idc.GridMultipassAlgorithm;
import com.ge.med.idc.IterativeRenderer;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.idc.RenderBufferOwner;

public class RmPixelBuffer {
    public static final int PIXEL_TYPE_LUMINANCE16 = 0;
    public static final int PIXEL_TYPE_RGB = 1;
    public static final int PIXEL_TYPE_LUMINANCE12 = 2;
    public static final int PIXEL_TYPE_LUMINANCE8 = 3;
    public Object pixBuffer = null;
    public int pixBufferOffset = 0;
    public int pixBufferWidth = 0;
    public int pixBufferHeight = 0;
    public int bpp = 0;
    public int nchannels = 0;
    public int x0 = 0;
    public int y0 = 0;
    public int xstep = 0;
    public int ystep = 0;
    public int remainingPasses = 0;
    public int mpAlgorithmId = -1;

    public void setPixelBuffer(Object pbuff, int pbuffOffset) {
        this.pixBuffer = pbuff;
        this.pixBufferOffset = pbuffOffset;
    }

    public int encodeMultipass(MultipassAlgorithm ma, int passno) {
        IterativeRenderer r = ma.getT3DIRenderer();
        int owidth = r.getBufferWidth();
        int oheight = r.getBufferHeight();
        Object srcPixels = r.getPixelBuffer();
        int idx = 0;
        this.nchannels = r.getNumChannels();
        this.bpp = this.nchannels * r.getBPP();
        if (ma instanceof GridMultipassAlgorithm) {
            GridMultipassAlgorithm gma = (GridMultipassAlgorithm)ma;
            this.x0 = gma.getXStart(passno);
            this.y0 = gma.getYStart(passno);
            this.xstep = gma.getXStep(passno);
            this.ystep = gma.getYStep(passno);
            if (srcPixels instanceof short[]) {
                short[] lumbuff = (short[])this.pixBuffer;
                short[] srclum = (short[])srcPixels;
                int yy = 0;
                int y = this.y0;
                while (y < oheight) {
                    int xx = 0;
                    int yoffset = y * owidth;
                    int x = this.x0;
                    while (x < owidth) {
                        lumbuff[this.pixBufferOffset + idx] = srclum[yoffset + x];
                        x += this.xstep;
                        ++xx;
                        ++idx;
                    }
                    this.pixBufferWidth = xx;
                    y += this.ystep;
                    ++yy;
                }
                this.pixBufferHeight = yy;
            } else if (srcPixels instanceof int[]) {
                int[] rgbbuff = (int[])this.pixBuffer;
                int[] srcrgb = (int[])srcPixels;
                int yy = 0;
                int y = this.y0;
                while (y < oheight) {
                    int xx = 0;
                    int yoffset = y * owidth;
                    int x = this.x0;
                    while (x < owidth) {
                        rgbbuff[this.pixBufferOffset + idx] = srcrgb[yoffset + x];
                        x += this.xstep;
                        ++xx;
                        ++idx;
                    }
                    this.pixBufferWidth = xx;
                    y += this.ystep;
                    ++yy;
                }
                this.pixBufferHeight = yy;
            }
        } else {
            this.x0 = 0;
            this.y0 = 0;
            this.xstep = 1;
            this.ystep = 1;
            this.pixBufferWidth = owidth;
            this.pixBufferHeight = oheight;
            if (srcPixels instanceof short[]) {
                this.nchannels = 1;
                short[] lumbuff = (short[])this.pixBuffer;
                short[] srclum = (short[])srcPixels;
                System.arraycopy(srclum, 0, lumbuff, this.pixBufferOffset, srclum.length);
                idx = srclum.length;
            } else {
                this.nchannels = 3;
                int[] rgbbuff = (int[])this.pixBuffer;
                int[] srcrgb = (int[])srcPixels;
                System.arraycopy(srcrgb, 0, rgbbuff, this.pixBufferOffset, srcrgb.length);
                idx = srcrgb.length;
            }
        }
        return idx;
    }

    public int decodeMultipass(RenderBufferOwner rb) {
        int owidth = rb.getBufferWidth();
        Object outPixels = rb.getPixelBuffer();
        int oy = this.y0;
        if (this.pixBuffer instanceof short[]) {
            short[] inbuff = (short[])this.pixBuffer;
            short[] outbuff = (short[])outPixels;
            int y = 0;
            while (y < this.pixBufferHeight) {
                int yoffset = y * this.pixBufferWidth;
                int oyoffset = oy * owidth;
                int ox = this.x0;
                int x = 0;
                while (x < this.pixBufferWidth) {
                    outbuff[oyoffset + ox] = inbuff[yoffset + x];
                    ++x;
                    ox += this.xstep;
                }
                ++y;
                oy += this.ystep;
            }
        } else {
            int[] inbuff = (int[])this.pixBuffer;
            int[] outbuff = (int[])outPixels;
            int y = 0;
            while (y < this.pixBufferHeight) {
                int yoffset = y * this.pixBufferWidth;
                int oyoffset = oy * owidth;
                int ox = this.x0;
                int x = 0;
                while (x < this.pixBufferWidth) {
                    outbuff[oyoffset + ox] = inbuff[yoffset + x];
                    ++x;
                    ox += this.xstep;
                }
                ++y;
                oy += this.ystep;
            }
        }
        return this.remainingPasses;
    }
}

