/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.plot;

import com.ge.med.terra.jami.plot.XpDrawTextUtils;
import com.ge.med.terra.jami.plot.XpExternalDrawerIF;
import com.ge.med.terra.jami.plot.XpMouseTrackerSupport;
import com.ge.med.terra.jami.plot.XpPlotModel;
import com.ge.med.terra.jami.plot.XpWaveformSource;
import com.ge.med.terra.jami.plot.XpWaveformValuePair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class XpPlotter
extends JPanel
implements PropertyChangeListener {
    private static final int DEFAULT_WIDTH = 690;
    private static final int DEFAULT_HEIGHT = 240;
    private static final int DEFAULT_ROUND_RADIUS = 30;
    private static final Color DEFAULT_PLOTBACKGROUND = Color.white;
    private static final Color DEFAULT_AUXBACKGROUND = Color.lightGray;
    private static final double Y_AXIS_LEEWAY = 0.1;
    private static final double TITLESPACE = 0.12;
    private static final double NOTITLE = 0.01;
    private static final double HORIZONTALAXISSPACE = 0.12;
    private static final double VERTICALAXISSPACE = 0.08;
    private static final double NOLEGEND = 0.02;
    private static final double LEGENDSPACE = 0.16999999999999998;
    private static final float[] MARKER_DASH = new float[]{6.0f, 6.0f};
    private static final int ALPHA = 30;
    private static final Color[] dsColorPalette = new Color[]{new Color(255, 0, 0, 30), new Color(0, 255, 0, 30), new Color(0, 255, 255, 30), new Color(255, 0, 255, 30), new Color(255, 255, 0, 30), new Color(0, 0, 255, 30)};
    private DecimalFormat df = new DecimalFormat("###.###");
    private Font legendFont = new Font("Fixed", 2, 11);
    private Font numberFont = new Font("Fixed", 0, 12);
    private Font axisTitleFont = new Font("Fixed", 2, 12);
    private Font titleFont = new Font("Serif", 1, 16);
    private Image offScreen = null;
    private boolean doubleBuffering = true;
    private boolean grid = true;
    private int horizontalGrid = 10;
    private int verticalGrid = 4;
    private XpPlotModel thePlotModel = null;
    private List externalDrawerList = null;
    private AffineTransform zoomTransTransform = AffineTransform.getScaleInstance(1.0, 1.0);
    private AffineTransform effectiveTransform = new AffineTransform();
    private Point2D plotCorner1 = new Point2D.Float();
    private Point2D plotCorner2 = new Point2D.Float();
    private Dimension plotDim = new Dimension();
    private Point2D plotOrig = new Point2D.Float();
    private Point2D effPlotCorner1 = new Point2D.Float();
    private Point2D effPlotCorner2 = new Point2D.Float();
    private Rectangle2D clipRectangle = new Rectangle2D.Double();
    private int majorTicksX = 4;
    private int majorTicksY = 3;
    private int minorTicksX = 4;
    private int minorTicksY = 3;
    private String xTitle = "Time";
    private String yTitle = "Values";
    private String graphTitle = "Waveform Plot";
    private boolean drawTitle = true;
    private double titleSpace = 0.12;
    private boolean legend = true;
    private double legendSpace = 0.16999999999999998;
    private boolean drawOutline = true;
    private Line2D xAxisLine = new Line2D.Double();
    private boolean segmentPlot = false;
    private List dataSegments = null;
    private List waveformDomainNames = null;
    private boolean xMarkerPlot = false;
    private List xDataMarkers = null;
    private Color xAxisMarkerColor = Color.orange;
    private Stroke xAxisMarkerStroke = new BasicStroke(1.0f, 0, 2, 1.0f, MARKER_DASH, 0.0f);
    private boolean yMarkerPlot = false;
    private List yDataMarkers = null;
    private Color yAxisMarkerColor = Color.red;
    private Stroke yAxisMarkerStroke = new BasicStroke(1.0f, 0, 2, 1.0f, MARKER_DASH, 0.0f);
    private Line2D gridLine = new Line2D.Double();
    private Rectangle2D outlineRect = new Rectangle2D.Double();
    private Line2D tickLine = new Line2D.Double();
    private Rectangle2D legendTableRect = new Rectangle2D.Double();
    private Line2D legendLine = new Line2D.Double();
    private Rectangle2D dataSegmentRect = new Rectangle2D.Double();
    private Line2D markerLine = new Line2D.Double();
    private boolean updateImmediate = false;

    public XpPlotter() {
        this.externalDrawerList = new ArrayList();
        this.setPreferredSize(new Dimension(690, 240));
        this.setBackground(DEFAULT_AUXBACKGROUND);
        ZoomBoxTracker zbt = new ZoomBoxTracker(this);
        this.addMouseListener(zbt);
        this.addMouseMotionListener(zbt);
        WaveformValueTrackerScroller wvts = new WaveformValueTrackerScroller(this);
        this.addMouseListener(wvts);
        this.addMouseMotionListener(wvts);
    }

    public XpPlotter(XpPlotModel mpm) {
        this();
        this.setPlotModel(mpm);
    }

    @Override
    public final void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.thePlotModel != null) {
            if (this.isDoubleBuffering()) {
                this.synchronizeImage();
                this.paintScreen(this.offScreen.getGraphics());
                g.drawImage(this.offScreen, 0, 0, null);
            } else {
                this.paintScreen(g);
            }
        }
    }

    public final Dimension getPlotArea() {
        Dimension plotDim = this.getSize();
        double plotAreaWidth = (double)plotDim.width * (0.92 - this.legendSpace);
        double plotAreaHeight = (double)plotDim.height * (1.0 - this.titleSpace - 0.12);
        plotDim.setSize((int)plotAreaWidth, (int)plotAreaHeight);
        return plotDim;
    }

    public final Point2D getPlotAreaOrigin() {
        Dimension plotDim = this.getSize();
        double plotAreaX = (double)plotDim.width * 0.08;
        double plotAreaY = (double)plotDim.height * this.titleSpace;
        this.plotOrig.setLocation(plotAreaX, plotAreaY);
        return this.plotOrig;
    }

    public final void resetTransform() {
        this.zoomTransTransform.setToIdentity();
        this.repaint();
    }

    public final void zoom(double oX, double oY, double scX, double scY) {
        AffineTransform trans = AffineTransform.getTranslateInstance(oX, oY);
        AffineTransform scale = AffineTransform.getScaleInstance(scX, scY);
        this.zoomTransTransform.preConcatenate(trans);
        this.zoomTransTransform.preConcatenate(scale);
        this.repaint();
    }

    public final void translate(double dX) {
        this.zoomTransTransform.preConcatenate(AffineTransform.getTranslateInstance(dX, 0.0));
        this.repaint();
    }

    private void paintScreen(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(Color.black);
        g2.setBackground(this.getBackground());
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2.setBackground(DEFAULT_PLOTBACKGROUND);
        double minX = this.thePlotModel.getMinX();
        double minY = this.thePlotModel.getMinY();
        double maxX = this.thePlotModel.getMaxX();
        double maxY = this.thePlotModel.getMaxY();
        double rangeX = maxX - minX;
        double rangeY = maxY - minY;
        if (rangeY != 0.0) {
            double leeWay = (maxY - minY) * 0.1;
            minY -= leeWay;
            maxY += leeWay;
        } else {
            minY -= 1.0;
            maxY += 1.0;
        }
        rangeY = maxY - minY;
        this.xAxisLine.setLine(minX - 10.0 * rangeX, 0.0, maxX + 10.0 * rangeX, 0.0);
        this.plotCorner1.setLocation(minX, minY);
        this.plotCorner2.setLocation(maxX, maxY);
        Dimension plotDim = this.getPlotArea();
        Point2D plotOrig = this.getPlotAreaOrigin();
        double plotAreaX = plotOrig.getX();
        double plotAreaY = plotOrig.getY();
        double plotAreaWidth = ((Dimension2D)plotDim).getWidth();
        double plotAreaHeight = ((Dimension2D)plotDim).getHeight();
        double scaleX = plotAreaWidth / rangeX;
        double scaleY = plotAreaHeight / rangeY;
        AffineTransform dataCorrectionTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        dataCorrectionTransform.translate(-minX, maxY);
        dataCorrectionTransform.scale(1.0, -1.0);
        this.effectiveTransform.setTransform(this.zoomTransTransform);
        this.effectiveTransform.concatenate(dataCorrectionTransform);
        this.effectiveTransform.transform(this.plotCorner1, this.effPlotCorner1);
        this.effectiveTransform.transform(this.plotCorner2, this.effPlotCorner2);
        double tRangeX = this.effPlotCorner2.getX() - this.effPlotCorner1.getX();
        double x1 = minX + -this.effPlotCorner1.getX() / tRangeX * rangeX;
        double x2 = x1 + plotAreaWidth / tRangeX * rangeX;
        double tRangeY = this.effPlotCorner2.getY() - this.effPlotCorner1.getY();
        double y1 = minY + -this.effPlotCorner1.getY() / tRangeY * rangeY;
        double y2 = y1 + plotAreaHeight / tRangeY * rangeY;
        this.effPlotCorner1.setLocation(x1, y1);
        this.effPlotCorner2.setLocation(x2, y2);
        Font defFont = g2.getFont();
        this.drawTitles(g2, x1, y1, x2, y2);
        int iPlotHeight = (int)(plotAreaHeight + 1.0);
        int iPlotWidth = (int)(plotAreaWidth + 1.0);
        int iPlotAreaY = (int)plotAreaY;
        g2.clearRect((int)plotAreaX, iPlotAreaY, iPlotWidth, iPlotHeight);
        if (this.isLegend()) {
            int lx = (int)(plotAreaX + (double)iPlotWidth + 5.0);
            int lw = (int)(0.16999999999999998 * plotAreaWidth);
            this.drawLegendTable(g2, lx, iPlotAreaY, lw, iPlotHeight);
        }
        g2.setFont(defFont);
        this.clipRectangle.setRect(plotAreaX, plotAreaY, plotAreaWidth, plotAreaHeight);
        g2.setClip(this.clipRectangle);
        AffineTransform globalTranslation = AffineTransform.getTranslateInstance(plotAreaX, plotAreaY);
        g2.transform(globalTranslation);
        if (this.isDrawOutline()) {
            this.drawGrid(g2, plotAreaWidth, plotAreaHeight);
        }
        this.drawDataSegments(g2, this.effectiveTransform, minX, maxX, minY, maxY);
        this.drawDataMarkers(g2, this.effectiveTransform, minX, maxX, minY, maxY);
        for (XpExternalDrawerIF edi : this.externalDrawerList) {
            edi.draw(g2);
        }
        if (this.isDrawOutline()) {
            this.drawOrnaments(g2, plotAreaWidth, plotAreaHeight);
        }
        g2.draw(this.effectiveTransform.createTransformedShape(this.xAxisLine));
        Shape drawShape = null;
        Iterator i = this.thePlotModel.getWaveforms();
        while (i.hasNext()) {
            XpWaveformSource mw = (XpWaveformSource)i.next();
            g2.setColor(mw.getColor());
            drawShape = this.effectiveTransform.createTransformedShape(mw.getWaveform());
            g2.draw(drawShape);
        }
    }

    private void drawTitles(Graphics2D g2, double x1, double y1, double x2, double y2) {
        double xAxisNumberLabelOffset = 0.0;
        Dimension plotDim = this.getPlotArea();
        Point2D plotOrig = this.getPlotAreaOrigin();
        double plotAreaX = plotOrig.getX();
        double plotAreaY = plotOrig.getY();
        double plotAreaWidth = ((Dimension2D)plotDim).getWidth();
        double plotAreaHeight = ((Dimension2D)plotDim).getHeight();
        g2.setFont(this.numberFont);
        double dx = (x2 - x1) / (double)this.majorTicksX;
        double deltaX = plotAreaWidth / (double)this.majorTicksX;
        double dy = (y2 - y1) / (double)this.majorTicksY;
        double deltaY = plotAreaHeight / (double)this.majorTicksY;
        double nX = x1;
        double pos = plotAreaX;
        int i = 0;
        while (i < this.majorTicksX + 1) {
            Rectangle2D r = XpDrawTextUtils.centerText(g2, this.df.format(nX), plotAreaY + plotAreaHeight + 1.0, pos);
            xAxisNumberLabelOffset = r.getHeight();
            ++i;
            nX += dx;
            pos += deltaX;
        }
        double nY = y1;
        pos = plotAreaY - xAxisNumberLabelOffset + 7.0;
        int i2 = 0;
        while (i2 < this.majorTicksY + 1) {
            XpDrawTextUtils.drawText(g2, this.df.format(nY), plotAreaX - 20.0, pos);
            ++i2;
            nY += dy;
            pos += deltaY;
        }
        Dimension absSize = this.getSize();
        double absWidth = absSize.getWidth();
        double absHeight = absSize.getHeight();
        g2.setFont(this.axisTitleFont);
        XpDrawTextUtils.centerText(g2, this.getXTitle(), plotAreaY + plotAreaHeight + xAxisNumberLabelOffset - 2.0, absWidth / 2.0);
        XpDrawTextUtils.centerVerticalText(g2, this.getYTitle(), 2.0, absHeight);
        if (this.isDrawTitle()) {
            g2.setFont(this.titleFont);
            XpDrawTextUtils.centerText(g2, this.getGraphTitle(), 1.0, absWidth / 2.0);
        }
    }

    private void drawGrid(Graphics2D g2, double w, double h) {
        int i = 0;
        double x = 0.0;
        double y = 0.0;
        Color c = g2.getColor();
        if (this.isGrid()) {
            g2.setColor(Color.lightGray);
            double dX = w / (double)this.horizontalGrid;
            i = 0;
            x = dX;
            while (i < this.horizontalGrid - 1) {
                this.gridLine.setLine(x, 0.0, x, h);
                g2.draw(this.gridLine);
                ++i;
                x += dX;
            }
            double dY = h / (double)this.verticalGrid;
            i = 0;
            y = dY;
            while (i < this.verticalGrid - 1) {
                this.gridLine.setLine(0.0, y, w, y);
                g2.draw(this.gridLine);
                ++i;
                y += dY;
            }
        }
        g2.setColor(c);
    }

    private void drawOrnaments(Graphics2D g2, double w, double h) {
        int i = 0;
        int j = 0;
        double x = 0.0;
        double xx = 0.0;
        double y = 0.0;
        double yy = 0.0;
        double lenMajor = h * 0.05;
        double lenMinor = h * 0.02;
        double dX = w / (double)this.majorTicksX;
        double dXX = dX / (double)this.minorTicksX;
        i = 0;
        x = 0.0;
        while (i < this.majorTicksX) {
            this.tickLine.setLine(x, 0.0, x, lenMajor);
            g2.draw(this.tickLine);
            this.tickLine.setLine(x, h - lenMajor, x, h);
            g2.draw(this.tickLine);
            j = 0;
            xx = x;
            while (j < this.minorTicksX) {
                this.tickLine.setLine(xx, 0.0, xx, lenMinor);
                g2.draw(this.tickLine);
                this.tickLine.setLine(xx, h - lenMinor, xx, h);
                g2.draw(this.tickLine);
                ++j;
                xx += dXX;
            }
            ++i;
            x += dX;
        }
        double dY = h / (double)this.majorTicksY;
        double dYY = dY / (double)this.minorTicksY;
        i = 0;
        y = 0.0;
        while (i < this.majorTicksY) {
            this.tickLine.setLine(0.0, y, lenMajor, y);
            g2.draw(this.tickLine);
            this.tickLine.setLine(w - lenMajor, y, w, y);
            g2.draw(this.tickLine);
            j = 0;
            yy = y;
            while (j < this.minorTicksY) {
                this.tickLine.setLine(0.0, yy, lenMinor, yy);
                g2.draw(this.tickLine);
                this.tickLine.setLine(w - lenMinor, yy, w, yy);
                g2.draw(this.tickLine);
                ++j;
                yy += dYY;
            }
            ++i;
            y += dY;
        }
        this.outlineRect.setRect(0.0, 0.0, w, h);
        g2.draw(this.outlineRect);
    }

    private void drawLegendTable(Graphics2D g2, int x, int y, int w, int h) {
        Stroke s = g2.getStroke();
        Color c = g2.getColor();
        int cY = y;
        int x1 = x + (int)((double)(w / 2) + (double)w * 0.15);
        int x2 = x1 + (int)((double)w * 0.3);
        g2.setFont(this.legendFont);
        g2.clearRect(x, y, w, h);
        this.legendTableRect.setRect(x, y, w, h);
        g2.draw(this.legendTableRect);
        Iterator i = this.thePlotModel.getWaveforms();
        while (i.hasNext()) {
            XpWaveformSource mw = (XpWaveformSource)i.next();
            String waveName = mw.getWaveformName();
            Stroke waveStroke = mw.getStroke();
            Color waveColor = mw.getColor();
            g2.setColor(Color.black);
            Rectangle2D r = XpDrawTextUtils.drawText(g2, waveName, x + 3, cY);
            int dY = (int)r.getHeight();
            g2.setColor(waveColor);
            this.legendLine.setLine(x1, cY + dY / 2, x2, cY + dY / 2);
            g2.draw(this.legendLine);
            cY += dY;
        }
        g2.setStroke(s);
        g2.setColor(c);
    }

    private void drawDataSegments(Graphics2D g2, AffineTransform cTrans, double minX, double maxX, double minY, double maxY) {
        Paint p = g2.getPaint();
        if (this.isSegmentPlot() && this.dataSegments != null) {
            int index = 0;
            for (Point2D val : this.dataSegments) {
                double x1 = val.getX();
                double x2 = val.getY();
                this.dataSegmentRect.setRect(x1, minY, x2 - x1, maxY - minY);
                Shape transBox = cTrans.createTransformedShape(this.dataSegmentRect);
                g2.setPaint(dsColorPalette[index]);
                g2.fill(transBox);
                index = (index + 1) % dsColorPalette.length;
            }
        }
        g2.setPaint(p);
    }

    private void drawDataMarkers(Graphics2D g2, AffineTransform cTrans, double minX, double maxX, double minY, double maxY) {
        Shape transLine;
        Color c = g2.getColor();
        Stroke s = g2.getStroke();
        if (this.isXMarkerPlot() && this.xDataMarkers != null) {
            g2.setColor(this.xAxisMarkerColor);
            g2.setStroke(this.xAxisMarkerStroke);
            for (Double val : this.xDataMarkers) {
                double x = val;
                double y = 5.0 * Math.max(Math.abs(minY), Math.abs(maxY));
                this.markerLine.setLine(x, -y, x, y);
                transLine = cTrans.createTransformedShape(this.markerLine);
                g2.draw(transLine);
            }
        }
        if (this.isYMarkerPlot() && this.yDataMarkers != null) {
            g2.setColor(this.yAxisMarkerColor);
            g2.setStroke(this.yAxisMarkerStroke);
            for (Double val : this.yDataMarkers) {
                double y = val;
                double x = 5.0 * Math.max(Math.abs(minX), Math.abs(maxX));
                this.markerLine.setLine(-x, y, x, y);
                transLine = cTrans.createTransformedShape(this.markerLine);
                g2.draw(transLine);
            }
        }
        g2.setColor(c);
        g2.setStroke(s);
    }

    private void synchronizeImage() {
        Dimension dim = this.getSize();
        if (this.offScreen == null || (double)this.offScreen.getWidth(null) != dim.getWidth() || (double)this.offScreen.getHeight(null) != dim.getHeight()) {
            this.offScreen = this.createImage(dim.width, dim.height);
        }
    }

    @Override
    public final void propertyChange(PropertyChangeEvent evt) {
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final void setPlotModel(XpPlotModel mpm) {
        if (this.thePlotModel != null) {
            this.thePlotModel.removePropertyChangeListener(this);
        }
        this.thePlotModel = mpm;
        if (mpm != null) {
            this.thePlotModel.addPropertyChangeListener(this);
        }
    }

    public final XpPlotModel getPlotModel() {
        return this.thePlotModel;
    }

    public final boolean isSegmentPlot() {
        return this.segmentPlot;
    }

    public final void setSegmentPlot(boolean newSegmentPlot) {
        this.segmentPlot = newSegmentPlot;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final void setDataSegments(List newDataSegments) {
        this.dataSegments = newDataSegments;
        if (this.isSegmentPlot() && this.updateImmediate) {
            this.repaint();
        }
    }

    public final void addWaveformDomainDescription(String name, double xBegin, double xEnd) {
        if (this.waveformDomainNames == null) {
            this.waveformDomainNames = new ArrayList();
        }
        WaveformDomainDescriptor wdd = new WaveformDomainDescriptor(name, new Point2D.Double(xBegin, xEnd));
        this.waveformDomainNames.add(wdd);
    }

    public final void clearWaveformDomainDescription() {
        if (this.waveformDomainNames != null) {
            this.waveformDomainNames.clear();
        }
    }

    public final String getWaveformDomainName(double t) {
        if (this.waveformDomainNames != null) {
            for (WaveformDomainDescriptor wdd : this.waveformDomainNames) {
                String s = wdd.getName();
                double x1 = wdd.getXBegin();
                double x2 = wdd.getXEnd();
                if (!(t >= x1) || !(t <= x2)) continue;
                return s;
            }
        }
        return null;
    }

    public final boolean isXMarkerPlot() {
        return this.xMarkerPlot;
    }

    public final void setXMarkerPlot(boolean newXMarkerPlot) {
        this.xMarkerPlot = newXMarkerPlot;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final void setXDataMarkers(List newXDataMarkers) {
        this.xDataMarkers = newXDataMarkers;
        if (this.isXMarkerPlot() && this.updateImmediate) {
            this.repaint();
        }
    }

    public final boolean isYMarkerPlot() {
        return this.yMarkerPlot;
    }

    public final void setYMarkerPlot(boolean newYMarkerPlot) {
        this.yMarkerPlot = newYMarkerPlot;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final void setYDataMarkers(List newYDataMarkers) {
        this.yDataMarkers = newYDataMarkers;
        if (this.isYMarkerPlot() && this.updateImmediate) {
            this.repaint();
        }
    }

    public final void setGrid(boolean newGrid) {
        this.grid = newGrid;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final boolean isGrid() {
        return this.grid;
    }

    public final void setXTitle(String newTitle) {
        this.xTitle = newTitle;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final String getXTitle() {
        return this.xTitle;
    }

    public final void setYTitle(String newTitle) {
        this.yTitle = newTitle;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final String getYTitle() {
        return this.yTitle;
    }

    public final void setGraphTitle(String newTitle) {
        this.graphTitle = newTitle;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final String getGraphTitle() {
        return this.graphTitle;
    }

    public final void setDrawOutline(boolean drawTheOutline) {
        this.drawOutline = drawTheOutline;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final boolean isDrawOutline() {
        return this.drawOutline;
    }

    public final void setDrawTitle(boolean drawTheTitle) {
        this.drawTitle = drawTheTitle;
        this.titleSpace = this.drawTitle ? 0.12 : 0.01;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final boolean isDrawTitle() {
        return this.drawTitle;
    }

    public final void setLegend(boolean newLegendVal) {
        this.legend = newLegendVal;
        this.legendSpace = this.legend ? 0.16999999999999998 : 0.02;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final boolean isLegend() {
        return this.legend;
    }

    public final boolean isDoubleBuffering() {
        return this.doubleBuffering;
    }

    public final void setDoubleBuffering(boolean _db) {
        this.doubleBuffering = _db;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final void setMinorTicksX(int newVal) {
        this.minorTicksX = newVal;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final int getMinorTicksX() {
        return this.minorTicksX;
    }

    public final void setMajorTicksX(int newVal) {
        this.majorTicksX = newVal;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final int getMajorTicksX() {
        return this.majorTicksX;
    }

    public final void setMinorTicksY(int newVal) {
        this.minorTicksY = newVal;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final int getMinorTicksY() {
        return this.minorTicksY;
    }

    public final void setMajorTicksY(int newVal) {
        this.majorTicksY = newVal;
        if (this.updateImmediate) {
            this.repaint();
        }
    }

    public final int getMajorTicksY() {
        return this.majorTicksY;
    }

    public final boolean getUpdateImmediate() {
        return this.updateImmediate;
    }

    public final void setUpdateImmediate(boolean updateImmediate) {
        this.updateImmediate = updateImmediate;
    }

    public void addExternalDrawer(XpExternalDrawerIF edi) {
        this.externalDrawerList.add(edi);
    }

    public Iterator valueAt(int xPos) {
        double x = 0.0;
        Dimension plotDim = this.getPlotArea();
        double plotAreaWidth = ((Dimension2D)plotDim).getWidth();
        double dataX1 = this.effPlotCorner1.getX();
        double dataX2 = this.effPlotCorner2.getX();
        double rangeDataX = dataX2 - dataX1;
        x = dataX1 + (double)((float)xPos / (float)plotAreaWidth) * rangeDataX;
        return this.thePlotModel.valueAt(x);
    }

    public static void main(String[] argv) {
        JFrame demoApp = new JFrame("XpPlotter Demo");
        ArrayList<Double> yVals = new ArrayList<Double>();
        ArrayList<Double> xVals = new ArrayList<Double>();
        ArrayList<Point2D.Double> dSegs = new ArrayList<Point2D.Double>();
        yVals.add(new Double(-0.3));
        yVals.add(new Double(-1.6));
        xVals.add(new Double(3.9));
        xVals.add(new Double(4.6));
        demoApp.setSize(690, 240);
        XpPlotModel mpm = XpPlotModel.getDemoModel();
        XpPlotter mp = new XpPlotter(mpm);
        demoApp.getContentPane().add(mp);
        demoApp.setVisible(true);
        demoApp.repaint();
        mp.setLegend(true);
        mp.setXDataMarkers(xVals);
        mp.setYDataMarkers(yVals);
        dSegs.add(new Point2D.Double(0.0, 1.0));
        dSegs.add(new Point2D.Double(3.0, 5.0));
        mp.setDataSegments(dSegs);
        mp.addWaveformDomainDescription("Pulse 1", 0.0, 1.0);
        mp.addWaveformDomainDescription("Pulse 2", 3.0, 5.0);
        mp.setXMarkerPlot(true);
        mp.setYMarkerPlot(true);
        mp.setSegmentPlot(true);
    }

    protected class WaveformValueTrackerScroller
    extends XpMouseTrackerSupport {
        private int currX;
        private int currY;
        private Line2D theMarker;
        private RoundRectangle2D valueBox;
        private Font boxFont;
        private int boxWidth;
        private int boxHeight;
        private DecimalFormat df;
        private Dimension2D plotSize;
        private double plotWidth;
        private double plotHeight;
        private static final double TRANSOFFSET = 10.0;

        public WaveformValueTrackerScroller(XpPlotter plot) {
            super(plot);
            this.currX = -1;
            this.currY = -1;
            this.theMarker = new Line2D.Double(0.0, 0.0, 1.0, 1.0);
            this.valueBox = new RoundRectangle2D.Double();
            this.boxFont = new Font("Fixed", 0, 10);
            this.boxWidth = 160;
            this.boxHeight = 80;
            this.df = new DecimalFormat("###.###");
            this.plotSize = null;
            this.plotWidth = -1.0;
            this.plotHeight = -1.0;
            this.plotSize = this.thePlotter.getPlotArea();
            this.thePlotter.addExternalDrawer(this);
        }

        @Override
        public final void dragMouse2(int x, int y) {
            this.currX = x;
            this.currY = y;
            if (this.currX < 10) {
                this.thePlotter.translate(10.0);
            } else if ((double)this.currX > this.plotWidth - 10.0) {
                this.thePlotter.translate(-10.0);
            } else {
                this.thePlotter.repaint();
            }
        }

        @Override
        public final void pressMouse2(int x, int y) {
            this.currX = x;
            this.currY = y;
            this.plotSize = this.thePlotter.getPlotArea();
            this.plotWidth = this.plotSize.getWidth();
            this.plotHeight = this.plotSize.getHeight();
            this.thePlotter.repaint();
        }

        @Override
        public final void releaseMouse2(int x, int y) {
            this.thePlotter.repaint();
        }

        @Override
        public final void draw(Graphics2D g) {
            int posX = 0;
            if (this.isMouse2Down()) {
                this.theMarker.setLine(this.currX, 0.0, this.currX, 400.0);
                g.draw(this.theMarker);
                if ((double)this.currX < this.plotWidth - (double)this.boxWidth) {
                    posX = this.currX + 2;
                    this.valueBox.setRoundRect(posX, this.currY, this.boxWidth, this.boxHeight, 30.0, 30.0);
                } else {
                    posX = this.currX - this.boxWidth - 2;
                    this.valueBox.setRoundRect(posX, this.currY, this.boxWidth, this.boxHeight, 30.0, 30.0);
                }
                Paint p = g.getPaint();
                g.setPaint(Color.yellow);
                g.fill(this.valueBox);
                g.setPaint(p);
                g.draw(this.valueBox);
                g.setFont(this.boxFont);
                int posY = this.currY + 6;
                Iterator i = this.thePlotter.valueAt(this.currX);
                boolean first = true;
                while (i.hasNext()) {
                    XpWaveformValuePair wvp = (XpWaveformValuePair)i.next();
                    double time = wvp.getX();
                    double value = wvp.getValue();
                    String sx = this.df.format(time);
                    String sy = this.df.format(value);
                    Rectangle2D r = null;
                    if (first) {
                        String dataSegmentName = this.thePlotter.getWaveformDomainName(time);
                        if (dataSegmentName != null) {
                            r = XpDrawTextUtils.centerText(g, dataSegmentName, posY, posX + this.boxWidth / 2);
                            posY = (int)((double)posY + r.getHeight());
                        }
                        String xTitle = this.thePlotter.getXTitle();
                        r = XpDrawTextUtils.centerText(g, xTitle + " : " + sx, posY, posX + this.boxWidth / 2);
                        posY = (int)((double)posY + r.getHeight());
                        g.drawLine(posX + 1, posY, posX + this.boxWidth, posY);
                        first = false;
                    }
                    r = XpDrawTextUtils.drawText(g, wvp.getName(), posX + 4, posY);
                    XpDrawTextUtils.drawText(g, " : " + sy, posX + this.boxWidth * 3 / 5, posY);
                    posY = (int)((double)posY + r.getHeight());
                }
            }
        }
    }

    protected class ZoomBoxTracker
    extends XpMouseTrackerSupport {
        private int origX;
        private int origY;
        private int boxWidth;
        private int boxHeight;
        private double zoomX;
        private double zoomY;
        private double posZoomBoxX;
        private double posZoomBoxY;
        private Dimension2D plotSize;
        private Rectangle2D theBox;
        private Rectangle2D deZoomBox;

        public ZoomBoxTracker(XpPlotter plot) {
            super(plot);
            this.origX = -1;
            this.origY = -1;
            this.boxWidth = -1;
            this.boxHeight = -1;
            this.zoomX = 1.0;
            this.zoomY = 1.0;
            this.posZoomBoxX = 0.0;
            this.posZoomBoxY = 0.0;
            this.plotSize = null;
            this.theBox = new Rectangle2D.Double();
            this.deZoomBox = new Rectangle2D.Double();
            this.thePlotter.addExternalDrawer(this);
        }

        @Override
        public final void dragMouse1(int x, int y) {
            this.boxWidth = x - this.origX;
            this.boxHeight = y - this.origY;
            this.thePlotter.repaint();
        }

        @Override
        public final void pressMouse1(int x, int y) {
            this.origX = x;
            this.origY = y;
            this.zoomY = 1.0;
            this.zoomX = 1.0;
            this.posZoomBoxY = 0.0;
            this.posZoomBoxX = 0.0;
            this.plotSize = this.thePlotter.getPlotArea();
        }

        @Override
        public final void releaseMouse1(int x, int y) {
            this.thePlotter.zoom(this.posZoomBoxX, this.posZoomBoxY, this.zoomX, this.zoomY);
        }

        @Override
        public final void draw(Graphics2D g) {
            if (this.isMouse1Down()) {
                int oX = this.origX;
                int oY = this.origY;
                int bw = Math.abs(this.boxWidth);
                int bh = Math.abs(this.boxHeight);
                Color oldColor = g.getColor();
                g.setColor(Color.darkGray);
                if (this.boxWidth < 0 || this.boxHeight < 0) {
                    double plotSizeWidth = this.plotSize.getWidth();
                    double plotSizeHeight = this.plotSize.getHeight();
                    double dzH = 30.0;
                    double dzW = dzH * (plotSizeWidth / plotSizeHeight);
                    double origZX = (double)oX - dzW / 2.0;
                    double origZY = (double)oY - dzH / 2.0;
                    double tbW = dzW - (double)(2 * this.boxWidth);
                    double tbH = dzH - (double)(2 * this.boxHeight);
                    double origTheBoxX = origZX + (double)this.boxWidth;
                    double origTheBoxY = origZY + (double)this.boxHeight;
                    this.deZoomBox.setRect(origZX, origZY, dzW, dzH);
                    g.draw(this.deZoomBox);
                    this.theBox.setRect(origTheBoxX, origTheBoxY, tbW, tbH);
                    this.zoomX = dzW / tbW;
                    this.zoomY = dzH / tbH;
                    this.posZoomBoxX = plotSizeWidth / 2.0;
                    this.posZoomBoxY = plotSizeHeight / 2.0;
                } else {
                    this.theBox.setRect(oX, oY, bw, bh);
                    this.zoomX = this.plotSize.getWidth() / (double)bw;
                    this.zoomY = this.plotSize.getHeight() / (double)bh;
                    this.posZoomBoxX = -oX;
                    this.posZoomBoxY = -oY;
                }
                g.draw(this.theBox);
                g.setColor(oldColor);
            }
        }
    }

    protected class WaveformDomainDescriptor {
        private String name;
        private Point2D interval;

        public WaveformDomainDescriptor(String n, Point2D in) {
            this.name = n;
            this.interval = in;
        }

        public String getName() {
            return this.name;
        }

        public double getXBegin() {
            return this.interval.getX();
        }

        public double getXEnd() {
            return this.interval.getY();
        }
    }
}

