/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.platform.dm;

import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.platform.dm.DmImageCreator;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.Dimension;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JFrame;

public class DmMultiFrameCreator
extends DmImageCreator {
    private DicomComposite dcmComp = new DicomComposite();
    private String fileName = "";
    private int[] dims = null;
    private double[] ulc = null;
    private double[] xdir = null;
    private double[] ydir = null;
    private double[] zdir = null;
    private int framesAdded = 0;
    private int pixelDataLen = 0;
    private byte[] cacheFrame = null;
    private ByteBuffer bbuff = null;
    private FileOutputStream appendStream = null;

    public DmMultiFrameCreator(XjVolumeInfo vol, XjTagValue[] tags, String fileName) {
        this(vol, tags, false, fileName);
    }

    public DmMultiFrameCreator(XjVolumeInfo vol, XjTagValue[] tags, boolean newStudy, String fileName) {
        super(vol, tags);
        this.init(this.getTags(), tags, vol, newStudy, fileName);
    }

    private void init(XjTagValue[] tagsToFill, XjTagValue[] userTags, XjVolumeInfo vol, boolean newStudy, String fileName) {
        this.setValues(this.dcmComp, tagsToFill);
        this.fileName = fileName;
        this.dims = vol.getVolumeDimensions(null);
        this.ulc = vol.getRASOfOrigin(null);
        this.xdir = vol.getXDirectionRAS(null);
        this.ydir = vol.getYDirectionRAS(null);
        this.zdir = vol.getZDirectionRAS(null);
        this.dcmComp.setValue(8, 24, UidGenerator.newInstanceUID());
        if (newStudy) {
            this.dcmComp.setValue(32, 13, UidGenerator.newInstanceUID());
        }
        this.dcmComp.setValue(32, 14, UidGenerator.newInstanceUID());
        this.dcmComp.setValue(8, 4158, "GEHC Multiframe volume");
        this.dcmComp.setValue(32, 17, DmMultiFrameCreator.getSeriesNo(vol));
        this.dcmComp.setDateValue(8, 18, this.getCreationDate());
        this.dcmComp.setTimeValue(8, 19, this.getCreationDate());
        this.dcmComp.setValue(2, 16, "1.2.840.10008.1.2.1");
        this.dcmComp.setValue(40, 8, new Integer(this.dims[2]));
        double thickness = JnVector3d.length(this.zdir);
        this.dcmComp.setValue(24, 80, "" + thickness);
        int bpp = vol.getBitsPerVoxel();
        int bytesPerVoxel = bpp / 8;
        this.pixelDataLen = this.dims[0] * this.dims[1] * this.dims[2] * bytesPerVoxel;
        this.dcmComp.setValue(32736, 0, new Long(this.pixelDataLen));
        if (userTags != null) {
            for (int i = 0; i < userTags.length; ++i) {
                XjTagValue t = userTags[i];
                try {
                    this.dcmComp.setValue(t.group, t.element, t.value);
                    continue;
                }
                catch (DMException e) {
                    System.err.println("ERROR: Setting user tag (" + Integer.toHexString(t.group) + "," + Integer.toHexString(t.element) + ") : " + t.value);
                    System.err.println("       " + e.getMessage());
                }
            }
        }
    }

    public int getNumberOfFrames() {
        return this.dims[2];
    }

    public void addFrame(Object data, int offset) throws IOException {
        int len = this.dims[0] * this.dims[1];
        if (this.framesAdded == 0) {
            if (data instanceof short[]) {
                this.dcmComp.setVR(32736, 16, 20311);
                this.cacheFrame = new byte[len * 2];
                this.bbuff = ByteBuffer.wrap(this.cacheFrame);
                this.bbuff.order(ByteOrder.LITTLE_ENDIAN);
                this.bbuff.asShortBuffer().put((short[])data, offset, len);
            } else if (data instanceof byte[]) {
                this.dcmComp.setVR(32736, 16, 20290);
                this.cacheFrame = new byte[len];
                this.bbuff = ByteBuffer.wrap(this.cacheFrame);
                this.bbuff.put((byte[])data, offset, len);
            }
            this.dcmComp.setValue(32736, 16, this.cacheFrame);
            FileOutputStream fos = new FileOutputStream(this.fileName);
            this.dcmComp.write(fos, true);
            fos.close();
            dicomParser dp = new dicomParser(this.fileName);
            tagValue tv = new tagValue(32736, 16);
            tv.fillValue = false;
            dp.fill(new tagValue[]{tv});
            dp.clearFile();
            RandomAccessFile raf = new RandomAccessFile(this.fileName, "rw");
            raf.seek(tv.fileOffset + 8L);
            byte[] buff = new byte[4];
            ByteBuffer bb = ByteBuffer.wrap(buff);
            bb.order(tv.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            bb.putInt(this.pixelDataLen);
            raf.write(buff);
            raf.close();
        } else {
            this.bbuff.rewind();
            if (data instanceof short[]) {
                this.bbuff.asShortBuffer().put((short[])data, offset, len);
            } else if (data instanceof byte[]) {
                this.bbuff.put((byte[])data, offset, len);
            }
            if (this.appendStream == null) {
                this.appendStream = new FileOutputStream(this.fileName, true);
            }
            this.appendStream.write(this.cacheFrame, 0, this.cacheFrame.length);
        }
        ++this.framesAdded;
    }

    public void close() throws IOException {
        if (this.appendStream != null) {
            this.appendStream.close();
        }
        if (this.framesAdded != this.dims[2]) {
            throw new IOException("Number of frames in multiframe object not equal to published value: " + this.framesAdded + " " + this.dims[2]);
        }
    }

    public static void main(String[] args) {
        DMSession dms = new DMSession(new String[]{"file", args[0]});
        DMObject[] dmo = dms.getRelated("series");
        DMVolume vol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[0]});
        String mfpath = args[1];
        DmMultiFrameCreator dmf = new DmMultiFrameCreator(vol, null, true, mfpath);
        JVolume.LinearShort jls = new JVolume.LinearShort(vol);
        try {
            for (int idx = 0; idx < jls.dz; ++idx) {
                dmf.addFrame(jls.volume, jls.PAD + idx * jls.dx * jls.dy);
            }
            dmf.close();
            System.err.println("%%% Wrote multiframe: " + mfpath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DMSession dms_mf = new DMSession(new String[]{"file", mfpath});
        DMObject[] dmo_mf = dms_mf.getRelated("series");
        DMVolume volmf = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo_mf[0]});
        JFrame jf = new JFrame("multiframe");
        T3DViewport iv = new T3DViewport();
        iv.setVolume(volmf);
        iv.setRenderStyle("VOLUME");
        jf.setContentPane(iv);
        iv.setPreferredSize(new Dimension(512, 512));
        jf.pack();
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }
}

