/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.marker;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.capable.SliceControlledCapable;
import com.ge.med.terra.jami.capable.SliceListener;
import com.ge.med.terra.jami.capable.SliceSourceCapable;
import com.ge.med.terra.jami.marker.XpMarker;
import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public abstract class XpSliceControlledMarker
extends XpMarker
implements SliceListener {
    protected Map intPtsMap = new HashMap();
    private Stroke markerStroke = new BasicStroke(2.0f);
    private CPoint cpDisp = new CPoint(1);
    private CPoint cpImg = new CPoint(0);
    private Point dp = new Point();

    public XpSliceControlledMarker() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void setImage(XpImage img) {
        super.setImage(img);
        this.intPtsMap.clear();
    }

    protected void resetSliceControlledCapable(SliceControlledCapable scc) {
        this.intPtsMap.remove(scc);
    }

    public final void setMarkerStroke(Stroke str) {
        this.markerStroke = str;
    }

    public final Stroke getMarkerStroke() {
        return this.markerStroke;
    }

    protected final boolean getImageIntersectionPoints(SliceSourceCapable ssc, Point2D[] pts) {
        XpImage mi = this.getImage();
        if (mi != null && ssc != null) {
            XpSlice slice = ssc.getActiveSlice();
            XpSlice mySlice = mi.getSlice();
            mySlice.getIntersection(slice, pts);
            return true;
        }
        return false;
    }

    protected Point2D[] getImageIntersectionPoints(SliceControlledCapable scc, int slIdx) {
        XpImage mi = this.getImage();
        if (mi != null) {
            Point2D[][] cintPts = (Point2D[][])this.intPtsMap.get(scc);
            if (cintPts == null) {
                int len = scc.getNumSlices();
                cintPts = new Point2D[len][];
                XpSlice mySlice = mi.getSlice();
                for (int i = 0; i < len; ++i) {
                    XpSlice currSlice = scc.getSlice(i);
                    cintPts[i] = new Point2D[2];
                    cintPts[i][0] = new Point2D.Double();
                    cintPts[i][1] = new Point2D.Double();
                    mySlice.getIntersection(currSlice, cintPts[i]);
                }
                this.intPtsMap.put(scc, cintPts);
            }
            return cintPts[slIdx];
        }
        return null;
    }

    protected static boolean intersects(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int x43 = x4 - x3;
        int y13 = y1 - y3;
        int y43 = y4 - y3;
        int x13 = x1 - x3;
        int x21 = x2 - x1;
        int y21 = y2 - y1;
        int denom = y43 * x21 - x43 * y21;
        int n1 = x43 * y13 - y43 * x13;
        int n2 = x21 * y13 - y21 * x13;
        if (denom == 0 && (n1 == 0 || n2 == 0)) {
            return true;
        }
        if (denom == 0) {
            return false;
        }
        double ua = (double)n1 / (double)denom;
        double ub = (double)n2 / (double)denom;
        return ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0;
    }

    protected final int getNearestSliceIndex(SliceControlledCapable scc, Point p) {
        this.cpDisp.setLocation(p.x, p.y, 0.0);
        this.transform(this.cpDisp, this.cpImg, (byte)0);
        double closestDist = Double.MAX_VALUE;
        int closestIdx = -1;
        int len = scc.getNumSlices();
        for (int i = 0; i < len; ++i) {
            Point2D[] pts = this.getImageIntersectionPoints(scc, i);
            this.dp.setLocation((pts[0].getX() + pts[1].getX()) / 2.0, (pts[0].getY() + pts[1].getY()) / 2.0);
            double dx = this.dp.getX() - this.cpImg.x;
            double dy = this.dp.getY() - this.cpImg.y;
            double d = dx * dx + dy * dy;
            if (!(d < closestDist)) continue;
            closestDist = d;
            closestIdx = i;
        }
        return closestIdx;
    }
}

