/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import java.util.Arrays;

public class VrHistogram {
    public double intercept;
    public double slope;
    public int max;
    public int min;
    public int[] count;

    public VrHistogram(int min, int max, double slope, double intercept) {
        this.min = min;
        this.max = max;
        this.slope = slope;
        this.intercept = intercept;
        this.count = new int[max - min + 1];
    }

    public void incrementRaw(int raw) {
        if (raw >= this.min && raw <= this.max) {
            int n = raw - this.min;
            this.count[n] = this.count[n] + 1;
        }
    }

    public void incrementValueAt(double value) {
        int raw = (int)Math.round((value - this.intercept) / this.slope);
        this.incrementRaw(raw);
    }

    public void reset() {
        if (this.count != null && this.count.length > 0) {
            Arrays.fill(this.count, 0);
        }
    }

    public static VrHistogram generateFakeHistogram() {
        VrHistogram h = new VrHistogram(-1000, 3071, 1.0, 0.0);
        double mu = 300.0;
        double sigma = h.max - h.min;
        for (int i = h.min; i < h.max; ++i) {
            h.count[i - h.min] = (int)(Math.exp(-((double)i - 300.0) * ((double)i - 300.0) * 600.0 / (sigma * sigma)) * 1000.0);
        }
        return h;
    }
}

