/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIcontrol;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import javax.swing.JComponent;

class OpacityMapUI
implements UIcontrol {
    Preset p;
    Layout l = new Layout();
    public static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{4.0f, 4.0f}, 0.0f);
    public static final BasicStroke CURVE_STROKE = new BasicStroke(1.5f);
    int[] xPoints;
    int[] yPoints;
    int[] curveXpoints;
    int[] curveYpoints;
    int ow;
    int oh;
    transient int counter = 0;
    static TexturePaint checker_;
    public boolean mousePressed = false;
    private int prevX_;
    private JComponent source;

    @Override
    public void setLayout(Layout layout) {
        this.l = layout;
    }

    public void fps() {
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    long t = System.currentTimeMillis();
                    OpacityMapUI.this.counter = 0;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    long t2 = System.currentTimeMillis();
                    if (OpacityMapUI.this.counter == 0) continue;
                    System.out.println(t2 % 10000L + " fps= " + 1000.0f * (float)OpacityMapUI.this.counter / (float)(t2 - t));
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public void paintSbar(Graphics g, int x, int y, int w, int h) {
        this.fillPolygon2(g, x, y, w, h);
    }

    @Override
    public void paint(Graphics g, int w, int h, Rectangle r) {
        this.l.setHeight(h);
        ++this.counter;
        if (this.p == null) {
            return;
        }
        if (this.p.getProperty("paintCache") == null || w != this.ow || h != this.oh) {
            this.ow = w;
            this.oh = h;
            this.updatePaintCache(this.p, w, h);
        }
        g.setColor(Color.GRAY);
        g.fillRect(this.l.BORDER.left, 0, w, this.l.op_bottom);
        this.fillPolygon(g, w, h);
        g.setColor(Color.BLACK);
        g.fillRect(0, this.l.op_bottom, w, 1);
    }

    @Override
    public void setPresets(Preset p) {
        this.p = p;
        this.setupPoints();
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpacityMapUI.this.p.putProperty("paintCache", null);
            }
        });
    }

    public void setupPoints() {
        this.xPoints = new int[4 + 2 * this.p.opacityPos.length];
        this.yPoints = new int[4 + 2 * this.p.opacityPos.length];
    }

    public void fillPolygon(Graphics g, int w, int h) {
        if (this.p == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (4 + 2 * this.p.opacityPos.length != this.xPoints.length) {
            this.setupPoints();
        }
        this.l.setHeight(h);
        int xrange = w - this.l.BORDER.left - this.l.BORDER.right;
        double hmin = this.l.op_bottom;
        double hmax = this.l.op_top;
        this.xPoints[0] = this.l.BORDER.left;
        this.yPoints[0] = (int)hmin;
        this.xPoints[1] = this.l.BORDER.left;
        this.yPoints[1] = (int)(this.p.opacityBefore[0] * (hmax - hmin) + hmin);
        for (int i = 0; i < this.p.opacityPos.length; ++i) {
            int xpos;
            int ypos = (int)(this.p.opacityBefore[i] * (hmax - hmin) + hmin);
            this.xPoints[i * 2 + 2] = xpos = this.l.getXpos(w, this.p.opacityPos[i]);
            this.yPoints[i * 2 + 2] = ypos;
            ypos = (int)(this.p.opacityAfter[i] * (hmax - hmin) + hmin);
            this.xPoints[i * 2 + 3] = xpos;
            this.yPoints[i * 2 + 3] = ypos;
        }
        this.xPoints[2 + this.p.opacityPos.length * 2] = w - this.l.BORDER.right;
        this.yPoints[2 + this.p.opacityPos.length * 2] = (int)(this.p.opacityAfter[this.p.opacityPos.length - 1] * (hmax - hmin) + hmin);
        this.xPoints[3 + this.p.opacityPos.length * 2] = w - this.l.BORDER.right;
        this.yPoints[3 + this.p.opacityPos.length * 2] = (int)hmin;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(OpacityMapUI.getCheckerPattern());
        g.fillPolygon(this.xPoints, this.yPoints, this.yPoints.length);
        g2d.setPaint((Paint)this.p.getProperty("paintCache"));
        g.fillPolygon(this.xPoints, this.yPoints, this.yPoints.length);
        Stroke oldStroke = g2d.getStroke();
        if (this.p.opacityMode == 6) {
            g.setColor(Color.GRAY);
            g2d.setStroke(DASHED_STROKE);
            int humpIndex = 0;
            for (int i = 0; this.p.opacityAtColor != null && i < this.p.opacityAtColor.length; ++i) {
                int ypos1;
                int xpos1;
                int ypos;
                int xpos;
                if (this.p.opacityAtColor[i] < 0.0) continue;
                if (i > 0 && this.p.opacityAtColor[i - 1] >= 0.0) {
                    xpos = (int)((double)xrange * (this.p.opacityPos[(humpIndex - 1) * 5 + 3] - Layout.MIN) / (Layout.MAX - Layout.MIN)) + this.l.BORDER.left;
                    ypos = (int)hmin;
                    xpos1 = (int)((double)xrange * (this.p.opacityPos[humpIndex * 5 + 1] - Layout.MIN) / (Layout.MAX - Layout.MIN)) + this.l.BORDER.left;
                    ypos1 = (int)(this.p.opacityAtColor[i] * (hmax - hmin) + hmin);
                    g2d.drawLine(xpos, ypos, xpos1, ypos1);
                }
                if (i < this.p.opacityAtColor.length - 1 && this.p.opacityAtColor[i + 1] >= 0.0) {
                    xpos = (int)((double)xrange * (this.p.opacityPos[humpIndex * 5 + 3] - Layout.MIN) / (Layout.MAX - Layout.MIN)) + this.l.BORDER.left;
                    ypos = (int)(this.p.opacityAtColor[i] * (hmax - hmin) + hmin);
                    xpos1 = (int)((double)xrange * (this.p.opacityPos[(humpIndex + 1) * 5 + 1] - Layout.MIN) / (Layout.MAX - Layout.MIN)) + this.l.BORDER.left;
                    ypos1 = (int)hmin;
                    g2d.drawLine(xpos, ypos, xpos1, ypos1);
                }
                ++humpIndex;
            }
            g2d.setStroke(oldStroke);
        }
        g2d.setStroke(CURVE_STROKE);
        g.setColor(Color.BLACK);
        g2d.drawPolyline(this.xPoints, this.yPoints, this.yPoints.length - 1);
        g2d.setStroke(oldStroke);
    }

    public void fillPolygon2(Graphics g, int x, int y, int w, int h) {
        if (this.p == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (4 + 2 * this.p.opacityPos.length != this.xPoints.length) {
            this.setupPoints();
        }
        BufferedImage img = new BufferedImage(w, 1, 1);
        int[] buff = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        if (this.p.blackwhitemode) {
            int gray = Color.GRAY.getRGB();
            Arrays.fill(buff, gray);
        } else {
            for (int i = 0; i < w; ++i) {
                double pos = (Layout.MAX - Layout.MIN) * (double)i / (double)(w - 1) + Layout.MIN;
                buff[i] = this.getColorAtLocataion(pos);
            }
        }
        TexturePaint paint = new TexturePaint(img, new Rectangle2D.Double(x, y, w, h));
        int xrange = w;
        double hmin = h;
        double hmax = y;
        this.xPoints[0] = x;
        this.yPoints[0] = (int)hmin;
        this.xPoints[1] = x;
        this.yPoints[1] = (int)(this.p.opacityBefore[0] * (hmax - hmin) + hmin) + y;
        for (int i = 0; i < this.p.opacityPos.length; ++i) {
            int xpos;
            int ypos = (int)(this.p.opacityBefore[i] * (hmax - hmin) + hmin);
            this.xPoints[i * 2 + 2] = xpos = x + (int)((double)xrange * (this.p.opacityPos[i] - Layout.MIN) / (Layout.MAX - Layout.MIN)) + 0;
            this.yPoints[i * 2 + 2] = ypos;
            ypos = (int)(this.p.opacityAfter[i] * (hmax - hmin) + hmin);
            this.xPoints[i * 2 + 3] = xpos;
            this.yPoints[i * 2 + 3] = ypos;
        }
        this.xPoints[2 + this.p.opacityPos.length * 2] = x + w;
        this.yPoints[2 + this.p.opacityPos.length * 2] = (int)(this.p.opacityAfter[this.p.opacityPos.length - 1] * (hmax - hmin) + hmin);
        this.xPoints[3 + this.p.opacityPos.length * 2] = x + w;
        this.yPoints[3 + this.p.opacityPos.length * 2] = (int)hmin;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(paint);
        g.fillPolygon(this.xPoints, this.yPoints, this.yPoints.length);
        Stroke oldStroke = g2d.getStroke();
        if (this.p.opacityMode == 6) {
            g.setColor(Color.GRAY);
            g2d.setStroke(DASHED_STROKE);
            int humpIndex = 0;
            for (int i = 0; this.p.opacityAtColor != null && i < this.p.opacityAtColor.length; ++i) {
                int ypos1;
                int xpos1;
                int ypos;
                int xpos;
                if (this.p.opacityAtColor[i] < 0.0) continue;
                if (i > 0 && this.p.opacityAtColor[i - 1] >= 0.0) {
                    xpos = x + (int)((double)xrange * (this.p.opacityPos[(humpIndex - 1) * 5 + 3] - Layout.MIN) / (Layout.MAX - Layout.MIN));
                    ypos = (int)hmin;
                    xpos1 = x + (int)((double)xrange * (this.p.opacityPos[humpIndex * 5 + 1] - Layout.MIN) / (Layout.MAX - Layout.MIN));
                    ypos1 = (int)(this.p.opacityAtColor[i] * (hmax - hmin) + hmin);
                    g2d.drawLine(xpos, ypos, xpos1, ypos1);
                }
                if (i < this.p.opacityAtColor.length - 1 && this.p.opacityAtColor[i + 1] >= 0.0) {
                    xpos = x + (int)((double)xrange * (this.p.opacityPos[humpIndex * 5 + 3] - Layout.MIN) / (Layout.MAX - Layout.MIN));
                    ypos = (int)(this.p.opacityAtColor[i] * (hmax - hmin) + hmin);
                    xpos1 = x + (int)((double)xrange * (this.p.opacityPos[(humpIndex + 1) * 5 + 1] - Layout.MIN) / (Layout.MAX - Layout.MIN));
                    ypos1 = (int)hmin;
                    g2d.drawLine(xpos, ypos, xpos1, ypos1);
                }
                ++humpIndex;
            }
            g2d.setStroke(oldStroke);
        }
        g2d.setStroke(CURVE_STROKE);
        g.setColor(Color.BLACK);
        g2d.drawPolyline(this.xPoints, this.yPoints, this.yPoints.length - 1);
        g2d.setStroke(oldStroke);
    }

    public int getColorAtLocataion(double pos) {
        if (pos <= this.p.rgbPos[0]) {
            return this.p.rgbValue[0] & 0xFFFFFF;
        }
        if (pos >= this.p.rgbPos[this.p.rgbPos.length - 1]) {
            return this.p.rgbValue[this.p.rgbPos.length - 1] & 0xFFFFFF;
        }
        for (int i = 1; i < this.p.rgbPos.length; ++i) {
            if (!(pos < this.p.rgbPos[i])) continue;
            int c1 = this.p.rgbValue[i];
            int c0 = this.p.rgbValue[i - 1];
            double t = (pos - this.p.rgbPos[i - 1]) / (this.p.rgbPos[i] - this.p.rgbPos[i - 1]);
            if (this.p.rgbNNeighbour) {
                return t > 0.5 ? c1 : c0;
            }
            int b = (int)((double)(c1 & 0xFF) * t + (double)(c0 & 0xFF) * (1.0 - t));
            int g = (int)((double)((c1 >>= 8) & 0xFF) * t + (double)((c0 >>= 8) & 0xFF) * (1.0 - t));
            int r = (int)((double)((c1 >>= 8) & 0xFF) * t + (double)((c0 >>= 8) & 0xFF) * (1.0 - t));
            int c = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
            return c;
        }
        return 0;
    }

    public double getOpacityAtLocation(double pos) {
        int i;
        for (i = 0; i < this.p.opacityPos.length && !(this.p.opacityPos[i] > pos); ++i) {
        }
        if (i > 0 && i < this.p.opacityPos.length) {
            double p0 = this.p.opacityPos[i - 1];
            double p1 = this.p.opacityPos[i];
            double o0 = this.p.opacityAfter[i - 1];
            double o1 = this.p.opacityBefore[i];
            return o0 + (pos - p0) / (p1 - p0) * (o1 - o0);
        }
        if (i == 0) {
            return this.p.opacityBefore[0];
        }
        return this.p.opacityAfter[this.p.opacityPos.length - 1];
    }

    public void updatePaintCache(Preset p, int sw, int sh) {
        int w = this.l.getXRange(sw);
        if (w <= 1) {
            p.putProperty("paintCache", new GradientPaint(0.0f, 0.0f, Color.black, 10.0f, 10.0f, Color.GRAY));
            p.putProperty("paintCacheNoAlpha", new GradientPaint(0.0f, 0.0f, Color.black, 10.0f, 10.0f, Color.GRAY));
            return;
        }
        int h = sh - this.l.BORDER.top - this.l.BORDER.bottom;
        BufferedImage img = new BufferedImage(w, 1, 2);
        int[] buff = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        BufferedImage imgNoAlpha = new BufferedImage(w, 1, 1);
        int[] buffNoAlpha = ((DataBufferInt)imgNoAlpha.getRaster().getDataBuffer()).getData();
        if (p.blackwhitemode) {
            p.putProperty("paintCacheNoAlpha", Color.GRAY);
            int gray = Color.GRAY.getRGB() & 0xFFFFFF;
            for (int i = 0; i < w; ++i) {
                double pos = (Layout.MAX - Layout.MIN) * (double)i / (double)(w - 1) + Layout.MIN;
                double alpha = this.getOpacityAtLocation(pos);
                buff[i] = gray | (int)(alpha * 255.0) << 24;
            }
            p.putProperty("paintCache", new TexturePaint(img, new Rectangle2D.Double(this.l.BORDER.left, this.l.BORDER.top, w, h)));
            return;
        }
        for (int i = 0; i < w; ++i) {
            double pos = (Layout.MAX - Layout.MIN) * (double)i / (double)(w - 1) + Layout.MIN;
            buffNoAlpha[i] = this.getColorAtLocataion(pos);
            double alpha = this.getOpacityAtLocation(pos);
            buff[i] = buffNoAlpha[i] & 0xFFFFFF | (int)(Math.pow(alpha, 0.1) * 255.0) << 24;
        }
        p.putProperty("paintCache", new TexturePaint(img, new Rectangle2D.Double(this.l.BORDER.left, this.l.BORDER.top, w, h)));
        p.putProperty("paintCacheNoAlpha", new TexturePaint(imgNoAlpha, new Rectangle2D.Double(this.l.BORDER.left, this.l.BORDER.top, w, h)));
    }

    public static Paint getCheckerPattern() {
        if (checker_ == null) {
            int checkerSize = 8;
            int white = Color.WHITE.getRGB();
            int gray = Color.GRAY.getRGB();
            BufferedImage im = new BufferedImage(16, 16, 1);
            int[] buff = ((DataBufferInt)im.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < buff.length; ++i) {
                int row = i / 8 / 2 / 8;
                int col = i % 16 / 8;
                buff[i] = row == 0 && col == 0 || row == 1 && col == 1 ? white : gray;
            }
            checker_ = new TexturePaint(im, new Rectangle2D.Double(0.0, 0.0, 16.0, 16.0));
        }
        return checker_;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.mousePressed) {
            return;
        }
        int x = e.getX();
        double translation = this.l.getVfromX(this.source.getWidth(), x) - this.l.getVfromX(this.source.getWidth(), this.prevX_);
        if (this.p.opacityMode != 6) {
            int i = 0;
            while (i < this.p.opacityPos.length) {
                int n = i++;
                this.p.opacityPos[n] = this.p.opacityPos[n] + translation;
            }
        } else {
            int i = 0;
            while (i < this.p.rgbPos.length) {
                int n = i++;
                this.p.rgbPos[n] = this.p.rgbPos[n] + translation;
            }
            this.p.updateOpacityPts();
        }
        this.source.repaint();
        this.p.fireActionPerformed(new ActionEvent(this, 0, "opacity_mouseDragged"));
        this.prevX_ = x;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        this.l.setHeight(c.getHeight());
        boolean onCurve = this.onCurve(e.getX(), e.getY(), c.getWidth());
        if (onCurve) {
            c.setCursor(Cursor.getPredefinedCursor(12));
            return true;
        }
        return false;
    }

    public boolean onCurve(int x, int y, int w) {
        double pos = this.l.getVfromX(w, x);
        double hmin = this.l.op_bottom;
        double hmax = this.l.op_top;
        int index = -1;
        for (int i = 0; i < this.p.opacityPos.length; ++i) {
            int x1 = this.l.getXpos(w, this.p.opacityPos[i]);
            if (x >= x1) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            double opacityAtCurve = 0.0;
            if (index == 0) {
                opacityAtCurve = this.p.opacityBefore[0];
            } else if (index == -1) {
                opacityAtCurve = this.p.opacityAfter[this.p.opacityPos.length - 1];
            } else {
                double y1 = this.p.opacityAfter[index - 1];
                double y2 = this.p.opacityBefore[index];
                double x1 = this.p.opacityPos[index - 1];
                double x2 = this.p.opacityPos[index];
                opacityAtCurve = y1 + (pos - x1) * (y2 - y1) / (x2 - x1);
            }
            int opAtCurveOnPlot = (int)(opacityAtCurve * (hmax - hmin) + hmin);
            if (Math.abs(y - opAtCurveOnPlot) < 5) {
                boolean onhandle = false;
                for (int i = 0; i < this.p.opacityPos.length; ++i) {
                    int x1;
                    if (!this.showLine(i) || Math.abs((x1 = this.l.getXpos(w, this.p.opacityPos[i])) - x) >= 10) continue;
                    int posBefore = (int)(this.p.opacityBefore[i] * (hmax - hmin) + hmin);
                    int posAfter = (int)(this.p.opacityAfter[i] * (hmax - hmin) + hmin);
                    boolean nearPosBefore = Math.abs(posBefore - y) < 6;
                    boolean nearPosAfter = Math.abs(posAfter - y) < 6;
                    int dx = x1 - x;
                    if (!this.showRHandle(i) && y < this.l.color_bottom && y > posBefore && posBefore == posAfter) break;
                    if (nearPosBefore && nearPosAfter) {
                        onhandle = true;
                        break;
                    }
                    if (nearPosBefore) {
                        onhandle = true;
                        break;
                    }
                    if (nearPosAfter) {
                        onhandle = true;
                        break;
                    }
                    if (y >= this.l.color_bottom) break;
                    break;
                }
                return !onhandle;
            }
        }
        return false;
    }

    public boolean showRHandle(int pos) {
        switch (this.p.opacityMode) {
            case 0: {
                return true;
            }
            case 4: {
                return pos == 0 || pos == 3;
            }
            case 3: {
                return pos == 1 || pos == 2;
            }
            case 6: {
                return this.showAttachObjectControlAt(pos);
            }
            case 2: {
                return pos == 0;
            }
            case 1: {
                return pos > 0;
            }
            case 5: {
                return pos == 0;
            }
        }
        return false;
    }

    private boolean showAttachObjectControlAt(int pos) {
        if (this.p.opacityMode != 6) {
            throw new IllegalArgumentException("Not in attach object mode!");
        }
        return pos % 5 == 2;
    }

    public boolean showLine(int pos) {
        switch (this.p.opacityMode) {
            case 0: {
                return true;
            }
            case 4: {
                return pos == 0 || pos == 3;
            }
            case 3: {
                return pos == 1 || pos == 2;
            }
            case 6: {
                return this.showAttachObjectControlAt(pos);
            }
            case 2: {
                return true;
            }
            case 1: {
                return true;
            }
            case 5: {
                return pos == 0;
            }
        }
        return false;
    }

    public boolean showLHandle(int pos) {
        switch (this.p.opacityMode) {
            case 0: {
                return true;
            }
            case 4: {
                return pos == 0 || pos == 3;
            }
            case 3: {
                return pos == 1 || pos == 2;
            }
            case 6: {
                return this.showAttachObjectControlAt(pos);
            }
            case 2: {
                return pos == 0;
            }
            case 1: {
                return pos > 0;
            }
            case 5: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        this.source = (JComponent)e.getSource();
        if (this.onCurve(e.getX(), e.getY(), this.source.getWidth())) {
            this.mousePressed = true;
            this.prevX_ = e.getX();
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mousePressed = false;
        ((JComponent)e.getSource()).repaint();
        this.p.fireActionPerformed(new ActionEvent(this, 0, "opacity_mouseReleased"));
    }
}

