/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.Beans;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ColorWheel
extends JComponent {
    protected float hue = Float.NaN;
    protected float sat = Float.NaN;
    protected double rad;
    double brig = 0.99;
    boolean redraw = true;
    BufferedImage img = new BufferedImage(1, 1, 1);
    transient Vector changeListeners = new Vector();

    public ColorWheel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("ColorWheel");
        ColorWheel p = new ColorWheel();
        f.setContentPane(p);
        f.setDefaultCloseOperation(3);
        f.setBounds(10, 10, 512, 512);
        f.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        int h = this.getHeight();
        int w = this.getWidth();
        if (w != this.img.getWidth() || h != this.img.getHeight()) {
            this.img = new BufferedImage(w, h, 1);
            this.redraw = true;
        }
        if (this.redraw) {
            this.fillBufferWithWheel(this.img, w, h);
            this.redraw = false;
        }
        g.drawImage(this.img, 0, 0, null);
        if ((double)this.hue == Double.NaN) {
            return;
        }
        if (Beans.isDesignTime()) {
            return;
        }
        this.paintBall(g, w, h);
        Graphics g2 = g.create();
        g2.setFont(this.getFont().deriveFont(1));
        g2.drawString("H:" + (int)((this.hue + 1.0f) * 180.0f) + " S:" + (float)((int)(this.sat * 100.0f)) / 100.0f, 5, h - 20);
    }

    public void fillBufferWithWheel(BufferedImage img, int w, int h) {
        this.rad = (w > h ? (double)h / 2.0 : (double)w / 2.0) - 10.0;
        int[] buff = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < buff.length; ++i) {
            double sat;
            double hue;
            double x = (double)w / 2.0 - (double)(i % w);
            double y = (double)h / 2.0 - (double)(i / w);
            double ang = Math.atan2(x, y) / (Math.PI * 2);
            double dist = Math.sqrt(x * x + y * y);
            if (dist > this.rad + 1.0) {
                buff[i] = 0;
                continue;
            }
            if (dist > this.rad) {
                hue = ang;
                sat = (dist - 1.0) / this.rad;
                double b = this.brig * (1.0 + this.rad - dist);
                buff[i] = Color.HSBtoRGB((float)hue, (float)sat, (float)b);
                continue;
            }
            hue = ang;
            sat = dist / this.rad;
            buff[i] = Color.HSBtoRGB((float)hue, (float)sat, (float)this.brig);
        }
    }

    public void paintBall(Graphics g, int w, int h) {
        double x = (double)w / 2.0 - (double)this.sat * this.rad * Math.sin((double)(this.hue * 2.0f) * Math.PI);
        double y = (double)h / 2.0 - (double)this.sat * this.rad * Math.cos((double)(this.hue * 2.0f) * Math.PI);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.BLACK);
        g.fillArc((int)(x - 5.0), (int)(y - 5.0), 10, 10, 0, 370);
        g.setColor(Color.getHSBColor(this.hue, this.sat, (float)this.brig));
        g.fillArc((int)(x - 3.0), (int)(y - 3.0), 6, 6, 0, 3700);
    }

    private void jbInit() throws Exception {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ColorWheel.this.this_mouseDragged(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ColorWheel.this.this_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ColorWheel.this.this_mouseReleased(e);
            }
        });
    }

    public void this_mouseDragged(MouseEvent e) {
        this.move(e);
    }

    public void this_mousePressed(MouseEvent e) {
        this.move(e);
    }

    public void this_mouseReleased(MouseEvent e) {
    }

    public void move(MouseEvent e) {
        double xd = (double)this.getWidth() / 2.0 - (double)e.getX();
        double yd = (double)this.getHeight() / 2.0 - (double)e.getY();
        double dist = Math.min(Math.sqrt(xd * xd + yd * yd), this.rad);
        this.hue = (float)(Math.atan2(xd, yd) / (Math.PI * 2));
        this.sat = (float)(dist / this.rad);
        this.fireStateChanged(new ChangeEvent(this));
        this.repaint();
    }

    public double getHue() {
        return this.hue;
    }

    public double getSat() {
        return this.sat;
    }

    public void setSat(double sat) {
        this.sat = (float)sat;
    }

    public void setHue(double hue) {
        this.hue = (float)hue;
    }

    public void setBright(double br) {
        this.brig = br;
        this.redraw = true;
        this.fireStateChanged(new ChangeEvent(this));
        this.repaint();
    }

    public double getBright() {
        return this.brig;
    }

    public void setColor(int rgb) {
        float[] hsb = Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, null);
        this.hue = hsb[0];
        this.sat = hsb[1];
        this.brig = hsb[2];
        this.redraw = true;
        this.repaint();
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireStateChanged(ChangeEvent e) {
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ChangeListener)listeners.elementAt(i)).stateChanged(e);
            }
        }
    }
}

