/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.CNOplot;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.ColorEditor;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.HistogramUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.OpacityMapUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.TickMarksUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrHistogram;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.Beans;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;

class CNOscrollview
extends JPanel {
    JDialog dialog = null;
    OverlayLayout olay = new OverlayLayout(this);
    ActionListener actionhandle = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            CNOscrollview.this.ms.repaint();
            if ("zoom_down".equals(action)) {
                CNOscrollview.this.setZoom(1.1 * CNOscrollview.this.getZoom());
            } else if ("zoom_up".equals(action)) {
                CNOscrollview.this.setZoom(0.9 * CNOscrollview.this.getZoom());
            } else if ("show_wheel".equals(action)) {
                Frame frame;
                if (CNOscrollview.this.dialog == null && (frame = CNOscrollview.this.getTopFrame()) != null) {
                    CNOscrollview.this.dialog = new JDialog(frame, "Preset Color Editor", false);
                    CNOscrollview.this.dialog.setContentPane(CNOscrollview.this.colorEdit);
                    CNOscrollview.this.colorEdit.setPreferredSize(new Dimension(356, 256));
                    int mw = frame.getWidth() >> 1;
                    int mh = frame.getHeight() >> 1;
                    int cw = CNOscrollview.this.colorEdit.getWidth() >> 1;
                    int ch = CNOscrollview.this.colorEdit.getHeight() >> 1;
                    CNOscrollview.this.dialog.setLocation(frame.getX() + mw - cw, frame.getY() + mh - ch);
                    CNOscrollview.this.dialog.pack();
                }
                CNOscrollview.this.dialog.setVisible(!CNOscrollview.this.dialog.isVisible());
            } else if ("add_col_at".equals(action)) {
                Point p = (Point)e.getSource();
                System.out.println("....=" + p.x);
                CNOscrollview.this.plot.preset.addNewColor(CNOscrollview.this.plot.layout.getVfromX(CNOscrollview.this.plot.getWidth(), p.x));
                CNOscrollview.this.plot.preset.putProperty("paintCache", null);
                CNOscrollview.this.repaint();
            } else if ("add_col".equals(action)) {
                Rectangle r = CNOscrollview.this.plot.getVisibleRect();
                CNOscrollview.this.plot.preset.addNewColor(CNOscrollview.this.plot.layout.getVfromX(CNOscrollview.this.plot.getWidth(), r.x + r.width / 2));
                CNOscrollview.this.repaint();
            } else if ("remove_col".equals(action)) {
                if (CNOscrollview.this.plot.preset.rgbSelected == -1) {
                    return;
                }
                CNOscrollview.this.plot.preset.removeSelectedColor();
                CNOscrollview.this.repaint();
            } else if ("color_changed".equals(action)) {
                CNOscrollview.this.repaint();
            } else if ("bwmode".equals(action)) {
                CNOscrollview.this.repaint();
            } else if ("attach_object".equals(action)) {
                CNOscrollview.this.plot.preset.attachObjectAt(CNOscrollview.this.plot.preset.rgbSelected);
                CNOscrollview.this.repaint();
            } else if ("detach_object".equals(action)) {
                CNOscrollview.this.plot.preset.detachObjectAt(CNOscrollview.this.plot.preset.rgbSelected);
                CNOscrollview.this.repaint();
            } else if ("rgbmode_changed".equals(action)) {
                CNOscrollview.this.repaint();
            } else if ("add_op".equals(action)) {
                Rectangle r = CNOscrollview.this.plot.getVisibleRect();
                CNOscrollview.this.plot.preset.addNewOpacity(CNOscrollview.this.plot.layout.getVfromX(CNOscrollview.this.plot.getWidth(), r.x + r.width / 2));
                CNOscrollview.this.repaint();
            } else if ("remove_op".equals(action)) {
                CNOscrollview.this.plot.preset.removeSelectedOpacity();
                CNOscrollview.this.repaint();
            }
        }
    };
    boolean secondTime = false;
    ColorEditor colorEdit = new ColorEditor();
    JScrollPane plotScrollPane = new JScrollPane();
    CNOplot plot = new CNOplot();
    MyScroll ms = new MyScroll();
    transient Vector actionListeners;

    public CNOscrollview() {
        if (Beans.isDesignTime()) {
            this.setPresets(new Preset());
        }
        this.setLayout(this.olay);
        this.plotScrollPane.setHorizontalScrollBarPolicy(32);
        this.plotScrollPane.setBounds(0, 0, 100, 100);
        this.colorEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CNOscrollview.this.dialog != null) {
                    CNOscrollview.this.dialog.setVisible(false);
                } else {
                    CNOscrollview.this.colorEdit.setVisible(false);
                }
            }
        });
        this.add(this.plotScrollPane);
        this.plotScrollPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.plotScrollPane.setViewportBorder(BorderFactory.createLineBorder(Color.BLACK, 0));
        this.plotScrollPane.getViewport().add(this.plot);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                System.out.println("componentResized this.getWidth()=" + CNOscrollview.this.getWidth());
                if (CNOscrollview.this.secondTime) {
                    return;
                }
                CNOscrollview.this.setZoom(10.0);
                int x = CNOscrollview.this.plot.layout.getXpos(CNOscrollview.this.plot.getWidth(), CNOscrollview.this.plot.preset.opacityPos[0]);
                Rectangle r = new Rectangle(x - 20, 0, CNOscrollview.this.getWidth(), 0);
                CNOscrollview.this.plot.scrollRectToVisible(r);
                CNOscrollview.this.secondTime = true;
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.plotScrollPane.setHorizontalScrollBar(this.ms);
    }

    private Frame getTopFrame() {
        Frame topWindow = null;
        Container c = this.getParent();
        while (true) {
            if (c instanceof Frame || c == null) break;
            c = c.getParent();
        }
        topWindow = (Frame)c;
        return topWindow;
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("CNOscrollview.java");
        CNOscrollview p = new CNOscrollview();
        p.setPresets(new Preset());
        f.setContentPane(p);
        f.setBounds(100, 100, 512, 512);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public void setPresets(Preset p) {
        this.plot.setPresets(p);
        this.colorEdit.setPreset(p);
        p.addActionListener(this.actionhandle);
        int x = this.plot.layout.getXpos(this.plot.getWidth(), p.opacityPos[0]);
        Rectangle r = new Rectangle(x, 0, this.getWidth(), 0);
        this.plot.scrollRectToVisible(r);
    }

    public double getZoom() {
        return this.plot.getZoom();
    }

    public void setZoom(double zoom) {
        this.plot.setZoom(zoom);
    }

    public synchronized void addActionListener(ActionListener l) {
    }

    public synchronized void removeActionListener(ActionListener l) {
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    private void jbInit() throws Exception {
    }

    public void setCursorValue(double value) {
        this.plot.setCursorValue(value);
        this.ms.setCursroValue(this.plot.layout.getNormalizedPosition(value));
    }

    public void setCursorColor(Color c) {
        this.plot.setCursorColor(c);
    }

    public void setHistogram(VrHistogram h) {
        this.plot.setHistogram(h);
        this.plot.resetPanZoom();
    }

    public void setDataRange(double min, double max, String unit) {
        Layout.MIN = min;
        Layout.MAX = max;
        TickMarksUI.UNIT = unit;
        this.plot.resetPanZoom();
    }

    public void setMousePan(boolean b) {
        System.out.println("CNOscrollview.setMousePan()" + b);
        this.plot.setMousePan(b);
    }

    public VrHistogram getHistogram() {
        return this.plot.getHistogram();
    }

    class MyScroll
    extends JScrollBar {
        OpacityMapUI umu;
        HistogramUI histogramUI;
        Rectangle r;
        double cv;
        BufferedImage img;
        int[] data;
        Graphics ig;

        public MyScroll() {
            super.setOrientation(0);
            this.umu = null;
            this.histogramUI = null;
            this.r = new Rectangle();
            this.cv = 0.5;
            this.img = new BufferedImage(1, 1, 2);
            this.data = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
            this.ig = this.img.getGraphics();
            for (int i = 0; i < CNOscrollview.this.plot.ui.length; ++i) {
                if (CNOscrollview.this.plot.ui[i] instanceof OpacityMapUI) {
                    this.umu = (OpacityMapUI)CNOscrollview.this.plot.ui[i];
                    continue;
                }
                if (!(CNOscrollview.this.plot.ui[i] instanceof HistogramUI)) continue;
                this.histogramUI = (HistogramUI)CNOscrollview.this.plot.ui[i];
            }
        }

        public void setCursroValue(double f) {
            this.cv = f;
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            Color c = this.getBackground();
            g.setColor(c);
            g.fillRect(0, 0, w, h);
            this.r.width = w;
            this.r.height = h;
            this.umu.paintSbar(g, 16, 0, w - 32, h);
            this.histogramUI.drawHistogram(g, new Rectangle(16, 0, w - 32, h), false, true);
            g.setColor(Color.GREEN);
            g.drawLine((int)((double)w * this.cv), 0, (int)((double)w * this.cv), this.getHeight());
            if (this.img.getWidth() != w || this.img.getHeight() != h) {
                this.img = new BufferedImage(w, h, 2);
                this.data = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
                this.ig = this.img.getGraphics();
            }
            for (int i = 0; i < this.data.length; ++i) {
                this.data[0] = 0;
            }
            super.paint(this.ig);
            int bg = c.getRGB();
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int i = x + y * w;
                    if (x < 16 || x > w - 17) continue;
                    if (this.data[i] == bg) {
                        this.data[i] = 0;
                        continue;
                    }
                    int n = i;
                    this.data[n] = this.data[n] & 0xFFFFFF;
                    int n2 = i;
                    this.data[n2] = this.data[n2] | 0xD0000000;
                }
            }
            g.drawImage(this.img, 0, 0, null);
        }
    }
}

