/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.AddRemovePanel;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.CNOoverlayPanel;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Messages;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrPresetsEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class BottomControlPanel
extends JPanel {
    public static final String ACTION_REMOVE_COL = "remove_col";
    public static final String ACTION_ADD_COL = "add_col";
    public static final String ACTION_ADD_COL_AT = "add_col_at";
    public static final String ACTION_ATTACH_OBJ = "attach_object";
    public static final String ACTION_DETACH_OBJ = "detach_object";
    public static final String ACTION_REMOVE_OP = "remove_op";
    public static final String ACTION_ADD_OP = "add_op";
    JButton addColorButton = new JButton();
    JButton removeColorButton = new JButton();
    JToggleButton attachButton = new JToggleButton();
    JToggleButton detachButton = new JToggleButton();
    JToggleButton linearColorToggle = new JToggleButton();
    JToggleButton nearestNeighborToggle = new JToggleButton();
    JToggleButton jTcontrast0 = new JToggleButton();
    JToggleButton jTcontrast1 = new JToggleButton();
    JToggleButton jTcontrast2 = new JToggleButton();
    JButton jBaddOpacity = new JButton();
    JButton jBrmOpacity = new JButton();
    JSpinner brightnessSpinner = new JSpinner();
    AbstractButton[] all = new AbstractButton[]{this.attachButton, this.detachButton, this.linearColorToggle, this.nearestNeighborToggle};
    JLabel colorLabel = new JLabel(" ");
    JLabel brightnessLabel = new JLabel(new ImageIcon(BottomControlPanel.class.getResource("bright.png")));
    Box bwBar = Box.createHorizontalBox();
    Box colorBar = Box.createHorizontalBox();
    private Preset preset_;

    public BottomControlPanel() {
        this.initUI();
        this.initActions();
    }

    private void initActions() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BottomControlPanel.this.preset_ != null) {
                    BottomControlPanel.this.preset_.fireActionPerformed(e);
                }
            }
        };
        this.linearColorToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BottomControlPanel.this.preset_ != null) {
                    BottomControlPanel.this.preset_.setRGBnn(false);
                }
            }
        });
        this.nearestNeighborToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BottomControlPanel.this.preset_ != null) {
                    BottomControlPanel.this.preset_.setRGBnn(true);
                }
            }
        });
        this.attachButton.setActionCommand(ACTION_ATTACH_OBJ);
        this.detachButton.setActionCommand(ACTION_DETACH_OBJ);
        this.addColorButton.setActionCommand(ACTION_ADD_COL);
        this.removeColorButton.setActionCommand(ACTION_REMOVE_COL);
        this.attachButton.addActionListener(al);
        this.detachButton.addActionListener(al);
        this.addColorButton.addActionListener(al);
        this.removeColorButton.addActionListener(al);
        this.colorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (BottomControlPanel.this.preset_ != null && ((BottomControlPanel)BottomControlPanel.this).preset_.rgbSelected >= 0) {
                    BottomControlPanel.this.preset_.fireActionPerformed(new ActionEvent(this, 0, "show_wheel"));
                }
            }
        });
        this.brightnessSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double v = (double)((Integer)BottomControlPanel.this.brightnessSpinner.getValue()).intValue() / 100.0;
                if (BottomControlPanel.this.preset_ != null) {
                    BottomControlPanel.this.preset_.setBrightness(v);
                }
            }
        });
        this.jBaddOpacity.setActionCommand(ACTION_ADD_OP);
        this.jBrmOpacity.setActionCommand(ACTION_REMOVE_OP);
        this.jBaddOpacity.addActionListener(al);
        this.jBrmOpacity.addActionListener(al);
        this.jTcontrast0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BottomControlPanel.this.preset_ != null) {
                    BottomControlPanel.this.preset_.setContrastEnhancementMode(0);
                }
            }
        });
        this.jTcontrast1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BottomControlPanel.this.preset_ != null) {
                    BottomControlPanel.this.preset_.setContrastEnhancementMode(1);
                }
            }
        });
        this.jTcontrast2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BottomControlPanel.this.preset_ != null) {
                    BottomControlPanel.this.preset_.setContrastEnhancementMode(2);
                }
            }
        });
    }

    public void updatePresets() {
        this.brightnessSpinner.setValue(new Integer((int)(this.preset_.brightness * 100.0)));
        this.linearColorToggle.setSelected(!this.preset_.rgbNNeighbour);
        this.nearestNeighborToggle.setSelected(this.preset_.rgbNNeighbour);
    }

    public void updateAppearance() {
        if (this.preset_ != null) {
            if (this.preset_.blackwhitemode) {
                this.attachButton.setVisible(false);
                this.detachButton.setVisible(false);
                this.addColorButton.setVisible(false);
                this.removeColorButton.setVisible(false);
                this.colorLabel.setVisible(false);
                this.jTcontrast0.setVisible(true);
                this.jTcontrast1.setVisible(true);
                this.jTcontrast2.setVisible(true);
                this.linearColorToggle.setVisible(false);
                this.nearestNeighborToggle.setVisible(false);
            } else {
                this.linearColorToggle.setVisible(true);
                this.nearestNeighborToggle.setVisible(true);
                this.jTcontrast0.setVisible(false);
                this.jTcontrast1.setVisible(false);
                this.jTcontrast2.setVisible(false);
                this.colorLabel.setVisible(true);
                this.addColorButton.setVisible(true);
                this.removeColorButton.setVisible(true);
                boolean attdetachVisible = this.preset_.opacityMode == 6;
                this.attachButton.setVisible(attdetachVisible);
                this.detachButton.setVisible(attdetachVisible);
            }
            boolean colorSelected = this.preset_.rgbSelected >= 0;
            this.removeColorButton.setEnabled(colorSelected && this.preset_.rgbPos.length > 1);
            this.attachButton.setEnabled(colorSelected);
            this.detachButton.setEnabled(colorSelected);
            if (colorSelected && this.preset_.opacityMode == 6 && this.preset_.opacityAtColor != null) {
                this.attachButton.setEnabled(true);
                this.detachButton.setEnabled(true);
                this.attachButton.setSelected(this.preset_.opacityAtColor[this.preset_.rgbSelected] >= 0.0);
                this.detachButton.setSelected(this.preset_.opacityAtColor[this.preset_.rgbSelected] < 0.0);
            } else {
                this.attachButton.setEnabled(false);
                this.detachButton.setEnabled(false);
            }
            if (!VrPresetsEditor.AWmode && this.preset_.opacityMode == 0) {
                this.jBaddOpacity.setVisible(true);
                this.jBrmOpacity.setVisible(true);
            } else {
                this.jBaddOpacity.setVisible(false);
                this.jBrmOpacity.setVisible(false);
            }
            this.jTcontrast0.setSelected(this.preset_.contrastEnhancementMode == 0);
            this.jTcontrast1.setSelected(this.preset_.contrastEnhancementMode == 1);
            this.jTcontrast2.setSelected(this.preset_.contrastEnhancementMode == 2);
            this.updateColorLabel();
            this.validate();
            this.revalidate();
        }
    }

    private void initUI() {
        this.addColorButton.setIcon(new ImageIcon(BottomControlPanel.class.getResource("add_color.png")));
        this.removeColorButton.setIcon(new ImageIcon(BottomControlPanel.class.getResource("remove_color.png")));
        this.colorLabel.setPreferredSize(new Dimension(20, 10));
        this.colorLabel.setMinimumSize(new Dimension(16, 10));
        this.colorLabel.setOpaque(true);
        this.attachButton.setIcon(new ImageIcon(BottomControlPanel.class.getResource("link_create.png")));
        this.detachButton.setIcon(new ImageIcon(BottomControlPanel.class.getResource("link_break.png")));
        this.linearColorToggle.setIcon(new ImageIcon(CNOoverlayPanel.class.getResource("smooth16.png")));
        this.nearestNeighborToggle.setIcon(new ImageIcon(CNOoverlayPanel.class.getResource("blocky16.png")));
        this.jBaddOpacity.setFocusPainted(false);
        this.jBaddOpacity.setIcon(new ImageIcon(AddRemovePanel.class.getResource("add16.png")));
        this.jBaddOpacity.setMargin(new Insets(0, 0, 0, 0));
        this.jBrmOpacity.setFocusPainted(false);
        this.jBrmOpacity.setIcon(new ImageIcon(AddRemovePanel.class.getResource("remove16.png")));
        this.jBrmOpacity.setMargin(new Insets(0, 0, 0, 0));
        Border rect = BorderFactory.createEtchedBorder();
        for (int i = 0; i < this.all.length; ++i) {
            this.all[i].setMargin(new Insets(0, 0, 0, 0));
            this.all[i].setBorder(rect);
            this.all[i].setMaximumSize(new Dimension(24, 24));
            this.all[i].setMinimumSize(new Dimension(24, 24));
            this.all[i].setFocusPainted(false);
        }
        this.addColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.addColorButton.setFocusPainted(false);
        this.removeColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeColorButton.setFocusPainted(false);
        this.setLayout(new BorderLayout());
        this.colorBar.add(this.addColorButton);
        this.colorBar.add(this.removeColorButton);
        this.colorBar.add(Box.createHorizontalGlue());
        this.colorBar.add(this.colorLabel);
        this.colorBar.add(Box.createHorizontalGlue());
        this.colorBar.add(this.attachButton);
        this.colorBar.add(this.detachButton);
        this.colorBar.add(this.jBaddOpacity);
        this.colorBar.add(this.jBrmOpacity);
        this.colorBar.add(Box.createHorizontalGlue());
        this.colorBar.add(this.linearColorToggle);
        this.colorBar.add(this.nearestNeighborToggle);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.linearColorToggle);
        bg.add(this.nearestNeighborToggle);
        bg = new ButtonGroup();
        bg.add(this.attachButton);
        bg.add(this.detachButton);
        this.colorLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jTcontrast0.setIcon(new ImageIcon(CNOoverlayPanel.class.getResource("Con_enhance_none.png")));
        this.jTcontrast0.setMargin(new Insets(0, 0, 0, 0));
        this.jTcontrast0.setSelected(true);
        this.jTcontrast1.setIcon(new ImageIcon(CNOoverlayPanel.class.getResource("Con_enhance_mild.png")));
        this.jTcontrast1.setMargin(new Insets(0, 0, 0, 0));
        this.jTcontrast2.setIcon(new ImageIcon(CNOoverlayPanel.class.getResource("Con_enhance_strong.png")));
        this.jTcontrast2.setMargin(new Insets(0, 0, 0, 0));
        this.jTcontrast0.setBorder(rect);
        this.jTcontrast1.setBorder(rect);
        this.jTcontrast2.setBorder(rect);
        this.jTcontrast0.setFocusPainted(false);
        this.jTcontrast1.setFocusPainted(false);
        this.jTcontrast2.setFocusPainted(false);
        bg = new ButtonGroup();
        bg.add(this.jTcontrast0);
        bg.add(this.jTcontrast1);
        bg.add(this.jTcontrast2);
        this.colorBar.add(this.jTcontrast0);
        this.colorBar.add(this.jTcontrast1);
        this.colorBar.add(this.jTcontrast2);
        this.colorBar.add(Box.createHorizontalGlue());
        this.colorBar.add(this.brightnessLabel);
        this.colorBar.add(this.brightnessSpinner);
        Dimension sz = this.brightnessSpinner.getPreferredSize();
        this.brightnessSpinner.setPreferredSize(new Dimension(60, sz.height));
        this.brightnessSpinner.setMaximumSize(new Dimension(60, sz.height));
        this.brightnessSpinner.setMinimumSize(new Dimension(60, sz.height));
        this.brightnessSpinner.setModel(new SpinnerNumberModel(100, 0, 700, 10));
        this.add((Component)this.colorBar, "North");
        this.updateAppearance();
        this.addColorButton.setToolTipText(Messages.getString("BottomControlPanel.addColor"));
        this.removeColorButton.setToolTipText(Messages.getString("BottomControlPanel.removeColor"));
        this.colorLabel.setToolTipText(Messages.getString("BottomControlPanel.selectedColor"));
        this.attachButton.setToolTipText(Messages.getString("BottomControlPanel.link"));
        this.detachButton.setToolTipText(Messages.getString("BottomControlPanel.unlink"));
        this.linearColorToggle.setToolTipText(Messages.getString("BottomControlPanel.bilinear"));
        this.nearestNeighborToggle.setToolTipText(Messages.getString("BottomControlPanel.nearestNeighbor"));
        this.brightnessLabel.setToolTipText(Messages.getString("BottomControlPanel.brightnessAdjustment"));
        this.brightnessSpinner.setToolTipText(Messages.getString("BottomControlPanel.brightnessAdjustment"));
        this.jTcontrast0.setToolTipText(Messages.getString("BottomControlPanel.noContrastEnh"));
        this.jTcontrast1.setToolTipText(Messages.getString("BottomControlPanel.mildContrastEnh"));
        this.jTcontrast2.setToolTipText(Messages.getString("BottomControlPanel.StrongConstrastEnh"));
    }

    public void setPreset(Preset p) {
        this.preset_ = p;
        p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("load".equals(e.getActionCommand())) {
                    System.out.println("reload...");
                    BottomControlPanel.this.updatePresets();
                } else if ("bwmode".equals(e.getActionCommand())) {
                    BottomControlPanel.this.updateAppearance();
                } else if ("opmode_changed".equals(e.getActionCommand())) {
                    BottomControlPanel.this.updateAppearance();
                } else if ("color_select".equals(e.getActionCommand())) {
                    BottomControlPanel.this.updateAppearance();
                } else if ("color_changed".equals(e.getActionCommand())) {
                    BottomControlPanel.this.updateColorLabel();
                } else if ("contrastEnhModeChanged".equals(e.getActionCommand())) {
                    BottomControlPanel.this.updateAppearance();
                }
            }
        });
        this.updatePresets();
        this.updateAppearance();
    }

    protected void updateColorLabel() {
        if (this.preset_ != null) {
            boolean colorSelected = this.preset_.rgbSelected >= 0;
            this.colorLabel.setBackground(colorSelected ? new Color(this.preset_.rgbValue[this.preset_.rgbSelected]) : null);
            this.colorLabel.setEnabled(colorSelected);
        }
    }
}

