/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import com.ge.med.terra.jami.j3d.vr.VrPreset;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class VrPresetCurves {
    public double[] opacity_table = new double[40960];
    public double[] intensity_table = new double[40960];
    public double[] lutrgb = new double[122880];
    public double[] colorEnhanceTable = null;
    public static final int COLOR_ENHANCE_TABLE_SIZE = 131072;
    public static final int TABLE_OFFSET = 8192;
    public static final int TABLE_SIZE = 32768;
    private static final int rangeMin = 0;
    private static final int rangeMax = 32768;
    private static final int internalVMin = 0;
    private static final int internalVMax = 32768;
    private VrPreset preset = null;
    private double preset_scale = 1.0;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private double ras_spx = 1.0;
    private double ras_spy = 1.0;

    public VrPresetCurves(VrPreset preset, double preset_scale, double rescaleSlope, double rescaleIntercept, double ras_spx, double ras_spy) {
        this.preset = preset;
        this.preset_scale = preset_scale;
        this.rescaleSlope = rescaleSlope;
        this.rescaleIntercept = rescaleIntercept;
        this.ras_spx = ras_spx;
        this.ras_spy = ras_spy;
        double thresh1 = (double)preset.thresh1 * preset_scale;
        double thresh2 = (double)preset.thresh2 * preset_scale;
        int rawthresh1 = VrPresetCurves.raw_value(thresh1, rescaleSlope, rescaleIntercept);
        int rawthresh2 = VrPresetCurves.raw_value(thresh2, rescaleSlope, rescaleIntercept);
        this.buildVxTables(rawthresh1, rawthresh2);
        this.colorEnhanceTable = new double[131073];
        double lightVal = 0.0;
        double delta = 7.629336324033172E-6;
        int i = 0;
        while (i < this.colorEnhanceTable.length) {
            this.colorEnhanceTable[i] = preset.attenuation * Math.pow(1.0 - lightVal, -0.5 - 0.5 * (preset.brightness - 1.0) / 6.0);
            ++i;
            lightVal += delta;
        }
    }

    public int[] createColorLut() {
        int[] cmap = new int[this.lutrgb.length / 3];
        for (int i = 0; i < cmap.length; ++i) {
            int a = (int)(this.opacity_table[i] * 255.0) & 0xFF;
            int r = (int)(this.lutrgb[3 * i] * 255.0);
            int g = (int)(this.lutrgb[3 * i + 1] * 255.0);
            int b = (int)(this.lutrgb[3 * i + 2] * 255.0);
            a = 1;
            cmap[i] = a << 24 | r << 16 | g << 8 | b;
        }
        return cmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePreset(String fileName) {
        FileOutputStream fos = null;
        PrintStream ps = null;
        try {
            fos = new FileOutputStream(fileName);
            ps = new PrintStream(fos);
            double thresh1 = (double)this.preset.thresh1 * this.preset_scale;
            double thresh2 = (double)this.preset.thresh2 * this.preset_scale;
            int rawthresh1 = VrPresetCurves.raw_value(thresh1, this.rescaleSlope, this.rescaleIntercept);
            int rawthresh2 = VrPresetCurves.raw_value(thresh2, this.rescaleSlope, this.rescaleIntercept);
            ps.println("" + this.preset.modality + " " + 8192 + " " + 32768 + " " + rawthresh1 + " " + rawthresh2);
            for (int i = 0; i < 40960; ++i) {
                ps.println("" + i + " " + this.opacity_table[i] + " " + this.intensity_table[i] + " " + this.lutrgb[3 * i] + " " + this.lutrgb[3 * i + 1] + " " + this.lutrgb[3 * i + 2]);
            }
            ps.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void buildVxTables(double thresh1, double thresh2) {
        int ctype = VrPresetCurves.vr_curvetype(this.preset.curvetype);
        int ltype = VrPresetCurves.vr_luttype(this.preset.luttype);
        int etype = VrPresetCurves.vr_enhancetype(this.preset.enhancetype);
        double max_opacity = this.preset.attenuation;
        double norm_factor = 1.0;
        double voxel_size = (this.ras_spx + this.ras_spy) * 0.5;
        if (this.preset.normalization) {
            norm_factor = 1.0 / voxel_size;
        }
        switch (ctype) {
            case 100: {
                VrPresetCurves.build_opacity_up(max_opacity, thresh1, thresh2, norm_factor, this.opacity_table);
                break;
            }
            case 101: {
                VrPresetCurves.build_opacity_up(max_opacity, 0.5 * (thresh1 + thresh2) - 0.001, 0.5 * (thresh1 + thresh2) + 0.001, norm_factor, this.opacity_table);
                break;
            }
            case 103: {
                VrPresetCurves.build_opacity_down(max_opacity, thresh1, thresh2, norm_factor, this.opacity_table);
                break;
            }
            case 102: {
                VrPresetCurves.build_opacity_bell(max_opacity, thresh1, thresh2, norm_factor, this.opacity_table);
                break;
            }
            case 104: {
                VrPresetCurves.build_opacity_reverse_bell(max_opacity, thresh1, thresh2, norm_factor, this.opacity_table);
                break;
            }
            case 105: {
                this.build_custom_opacity(this.preset.opacity_lut, this.preset.startOpacity, this.preset.deltaOpacity, this.opacity_table);
            }
        }
        VrPresetCurves.build_intensity(0, 32768, ctype, etype, thresh1, thresh2, this.intensity_table);
        if (ltype == 305) {
            this.build_colortable(this.preset.colorlut.colorlut, this.preset.colorlut.startX, this.preset.colorlut.deltaX);
        } else {
            this.build_colortable(ltype, this.preset.colors);
        }
    }

    private void build_custom_opacity(double[] modopacity, double startX, double delta, double[] table) {
        double slope = this.rescaleSlope;
        double intercept = this.rescaleIntercept;
        double rstart = VrPresetCurves.raw_value(startX * this.preset_scale, slope, intercept);
        double rdelta = (double)VrPresetCurves.raw_value(delta * this.preset_scale, slope, intercept) + intercept;
        for (int i = 0; i < table.length; ++i) {
            int rval = i - 8192;
            double idx = ((double)rval - rstart) / rdelta;
            table[i] = 0.0;
            if (idx >= 0.0 && idx < (double)(modopacity.length - 1)) {
                int intidx = (int)idx;
                double f = idx - (double)intidx;
                double v0 = modopacity[intidx];
                double v1 = modopacity[intidx + 1];
                table[i] = v0 + f * (v1 - v0);
                continue;
            }
            if (!(idx >= (double)modopacity.length)) continue;
            table[i] = modopacity[modopacity.length - 1];
        }
    }

    static void build_opacity_up(double max_opacity, double thresh0, double thresh1, double norm_factor, double[] table) {
        double a = 0.0;
        double t0 = Math.min(thresh0, (double)(table.length - 1 - 8192));
        double t1 = Math.min(thresh1, (double)(table.length - 1 - 8192));
        if (norm_factor != 1.0) {
            max_opacity = Math.pow(max_opacity, norm_factor);
        }
        double dx = max_opacity / (thresh1 - thresh0);
        int x = 0;
        while ((double)x < t0) {
            table[x + 8192] = 0.0;
            ++x;
        }
        if (norm_factor == 1.0) {
            while ((double)x < t1) {
                table[x + 8192] = a;
                ++x;
                a += dx;
            }
        } else {
            while ((double)x < t1) {
                table[x + 8192] = Math.pow(a, norm_factor);
                ++x;
                a += dx;
            }
        }
        while (x < 32768) {
            table[x + 8192] = max_opacity;
            ++x;
        }
    }

    static void build_opacity_down(double max_opacity, double thresh0, double thresh1, double norm_factor, double[] table) {
        double t0 = Math.min(thresh0, (double)(table.length - 1 - 8192));
        double t1 = Math.min(thresh1, (double)(table.length - 1 - 8192));
        if (norm_factor != 1.0) {
            max_opacity = Math.pow(max_opacity, norm_factor);
        }
        double a = max_opacity;
        double dx = -max_opacity / (thresh1 - thresh0);
        int x = 0;
        while ((double)x < t0) {
            table[x + 8192] = max_opacity;
            ++x;
        }
        if (norm_factor == 1.0) {
            while ((double)x < t1) {
                table[x + 8192] = a;
                ++x;
                a += dx;
            }
        } else {
            while ((double)x < t1) {
                table[x + 8192] = Math.pow(a, norm_factor);
                ++x;
                a += dx;
            }
        }
        while (x < 32768) {
            table[x + 8192] = 0.0;
            ++x;
        }
    }

    static void build_opacity_bell(double max_opacity, double thresh2, double thresh3, double norm_factor, double[] table) {
        double k = 0.75;
        double a = 0.0;
        double mid = 0.5 * (thresh2 + thresh3);
        double delta = k * (thresh3 - thresh2);
        if (norm_factor != 1.0) {
            max_opacity = Math.pow(max_opacity, norm_factor);
        }
        double b1 = mid - 0.5 * delta;
        double b2 = mid + 0.5 * delta;
        double dx = max_opacity / (b1 - thresh2);
        int x = 0;
        while ((double)x < thresh2) {
            table[x + 8192] = 0.0;
            ++x;
        }
        if (norm_factor == 1.0) {
            a = 0.0;
            while ((double)x < b1) {
                table[x + 8192] = a;
                ++x;
                a += dx;
            }
            while ((double)x < b2) {
                table[x + 8192] = max_opacity;
                ++x;
            }
            a = max_opacity;
            while ((double)x < thresh3) {
                table[x + 8192] = a;
                ++x;
                a -= dx;
            }
        } else {
            a = 0.0;
            while ((double)x < b1) {
                table[x + 8192] = Math.pow(a, norm_factor);
                ++x;
                a += dx;
            }
            while ((double)x < b2) {
                table[x + 8192] = max_opacity;
                ++x;
            }
            a = max_opacity;
            while ((double)x < thresh3) {
                table[x + 8192] = Math.pow(a, norm_factor);
                ++x;
                a -= dx;
            }
        }
        while (x < 32768) {
            table[x + 8192] = 0.0;
            ++x;
        }
    }

    static void build_opacity_reverse_bell(double max_opacity, double thresh2, double thresh3, double norm_factor, double[] table) {
        double k = 0.75;
        double a = 0.0;
        double mid = 0.5 * (thresh2 + thresh3);
        double delta = k * (thresh3 - thresh2);
        if (norm_factor != 1.0) {
            max_opacity = Math.pow(max_opacity, norm_factor);
        }
        double b1 = mid - 0.5 * delta;
        double b2 = mid + 0.5 * delta;
        double dx = max_opacity / (b1 - thresh2);
        int x = 0;
        while ((double)x < thresh2) {
            table[x + 8192] = max_opacity;
            ++x;
        }
        if (norm_factor == 1.0) {
            a = max_opacity;
            while ((double)x < b1) {
                table[x + 8192] = a;
                ++x;
                a -= dx;
            }
            while ((double)x < b2) {
                table[x + 8192] = 0.0;
                ++x;
            }
            a = 0.0;
            while ((double)x < thresh3) {
                table[x + 8192] = a;
                ++x;
                a += dx;
            }
        } else {
            a = max_opacity;
            while ((double)x < b1) {
                table[x + 8192] = Math.pow(a, norm_factor);
                ++x;
                a -= dx;
            }
            while ((double)x < b2) {
                table[x + 8192] = 0.0;
                ++x;
            }
            a = 0.0;
            while ((double)x < thresh3) {
                table[x + 8192] = Math.pow(a, norm_factor);
                ++x;
                a += dx;
            }
        }
        while (x < 32768) {
            table[x + 8192] = max_opacity;
            ++x;
        }
    }

    private static void build_intensity(int rangeMin, int rangeMax, int curveType, int enhanceType, double thresh2, double thresh3, double[] table) {
        int x;
        double ithresh2 = 0.0;
        double ithresh3 = 4095.0;
        double a = 0.0;
        switch (enhanceType) {
            case 201: {
                if (curveType != 103) {
                    ithresh2 = thresh2 < 50.0 ? 0.0 : thresh2 - 50.0;
                    ithresh3 = 4095.0;
                    break;
                }
                ithresh2 = 0.0;
                ithresh3 = thresh3 > 4045.0 ? 4095.0 : thresh3 + 50.0;
                break;
            }
            case 202: {
                ithresh2 = thresh2 < 50.0 ? 0.0 : thresh2 - 50.0;
                ithresh3 = thresh3 > 4045.0 ? 4095.0 : thresh3 + 50.0;
                break;
            }
            case 200: {
                ithresh2 = 0.0;
                ithresh3 = 4095.0;
                break;
            }
            case 203: {
                for (x = 0; x < 32768; ++x) {
                    table[x + 8192] = 4095.0;
                }
                break;
            }
        }
        double dx = 4095.0 / (ithresh3 - ithresh2);
        x = 0;
        while ((double)x < ithresh2) {
            table[x + 8192] = 0.0;
            ++x;
        }
        while ((double)x < ithresh3) {
            table[x + 8192] = a;
            ++x;
            a += dx;
        }
        while (x < 32768) {
            table[x + 8192] = 4095.0;
            ++x;
        }
    }

    public void build_colortable(double[] modrgblut, double startX, double delta) {
        double slope = this.rescaleSlope;
        double intercept = this.rescaleIntercept;
        double rstart = VrPresetCurves.raw_value(startX * this.preset_scale, slope, intercept);
        double rdelta = (double)VrPresetCurves.raw_value(delta * this.preset_scale, slope, intercept) + intercept;
        int ncolors = modrgblut.length / 3;
        int ti = 0;
        int i = 0;
        i = 0;
        for (ti = 0; ti < this.lutrgb.length; ti += 3) {
            int rval = i - 8192;
            double idx = ((double)rval - rstart) / rdelta;
            this.lutrgb[ti] = 0.0;
            this.lutrgb[ti + 1] = 0.0;
            this.lutrgb[ti + 2] = 0.0;
            if (idx >= 0.0 && idx < (double)(ncolors - 1)) {
                int intidx = (int)idx;
                double f = idx - (double)intidx;
                double r0 = modrgblut[intidx *= 3];
                double r1 = modrgblut[intidx + 3];
                double g0 = modrgblut[intidx + 1];
                double g1 = modrgblut[intidx + 4];
                double b0 = modrgblut[intidx + 2];
                double b1 = modrgblut[intidx + 5];
                this.lutrgb[ti] = r0 + f * (r1 - r0);
                this.lutrgb[ti + 1] = g0 + f * (g1 - g0);
                this.lutrgb[ti + 2] = b0 + f * (b1 - b0);
            } else if (idx >= (double)ncolors) {
                this.lutrgb[ti] = modrgblut[modrgblut.length - 3];
                this.lutrgb[ti + 1] = modrgblut[modrgblut.length - 2];
                this.lutrgb[ti + 2] = modrgblut[modrgblut.length - 1];
            }
            ++i;
        }
    }

    private void build_colortable(int lutType, List clist) {
        double slope = this.rescaleSlope;
        double intercept = this.rescaleIntercept;
        int len = clist.size();
        VrPreset.Color cfirst = (VrPreset.Color)clist.get(0);
        VrPreset.Color clast = (VrPreset.Color)clist.get(len - 1);
        double firstlevel = VrPresetCurves.raw_value(cfirst.level * this.preset_scale, slope, intercept);
        double lastlevel = VrPresetCurves.raw_value(clast.level * this.preset_scale, slope, intercept);
        switch (lutType) {
            case 301: {
                for (int i = 0; i < 32768; ++i) {
                    double r = 0.0;
                    double g = 0.0;
                    double b = 0.0;
                    boolean fill = false;
                    for (int j = 0; j < len - 1; ++j) {
                        VrPreset.Color c1 = (VrPreset.Color)clist.get(j);
                        VrPreset.Color c2 = (VrPreset.Color)clist.get(j + 1);
                        double level1 = VrPresetCurves.raw_value(c1.level * this.preset_scale, slope, intercept);
                        double level2 = VrPresetCurves.raw_value(c2.level * this.preset_scale, slope, intercept);
                        if (!((double)i >= level1) || !((double)i <= level2)) continue;
                        double k = ((double)i - level1) / (level2 - level1);
                        r = c1.red + k * (c2.red - c1.red);
                        g = c1.green + k * (c2.green - c1.green);
                        b = c1.blue + k * (c2.blue - c1.blue);
                        fill = true;
                        break;
                    }
                    if (!fill) {
                        if ((double)i <= firstlevel) {
                            r = cfirst.red;
                            g = cfirst.green;
                            b = cfirst.blue;
                        } else if ((double)i >= lastlevel) {
                            r = clast.red;
                            g = clast.green;
                            b = clast.blue;
                        }
                    }
                    int rgbidx = 3 * (i + 8192);
                    this.lutrgb[rgbidx] = r / 255.0;
                    this.lutrgb[rgbidx + 1] = g / 255.0;
                    this.lutrgb[rgbidx + 2] = b / 255.0;
                }
                break;
            }
            default: {
                System.out.println("*** Unrecognized lutType: " + lutType);
            }
        }
    }

    private static int raw_value(double modval, double slope, double intercept) {
        return (int)((modval - intercept) / slope);
    }

    public static int vr_enhancetype(String enhance_type) {
        String t = enhance_type.toUpperCase();
        if (t.equals("NONE")) {
            return 200;
        }
        return 200;
    }

    public static int vr_curvetype(String curve_type) {
        String t = curve_type.toUpperCase();
        if (t.equals("UP")) {
            return 100;
        }
        if (t.equals("DOWN")) {
            return 103;
        }
        if (t.equals("BELL")) {
            return 102;
        }
        if (t.equals("REVBELL")) {
            return 104;
        }
        return 105;
    }

    public static int vr_luttype(String lut_type) {
        String t = lut_type.toUpperCase();
        if (t.equals("RAMP")) {
            return 301;
        }
        if (t.equals("NEAREST")) {
            return 302;
        }
        if (t.equals("CUSTOM")) {
            return 305;
        }
        return 300;
    }
}

