/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.DemoUtils;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.capable.VrCapable;
import com.ge.med.terra.jami.j3d.J3DRenderEngine;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.VrApp_viewButton_actionAdapter;
import com.ge.med.terra.jami.j3d.vr.VrApp_vrpresetCB_actionAdapter;
import com.ge.med.terra.jami.j3d.vr.VrColorLut;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrHistogram;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrPresetsEditor;
import com.ge.med.terra.jami.seg.BinGrid;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VrApp
extends JPanel {
    private static final String ROOT = "presets";
    private static String[] presets = new String[]{"Standard", "Solid Air", "Solid Vessel", "Color VR1", "Color VR2", "Color VR3", "B/W Veins", "Grey Skull", "Pet", "Pet1"};
    private static String[] paths = new String[]{null, "presets/HEAD/solid_air.vrp", "presets/HEAD/solid_vessel.vrp", "presets/HEAD/clr_c_of_w_1.vrp", "presets/HEAD/clr_c_of_w_2.vrp", "presets/HEAD/clr_c_of_w_3.vrp", "presets/HEAD/bw_c_of_w.vrp", "presets/HEAD/bw_facial.vrp", "presets/ABDOMEN/pet.vrp", "presets/ABDOMEN/pet1.vrp"};
    private T3DViewport vp = new T3DViewport(new J3DRenderEngine());
    private VrPresetsEditor presetsEditor = new VrPresetsEditor();
    private Preset preset = new Preset();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel uiPanel = new JPanel();
    JPanel threshPanel = new JPanel();
    JButton viewButton = new JButton();
    JButton dupvolButton = new JButton("Dup Volume");
    JTextArea minTh = new JTextArea("0");
    JTextArea maxTh = new JTextArea("4095");
    JButton applyPresetButton = new JButton("Apply Preset");
    JButton threshButton = new JButton("Threshold");
    JButton cttableButton = new JButton("Remove Table");
    JButton resetthreshButton = new JButton("Reset Bingrid");
    JSlider zoomSlider = new JSlider(0, 0, 100, 15);
    JLabel zoomLabel = new JLabel("Zoom: ");
    JComboBox vrpresetCB = new JComboBox<String>(presets);
    JProgressBar vrprogressBar = new JProgressBar();
    private double baseHeight = -1.0;
    private boolean processUpdate = true;
    private String[] params = null;

    public VrApp() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public VrApp(String[] params) {
        this();
        int DIM = 600;
        this.vp.setPreferredSize(new Dimension(DIM, DIM));
        this.presetsEditor.setPreferredSize(new Dimension(300, DIM));
        this.presetsEditor.setBorder(BorderFactory.createBevelBorder(0));
        this.add((Component)this.vp, "Center");
        this.add((Component)this.presetsEditor, "West");
        this.presetsEditor.setPresets(this.preset);
        this.params = params;
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                double val = VrApp.this.zoomSlider.getValue();
                double zoom = 0.5 + val / (double)VrApp.this.zoomSlider.getMaximum() * 3.5;
                if (VrApp.this.baseHeight < 0.0) {
                    VrApp.this.baseHeight = VrApp.this.vp.getViewHeight();
                }
                VrApp.this.vp.setViewHeight(VrApp.this.baseHeight / zoom);
                VrApp.this.vp.repaint();
            }
        });
        this.threshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double intercept = 0.0;
                    double slope = 1.0;
                    BinGrid bg = null;
                    XjVolumeModel vm = VrApp.this.vp.getVolumeModel();
                    if (vm instanceof J3DVolumeModel) {
                        J3DVolumeModel j3dvm = (J3DVolumeModel)vm;
                        JVolume.LinearShort j_vol = (JVolume.LinearShort)j3dvm.j_vol;
                        intercept = j_vol.rescaleIntercept;
                        slope = j_vol.rescaleSlope;
                        slope = slope != 0.0 ? slope : 1.0;
                        bg = new BinGrid(j_vol.volume, j_vol.PAD, j_vol.dx, j_vol.dy, j_vol.dz);
                    }
                    int minv = Integer.parseInt(VrApp.this.minTh.getText());
                    int maxv = Integer.parseInt(VrApp.this.maxTh.getText());
                    System.out.println("thresholding: " + minv + " " + maxv);
                    J3DRenderEngine jre = (J3DRenderEngine)VrApp.this.vp.getT3DComponent().getT3DRenderEngine();
                    if (jre != null && bg != null) {
                        int minVS = (int)((double)minv / slope - intercept);
                        int maxVS = (int)((double)maxv / slope - intercept);
                        bg.threshold(minVS, maxVS);
                        byte[] th = bg.bingrid;
                        jre.applySegmentation(th);
                        VrApp.this.vp.repaint();
                    }
                }
                catch (NumberFormatException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.applyPresetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double deltax = ((VrApp)VrApp.this).preset.incr;
                double startx = ((VrApp)VrApp.this).preset.start;
                System.out.println("deltax=" + deltax);
                System.out.println("startx=" + startx);
                double[] opacity = VrApp.this.preset.fillOpacity();
                double[] clut = VrApp.this.preset.fillRGB();
                VrColorLut vrcl = new VrColorLut(clut, startx, deltax);
                VrPreset p = new VrPreset("CT", vrcl, opacity, startx, deltax);
                VrApp.this.vp.setProperty("PRESET_PROPERTY", p);
                VrApp.this.vp.repaint();
            }
        });
        this.cttableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread th = new Thread(){

                    @Override
                    public void run() {
                        J3DRenderEngine jre = (J3DRenderEngine)VrApp.this.vp.getT3DComponent().getT3DRenderEngine();
                        if (jre != null) {
                            J3DVolumeModel vol_model = (J3DVolumeModel)jre.getVolumeModel();
                            JVolume.LinearVolume vol = vol_model.j_vol;
                            short[] voldata = ((JVolume.LinearShort)vol).volume;
                            BinGrid bg = new BinGrid(voldata, vol.PAD, vol.dx, vol.dy, vol.dz);
                            BinGrid.SegAlgorithm sa = BinGrid.createSegAlgorithm("com.ge.med.jip.voxtool.CTTableRemoval");
                            if (sa != null) {
                                double[] ras_sp = new double[]{vol.ras_spx, vol.ras_spy, vol.ras_spz};
                                BinGrid ctt = sa.segment(bg, new Object[]{ras_sp}, new VRTL());
                                byte[] bgrid = ctt.bingrid;
                                jre.applySegmentation(bgrid);
                                VrApp.this.vp.repaint();
                            } else {
                                JOptionPane.showMessageDialog(VrApp.this.vp, "CT Table Removal algorithm not available", "Warning", 2);
                            }
                        }
                    }
                };
                th.start();
            }
        });
        this.resetthreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VrCapable vrc = (VrCapable)VrApp.this.vp.getCapable("com.ge.med.terra.jami.capable.VrCapable");
                if (vrc != null) {
                    vrc.clearSegmentation();
                    vrc.repaint();
                }
            }
        });
        this.dupvolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame frame = new JFrame("New View of Duplicate Volume");
                J3DVolumeModel vm = (J3DVolumeModel)VrApp.this.vp.getVolumeModel();
                J3DVolumeModel dupvm = (J3DVolumeModel)vm.dupvol();
                T3DViewport iv = new T3DViewport();
                iv.setPreferredSize(new Dimension(512, 512));
                JVolume.LinearShort jls = (JVolume.LinearShort)dupvm.j_vol;
                JVolume.LinearShort orig = (JVolume.LinearShort)vm.j_vol;
                for (int i = 0; i < jls.volume.length >> 1; ++i) {
                    jls.volume[jls.PAD + i] = orig.volume[orig.PAD + i];
                }
                iv.setVolumeModel(dupvm);
                frame.setLocation(100, 100);
                frame.setDefaultCloseOperation(3);
                frame.setContentPane(iv);
                frame.pack();
                frame.setVisible(true);
            }
        });
        this.vp.setRenderStyle("VOLUME");
    }

    public void enableUI(boolean b) {
        this.applyPresetButton.setEnabled(b);
        this.vrpresetCB.setEnabled(b);
        this.viewButton.setEnabled(b);
        this.zoomSlider.setEnabled(b);
        this.threshPanel.setEnabled(b);
        this.dupvolButton.setEnabled(b);
        this.minTh.setEnabled(b);
        this.maxTh.setEnabled(b);
        this.threshButton.setEnabled(b);
        this.resetthreshButton.setEnabled(b);
        this.cttableButton.setEnabled(b);
    }

    public void init() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                XjVolumeModel vm;
                VrApp.this.enableUI(false);
                int[] dim = new int[3];
                VrApp.this.vp.addTaskMonitor(new VRTL());
                DMVolume vol = null;
                if (VrApp.this.params != null) {
                    DMSession dms = new DMSession(VrApp.this.params);
                    DMObject[] dmo = dms.getRelated("series");
                    vol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[0]});
                    vol.getVolumeDimensions(dim);
                    VrApp.this.vp.setVolume(vol);
                }
                if ((vm = VrApp.this.vp.getVolumeModel()) instanceof J3DVolumeModel) {
                    JVolume.LinearVolume jvol = ((J3DVolumeModel)vm).j_vol;
                    VrHistogram h = new VrHistogram(0, 4095, jvol.rescaleSlope, jvol.rescaleIntercept);
                    if (jvol instanceof JVolume.LinearShort) {
                        short[] vox = ((JVolume.LinearShort)jvol).volume;
                        for (int pix = jvol.PAD; pix < jvol.PAD + jvol.dx * jvol.dy * jvol.dz; ++pix) {
                            h.incrementRaw(vox[pix]);
                        }
                    } else {
                        byte[] vox = ((JVolume.LinearByte)jvol).volume;
                        for (int pix = jvol.PAD; pix < jvol.PAD + jvol.dx * jvol.dy * jvol.dz; ++pix) {
                            h.incrementRaw(vox[pix] & 0xFF);
                        }
                    }
                    VrApp.this.vp.putClientProperty("HIST_PROPERTY", h);
                    VrApp.this.presetsEditor.setHistogram(h);
                }
                VrApp.this.enableUI(true);
                VrApp.this.vrprogressBar.setValue(0);
                VrApp.this.repaint();
            }
        };
        new Thread(r).start();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("T3D Java Volume Renderer");
        String[] params = null;
        params = args.length > 0 ? new String[]{"file", args[0]} : new String[]{"file", DemoUtils.demoChooseDirectory("VrApp")};
        VrApp sid = new VrApp(params);
        frame.setLocation(32, 32);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(sid);
        frame.pack();
        frame.setVisible(true);
        sid.init();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.viewButton.setText("New View");
        this.viewButton.addActionListener(new VrApp_viewButton_actionAdapter(this));
        this.vrpresetCB.addActionListener(new VrApp_vrpresetCB_actionAdapter(this));
        this.vrprogressBar.setPreferredSize(new Dimension(70, 25));
        this.zoomSlider.setPreferredSize(new Dimension(75, 25));
        JPanel bigPanel = new JPanel();
        bigPanel.setLayout(new BorderLayout());
        this.uiPanel.setMinimumSize(new Dimension(269, 95));
        this.uiPanel.add(this.applyPresetButton);
        this.uiPanel.add(this.zoomLabel);
        this.uiPanel.add((Component)this.zoomSlider, null);
        this.uiPanel.add((Component)this.viewButton, null);
        this.uiPanel.add((Component)this.dupvolButton, null);
        this.uiPanel.add((Component)this.vrprogressBar, null);
        this.threshPanel.setPreferredSize(new Dimension(260, 45));
        this.threshPanel.setBorder(new EtchedBorder());
        this.add((Component)bigPanel, "South");
        this.uiPanel.add((Component)this.vrpresetCB, null);
        bigPanel.add((Component)this.uiPanel, "Center");
        bigPanel.add((Component)this.threshPanel, "South");
        this.minTh.setPreferredSize(new Dimension(40, 20));
        this.maxTh.setPreferredSize(new Dimension(40, 20));
        this.threshPanel.add(new JLabel("  Min: "));
        this.threshPanel.add(this.minTh);
        this.threshPanel.add(new JLabel("  Max: "));
        this.threshPanel.add(this.maxTh);
        this.threshPanel.add(new JLabel("      "));
        this.threshPanel.add(this.threshButton);
        this.threshPanel.add(this.cttableButton);
        this.threshPanel.add(this.resetthreshButton);
    }

    void viewButton_actionPerformed(ActionEvent e) {
        JFrame frame = new JFrame("New View");
        J3DVolumeModel vm = (J3DVolumeModel)this.vp.getVolumeModel();
        T3DViewport iv = new T3DViewport();
        iv.setPreferredSize(new Dimension(512, 512));
        iv.setVolumeModel((XjVolumeModel)vm.clone());
        frame.setLocation(100, 100);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(iv);
        frame.pack();
        frame.setVisible(true);
    }

    void vrpresetCB_actionPerformed(ActionEvent e) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                VrApp.this.enableUI(false);
                int idx = VrApp.this.vrpresetCB.getSelectedIndex();
                System.out.println("Load: " + paths[idx]);
                try {
                    VrPreset vrp = null;
                    if (paths[idx] != null) {
                        InputStream is = VrApp.class.getResourceAsStream(paths[idx]);
                        vrp = new VrPreset(is);
                    } else {
                        vrp = new VrPreset();
                    }
                    VrCapable vrc = (VrCapable)VrApp.this.vp.getCapable("com.ge.med.terra.jami.capable.VrCapable");
                    if (vrc != null) {
                        vrc.setPreset(vrp);
                        vrc.repaint();
                    }
                }
                catch (FileNotFoundException ex) {
                    System.err.println("Cannot find file: " + paths[idx]);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                VrApp.this.enableUI(true);
            }
        };
        new Thread(r).start();
    }

    private class VRTL
    implements TaskMonitor {
        private VRTL() {
        }

        @Override
        public void taskBegin(String taskName, int totalWork) {
            if (VrApp.this.processUpdate) {
                VrApp.this.vrprogressBar.setMinimum(0);
                VrApp.this.vrprogressBar.setMaximum(totalWork - 1);
                VrApp.this.vrprogressBar.setValue(0);
            }
        }

        @Override
        public void taskDone(String taskName) {
            if (VrApp.this.processUpdate) {
                VrApp.this.vrprogressBar.setValue(VrApp.this.vrprogressBar.getMaximum());
            }
        }

        @Override
        public void taskProgress(String taskName, int units) {
            if (VrApp.this.processUpdate) {
                VrApp.this.vrprogressBar.setValue(units);
                VrApp.this.vrprogressBar.repaint();
            }
        }

        @Override
        public void taskFailed(String taskName, String reason, Exception e) {
        }
    }
}

