/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Preset {
    public double[] opacityPos = new double[]{103.0, 603.0};
    public double[] opacityBefore = new double[]{0.0, 1.0};
    public double[] opacityAfter = new double[]{0.0, 1.0};
    public int opacityMode = 1;
    public boolean blackwhitemode = false;
    public int contrastEnhancementMode = 0;
    public boolean enhanceContours = true;
    public int transparency = 10;
    public double[] rgbPos = null;
    public double[] rgbStepPosRatio = null;
    public double[] opacityAtColor = null;
    public int[] rgbValue = null;
    public boolean rgbNNeighbour = false;
    public double brightness = 1.0;
    public double start = -4096.0;
    public double incr = 1.0;
    public int rgbSelected = -1;
    public int opacitySelected = -1;
    public static final String RGBMODE_CHANGED = "rgbmode_changed";
    public static final String OPMODE_CHANGED = "opmode_changed";
    public static final int OPMODE_FREE = 0;
    public static final int OPMODE_RAMP_UP = 1;
    public static final int OPMODE_RAMP_DOWN = 2;
    public static final int OPMODE_HUMP_UP = 3;
    public static final int OPMODE_HUMP_DOWN = 4;
    public static final int OPMODE_EDGE = 5;
    public static final int OPMODE_ATTACH = 6;
    public static final int CONTRAST_ENH_MODE_NONE = 0;
    public static final int CONTRAST_ENH_MODE_MILD = 1;
    public static final int CONTRAST_ENH_MODE_STRONG = 2;
    public static final String COLOR_BW_MODE_CHANGED = "bwmode";
    public static final String CONTRAST_ENH_MODE_CHANGED = "contrastEnhModeChanged";
    public static final String BRIGHTNESS_CHANGED = "brightness";
    public static final String RELOAD = "load";
    public static final double RAMP_RANGE = 0.2;
    BufferedImage icon;
    String iconPath;
    String name;
    String category;
    Date lastUsed;
    public static final String POSTFIX = ".vrpreset";
    public static final String COLOR_SELECT = "color_select";
    public static final String TRANSPARENCY_CHANGED = "transparency";
    public static final String ENHANCE_CONTOURS = "enhanceContours";
    public static final String COLOR_CHANGED = "color_changed";
    public static final String PAINT_CACHE_PROPERTY = "paintCache";
    public static final String PAINT_CACHE_NOALPHA_PROPERTY = "paintCacheNoAlpha";
    transient Vector actionListeners = new Vector();
    Hashtable props = new Hashtable();
    public static final String CNO_CLIENT_PROPERTY = "CNO_PROPERTY";
    public static final String HISTOGRAM_CLIENT_PROPERTY = "HIST_PROPERTY";

    public Preset() {
        this.rgbPos = new double[5];
        this.rgbValue = new int[5];
        this.rgbStepPosRatio = new double[4];
        this.rgbValue[0] = new Color(255, 150, 127).getRGB();
        this.rgbPos[0] = -179.0;
        this.rgbValue[1] = new Color(169, 255, 250).getRGB();
        this.rgbPos[1] = 121.0;
        this.rgbValue[2] = new Color(255, 78, 80).getRGB();
        this.rgbPos[2] = 146.0;
        this.rgbValue[3] = new Color(255, 201, 113).getRGB();
        this.rgbPos[3] = 221.0;
        this.rgbValue[4] = new Color(255, 254, 243).getRGB();
        this.rgbPos[4] = 452.0;
        this.rgbNNeighbour = false;
        for (int i = 0; i < this.rgbStepPosRatio.length; ++i) {
            this.rgbStepPosRatio[i] = 0.5;
        }
    }

    public void print() {
        int i;
        if (this.blackwhitemode) {
            System.out.println("black and white");
        }
        if (this.rgbNNeighbour) {
            System.out.println("rgbNNeighbour mode");
        }
        System.out.println("opacityMode" + this.opacityMode);
        for (i = 0; i < this.rgbValue.length; ++i) {
            System.out.print("rgb[" + i + "] " + this.rgbPos[i] + " ");
            String hex = "000000" + Integer.toHexString(this.rgbValue[i]);
            System.out.println("0x" + hex.substring(hex.length() - 6));
        }
        if (this.opacityAtColor != null) {
            for (i = 0; i < this.opacityAtColor.length; ++i) {
                System.out.println("OpacityAtColor[" + i + "] = " + this.opacityAtColor[i]);
            }
        } else {
            System.out.println("opacityAtColor = null");
        }
        for (i = 0; i < this.opacityPos.length; ++i) {
            System.out.println("opacity[" + i + "]=" + this.opacityPos[i] + " " + this.opacityBefore[i] + "  " + this.opacityAfter[i]);
        }
    }

    public Preset(String fileName) throws FileNotFoundException, IOException {
        this.load(fileName);
    }

    public void load(Preset p) {
        this.opacityPos = Preset.dup(p.opacityPos);
        this.opacityBefore = Preset.dup(p.opacityBefore);
        this.opacityAfter = Preset.dup(p.opacityAfter);
        this.opacityMode = p.opacityMode;
        this.blackwhitemode = p.blackwhitemode;
        this.enhanceContours = p.enhanceContours;
        this.transparency = p.transparency;
        this.contrastEnhancementMode = p.contrastEnhancementMode;
        this.rgbPos = Preset.dup(p.rgbPos);
        this.rgbValue = Preset.dup(p.rgbValue);
        this.opacityAtColor = Preset.dup(p.opacityAtColor);
        this.rgbNNeighbour = p.rgbNNeighbour;
        this.brightness = p.brightness;
        this.putProperty(PAINT_CACHE_PROPERTY, null);
        this.fireActionPerformed(new ActionEvent(this, 0, BRIGHTNESS_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, COLOR_BW_MODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, OPMODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, CONTRAST_ENH_MODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, RELOAD));
    }

    public Object clone() {
        Preset p = new Preset();
        p.load(this);
        return p;
    }

    public Preset(InputStream stream) {
        this.load(stream);
    }

    public void load(String fileName) throws FileNotFoundException, IOException {
        File f = new File(fileName);
        if (f.exists()) {
            FileInputStream istream = new FileInputStream(fileName);
            this.load(istream);
            ((InputStream)istream).close();
        } else if (!fileName.endsWith(POSTFIX)) {
            this.load(fileName + POSTFIX);
        }
    }

    public void load(InputStream stream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            Element elem = doc.getDocumentElement();
            this.name = elem.getAttribute("name");
            this.iconPath = elem.getAttribute("icon");
            this.lastUsed = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").parse(elem.getAttribute("date"));
            for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
                String[] v;
                String s;
                if ("opacity".equalsIgnoreCase(n.getNodeName())) {
                    Node nnm = n.getAttributes().getNamedItem("opacityMode");
                    this.opacityMode = 1;
                    if (nnm != null) {
                        this.opacityMode = Integer.parseInt(nnm.getNodeValue());
                    }
                    String s2 = n.getFirstChild().getNodeValue().trim();
                    String[] v2 = s2.split("\\s+");
                    this.opacityPos = new double[v2.length / 3];
                    this.opacityBefore = new double[v2.length / 3];
                    this.opacityAfter = new double[v2.length / 3];
                    for (int i = 0; i < v2.length / 3; ++i) {
                        this.opacityPos[i] = Double.parseDouble(v2[i * 3]);
                        this.opacityBefore[i] = Double.parseDouble(v2[i * 3 + 1]);
                        this.opacityAfter[i] = Double.parseDouble(v2[i * 3 + 2]);
                        System.out.println("opacityAfter[" + i + "]=" + this.opacityAfter[i]);
                    }
                }
                if ("RGB".equalsIgnoreCase(n.getNodeName())) {
                    this.blackwhitemode = Preset.getAttribute(n, "blackwhitemode", this.blackwhitemode);
                    this.rgbNNeighbour = Preset.getAttribute(n, "rgbNNeighbour", this.rgbNNeighbour);
                    this.brightness = Preset.getAttribute(n, BRIGHTNESS_CHANGED, this.brightness);
                    s = n.getFirstChild().getNodeValue().trim();
                    v = s.split("\\s+");
                    this.rgbPos = new double[v.length / 2];
                    this.rgbValue = new int[v.length / 2];
                    for (int i = 0; i < v.length / 2; ++i) {
                        this.rgbPos[i] = Double.parseDouble(v[i * 2]);
                        this.rgbValue[i] = Integer.decode(v[i * 2 + 1]);
                    }
                }
                if (!"AttachedObjects".equalsIgnoreCase(n.getNodeName())) continue;
                s = n.getFirstChild().getNodeValue().trim();
                v = s.split("\\s+");
                this.opacityAtColor = new double[v.length];
                for (int i = 0; i < this.opacityAtColor.length; ++i) {
                    this.opacityAtColor[i] = Double.parseDouble(v[i]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.putProperty(PAINT_CACHE_PROPERTY, null);
        this.fireActionPerformed(new ActionEvent(this, 0, BRIGHTNESS_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, COLOR_BW_MODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, OPMODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, RELOAD));
    }

    private static boolean getAttribute(Node n, String name, boolean b) {
        Node nnm = n.getAttributes().getNamedItem(name);
        if (nnm != null) {
            return "true".equalsIgnoreCase(nnm.getNodeValue());
        }
        return b;
    }

    private static double getAttribute(Node n, String name, double def) {
        Node nnm = n.getAttributes().getNamedItem(name);
        if (nnm != null) {
            return Double.parseDouble(nnm.getNodeValue());
        }
        return def;
    }

    private static int getAttribute(Node n, String name, int def) {
        Node nnm = n.getAttributes().getNamedItem(name);
        if (nnm != null) {
            return Integer.parseInt(nnm.getNodeValue());
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printFile(String fileName) {
        System.out.println("=========================== " + fileName + "======================");
        FileReader fr = null;
        BufferedReader lr = null;
        try {
            String st;
            fr = new FileReader(fileName);
            lr = new LineNumberReader(fr);
            while ((st = ((LineNumberReader)lr).readLine()) != null) {
                System.out.println(st);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (lr != null) {
                    lr.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("=========================== " + fileName + "======================\n");
        System.out.flush();
        System.err.flush();
    }

    public static void main(String[] args) {
        Preset p = new Preset();
        p.save("default", "c:\\def");
        System.out.println("saved\n\n");
        Preset.printFile("c:\\def.vrpreset");
        try {
            Preset p2 = new Preset("c:\\def");
            System.out.println("loaded\n\n");
            System.out.flush();
            Thread.sleep(100L);
            p2.save("default", "c:\\def2");
            Preset.printFile("c:\\def2.vrpreset");
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String name, String fileName) {
        String iconStr = "";
        if (fileName.endsWith(POSTFIX)) {
            fileName = fileName.substring(0, fileName.length() - POSTFIX.length());
        }
        if (this.icon != null) {
            iconStr = " icon=\"" + fileName + ".icon\"";
        }
        OutputStreamWriter fw = null;
        PrintWriter pw = null;
        try {
            int i;
            fw = new FileWriter(fileName + POSTFIX);
            pw = new PrintWriter(fw);
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            pw.println("<VRPresets name=\"" + name + "\"" + iconStr + " date=\"" + new Date() + "\">");
            pw.println("  <opacity   opacityMode=\"" + this.opacityMode + "\">");
            for (i = 0; i < this.opacityPos.length; ++i) {
                pw.println("    " + this.opacityPos[i] + " " + this.opacityBefore[i] + " " + this.opacityAfter[i]);
            }
            pw.println("  </opacity>");
            pw.println("  <RGB blackwhitemode=\"" + this.blackwhitemode + "\" contrastEnhancementMode=\"" + this.contrastEnhancementMode + "\" rgbNNeighbour=\"" + this.rgbNNeighbour + "\" brightness=\"" + this.brightness + "\">");
            for (i = 0; i < this.rgbPos.length; ++i) {
                String s = Integer.toHexString(this.rgbValue[i] & 0xFFFFFF);
                String out = "00000000".substring(s.length()) + s;
                pw.println("    " + this.rgbPos[i] + " 0x" + out);
            }
            pw.println("  </RGB>");
            if (this.opacityMode == 6 && !this.blackwhitemode) {
                pw.println("  <AttachedObjects>");
                for (i = 0; i < this.opacityAtColor.length; ++i) {
                    pw.println("    " + this.opacityAtColor[i]);
                }
                pw.println("  </AttachedObjects>");
            }
            pw.println("</VRPresets>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println("done saving..." + fileName + POSTFIX);
    }

    public String getXMLelement() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("<VRPresets name=\"" + this.name + "\">\n");
        buf.append("  <opacity   opacityMode=\"" + this.opacityMode + "\">\n");
        for (i = 0; i < this.opacityPos.length; ++i) {
            buf.append("    " + this.opacityPos[i] + " " + this.opacityBefore[i] + " " + this.opacityAfter[i] + "\n");
        }
        buf.append("  </opacity>\n");
        buf.append("  <RGB blackwhitemode=\"" + this.blackwhitemode + "\" contrastEnhancementMode=\"" + this.contrastEnhancementMode + "\" rgbNNeighbour=\"" + this.rgbNNeighbour + "\" brightness=\"" + this.brightness + "\">\n");
        for (i = 0; i < this.rgbPos.length; ++i) {
            String s = Integer.toHexString(this.rgbValue[i] & 0xFFFFFF);
            String out = "00000000".substring(s.length()) + s;
            buf.append("    " + this.rgbPos[i] + " 0x" + out + "\n");
        }
        buf.append("  </RGB>\n");
        if (this.opacityMode == 6 && !this.blackwhitemode) {
            buf.append("  <AttachedObjects>\n");
            for (i = 0; i < this.opacityAtColor.length; ++i) {
                buf.append("    " + this.opacityAtColor[i] + "\n");
            }
            buf.append("  </AttachedObjects>\n");
        }
        buf.append("</VRPresets>");
        return buf.toString();
    }

    public double[] fillRGB() {
        if (this.blackwhitemode) {
            double[] rgb = new double[196608];
            double br = 1.0 + (this.brightness - 1.0) / 10.0;
            Arrays.fill(rgb, br);
            return rgb;
        }
        if (this.rgbNNeighbour) {
            return this.fillRGBNNeighbour();
        }
        return this.fillRGBlinear();
    }

    double[] fillRGBNNeighbour() {
        double d;
        double[] rgb = new double[196608];
        int k = 0;
        int r0 = this.rgbValue[0] & 0xFF;
        int g0 = this.rgbValue[0] >> 8 & 0xFF;
        int b0 = this.rgbValue[0] >> 16 & 0xFF;
        double scale = (1.0 + (this.brightness - 1.0) / 10.0) / 255.0;
        for (d = this.start; d < this.rgbPos[0]; d += this.incr) {
            rgb[k * 3 + 0] = (double)b0 * scale;
            rgb[k * 3 + 1] = (double)g0 * scale;
            rgb[k * 3 + 2] = (double)r0 * scale;
            ++k;
        }
        for (int i = 1; i < this.rgbPos.length; ++i) {
            int r1 = this.rgbValue[i] & 0xFF;
            int g1 = this.rgbValue[i] >> 8 & 0xFF;
            int b1 = this.rgbValue[i] >> 16 & 0xFF;
            while (d < this.rgbPos[i]) {
                double t1 = (d - this.rgbPos[i - 1]) / (this.rgbPos[i] - this.rgbPos[i - 1]);
                if (t1 > 0.5) {
                    rgb[k * 3 + 0] = (double)b1 * scale;
                    rgb[k * 3 + 1] = (double)g1 * scale;
                    rgb[k * 3 + 2] = (double)r1 * scale;
                } else {
                    rgb[k * 3 + 0] = (double)b0 * scale;
                    rgb[k * 3 + 1] = (double)g0 * scale;
                    rgb[k * 3 + 2] = (double)r0 * scale;
                }
                ++k;
                d += this.incr;
            }
            r0 = r1;
            g0 = g1;
            b0 = b1;
        }
        while (k < rgb.length / 3) {
            rgb[k * 3 + 0] = (double)b0 * scale;
            rgb[k * 3 + 1] = (double)g0 * scale;
            rgb[k * 3 + 2] = (double)r0 * scale;
            ++k;
        }
        return rgb;
    }

    double[] fillRGBlinear() {
        double d;
        double[] rgb = new double[196608];
        int k = 0;
        int r0 = this.rgbValue[0] & 0xFF;
        int g0 = this.rgbValue[0] >> 8 & 0xFF;
        int b0 = this.rgbValue[0] >> 16 & 0xFF;
        double scale = (1.0 + (this.brightness - 1.0) / 10.0) / 255.0;
        for (d = this.start; d < this.rgbPos[0]; d += this.incr) {
            rgb[k * 3 + 0] = (double)b0 * scale;
            rgb[k * 3 + 1] = (double)g0 * scale;
            rgb[k * 3 + 2] = (double)r0 * scale;
            ++k;
        }
        for (int i = 1; i < this.rgbPos.length; ++i) {
            int r1 = this.rgbValue[i] & 0xFF;
            int g1 = this.rgbValue[i] >> 8 & 0xFF;
            int b1 = this.rgbValue[i] >> 16 & 0xFF;
            while (d < this.rgbPos[i]) {
                double t1 = (d - this.rgbPos[i - 1]) / (this.rgbPos[i] - this.rgbPos[i - 1]);
                double t0 = (1.0 - t1) * scale;
                rgb[k * 3 + 0] = (double)b0 * t0 + (double)b1 * (t1 *= scale);
                rgb[k * 3 + 1] = (double)g0 * t0 + (double)g1 * t1;
                rgb[k * 3 + 2] = (double)r0 * t0 + (double)r1 * t1;
                ++k;
                d += this.incr;
            }
            r0 = r1;
            g0 = g1;
            b0 = b1;
        }
        while (k < rgb.length / 3) {
            rgb[k * 3 + 0] = (double)b0 * scale;
            rgb[k * 3 + 1] = (double)g0 * scale;
            rgb[k * 3 + 2] = (double)r0 * scale;
            ++k;
        }
        return rgb;
    }

    public double[] fillOpacity() {
        double d;
        double[] opacityTab = new double[65536];
        int k = 0;
        for (d = this.start; d < this.opacityPos[0]; d += this.incr) {
            opacityTab[k++] = this.opacityBefore[0];
        }
        for (int i = 1; i < this.opacityPos.length; ++i) {
            double op0 = this.opacityAfter[i - 1];
            double op1 = this.opacityBefore[i];
            while (d < this.opacityPos[i]) {
                double t1 = (d - this.opacityPos[i - 1]) / (this.opacityPos[i] - this.opacityPos[i - 1]);
                double t0 = 1.0 - t1;
                opacityTab[k++] = op0 * t0 + op1 * t1;
                d += this.incr;
            }
        }
        double op0 = this.opacityAfter[this.opacityAfter.length - 1];
        while (k < opacityTab.length) {
            opacityTab[k] = op0;
            ++k;
        }
        return opacityTab;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    public void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    public void setRGBnn(boolean b) {
        this.rgbNNeighbour = b;
        this.fireActionPerformed(new ActionEvent(this, 0, RGBMODE_CHANGED));
    }

    public void setBrightness(double b) {
        this.brightness = b;
        this.fireActionPerformed(new ActionEvent(this, 0, BRIGHTNESS_CHANGED));
    }

    public void setBlackWhite(boolean bw) {
        this.blackwhitemode = bw;
        this.putProperty(PAINT_CACHE_PROPERTY, null);
        this.fireActionPerformed(new ActionEvent(this, 0, COLOR_BW_MODE_CHANGED));
    }

    public void setContrastEnhancementMode(int mode) {
        if (mode != this.contrastEnhancementMode) {
            this.contrastEnhancementMode = mode;
            this.fireActionPerformed(new ActionEvent(this, 0, CONTRAST_ENH_MODE_CHANGED));
        }
    }

    public void setOpacityMode(int mode) {
        boolean changed = mode != this.opacityMode;
        this.opacityMode = mode;
        double max = this.opacityAfter.length == 1 ? Math.max(this.opacityAfter[0], this.opacityAfter[0]) : Math.max(this.opacityAfter[0], this.opacityAfter[1]);
        switch (mode) {
            case 0: 
            case 6: {
                break;
            }
            case 4: {
                if (!changed) break;
                this.opacityAfter = Preset.realloc(this.opacityAfter, 4);
                this.opacityBefore = Preset.realloc(this.opacityBefore, 4);
                this.opacityPos = Preset.realloc(this.opacityPos, 4);
                this.opacityAfter[0] = this.opacityBefore[0] = max;
                this.opacityBefore[1] = 0.0;
                this.opacityAfter[1] = 0.0;
                this.opacityBefore[2] = 0.0;
                this.opacityAfter[2] = 0.0;
                this.opacityAfter[3] = this.opacityBefore[3] = max;
                this.opacityPos[2] = this.opacityPos[1] + (this.opacityPos[1] - this.opacityPos[0]);
                this.opacityPos[3] = this.opacityPos[2] + (this.opacityPos[1] - this.opacityPos[0]);
                break;
            }
            case 3: {
                if (changed) {
                    this.opacityAfter = Preset.realloc(this.opacityAfter, 4);
                    this.opacityBefore = Preset.realloc(this.opacityBefore, 4);
                    this.opacityPos = Preset.realloc(this.opacityPos, 4);
                    this.opacityBefore[0] = 0.0;
                    this.opacityAfter[0] = 0.0;
                    this.opacityAfter[1] = this.opacityBefore[1] = max;
                    this.opacityAfter[2] = this.opacityBefore[2] = max;
                    this.opacityBefore[3] = 0.0;
                    this.opacityAfter[3] = 0.0;
                    this.opacityPos[2] = this.opacityPos[1] + (this.opacityPos[1] - this.opacityPos[0]);
                    this.opacityPos[3] = this.opacityPos[2] + (this.opacityPos[1] - this.opacityPos[0]);
                    break;
                }
                this.opacityBefore[0] = 0.0;
                this.opacityAfter[0] = 0.0;
                this.opacityAfter[1] = this.opacityBefore[1] = max;
                this.opacityAfter[2] = this.opacityBefore[2] = max;
                this.opacityBefore[3] = 0.0;
                this.opacityAfter[3] = 0.0;
                if (this.opacityPos[1] == 0.0) {
                    this.opacityPos[1] = this.opacityPos[0] + 30.0;
                }
                this.opacityPos[2] = this.opacityPos[1] + (this.opacityPos[1] - this.opacityPos[0]);
                this.opacityPos[3] = this.opacityPos[2] + (this.opacityPos[1] - this.opacityPos[0]);
                break;
            }
            case 2: {
                this.opacityAfter = Preset.realloc(this.opacityAfter, 2);
                this.opacityBefore = Preset.realloc(this.opacityBefore, 2);
                this.opacityPos = Preset.realloc(this.opacityPos, 2);
                this.opacityAfter[0] = this.opacityBefore[0] = max;
                this.opacityBefore[1] = 0.0;
                this.opacityAfter[1] = 0.0;
                if (this.opacityPos[1] != 0.0) break;
                this.opacityPos[1] = this.opacityPos[0] + 30.0;
                break;
            }
            case 1: {
                this.opacityAfter = Preset.realloc(this.opacityAfter, 2);
                this.opacityBefore = Preset.realloc(this.opacityBefore, 2);
                this.opacityPos = Preset.realloc(this.opacityPos, 2);
                this.opacityAfter[1] = this.opacityBefore[1] = max;
                this.opacityBefore[0] = 0.0;
                this.opacityAfter[0] = 0.0;
                if (this.opacityPos[1] != 0.0) break;
                this.opacityPos[1] = this.opacityPos[0] + 30.0;
                break;
            }
            case 5: {
                this.opacityAfter = Preset.realloc(this.opacityAfter, 1);
                this.opacityBefore = Preset.realloc(this.opacityBefore, 1);
                this.opacityPos = Preset.realloc(this.opacityPos, 1);
                this.opacityAfter[0] = max;
                this.opacityBefore[0] = 0.0;
            }
        }
        if (this.opacityMode != 6) {
            this.opacityAtColor = null;
        } else {
            this.opacityAtColor = new double[this.rgbPos.length];
            Arrays.fill(this.opacityAtColor, -1.0);
        }
        this.fireActionPerformed(new ActionEvent(this, 0, OPMODE_CHANGED));
    }

    public int getOpacityMode() {
        return this.opacityMode;
    }

    public void removeSelectedOpacity() {
        if (this.opacitySelected == -1) {
            return;
        }
        if (this.opacityMode != 0) {
            return;
        }
        double[] nPos = new double[this.opacityPos.length - 1];
        double[] nBef = new double[this.opacityBefore.length - 1];
        double[] nAft = new double[this.opacityAfter.length - 1];
        int off = 0;
        for (int i = 0; i < nPos.length; ++i) {
            if (i == this.opacitySelected) {
                ++off;
            }
            nPos[i] = this.opacityPos[i + off];
            nBef[i] = this.opacityBefore[i + off];
            nAft[i] = this.opacityAfter[i + off];
        }
        if (this.opacitySelected == nPos.length) {
            --this.opacitySelected;
        }
        this.opacityPos = nPos;
        this.opacityBefore = nBef;
        this.opacityAfter = nAft;
    }

    public void addNewOpacity(double v) {
        if (this.opacityMode != 0) {
            return;
        }
        this.opacityPos = Preset.realloc(this.opacityPos, this.opacityPos.length + 1);
        this.opacityBefore = Preset.realloc(this.opacityBefore, this.opacityBefore.length + 1);
        this.opacityAfter = Preset.realloc(this.opacityAfter, this.opacityAfter.length + 1);
        this.opacityAfter[this.opacityPos.length - 1] = 0.5;
        this.opacityBefore[this.opacityPos.length - 1] = 0.5;
        this.opacityPos[this.opacityPos.length - 1] = v;
        this.opacitySelected = this.opacityPos.length - 1;
        this.sortOpacity();
    }

    public void sortOpacity() {
        boolean swap = false;
        do {
            swap = false;
            for (int i = 1; i < this.opacityPos.length; ++i) {
                if (!(this.opacityPos[i - 1] > this.opacityPos[i])) continue;
                swap = true;
                double tPos = this.opacityPos[i - 1];
                double tBefore = this.opacityBefore[i - 1];
                double tAfter = this.opacityAfter[i - 1];
                this.opacityPos[i - 1] = this.opacityPos[i];
                this.opacityBefore[i - 1] = this.opacityBefore[i];
                this.opacityAfter[i - 1] = this.opacityAfter[i];
                this.opacityPos[i] = tPos;
                this.opacityBefore[i] = tBefore;
                this.opacityAfter[i] = tAfter;
                if (this.opacitySelected == i) {
                    this.opacitySelected = i - 1;
                    continue;
                }
                if (this.opacitySelected != i - 1) continue;
                this.opacitySelected = i;
            }
        } while (swap);
    }

    public void removeSelectedColor() {
        int i;
        double[] nPos = new double[this.rgbPos.length - 1];
        int[] nVal = new int[this.rgbValue.length - 1];
        double[] nRatio = new double[this.rgbStepPosRatio.length - 1];
        double[] nOpacityAtColor = null;
        if (this.opacityMode == 6) {
            nOpacityAtColor = new double[this.opacityAtColor.length - 1];
        }
        int off = 0;
        for (i = 0; i < nVal.length; ++i) {
            if (i == this.rgbSelected) {
                ++off;
            }
            nPos[i] = this.rgbPos[i + off];
            nVal[i] = this.rgbValue[i + off];
            if (this.opacityMode != 6) continue;
            nOpacityAtColor[i] = this.opacityAtColor[i + off];
        }
        if (nRatio.length > 0) {
            for (i = 0; i < this.rgbSelected - 1; ++i) {
                nRatio[i] = this.rgbStepPosRatio[i];
            }
            if (this.rgbSelected > 0 && this.rgbSelected < this.rgbPos.length - 1) {
                nRatio[this.rgbSelected - 1] = 0.5;
            }
            for (i = this.rgbSelected; i < nRatio.length; ++i) {
                nRatio[i] = this.rgbStepPosRatio[i + 1];
            }
        }
        if (this.rgbSelected == nVal.length) {
            --this.rgbSelected;
        }
        this.rgbPos = nPos;
        this.rgbValue = nVal;
        this.rgbStepPosRatio = nRatio;
        if (this.opacityMode == 6) {
            this.opacityAtColor = nOpacityAtColor;
            this.updateOpacityPts();
        }
        this.fireActionPerformed(new ActionEvent(this, 0, COLOR_SELECT));
    }

    public void addNewColor(double v) {
        this.addNewColor(v, 0xFFFFFF);
    }

    public void addNewColor(double v, int rgb) {
        int i;
        int insertIndex = -1;
        for (int i2 = 0; i2 < this.rgbPos.length; ++i2) {
            if (!(v < this.rgbPos[i2])) continue;
            insertIndex = i2;
            break;
        }
        if (insertIndex == -1) {
            insertIndex = this.rgbPos.length;
        }
        double[] nPos = new double[this.rgbPos.length + 1];
        int[] nVal = new int[this.rgbPos.length + 1];
        double[] nRatio = new double[this.rgbStepPosRatio.length + 1];
        for (i = 0; i < insertIndex; ++i) {
            nPos[i] = this.rgbPos[i];
            nVal[i] = this.rgbValue[i];
        }
        nPos[insertIndex] = v;
        nVal[insertIndex] = rgb;
        for (i = insertIndex + 1; i < nPos.length; ++i) {
            nPos[i] = this.rgbPos[i - 1];
            nVal[i] = this.rgbValue[i - 1];
        }
        for (i = 0; i < insertIndex - 1; ++i) {
            nRatio[i] = this.rgbStepPosRatio[i];
        }
        if (insertIndex > 0) {
            nRatio[insertIndex - 1] = 0.5;
        }
        if (insertIndex < nRatio.length) {
            nRatio[insertIndex] = 0.5;
        }
        for (i = insertIndex + 1; i < nRatio.length; ++i) {
            nRatio[i] = this.rgbStepPosRatio[i - 1];
        }
        if (this.opacityMode == 6) {
            double[] nOAC = new double[this.rgbPos.length + 1];
            if (this.opacityAtColor != null) {
                int i3;
                for (i3 = 0; i3 < insertIndex; ++i3) {
                    nOAC[i3] = this.opacityAtColor[i3];
                }
                nOAC[insertIndex] = -1.0;
                for (i3 = insertIndex + 1; i3 < nPos.length; ++i3) {
                    nOAC[i3] = this.opacityAtColor[i3 - 1];
                }
            } else {
                Arrays.fill(nOAC, -1.0);
            }
            this.opacityAtColor = nOAC;
        }
        this.rgbSelected = insertIndex;
        this.rgbPos = nPos;
        this.rgbValue = nVal;
        this.rgbStepPosRatio = nRatio;
        this.updateOpacityPts();
        this.fireActionPerformed(new ActionEvent(this, 0, COLOR_SELECT));
    }

    public void sortColor() {
        boolean cont;
        if (this.rgbPos.length < 2) {
            return;
        }
        boolean sorted = true;
        for (int i = 0; i < this.rgbPos.length - 1; ++i) {
            if (!(this.rgbPos[i] > this.rgbPos[i + 1])) continue;
            sorted = false;
            break;
        }
        if (sorted) {
            return;
        }
        double position = this.rgbPos[this.rgbSelected];
        int color = this.rgbValue[this.rgbSelected];
        if (this.rgbSelected > 0) {
            this.rgbStepPosRatio[this.rgbSelected - 1] = 0.5;
        }
        if (this.rgbSelected < this.rgbPos.length - 1) {
            this.rgbStepPosRatio[this.rgbSelected] = 0.5;
        }
        do {
            cont = false;
            for (int i = 1; i < this.rgbPos.length; ++i) {
                if (!(this.rgbPos[i - 1] > this.rgbPos[i])) continue;
                double tmpPos = this.rgbPos[i - 1];
                int tmpVal = this.rgbValue[i - 1];
                this.rgbPos[i - 1] = this.rgbPos[i];
                this.rgbValue[i - 1] = this.rgbValue[i];
                this.rgbPos[i] = tmpPos;
                this.rgbValue[i] = tmpVal;
                if (this.opacityAtColor != null) {
                    double tmpOp = this.opacityAtColor[i - 1];
                    this.opacityAtColor[i - 1] = this.opacityAtColor[i];
                    this.opacityAtColor[i] = tmpOp;
                }
                if (this.rgbSelected == i) {
                    this.rgbSelected = i - 1;
                } else if (this.rgbSelected == i - 1) {
                    this.rgbSelected = i;
                }
                cont = true;
            }
        } while (cont);
        if (this.rgbSelected > 0) {
            this.rgbStepPosRatio[this.rgbSelected - 1] = 0.5;
        }
        if (this.rgbSelected < this.rgbPos.length - 1) {
            this.rgbStepPosRatio[this.rgbSelected] = 0.5;
        }
    }

    protected static int[] realloc(int[] src, int len) {
        if (src == null) {
            return new int[len];
        }
        if (src.length == len) {
            return src;
        }
        int[] ret = new int[len];
        System.arraycopy(src, 0, ret, 0, Math.min(len, src.length));
        return ret;
    }

    protected static float[] realloc(float[] src, int len) {
        if (src == null) {
            return new float[len];
        }
        if (src.length == len) {
            return src;
        }
        float[] ret = new float[len];
        System.arraycopy(src, 0, ret, 0, Math.min(len, src.length));
        return ret;
    }

    protected static double[] realloc(double[] src, int len) {
        if (src == null) {
            return new double[len];
        }
        if (src.length == len) {
            return src;
        }
        double[] ret = new double[len];
        System.arraycopy(src, 0, ret, 0, Math.min(len, src.length));
        return ret;
    }

    private static int[] dup(int[] src) {
        if (src == null) {
            return null;
        }
        int[] ret = new int[src.length];
        System.arraycopy(src, 0, ret, 0, src.length);
        return ret;
    }

    private static float[] dup(float[] src) {
        if (src == null) {
            return null;
        }
        float[] ret = new float[src.length];
        System.arraycopy(src, 0, ret, 0, src.length);
        return ret;
    }

    private static double[] dup(double[] src) {
        if (src == null) {
            return null;
        }
        double[] ret = new double[src.length];
        System.arraycopy(src, 0, ret, 0, src.length);
        return ret;
    }

    public double getDelta() {
        return this.incr;
    }

    public double getStartX() {
        return this.start;
    }

    public void setStartX(double nStart) {
        this.start = nStart;
    }

    public String getName() {
        return this.name;
    }

    public void load(Element elem) {
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if ("opacity".equalsIgnoreCase(n.getNodeName())) {
                Node nnm = n.getAttributes().getNamedItem("opacityMode");
                this.opacityMode = 1;
                if (nnm != null) {
                    this.opacityMode = Integer.parseInt(nnm.getNodeValue());
                }
                String s = n.getFirstChild().getNodeValue().trim();
                String[] v = s.split("\\s+");
                this.opacityPos = new double[v.length / 3];
                this.opacityBefore = new double[v.length / 3];
                this.opacityAfter = new double[v.length / 3];
                for (int i = 0; i < v.length / 3; ++i) {
                    this.opacityPos[i] = Double.parseDouble(v[i * 3]);
                    this.opacityBefore[i] = Double.parseDouble(v[i * 3 + 1]);
                    this.opacityAfter[i] = Double.parseDouble(v[i * 3 + 2]);
                    System.out.println("opacityAfter[" + i + "]=" + this.opacityAfter[i]);
                }
            }
            if (!"RGB".equalsIgnoreCase(n.getNodeName())) continue;
            this.blackwhitemode = Preset.getAttribute(n, "blackwhitemode", this.blackwhitemode);
            this.contrastEnhancementMode = Preset.getAttribute(n, "contrastEnhancementMode", 0);
            this.rgbNNeighbour = Preset.getAttribute(n, "rgbNNeighbour", this.rgbNNeighbour);
            this.brightness = Preset.getAttribute(n, BRIGHTNESS_CHANGED, this.brightness);
            String s = n.getFirstChild().getNodeValue().trim();
            String[] v = s.split("\\s+");
            this.rgbPos = new double[v.length / 2];
            this.rgbValue = new int[v.length / 2];
            for (int i = 0; i < v.length / 2; ++i) {
                this.rgbPos[i] = Double.parseDouble(v[i * 2]);
                this.rgbValue[i] = Integer.decode(v[i * 2 + 1]);
            }
        }
        this.putProperty(PAINT_CACHE_PROPERTY, null);
        this.fireActionPerformed(new ActionEvent(this, 0, BRIGHTNESS_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, COLOR_BW_MODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, OPMODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, RELOAD));
    }

    public void attachObjectAt(int pos) {
        if (this.opacityMode == 6) {
            if (this.opacityAtColor == null) {
                this.opacityAtColor = new double[this.rgbPos.length];
                Arrays.fill(this.opacityAtColor, -1.0);
            }
            this.opacityAtColor[pos] = 1.0;
            this.updateOpacityPts();
        }
    }

    public void detachObjectAt(int pos) {
        if (this.opacityMode == 6) {
            this.opacityAtColor[pos] = -1.0;
            this.updateOpacityPts();
        }
    }

    public void updateOpacityPts() {
        if (this.opacityMode == 6 && this.opacityAtColor != null) {
            int numPts = 0;
            for (int i = 0; i < this.opacityAtColor.length; ++i) {
                if (!(this.opacityAtColor[i] >= 0.0)) continue;
                ++numPts;
            }
            if (numPts > 0) {
                this.opacityBefore = Preset.realloc(this.opacityBefore, numPts * 5);
                this.opacityAfter = Preset.realloc(this.opacityAfter, numPts * 5);
                this.opacityPos = Preset.realloc(this.opacityPos, numPts * 5);
                int humpIndex = 0;
                for (int i = 0; i < this.opacityAtColor.length; ++i) {
                    double dist;
                    if (this.opacityAtColor[i] < 0.0) continue;
                    if (i == 0) {
                        this.opacityBefore[0] = this.opacityAtColor[i];
                        this.opacityAfter[0] = this.opacityAtColor[i];
                        this.opacityPos[0] = this.rgbPos[i] - 10.0;
                        this.opacityBefore[1] = this.opacityAtColor[i];
                        this.opacityAfter[1] = this.opacityAtColor[i];
                        this.opacityPos[1] = this.rgbPos[i] - 5.0;
                    } else {
                        dist = this.rgbPos[i] - this.rgbPos[i - 1];
                        if (this.opacityAtColor[i - 1] < 0.0) {
                            this.opacityBefore[humpIndex * 5] = 0.0;
                            this.opacityAfter[humpIndex * 5] = 0.0;
                            this.opacityPos[humpIndex * 5] = this.rgbPos[i - 1] + dist * 0.8 * 0.5;
                        } else {
                            this.opacityBefore[humpIndex * 5] = (this.opacityAtColor[i] + this.opacityAtColor[i - 1]) * 0.5;
                            this.opacityAfter[humpIndex * 5] = this.opacityBefore[humpIndex * 5];
                            this.opacityPos[humpIndex * 5] = this.rgbPos[i - 1] + dist * 0.5 + 0.01;
                        }
                        this.opacityBefore[humpIndex * 5 + 1] = this.opacityAtColor[i];
                        this.opacityAfter[humpIndex * 5 + 1] = this.opacityAtColor[i];
                        this.opacityPos[humpIndex * 5 + 1] = this.rgbPos[i - 1] + dist * 1.2 * 0.5;
                    }
                    this.opacityBefore[humpIndex * 5 + 2] = this.opacityAtColor[i];
                    this.opacityAfter[humpIndex * 5 + 2] = this.opacityAtColor[i];
                    this.opacityPos[humpIndex * 5 + 2] = this.rgbPos[i];
                    if (i != this.opacityAtColor.length - 1) {
                        dist = this.rgbPos[i + 1] - this.rgbPos[i];
                        this.opacityBefore[humpIndex * 5 + 3] = this.opacityAtColor[i];
                        this.opacityAfter[humpIndex * 5 + 3] = this.opacityAtColor[i];
                        this.opacityPos[humpIndex * 5 + 3] = this.rgbPos[i] + dist * 0.8 * 0.5;
                        if (this.opacityAtColor[i + 1] < 0.0) {
                            this.opacityBefore[humpIndex * 5 + 4] = 0.0;
                            this.opacityAfter[humpIndex * 5 + 4] = 0.0;
                            this.opacityPos[humpIndex * 5 + 4] = this.rgbPos[i] + dist * 1.2 * 0.5;
                        } else {
                            this.opacityBefore[humpIndex * 5 + 4] = (this.opacityAtColor[i] + this.opacityAtColor[i + 1]) * 0.5;
                            this.opacityAfter[humpIndex * 5 + 4] = this.opacityBefore[humpIndex * 5 + 4];
                            this.opacityPos[humpIndex * 5 + 4] = this.rgbPos[i] + dist * 0.5;
                        }
                    } else {
                        this.opacityBefore[humpIndex * 5 + 3] = this.opacityAtColor[i];
                        this.opacityAfter[humpIndex * 5 + 3] = this.opacityAtColor[i];
                        this.opacityPos[humpIndex * 5 + 3] = this.rgbPos[i] + 5.0;
                        this.opacityBefore[humpIndex * 5 + 4] = this.opacityAtColor[i];
                        this.opacityAfter[humpIndex * 5 + 4] = this.opacityAtColor[i];
                        this.opacityPos[humpIndex * 5 + 4] = this.rgbPos[i] + 10.0;
                    }
                    ++humpIndex;
                }
            } else {
                this.opacityBefore = Preset.realloc(this.opacityBefore, 2);
                this.opacityAfter = Preset.realloc(this.opacityAfter, 2);
                this.opacityPos = Preset.realloc(this.opacityPos, 2);
                Arrays.fill(this.opacityBefore, 0.0);
                Arrays.fill(this.opacityAfter, 0.0);
                this.opacityPos[0] = 0.0;
                this.opacityPos[1] = 1.0;
            }
        }
    }

    public void setRGBselected(int temp) {
        if (temp != this.rgbSelected) {
            this.rgbSelected = temp;
            this.fireActionPerformed(new ActionEvent(this, 0, COLOR_SELECT));
        }
    }

    public void setTransparency(int num) {
        if (num != this.transparency) {
            this.transparency = num;
            this.fireActionPerformed(new ActionEvent(this, 0, TRANSPARENCY_CHANGED));
        }
    }

    public void setEnhanceContours(boolean b) {
        if (this.enhanceContours != b) {
            this.enhanceContours = b;
            this.fireActionPerformed(new ActionEvent(this, 0, ENHANCE_CONTOURS));
        }
    }

    public void putProperty(Object key, Object value) {
        if (value == null) {
            this.props.remove(key);
        } else {
            this.props.put(key, value);
        }
    }

    public Object getProperty(Object key) {
        return this.props.get(key);
    }
}

