/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.surface;

import javax.swing.JPanel;

public class TriangleRasterizer
extends JPanel {
    public static final float AMBIENT_LIGHT = 0.2f;
    public static final float DIRECTIONAL_LIGHT = 0.8f;

    public static void triangle2(float[] zbuff, int iw, int ih, int v1, int v2, int v3, float[][] xyz) {
        int b;
        int a;
        int s;
        float[] vx = xyz[0];
        float[] vy = xyz[1];
        float[] vz = xyz[2];
        float dz_dx = 0.0f;
        float dz_dy = 0.0f;
        float zoff = 0.0f;
        int[] v = new int[]{v1, v2, v3};
        for (s = 0; s < 3; ++s) {
            a = s;
            b = (s + 1) % 3;
            if (vx[v[a]] == vx[v[b]]) continue;
            dz_dx = (vz[v[b]] - vz[v[a]]) / (vx[v[b]] - vx[v[a]]);
            break;
        }
        for (s = 0; s < 3; ++s) {
            a = s;
            b = (s + 1) % 3;
            if (vy[v[a]] == vy[v[b]]) continue;
            dz_dy = (vz[v[b]] - vz[v[a]]) / (vy[v[b]] - vy[v[a]]);
            break;
        }
        zoff = vz[v1] - dz_dx * vx[v1] - dz_dy * vy[v1];
        float y1 = xyz[1][v1];
        float y2 = xyz[1][v2];
        float y3 = xyz[1][v3];
        float x1 = xyz[0][v1];
        float x2 = xyz[0][v2];
        float x3 = xyz[0][v3];
        int minx = (int)Math.min(x1, Math.min(x2, x3));
        int maxx = (int)Math.max(x1, Math.max(x2, x3));
        int miny = (int)Math.min(y1, Math.min(y2, y3));
        int maxy = (int)Math.max(y1, Math.max(y2, y3));
        int p = miny * iw;
        for (int y = miny; y < maxy; ++y) {
            for (int x = minx; x < maxx; ++x) {
                float zb;
                if (!((x1 - x2) * ((float)y - y1) - (y1 - y2) * ((float)x - x1) > 0.0f) || !((x2 - x3) * ((float)y - y2) - (y2 - y3) * ((float)x - x2) > 0.0f) || !((x3 - x1) * ((float)y - y3) - (y3 - y1) * ((float)x - x3) > 0.0f) || !(zbuff[p + x] > (zb = zoff + (float)x * dz_dx + (float)y + dz_dy))) continue;
                zbuff[p + x] = zb;
            }
            p += iw;
        }
    }

    public static void triangle(float[] zbuff, int iw, int ih, int v1, int v2, int v3, float[][] xyz) {
        float[] vx = xyz[0];
        float[] vy = xyz[1];
        float[] vz = xyz[2];
        float x1 = vx[v1];
        float x2 = vx[v2];
        float x3 = vx[v3];
        float y1 = vy[v1];
        float y2 = vy[v2];
        float y3 = vy[v3];
        float z1 = vz[v1];
        float z2 = vz[v2];
        float z3 = vz[v3];
        TriangleRasterizer.triangle(zbuff, iw, ih, 0, 0, iw, ih, x1, y1, z1, x2, y2, z2, x3, y3, z3);
    }

    public static void triangleGouraud(float[] zbuff, float[] normBuff, int iw, int ih, int x0, int y0, int w, int h, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float normx1, float normy1, float normz1, float normx2, float normy2, float normz2, float normx3, float normy3, float normz3) {
        float dom = x1 * (y3 - y2) - x2 * y3 + x3 * y2 + (x2 - x3) * y1;
        if (dom == 0.0f) {
            return;
        }
        float normx = (normx1 + normx2 + normx3) / 3.0f;
        float normy = (normy1 + normy2 + normy3) / 3.0f;
        float normz = (normz1 + normz2 + normz3) / 3.0f;
        float dz_dx = -(y1 * (z3 - z2) - y2 * z3 + y3 * z2 + (y2 - y3) * z1) / dom;
        float dz_dy = (x1 * (z3 - z2) - x2 * z3 + x3 * z2 + (x2 - x3) * z1) / dom;
        float zoff = (x1 * (y3 * z2 - y2 * z3) + y1 * (x2 * z3 - x3 * z2) + (x3 * y2 - x2 * y3) * z1) / dom;
        int Y1 = Math.round(16.0f * y1);
        int Y2 = Math.round(16.0f * y2);
        int Y3 = Math.round(16.0f * y3);
        int X1 = Math.round(16.0f * x1);
        int X2 = Math.round(16.0f * x2);
        int X3 = Math.round(16.0f * x3);
        int DX12 = X1 - X2;
        int DX23 = X2 - X3;
        int DX31 = X3 - X1;
        int DY12 = Y1 - Y2;
        int DY23 = Y2 - Y3;
        int DY31 = Y3 - Y1;
        int FDX12 = DX12 << 4;
        int FDX23 = DX23 << 4;
        int FDX31 = DX31 << 4;
        int FDY12 = DY12 << 4;
        int FDY23 = DY23 << 4;
        int FDY31 = DY31 << 4;
        int minx = Math.min(X1, Math.min(X2, X3)) + 15 >> 4;
        int maxx = Math.max(X1, Math.max(X2, X3)) + 15 >> 4;
        int miny = Math.min(Y1, Math.min(Y2, Y3)) + 15 >> 4;
        int maxy = Math.max(Y1, Math.max(Y2, Y3)) + 15 >> 4;
        if (minx < x0) {
            minx = x0;
        }
        if (maxx > iw) {
            maxx = iw;
        }
        if (miny < 0) {
            miny = 0;
        }
        if (maxy > ih) {
            maxy = ih;
        }
        int p = miny * iw;
        int C1 = DY12 * X1 - DX12 * Y1;
        int C2 = DY23 * X2 - DX23 * Y2;
        int C3 = DY31 * X3 - DX31 * Y3;
        if (DY12 < 0 || DY12 == 0 && DX12 > 0) {
            ++C1;
        }
        if (DY23 < 0 || DY23 == 0 && DX23 > 0) {
            ++C2;
        }
        if (DY31 < 0 || DY31 == 0 && DX31 > 0) {
            ++C3;
        }
        int CY1 = C1 + DX12 * (miny << 4) - DY12 * (minx << 4);
        int CY2 = C2 + DX23 * (miny << 4) - DY23 * (minx << 4);
        int CY3 = C3 + DX31 * (miny << 4) - DY31 * (minx << 4);
        for (int y = miny; y < maxy; ++y) {
            int CX1 = CY1;
            int CX2 = CY2;
            int CX3 = CY3;
            for (int x = minx; x < maxx; ++x) {
                float zb;
                if (CX1 > 0 && CX2 > 0 && CX3 > 0 && zbuff[p + x] > (zb = zoff + (float)x * dz_dx + (float)y * dz_dy)) {
                    zbuff[p + x] = zb;
                    normBuff[(p + x) * 3] = normx;
                    normBuff[(p + x) * 3 + 1] = normy;
                    normBuff[(p + x) * 3 + 2] = normz;
                }
                CX1 -= FDY12;
                CX2 -= FDY23;
                CX3 -= FDY31;
            }
            CY1 += FDX12;
            CY2 += FDX23;
            CY3 += FDX31;
            p += iw;
        }
    }

    public static void triangle(float[] zbuff, int bufw, int bufh, int x0, int y0, int w, int h, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        float dom = x1 * (y3 - y2) - x2 * y3 + x3 * y2 + (x2 - x3) * y1;
        if (dom == 0.0f) {
            return;
        }
        float dz_dx = -(y1 * (z3 - z2) - y2 * z3 + y3 * z2 + (y2 - y3) * z1) / dom;
        float dz_dy = (x1 * (z3 - z2) - x2 * z3 + x3 * z2 + (x2 - x3) * z1) / dom;
        float zoff = (x1 * (y3 * z2 - y2 * z3) + y1 * (x2 * z3 - x3 * z2) + (x3 * y2 - x2 * y3) * z1) / dom;
        int Y1 = Math.round(16.0f * y1);
        int Y2 = Math.round(16.0f * y2);
        int Y3 = Math.round(16.0f * y3);
        int X1 = Math.round(16.0f * x1);
        int X2 = Math.round(16.0f * x2);
        int X3 = Math.round(16.0f * x3);
        int DX12 = X1 - X2;
        int DX23 = X2 - X3;
        int DX31 = X3 - X1;
        int DY12 = Y1 - Y2;
        int DY23 = Y2 - Y3;
        int DY31 = Y3 - Y1;
        int FDX12 = DX12 << 4;
        int FDX23 = DX23 << 4;
        int FDX31 = DX31 << 4;
        int FDY12 = DY12 << 4;
        int FDY23 = DY23 << 4;
        int FDY31 = DY31 << 4;
        int minx = Math.min(X1, Math.min(X2, X3)) + 15 >> 4;
        int maxx = Math.max(X1, Math.max(X2, X3)) + 15 >> 4;
        int miny = Math.min(Y1, Math.min(Y2, Y3)) + 15 >> 4;
        int maxy = Math.max(Y1, Math.max(Y2, Y3)) + 15 >> 4;
        if (minx < x0) {
            minx = x0;
        }
        if (maxx > x0 + w) {
            maxx = x0 + w;
        }
        if (miny < y0) {
            miny = y0;
        }
        if (maxy > y0 + h) {
            maxy = y0 + h;
        }
        int C1 = DY12 * X1 - DX12 * Y1;
        int C2 = DY23 * X2 - DX23 * Y2;
        int C3 = DY31 * X3 - DX31 * Y3;
        if (DY12 < 0 || DY12 == 0 && DX12 > 0) {
            ++C1;
        }
        if (DY23 < 0 || DY23 == 0 && DX23 > 0) {
            ++C2;
        }
        if (DY31 < 0 || DY31 == 0 && DX31 > 0) {
            ++C3;
        }
        int CY1 = C1 + DX12 * (miny << 4) - DY12 * (minx << 4);
        int CY2 = C2 + DX23 * (miny << 4) - DY23 * (minx << 4);
        int CY3 = C3 + DX31 * (miny << 4) - DY31 * (minx << 4);
        int y = miny;
        int p = miny * bufw;
        while (y < maxy) {
            int CX1 = CY1;
            int CX2 = CY2;
            int CX3 = CY3;
            for (int x = minx; x < maxx; ++x) {
                float zb;
                if (CX1 > 0 && CX2 > 0 && CX3 > 0 && zbuff[p + x] > (zb = zoff + (float)x * dz_dx + (float)y * dz_dy)) {
                    zbuff[p + x] = zb;
                }
                CX1 -= FDY12;
                CX2 -= FDY23;
                CX3 -= FDY31;
            }
            CY1 += FDX12;
            CY2 += FDX23;
            CY3 += FDX31;
            ++y;
            p += bufw;
        }
    }
}

