/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.remote;

import com.ge.med.idc.RemoteVolume;
import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.XjVolume;
import com.ge.med.terra.jami.CodecUtils;
import com.ge.med.terra.jami.j3d.Commons3D;
import com.ge.med.terra.jami.j3d.remote.Rm3DClientServerIF;
import com.ge.med.terra.jami.j3d.remote.RmServer3DEngine;
import com.ge.med.terra.jami.j3d.vr.VrColorLut;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.jami.remote.RmCommand;
import com.ge.med.terra.jami.remote.RmServerDataManager;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Rm3DDispatcher
implements Rm3DClientServerIF {
    private RemoteCaller caller = null;
    private RmServer3DEngine server_engine = null;
    private byte[] initRender_args = new byte[1];
    private byte[] suppRStyles_args = new byte[1];
    private byte[] suppMpass_args = new byte[1];
    private byte[] clearBuffers_args = new byte[1];
    private byte[] suppCodec_args = new byte[1];
    private byte[] rendering_args = new byte[10];
    private byte[] setbg_args = new byte[9];
    private byte[] setOutput_args = new byte[9];
    private byte[] clearPixels_args = new byte[25];
    private byte[] setPerspective_args = new byte[2];
    private byte[] setCamera_args = new byte[73];
    private byte[] setLookPt_args = new byte[25];
    private byte[] setEyePt_args = new byte[25];
    private byte[] setUp_args = new byte[25];
    private byte[] setViewClip_args = new byte[17];
    private byte[] setViewHeight_args = new byte[9];
    private byte[] getDepthStep_args = new byte[9];
    private byte[] getRASCoords_args = new byte[9];
    private byte[] getVolumeCoords_args = new byte[9];
    private byte[] getValue_args = new byte[9];
    private Object[] server_args = new Object[10];
    private byte[] outbuffer = new byte[4096];

    public Rm3DDispatcher(RemoteCaller c) {
        this.caller = c;
    }

    public int createEngine(String rengine) {
        T3DRenderEngine engine = Commons3D.createRenderEngine(rengine);
        if (engine != null) {
            this.server_engine = new RmServer3DEngine(engine);
            return this.server_engine.getServer3DEngineId();
        }
        throw new RuntimeException("Invalid RenderEngine class name: " + rengine);
    }

    public Object remoteCommand(RmCommand rmc) {
        byte cmdId = rmc.getCommandId();
        Object[] args = rmc.getArgs();
        byte[] data = null;
        int data_offset = 0;
        int data_len = 0;
        switch (cmdId) {
            case 5: {
                int renderOutputLayer = (Integer)args[0];
                int passno = (Integer)args[1];
                byte renderType = (Byte)args[2];
                CodecUtils.putInt(this.rendering_args, 1, renderOutputLayer);
                CodecUtils.putInt(this.rendering_args, 5, passno);
                this.rendering_args[9] = renderType;
                data = this.rendering_args;
                data_len = data.length;
                break;
            }
            case 0: {
                RemoteVolume rmvol = (RemoteVolume)args[0];
                data = new byte[5];
                CodecUtils.putInt(data, 1, rmvol.getRemoteId());
                data_len = data.length;
                break;
            }
            case 1: {
                int vol_idx = (Integer)args[0];
                int vmId = (Integer)args[1];
                data = new byte[9];
                CodecUtils.putInt(data, 1, vol_idx);
                CodecUtils.putInt(data, 5, vmId);
                data_len = data.length;
                break;
            }
            case 2: {
                String style = (String)args[0];
                data = new byte[style.length() * 2 + 3];
                CodecUtils.putString(data, 1, style);
                data_len = data.length;
                break;
            }
            case 3: {
                int rgbbackground = (Integer)args[0];
                int lumbackground = (Integer)args[1];
                CodecUtils.putInt(this.setbg_args, 1, rgbbackground);
                CodecUtils.putInt(this.setbg_args, 5, lumbackground);
                data = this.setbg_args;
                data_len = data.length;
                break;
            }
            case 4: {
                data = this.initRender_args;
                data_len = data.length;
                break;
            }
            case 8: {
                int width = (Integer)args[0];
                int height = (Integer)args[1];
                CodecUtils.putInt(this.setOutput_args, 1, width);
                CodecUtils.putInt(this.setOutput_args, 5, height);
                data = this.setOutput_args;
                data_len = data.length;
                break;
            }
            case 9: {
                data = this.clearBuffers_args;
                data_len = data.length;
                break;
            }
            case 10: {
                int x0 = (Integer)args[0];
                int y0 = (Integer)args[1];
                int width = (Integer)args[2];
                int height = (Integer)args[3];
                int stepx = (Integer)args[4];
                int stepy = (Integer)args[5];
                CodecUtils.putInt(this.clearPixels_args, 1, x0);
                CodecUtils.putInt(this.clearPixels_args, 5, y0);
                CodecUtils.putInt(this.clearPixels_args, 9, width);
                CodecUtils.putInt(this.clearPixels_args, 13, height);
                CodecUtils.putInt(this.clearPixels_args, 17, stepx);
                CodecUtils.putInt(this.clearPixels_args, 21, stepy);
                data = this.clearPixels_args;
                data_len = data.length;
                break;
            }
            case 11: {
                data = this.suppRStyles_args;
                data_len = data.length;
                break;
            }
            case 12: {
                int writeOffset;
                String propName = (String)args[0];
                Object value = args[1];
                if (value instanceof VrPreset) {
                    data = new byte[0x200000];
                    VrPreset preset = (VrPreset)value;
                    writeOffset = 1;
                    CodecUtils.putString(data, writeOffset, propName);
                    data_len = preset.toBytes(data, writeOffset += CodecUtils.getStringLengthInBytes(propName));
                    break;
                }
                if (value instanceof VrColorLut) {
                    data = new byte[0x200000];
                    VrColorLut vcl = (VrColorLut)value;
                    writeOffset = 1;
                    CodecUtils.putString(data, writeOffset, propName);
                    data_len = vcl.toBytes(data, writeOffset += CodecUtils.getStringLengthInBytes(propName));
                    break;
                }
                String propValue = "" + value;
                data_len = CodecUtils.getStringLengthInBytes(propName) + CodecUtils.getStringLengthInBytes(propValue) + 1;
                data = new byte[data_len];
                writeOffset = 1;
                CodecUtils.putString(data, writeOffset, propName);
                CodecUtils.putString(data, writeOffset += CodecUtils.getStringLengthInBytes(propName), propValue);
                writeOffset += CodecUtils.getStringLengthInBytes(propValue);
                break;
            }
            case 13: {
                boolean b = (Boolean)args[0];
                CodecUtils.putBoolean(this.setPerspective_args, 1, b);
                data = this.setPerspective_args;
                data_len = data.length;
                break;
            }
            case 14: {
                double[] lookpt = (double[])args[0];
                data = this.setLookPt_args;
                int offset = this.encode3Tuple(lookpt, data, 1);
                data_len = data.length;
                break;
            }
            case 15: {
                double[] eyept = (double[])args[0];
                data = this.setEyePt_args;
                int offset = this.encode3Tuple(eyept, data, 1);
                data_len = data.length;
                break;
            }
            case 16: {
                double[] up = (double[])args[0];
                data = this.setUp_args;
                int offset = this.encode3Tuple(up, data, 1);
                data_len = data.length;
                break;
            }
            case 17: {
                double[] eyept = (double[])args[0];
                double[] lookpt = (double[])args[1];
                double[] up = (double[])args[2];
                data = this.setCamera_args;
                int offset = this.encode3Tuple(eyept, data, 1);
                offset = this.encode3Tuple(lookpt, data, offset);
                offset = this.encode3Tuple(up, data, offset);
                data_len = data.length;
                break;
            }
            case 18: {
                double[] clipOffsets = (double[])args[0];
                data = this.setViewClip_args;
                CodecUtils.putDouble(data, 1, clipOffsets[0]);
                CodecUtils.putDouble(data, 5, clipOffsets[1]);
                data_len = data.length;
                break;
            }
            case 19: {
                double viewHeight = (Double)args[0];
                data = this.setViewHeight_args;
                CodecUtils.putDouble(data, 1, viewHeight);
                data_len = data.length;
                break;
            }
            case 20: {
                int x = (Integer)args[0];
                int y = (Integer)args[1];
                data = this.getDepthStep_args;
                CodecUtils.putInt(data, 1, x);
                CodecUtils.putInt(data, 5, y);
                data_len = data.length;
                break;
            }
            case 21: {
                int x = (Integer)args[0];
                int y = (Integer)args[1];
                data = this.getRASCoords_args;
                CodecUtils.putInt(data, 1, x);
                CodecUtils.putInt(data, 5, y);
                data_len = data.length;
                break;
            }
            case 22: {
                int x = (Integer)args[0];
                int y = (Integer)args[1];
                data = this.getVolumeCoords_args;
                CodecUtils.putInt(data, 1, x);
                CodecUtils.putInt(data, 5, y);
                data_len = data.length;
                break;
            }
            case 23: {
                int x = (Integer)args[0];
                int y = (Integer)args[1];
                data = this.getValue_args;
                CodecUtils.putInt(data, 1, x);
                CodecUtils.putInt(data, 5, y);
                data_len = data.length;
                break;
            }
            case 24: {
                data = this.suppMpass_args;
                data_len = data.length;
                break;
            }
            case 25: {
                VrPreset preset = (VrPreset)args[0];
                data = new byte[0x100000];
                data_len = preset.toBytes(data, 1);
                break;
            }
            case 26: {
                VrColorLut vcl = (VrColorLut)args[0];
                data = new byte[0x100000];
                data_len = vcl.toBytes(data, 1);
                break;
            }
            case 27: {
                Integer offset = (Integer)args[1];
                int writeOffset = 2;
                if (args[0] instanceof byte[]) {
                    byte[] bgrid = (byte[])args[0];
                    data_len = bgrid.length + 10;
                    data = new byte[data_len];
                    data[1] = 0;
                    Rm3DDispatcher.writeByteArray(bgrid, offset, data, writeOffset);
                    break;
                }
                short[] sgrid = (short[])args[0];
                data_len = sgrid.length * 2 + 10;
                data = new byte[data_len];
                data[1] = 1;
                Rm3DDispatcher.writeShortArray(sgrid, offset, data, writeOffset);
                break;
            }
            case 35: {
                data = this.suppCodec_args;
                data_len = data.length;
                break;
            }
            case 36: {
                String codec = (String)args[0];
                data = new byte[CodecUtils.getStringLengthInBytes(codec) + 1];
                data_len = data.length;
                CodecUtils.putString(data, 1, codec);
                break;
            }
            case 28: {
                data = new byte[1];
                data_len = data.length;
                break;
            }
            case 29: {
                byte[] bgrid = (byte[])args[0];
                data_len = bgrid.length + 9;
                data = new byte[data_len];
                Rm3DDispatcher.writeByteArray(bgrid, 0, data, 1);
                break;
            }
            case 30: {
                byte[] bgrid = (byte[])args[0];
                data_len = bgrid.length + 9;
                data = new byte[data_len];
                Rm3DDispatcher.writeByteArray(bgrid, 0, data, 1);
                break;
            }
            case 31: {
                data = new byte[1];
                data_len = data.length;
                break;
            }
            case 32: {
                Boolean bval = (Boolean)args[0];
                data = new byte[2];
                data_len = data.length;
                CodecUtils.putBoolean(data, 1, bval);
                break;
            }
            case 33: {
                int[] cmap = (int[])args[0];
                data = new byte[cmap.length * 4 + 9];
                data_len = data.length;
                Rm3DDispatcher.writeIntArray(cmap, 0, data, 1);
                break;
            }
        }
        if (data_len == 0) {
            return null;
        }
        data[0] = cmdId;
        byte[] ret = this.caller.call(data, data_offset, data_len);
        Object retvalue = null;
        switch (cmdId) {
            case 0: {
                int vmId = CodecUtils.getInt(ret, 0);
                retvalue = new Integer(vmId);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                retvalue = ret;
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                String rstyles_ret = CodecUtils.getString(ret, 0);
                StringTokenizer st = new StringTokenizer(rstyles_ret, "#");
                ArrayList<String> al = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String rstyle = st.nextToken();
                    al.add(rstyle);
                }
                String[] rstyles = new String[al.size()];
                for (int i = 0; i < rstyles.length; ++i) {
                    rstyles[i] = (String)al.get(i);
                }
                retvalue = rstyles;
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                int dstep = CodecUtils.getInt(ret, 0);
                retvalue = new Integer(dstep);
                break;
            }
            case 21: {
                double[] rasCoords = new double[3];
                this.decode3Tuple(ret, 0, rasCoords);
                retvalue = rasCoords;
                break;
            }
            case 22: {
                double[] volCoords = new double[3];
                this.decode3Tuple(ret, 0, volCoords);
                retvalue = volCoords;
                break;
            }
            case 23: {
                double value = CodecUtils.getDouble(ret, 0);
                retvalue = new Double(value);
                break;
            }
            case 24: {
                String mpass_alg = CodecUtils.getString(ret, 0);
                StringTokenizer stmp = new StringTokenizer(mpass_alg, "#");
                ArrayList<String> mp_list = new ArrayList<String>();
                while (stmp.hasMoreTokens()) {
                    String mp = stmp.nextToken();
                    mp_list.add(mp);
                }
                Class[] mpass_table = new Class[mp_list.size()];
                for (int i = 0; i < mpass_table.length; ++i) {
                    String clName = (String)mp_list.get(i);
                    try {
                        mpass_table[i] = Class.forName(clName);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("Rm3DDispatcher ERROR: Non-existent class=" + clName);
                    }
                }
                retvalue = mpass_table;
                break;
            }
            case 35: {
                String scodecs_ret = CodecUtils.getString(ret, 0);
                StringTokenizer strt = new StringTokenizer(scodecs_ret, "#");
                ArrayList<String> arrl = new ArrayList<String>();
                while (strt.hasMoreTokens()) {
                    String scodecs = strt.nextToken();
                    arrl.add(scodecs);
                }
                String[] suppcodecs = new String[arrl.size()];
                for (int i = 0; i < suppcodecs.length; ++i) {
                    suppcodecs[i] = (String)arrl.get(i);
                }
                retvalue = suppcodecs;
                break;
            }
            case 36: {
                boolean codecSet = CodecUtils.getBoolean(ret, 0);
                retvalue = new Boolean(codecSet);
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                boolean as = CodecUtils.getBoolean(ret, 0);
                retvalue = new Boolean(as);
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                boolean siret = CodecUtils.getBoolean(ret, 0);
                retvalue = new Boolean(siret);
                break;
            }
            case 30: {
                boolean suret = CodecUtils.getBoolean(ret, 0);
                retvalue = new Boolean(suret);
                break;
            }
            case 31: {
                boolean snret = CodecUtils.getBoolean(ret, 0);
                retvalue = new Boolean(snret);
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
        }
        return retvalue;
    }

    public ByteBuffer processCommand(byte[] in) {
        byte cmdId = in[0];
        switch (cmdId) {
            case 5: {
                this.server_args[0] = new Integer(CodecUtils.getInt(in, 1));
                this.server_args[1] = new Integer(CodecUtils.getInt(in, 5));
                this.server_args[2] = new Byte(in[9]);
                break;
            }
            case 0: {
                int volId = CodecUtils.getInt(in, 1);
                XjVolume vol = (XjVolume)RmServerDataManager.instance().getDataObject(volId);
                this.server_args[0] = vol;
                break;
            }
            case 1: {
                int vol_idx = CodecUtils.getInt(in, 1);
                int vmId = CodecUtils.getInt(in, 5);
                this.server_args[0] = new Integer(vol_idx);
                this.server_args[1] = new Integer(vmId);
                break;
            }
            case 2: {
                this.server_args[0] = CodecUtils.getString(in, 1);
                break;
            }
            case 3: {
                this.server_args[0] = new Integer(CodecUtils.getInt(in, 1));
                this.server_args[1] = new Integer(CodecUtils.getInt(in, 5));
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                int width = CodecUtils.getInt(in, 1);
                int height = CodecUtils.getInt(in, 5);
                this.outbuffer = new byte[width * height * 4];
                this.server_args[0] = new Integer(width);
                this.server_args[1] = new Integer(height);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                this.server_args[0] = new Integer(CodecUtils.getInt(in, 1));
                this.server_args[1] = new Integer(CodecUtils.getInt(in, 5));
                this.server_args[2] = new Integer(CodecUtils.getInt(in, 9));
                this.server_args[3] = new Integer(CodecUtils.getInt(in, 13));
                this.server_args[4] = new Integer(CodecUtils.getInt(in, 17));
                this.server_args[5] = new Integer(CodecUtils.getInt(in, 21));
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                int readOffset = 1;
                String propValue = CodecUtils.getString(in, readOffset);
                readOffset += CodecUtils.getStringLengthInBytes(propValue);
                this.server_args[0] = propValue;
                if (propValue.equals("PRESET_PROPERTY")) {
                    this.server_args[1] = VrPreset.createFromBytes(in, readOffset, new int[1]);
                    break;
                }
                if (propValue.equals("COLORLUT_PROPERTY")) {
                    this.server_args[1] = VrColorLut.createFromBytes(in, readOffset, new int[1]);
                    break;
                }
                this.server_args[1] = CodecUtils.getString(in, readOffset);
                break;
            }
            case 13: {
                this.server_args[0] = new Boolean(CodecUtils.getBoolean(in, 1));
                break;
            }
            case 14: {
                double[] v = new double[3];
                this.decode3Tuple(in, 1, v);
                this.server_args[0] = v;
                break;
            }
            case 15: {
                double[] v = new double[3];
                this.decode3Tuple(in, 1, v);
                this.server_args[0] = v;
                break;
            }
            case 16: {
                double[] v = new double[3];
                this.decode3Tuple(in, 1, v);
                this.server_args[0] = v;
                break;
            }
            case 17: {
                double[] v0 = new double[3];
                double[] v1 = new double[3];
                double[] v2 = new double[3];
                int offset = this.decode3Tuple(in, 1, v0);
                offset = this.decode3Tuple(in, offset, v1);
                offset = this.decode3Tuple(in, offset, v2);
                this.server_args[0] = v0;
                this.server_args[1] = v1;
                this.server_args[2] = v2;
                break;
            }
            case 18: {
                double[] v = new double[]{CodecUtils.getDouble(in, 1), CodecUtils.getDouble(in, 9)};
                this.server_args[0] = v;
                break;
            }
            case 19: {
                this.server_args[0] = new Double(CodecUtils.getDouble(in, 1));
                break;
            }
            case 20: {
                this.server_args[0] = new Integer(CodecUtils.getInt(in, 1));
                this.server_args[1] = new Integer(CodecUtils.getInt(in, 5));
                break;
            }
            case 21: {
                this.server_args[0] = new Integer(CodecUtils.getInt(in, 1));
                this.server_args[1] = new Integer(CodecUtils.getInt(in, 5));
                break;
            }
            case 22: {
                this.server_args[0] = new Integer(CodecUtils.getInt(in, 1));
                this.server_args[1] = new Integer(CodecUtils.getInt(in, 5));
                break;
            }
            case 23: {
                this.server_args[0] = new Integer(CodecUtils.getInt(in, 1));
                this.server_args[1] = new Integer(CodecUtils.getInt(in, 5));
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                this.server_args[0] = CodecUtils.getString(in, 1);
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                this.server_args[0] = VrPreset.createFromBytes(in, 1, new int[1]);
                break;
            }
            case 26: {
                this.server_args[0] = VrColorLut.createFromBytes(in, 1, new int[1]);
                break;
            }
            case 27: {
                Object[] grid;
                byte type = in[1];
                int[] offset = new int[1];
                int readOffset = 2;
                if (type == 0) {
                    grid = Rm3DDispatcher.readByteArray(in, readOffset, offset);
                    this.server_args[0] = grid;
                } else if (type == 1) {
                    grid = Rm3DDispatcher.readShortArray(in, readOffset, offset);
                    this.server_args[0] = grid;
                }
                this.server_args[1] = offset[0];
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                int[] offset = new int[1];
                byte[] grid = Rm3DDispatcher.readByteArray(in, 1, offset);
                this.server_args[0] = grid;
                break;
            }
            case 30: {
                int[] offset = new int[1];
                byte[] grid = Rm3DDispatcher.readByteArray(in, 1, offset);
                this.server_args[0] = grid;
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                this.server_args[0] = CodecUtils.getBoolean(in, 1);
                break;
            }
            case 33: {
                int[] offset = new int[1];
                int[] cmap = Rm3DDispatcher.readIntArray(in, 1, offset);
                this.server_args[0] = cmap;
                break;
            }
        }
        RmCommand rmcmd = new RmCommand(cmdId, this.server_args);
        Object retval = this.server_engine.executeCommand(rmcmd);
        ByteBuffer xm_retval = null;
        switch (cmdId) {
            case 5: {
                Object[] retvals = (Object[])retval;
                int offset = (Integer)retvals[0];
                int pblen = (Integer)retvals[1];
                byte[] pbencode = (byte[])retvals[2];
                xm_retval = ByteBuffer.wrap(pbencode, offset, pblen);
                break;
            }
            case 0: {
                Integer vmId = (Integer)retval;
                CodecUtils.putInt(this.outbuffer, 0, vmId);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 4);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                String rstyles_ret = "";
                String[] rstyles = (String[])retval;
                if (rstyles == null) break;
                rstyles_ret = rstyles[0];
                for (int i = 1; i < rstyles.length; ++i) {
                    rstyles_ret = rstyles_ret + "#" + rstyles[i];
                }
                CodecUtils.putString(this.outbuffer, 0, rstyles_ret);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 2 * rstyles_ret.length() + 2);
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                Integer dstep = (Integer)retval;
                CodecUtils.putInt(this.outbuffer, 0, dstep);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 4);
                break;
            }
            case 21: {
                double[] rasCoords = (double[])retval;
                this.encode3Tuple(rasCoords, this.outbuffer, 0);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 24);
                break;
            }
            case 22: {
                double[] volCoords = (double[])retval;
                this.encode3Tuple(volCoords, this.outbuffer, 0);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 24);
                break;
            }
            case 23: {
                Double value = (Double)retval;
                CodecUtils.putDouble(this.outbuffer, 0, value);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 8);
                break;
            }
            case 24: {
                String mpass_ret = "";
                Class[] malg = (Class[])retval;
                if (malg == null) break;
                mpass_ret = malg[0].getCanonicalName();
                for (int i = 1; i < malg.length; ++i) {
                    mpass_ret = mpass_ret + "#" + malg[i].getCanonicalName();
                }
                CodecUtils.putString(this.outbuffer, 0, mpass_ret);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 2 * mpass_ret.length() + 2);
                break;
            }
            case 35: {
                String scodecs_ret = "";
                String[] scodecs = (String[])retval;
                if (scodecs == null) break;
                scodecs_ret = scodecs[0];
                for (int i = 1; i < scodecs.length; ++i) {
                    scodecs_ret = scodecs_ret + "#" + scodecs[i];
                }
                CodecUtils.putString(this.outbuffer, 0, scodecs_ret);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 2 * scodecs_ret.length() + 2);
                break;
            }
            case 36: {
                Boolean codecSet = (Boolean)retval;
                CodecUtils.putBoolean(this.outbuffer, 0, codecSet);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 1);
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                Boolean as_ret = (Boolean)retval;
                CodecUtils.putBoolean(this.outbuffer, 0, as_ret);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 1);
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                Boolean si_ret = (Boolean)retval;
                CodecUtils.putBoolean(this.outbuffer, 0, si_ret);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 1);
                break;
            }
            case 30: {
                Boolean su_ret = (Boolean)retval;
                CodecUtils.putBoolean(this.outbuffer, 0, su_ret);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 1);
                break;
            }
            case 31: {
                Boolean sn_ret = (Boolean)retval;
                CodecUtils.putBoolean(this.outbuffer, 0, sn_ret);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 1);
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
        }
        return xm_retval;
    }

    private int encode3Tuple(double[] v, byte[] res, int off) {
        int offset = off;
        CodecUtils.putDouble(res, offset, v[0]);
        CodecUtils.putDouble(res, offset += 8, v[1]);
        CodecUtils.putDouble(res, offset += 8, v[2]);
        return offset += 8;
    }

    private int decode3Tuple(byte[] res, int off, double[] v) {
        int offset = off;
        v[0] = CodecUtils.getDouble(res, offset);
        v[1] = CodecUtils.getDouble(res, offset += 8);
        v[2] = CodecUtils.getDouble(res, offset += 8);
        return offset += 8;
    }

    private static int writeByteArray(byte[] bgrid, int offset, byte[] data, int woffset) {
        int writeOffset = woffset;
        CodecUtils.putInt(data, writeOffset, offset);
        CodecUtils.putInt(data, writeOffset += 4, bgrid.length);
        writeOffset += 4;
        for (int i = 0; i < bgrid.length; ++i) {
            data[writeOffset] = bgrid[i];
            ++writeOffset;
        }
        return writeOffset;
    }

    private static byte[] readByteArray(byte[] data, int roffset, int[] offset) {
        int readOffset = roffset;
        offset[0] = CodecUtils.getInt(data, readOffset);
        int len = CodecUtils.getInt(data, readOffset += 4);
        readOffset += 4;
        byte[] grid = new byte[len];
        for (int i = 0; i < len; ++i) {
            grid[i] = data[readOffset++];
        }
        return grid;
    }

    private static int writeShortArray(short[] sgrid, int offset, byte[] data, int woffset) {
        int writeOffset = woffset;
        CodecUtils.putInt(data, writeOffset, offset);
        CodecUtils.putInt(data, writeOffset += 4, sgrid.length);
        writeOffset += 4;
        for (int i = 0; i < sgrid.length; ++i) {
            CodecUtils.putShort(data, writeOffset, sgrid[i]);
            writeOffset += 2;
        }
        return writeOffset;
    }

    private static short[] readShortArray(byte[] data, int roffset, int[] offset) {
        int readOffset = roffset;
        offset[0] = CodecUtils.getInt(data, readOffset);
        int len = CodecUtils.getInt(data, readOffset += 4);
        readOffset += 4;
        short[] grid = new short[len];
        for (int i = 0; i < len; ++i) {
            grid[i] = CodecUtils.getShort(data, readOffset);
            readOffset += 2;
        }
        return grid;
    }

    private static int writeIntArray(int[] igrid, int offset, byte[] data, int woffset) {
        int writeOffset = woffset;
        CodecUtils.putInt(data, writeOffset, offset);
        CodecUtils.putInt(data, writeOffset += 4, igrid.length);
        writeOffset += 4;
        for (int i = 0; i < igrid.length; ++i) {
            CodecUtils.putInt(data, writeOffset, igrid[i]);
            writeOffset += 4;
        }
        return writeOffset;
    }

    private static int[] readIntArray(byte[] data, int roffset, int[] offset) {
        int readOffset = roffset;
        offset[0] = CodecUtils.getInt(data, readOffset);
        int len = CodecUtils.getInt(data, readOffset += 4);
        readOffset += 4;
        int[] grid = new int[len];
        for (int i = 0; i < len; ++i) {
            grid[i] = CodecUtils.getInt(data, readOffset);
            readOffset += 4;
        }
        return grid;
    }

    public static interface RemoteCaller {
        public byte[] call(byte[] var1, int var2, int var3);
    }
}

