/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.registration;

import com.ge.med.idc.LinearTransformable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.terra.jami.XpMouseController;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class ScaleTransformMouseController
extends MouseInputAdapter
implements XpMouseController {
    protected int prevY;
    protected T3DCapable t3d;
    protected double[] lookPoint = new double[3];
    protected double[] transformArray = new double[16];
    protected JnMatrix4d transform = new JnMatrix4d();
    protected JnMatrix4d scaleTransform = new JnMatrix4d();
    protected LinearTransformable transformObject = null;

    public void setLinearTransformable(LinearTransformable transformObject) {
        this.transformObject = transformObject;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.t3d == null) {
            return;
        }
        int y = e.getY();
        double scale = 1.0 - (double)(y - this.prevY) / (double)e.getComponent().getHeight();
        this.t3d.getLookPoint(this.lookPoint);
        this.transformObject.getLinearTransform(this.transformArray);
        this.transform.set(this.transformArray);
        this.transform.translate(-this.lookPoint[0], -this.lookPoint[1], -this.lookPoint[2]);
        this.scaleTransform.setScale(scale);
        this.transform.mul(this.scaleTransform);
        this.transform.translate(this.lookPoint[0], this.lookPoint[1], this.lookPoint[2]);
        this.transform.get(this.transformArray);
        this.transformObject.setLinearTransform(this.transformArray);
        this.t3d.repaint();
        this.prevY = y;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevY = e.getY();
    }

    @Override
    public void setTarget(JComponent jc) {
        if (jc instanceof T3DCapable) {
            this.t3d = (T3DCapable)((Object)jc);
        }
    }
}

