/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.idc.IterativeRenderer;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.idc.T2DRenderStyleCapable;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.j3d.Commons3D;
import com.ge.med.terra.jami.j3d.T3DRenderEngineDefs;
import com.ge.med.terra.jami.j3d.mprender.Grid2x2MultipassAlgorithm;
import com.ge.med.terra.jami.j3d.mprender.Grid4x2MultipassAlgorithm;
import com.ge.med.terra.jami.j3d.mprender.Grid4x4MultipassAlgorithm;
import com.ge.med.terra.jami.j3d.mprender.Grid8x4MultipassAlgorithm;
import com.ge.med.terra.jami.j3d.mprender.MultipassMap;
import com.ge.med.terra.jami.j3d.mprender.OnepassAlgorithm;
import com.ge.med.terra.jami.j3d.mprender.OnepassLineAlgorithm;

public class DefaultMultipassMap
implements MultipassMap,
T3DRenderEngineDefs,
T2DRenderStyleCapable {
    private String renderStyle = null;
    private int rstyle = -1;
    private MultipassAlgorithm onepass = null;
    private MultipassAlgorithm onepassLine = null;
    private MultipassAlgorithm grid4x4 = null;
    private MultipassAlgorithm grid4x2 = null;
    private MultipassAlgorithm grid2x2 = null;
    private MultipassAlgorithm grid8x4 = null;

    public DefaultMultipassMap(IterativeRenderer irenderer, ParallelTaskManager ptm) {
        this.onepass = new OnepassAlgorithm(ptm);
        this.onepassLine = new OnepassLineAlgorithm(ptm);
        this.grid4x4 = new Grid4x4MultipassAlgorithm(ptm);
        this.grid4x2 = new Grid4x2MultipassAlgorithm(ptm);
        this.grid2x2 = new Grid2x2MultipassAlgorithm(ptm);
        this.grid8x4 = new Grid8x4MultipassAlgorithm(ptm);
        this.onepass.setT3DIRenderer(irenderer);
        this.onepassLine.setT3DIRenderer(irenderer);
        this.grid4x4.setT3DIRenderer(irenderer);
        this.grid4x2.setT3DIRenderer(irenderer);
        this.grid8x4.setT3DIRenderer(irenderer);
        this.grid2x2.setT3DIRenderer(irenderer);
    }

    @Override
    public void clear() {
        this.onepass.shutdown();
        this.onepassLine.shutdown();
        this.grid4x4.shutdown();
        this.grid4x2.shutdown();
        this.grid2x2.shutdown();
        this.grid8x4.shutdown();
        this.onepass = null;
        this.onepassLine = null;
        this.grid4x4 = null;
        this.grid4x2 = null;
        this.grid2x2 = null;
        this.grid8x4 = null;
    }

    @Override
    public MultipassAlgorithm getMultipassAlgorithm(int width, int height, double thickness) {
        MultipassAlgorithm retalg = this.grid4x2;
        int w = width;
        int h = height;
        switch (this.rstyle) {
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 16: 
            case 25: {
                retalg = this.onepass;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                if (thickness < 3.0) {
                    retalg = this.onepass;
                    break;
                }
                if (thickness < 30.0) {
                    retalg = this.grid2x2;
                    break;
                }
                if (thickness <= 70.0 && w < 600 && h < 600) {
                    retalg = this.grid4x2;
                    break;
                }
                retalg = this.grid4x4;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                boolean bigviewport;
                boolean bl = bigviewport = w > 600 && h > 600;
                if (bigviewport) {
                    retalg = this.grid8x4;
                    break;
                }
                if (w <= 420 && h <= 420) {
                    retalg = this.grid4x2;
                    break;
                }
                if (w <= 260 && h <= 260) {
                    retalg = this.grid2x2;
                    break;
                }
                retalg = this.grid4x4;
                break;
            }
            case 14: 
            case 15: {
                retalg = this.onepassLine;
                break;
            }
            case 60001: {
                retalg = this.grid2x2;
                break;
            }
            case 60002: {
                retalg = this.grid4x2;
            }
        }
        return retalg;
    }

    @Override
    public MultipassAlgorithm[] getSupportedMultipassAlgorithms() {
        return new MultipassAlgorithm[]{this.onepass, this.onepassLine, this.grid4x4, this.grid4x2, this.grid2x2, this.grid8x4};
    }

    @Override
    public void setRenderStyle(String renderStyle) {
        this.renderStyle = renderStyle;
        this.rstyle = Commons3D.getRenderStyleCode(renderStyle);
    }

    @Override
    public String getRenderStyle() {
        return this.renderStyle;
    }
}

