/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.idc.IterativeRenderer;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.jnu.geom.JnPoint;
import com.ge.med.jnu.geom.JnRectangle;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.Worker;
import java.util.Arrays;

public abstract class BaseMultipassAlgorithm
implements MultipassAlgorithm {
    private ParallelTaskManager tp = null;
    private IterativeRenderer ren = null;
    public int NOT = 0;
    private Object[] thread_data = null;
    private MPWorker[] worker = null;
    private RunnerData[] runnerdata = null;
    private byte[] bitmap = null;
    private int rowlen = 0;
    private int scrw = 0;
    private int scrh = 0;
    private boolean parallelRendering = true;
    private int curr_passno = -1;

    public BaseMultipassAlgorithm(boolean parallelRendering) {
        this.parallelRendering = parallelRendering;
        this.tp = new ParallelTaskManager();
        this.init();
    }

    @Override
    public void shutdown() {
        this.ren = null;
        this.thread_data = null;
        this.worker = null;
        for (RunnerData rd : this.runnerdata) {
            rd.shutdown();
        }
        this.runnerdata = null;
    }

    public BaseMultipassAlgorithm(ParallelTaskManager ptm, boolean parallelRendering) {
        this.parallelRendering = parallelRendering;
        this.tp = ptm;
        this.init();
    }

    @Override
    public String getDescriptor() {
        return "";
    }

    private void init() {
        this.NOT = ParallelTaskManager.getNumCPU();
        this.thread_data = new Object[this.NOT];
        this.worker = new MPWorker[this.NOT];
        this.runnerdata = new RunnerData[this.NOT];
        for (int i = 0; i < this.NOT; ++i) {
            this.worker[i] = new MPWorker(this.tp, i);
            this.runnerdata[i] = new RunnerData();
        }
        this.tp.setWorkers(this.worker);
    }

    public void launch(Runner[] r, Object data) {
        for (int i = 0; i < this.NOT; ++i) {
            this.runnerdata[i].thread_data = this.thread_data[i];
            this.runnerdata[i].global_data = data;
            this.runnerdata[i].runner = r[i];
            this.runnerdata[i].passno = this.curr_passno;
        }
        this.tp.launch(this.runnerdata);
    }

    public void launch(Runner[] r) {
        this.launch(r, null);
    }

    protected Object getThreadData(int cpuId) {
        return this.thread_data[cpuId];
    }

    @Override
    public IterativeRenderer getT3DIRenderer() {
        return this.ren;
    }

    private void syncPixmap() {
        int w = this.ren.getBufferWidth();
        int h = this.ren.getBufferHeight();
        if (this.bitmap == null || w != this.scrw || h != this.scrh) {
            this.scrw = w;
            this.scrh = h;
            this.rowlen = w >> 3;
            if (w % 8 != 0) {
                ++this.rowlen;
            }
            this.bitmap = new byte[this.rowlen * h];
        }
    }

    public void setPriority(int p) {
    }

    @Override
    public final int render(int x, int y, int w, int h, int renderOutputLayer, int passno) {
        this.syncPixmap();
        if (passno == 0) {
            this.clearBitmap();
        }
        this.curr_passno = passno;
        return this.renderMPass(x, y, w, h, renderOutputLayer, passno);
    }

    @Override
    public void fill(int x, int y, int w, int h, int renderOutputLayer, int passno) {
        this.curr_passno = passno;
        this.fillMPass(x, y, w, h, renderOutputLayer, passno);
    }

    protected final boolean isParallelRendering() {
        return this.parallelRendering;
    }

    public abstract int renderMPass(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillMPass(int var1, int var2, int var3, int var4, int var5, int var6);

    public void clearBitmap() {
        Arrays.fill(this.bitmap, (byte)0);
    }

    protected final void markbit(int x, int y) {
        int bidx = x >> 3;
        int idx = y * this.rowlen + bidx;
        int bmod = x & 7;
        this.bitmap[idx] = (byte)(this.bitmap[idx] | 1 << bmod);
    }

    protected final void markbits(int x0, int y0, int width, int height, int sx, int sy) {
        for (int y = y0; y < height; y += sy) {
            int yoffset = y * this.rowlen;
            for (int x = x0; x < width; x += sx) {
                int bidx = x >> 3;
                int bmod = x & 7;
                int idx = yoffset + bidx;
                this.bitmap[idx] = (byte)(this.bitmap[idx] | 1 << bmod);
            }
        }
    }

    protected final void markallbits() {
        Arrays.fill(this.bitmap, (byte)-1);
    }

    @Override
    public void setT3DIRenderer(IterativeRenderer renderer) {
        this.ren = renderer;
        for (int i = 0; i < this.NOT; ++i) {
            this.thread_data[i] = this.ren.createThreadData();
            this.runnerdata[i].ren = renderer;
            this.runnerdata[i].thread_data = this.thread_data[i];
        }
    }

    public static interface Runner {
        public void work(int var1, int var2, int var3, IterativeRenderer var4, Object var5, Object var6);
    }

    private static class MPWorker
    extends Worker {
        public MPWorker(ParallelTaskManager ptm, int workerId) {
            super(ptm, workerId);
        }

        @Override
        public void work(int workerId, int workers, Object data) {
            RunnerData[] rdata = (RunnerData[])data;
            RunnerData r = rdata[workerId];
            r.runner.work(workerId, workers, r.passno, r.ren, r.global_data, r.thread_data);
        }
    }

    private static class RunnerData {
        public Object thread_data = null;
        public Runner runner = null;
        public int passno = -1;
        public Object global_data = null;
        public IterativeRenderer ren = null;

        private RunnerData() {
        }

        public void shutdown() {
            this.thread_data = null;
            this.runner = null;
            this.global_data = null;
            this.ren = null;
        }
    }

    protected static class RenderData {
        public JnPoint p = new JnPoint();
        public int outLayer = 0;
        public JnRectangle outputArea = null;

        protected RenderData() {
        }
    }
}

