/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.terra.jami.j3d.VoxelCombiner;
import com.ge.med.terra.jami.j3d.mpr.majoraxisThickmpr;
import java.util.Arrays;

public class mprMultiVolume
extends majoraxisThickmpr {
    private VoxelCombiner m_combiner = null;

    public void setCombiner(VoxelCombiner combiner) {
        this.m_combiner = combiner;
    }

    public VoxelCombiner getCombiner() {
        return this.m_combiner;
    }

    private static int startval(int vstart, int modres, int mod) {
        int v = vstart;
        while (v % mod != modres) {
            ++v;
        }
        return v;
    }

    public void mprMultiVolume_tl(int threadNo, int x0, int y0, int x1, int y1, int xskip, int yskip, short[][] vols, int vol_offset, short[] img, int w, int h) {
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int psize = dx * dy;
        int[][] tidx = this.getViewPlaneIntersectBounds();
        double startX = mprMultiVolume.getViewStartCoord(0, w, h, lookpt, xstep, ystep, dx);
        double startY = mprMultiVolume.getViewStartCoord(1, w, h, lookpt, xstep, ystep, dy);
        double startZ = mprMultiVolume.getViewStartCoord(2, w, h, lookpt, xstep, ystep, dz);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        short[][] vals = new short[vols.length][8];
        short[] combined = new short[8];
        try {
            int i;
            ystart -= ystart % yskip;
            int ybegin = ystart + y0;
            int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
            int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
            int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
            int ylast = ybegin;
            for (i = ybegin; i < yend; i += yskip) {
                int yoffset = i * w;
                int xstart = mprMultiVolume.startval(tidx[i][0], x0, xskip);
                int xend = tidx[i][1];
                ylast = i;
                int six = rix + ixstep_x * xstart;
                int siy = riy + ixstep_y * xstart;
                int siz = riz + ixstep_z * xstart;
                int xlast = xstart;
                for (int j = xstart; j < xend; j += xskip) {
                    int frac0_x = six & Short.MAX_VALUE;
                    int frac0_y = siy & Short.MAX_VALUE;
                    int frac0_z = siz & Short.MAX_VALUE;
                    ix = six >> 15;
                    iy = siy >> 15;
                    iz = siz >> 15;
                    int poffset0 = vol_offset + iz * psize;
                    int roffset0 = iy * dx;
                    int vidx = poffset0 + roffset0 + ix;
                    int vidx_n = vidx + psize;
                    for (int v = 0; v < vols.length; ++v) {
                        vals[v][0] = vols[v][vidx];
                        vals[v][1] = vols[v][vidx + 1];
                        vals[v][2] = vols[v][vidx + dx];
                        vals[v][3] = vols[v][vidx + dx + 1];
                        vals[v][4] = vols[v][vidx_n];
                        vals[v][5] = vols[v][vidx_n + 1];
                        vals[v][6] = vols[v][vidx_n + dx];
                        vals[v][7] = vols[v][vidx_n + dx + 1];
                    }
                    this.m_combiner.combine(threadNo, combined, vals, 0, 0, 1, 1, 8);
                    int voxel_z0_x1 = combined[0] + ((combined[1] - combined[0]) * frac0_x >> 15);
                    int voxel_z0_x2 = combined[2] + ((combined[3] - combined[2]) * frac0_x >> 15);
                    int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                    int voxel_z1_x1 = combined[4] + ((combined[5] - combined[4]) * frac0_x >> 15);
                    int voxel_z1_x2 = combined[6] + ((combined[7] - combined[6]) * frac0_x >> 15);
                    int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                    int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                    img[yoffset + j] = (short)voxel;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                    xlast = j;
                }
                if (this.isMajorAxisView()) {
                    this.fillLineEdges(threadNo, vols, vol_offset, img, i, w, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep);
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
            if (this.isMajorAxisView()) {
                int npix;
                for (i = ylast + yskip; i < h && (npix = this.fillLine(threadNo, vols, vol_offset, img, i, w, x0, w - 1, xskip, startX, startY, startZ, xstep, ystep)) > 0; i += yskip) {
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("ERROR: mpr[nn] Bad array idx: [" + ix + "," + iy + "," + iz + "]");
            aie.printStackTrace();
        }
    }

    private int fillLineEdges(int threadNo, short[][] vols, int vol_offset, short[] outimg, int y, int width, int x0, int x1, int xskip, double sx, double sy, double sz, double[] xstep, double[] ystep) {
        double p;
        double p1;
        double p0;
        double p03;
        double p02;
        double p01;
        double p00;
        int voffset;
        double fz;
        double fy;
        double fx;
        int iz;
        int iy;
        int ix;
        int v7;
        int v6;
        int v5;
        int v4;
        int v3;
        int v2;
        int v1;
        int v0;
        double siz;
        double siy;
        double six;
        int j;
        int dimx = this.getVolDimX();
        int dimy = this.getVolDimY();
        int dimz = this.getVolDimZ();
        int psize = dimx * dimy;
        int npixels = 0;
        int noContent = -2000;
        double rix = sx + ystep[0] * (double)y;
        double riy = sy + ystep[1] * (double)y;
        double riz = sz + ystep[2] * (double)y;
        int yoffset = y * width;
        int vollen = vols.length;
        short[][] vals = new short[vollen][8];
        short[] combined = new short[8];
        for (j = x0 - xskip; j >= 0; j -= xskip) {
            six = rix + xstep[0] * (double)j;
            siy = riy + xstep[1] * (double)j;
            siz = riz + xstep[2] * (double)j;
            v0 = -2000;
            v1 = -2000;
            v2 = -2000;
            v3 = -2000;
            v4 = -2000;
            v5 = -2000;
            v6 = -2000;
            v7 = -2000;
            ix = (int)six;
            iy = (int)siy;
            iz = (int)siz;
            fx = six - (double)ix;
            fy = siy - (double)iy;
            fz = siz - (double)iz;
            voffset = vol_offset + psize * iz + iy * dimx + ix;
            if (ix < 0 || ix >= dimx || iy < 0 || iy >= dimy || iz < 0 || iz >= dimz) continue;
            for (int v = 0; v < vollen; ++v) {
                Arrays.fill(vals[v], (short)-2000);
                vals[v][0] = vols[v][voffset];
                if (ix < dimx - 1) {
                    vals[v][1] = vols[v][voffset + 1];
                }
                if (iy < dimy - 1) {
                    vals[v][2] = vols[v][voffset + dimx];
                }
                if (ix < dimx - 1 && iy < dimy - 1) {
                    vals[v][3] = vols[v][voffset + dimx + 1];
                }
                if (iz >= dimz - 1) continue;
                vals[v][4] = vols[v][voffset + psize];
                if (ix < dimx - 1) {
                    vals[v][5] = vols[v][voffset + psize + 1];
                }
                if (iy < dimy - 1) {
                    vals[v][6] = vols[v][voffset + psize + dimx];
                }
                if (ix >= dimx - 1 || iy >= dimy - 1) continue;
                vals[v][7] = vols[v][voffset + psize + dimx + 1];
            }
            this.m_combiner.combine(threadNo, combined, vals, 0, 0, 1, 1, 8);
            v0 = combined[0];
            v1 = combined[1];
            v2 = combined[2];
            v3 = combined[3];
            v4 = combined[4];
            v5 = combined[5];
            v6 = combined[6];
            v7 = combined[7];
            if (six < 0.0) {
                v1 = -2000;
                v3 = -2000;
                v5 = -2000;
                v7 = -2000;
                fx = -fx;
            }
            if (siy < 0.0) {
                v2 = -2000;
                v3 = -2000;
                v6 = -2000;
                v7 = -2000;
                fy = -fy;
            }
            if (siz < 0.0) {
                v4 = -2000;
                v5 = -2000;
                v6 = -2000;
                v7 = -2000;
                fz = -fz;
            }
            p00 = (double)v0 + (double)(v1 - v0) * fx;
            p01 = (double)v2 + (double)(v3 - v2) * fx;
            p02 = (double)v4 + (double)(v5 - v4) * fx;
            p03 = (double)v6 + (double)(v7 - v6) * fx;
            p0 = p00 + (p01 - p00) * fy;
            p1 = p02 + (p03 - p02) * fy;
            p = p0 + (p1 - p0) * fz;
            outimg[yoffset + j] = (short)p;
            ++npixels;
        }
        for (j = x1 + xskip; j < width; j += xskip) {
            six = rix + xstep[0] * (double)j;
            siy = riy + xstep[1] * (double)j;
            siz = riz + xstep[2] * (double)j;
            v0 = 0;
            v1 = 0;
            v2 = 0;
            v3 = 0;
            v4 = 0;
            v5 = 0;
            v6 = 0;
            v7 = 0;
            ix = (int)six;
            iy = (int)siy;
            iz = (int)siz;
            fx = six - (double)ix;
            fy = siy - (double)iy;
            fz = siz - (double)iz;
            voffset = vol_offset + psize * iz + iy * dimx + ix;
            if (ix >= 0 && ix < dimx && iy >= 0 && iy < dimy && iz >= 0 && iz < dimz) {
                for (int v = 0; v < vollen; ++v) {
                    Arrays.fill(vals[v], (short)-2000);
                    vals[v][0] = vols[v][voffset];
                    if (ix < dimx - 1) {
                        vals[v][1] = vols[v][voffset + 1];
                    }
                    if (iy < dimy - 1) {
                        vals[v][2] = vols[v][voffset + dimx];
                    }
                    if (ix < dimx - 1 && iy < dimy - 1) {
                        vals[v][3] = vols[v][voffset + dimx + 1];
                    }
                    if (iz >= dimz - 1) continue;
                    vals[v][4] = vols[v][voffset + psize];
                    if (ix < dimx - 1) {
                        vals[v][5] = vols[v][voffset + psize + 1];
                    }
                    if (iy < dimy - 1) {
                        vals[v][6] = vols[v][voffset + psize + dimx];
                    }
                    if (ix >= dimx - 1 || iy >= dimy - 1) continue;
                    vals[v][7] = vols[v][voffset + psize + dimx + 1];
                }
                this.m_combiner.combine(threadNo, combined, vals, 0, 0, 1, 1, 8);
                v0 = combined[0];
                v1 = combined[1];
                v2 = combined[2];
                v3 = combined[3];
                v4 = combined[4];
                v5 = combined[5];
                v6 = combined[6];
                v7 = combined[7];
                if (six < 0.0) {
                    v1 = -2000;
                    v3 = -2000;
                    v5 = -2000;
                    v7 = -2000;
                    fx = -fx;
                }
                if (siy < 0.0) {
                    v2 = -2000;
                    v3 = -2000;
                    v6 = -2000;
                    v7 = -2000;
                    fy = -fy;
                }
                if (siz < 0.0) {
                    v4 = -2000;
                    v5 = -2000;
                    v6 = -2000;
                    v7 = -2000;
                    fz = -fz;
                }
                p00 = (double)v0 + (double)(v1 - v0) * fx;
                p01 = (double)v2 + (double)(v3 - v2) * fx;
                p02 = (double)v4 + (double)(v5 - v4) * fx;
                p03 = (double)v6 + (double)(v7 - v6) * fx;
                p0 = p00 + (p01 - p00) * fy;
                p1 = p02 + (p03 - p02) * fy;
                p = p0 + (p1 - p0) * fz;
                outimg[yoffset + j] = (short)p;
            }
            ++npixels;
        }
        return npixels;
    }

    private int fillLine(int threadNo, short[][] vols, int vol_offset, short[] outimg, int y, int width, int x0, int x1, int xskip, double sx, double sy, double sz, double[] xstep, double[] ystep) {
        int dimx = this.getVolDimX();
        int dimy = this.getVolDimY();
        int dimz = this.getVolDimZ();
        int psize = dimx * dimy;
        int npixels = 0;
        double rix = sx + ystep[0] * (double)y;
        double riy = sy + ystep[1] * (double)y;
        double riz = sz + ystep[2] * (double)y;
        double xstep_x = xstep[0];
        double xstep_y = xstep[1];
        double xstep_z = xstep[2];
        double vx = rix + xstep[0] * (double)x0;
        double vy = riy + xstep[1] * (double)x0;
        double vz = riz + xstep[2] * (double)x0;
        int noContent = -2000;
        int yoffset = y * width;
        int vollen = vols.length;
        short[][] vals = new short[vollen][8];
        short[] combined = new short[8];
        for (int j = x0; j <= x1; j += xskip) {
            int ix = (int)vx;
            int iy = (int)vy;
            int iz = (int)vz;
            double fx = vx - (double)ix;
            double fy = vy - (double)iy;
            double fz = vz - (double)iz;
            int voffset = vol_offset + psize * iz + iy * dimx + ix;
            int v0 = -2000;
            int v1 = -2000;
            int v2 = -2000;
            int v3 = -2000;
            int v4 = -2000;
            int v5 = -2000;
            int v6 = -2000;
            int v7 = -2000;
            if (vx >= 0.0 && vx < (double)dimx && vy >= 0.0 && vy < (double)dimy && vz >= 0.0 && vz < (double)dimz) {
                for (int v = 0; v < vollen; ++v) {
                    Arrays.fill(vals[v], (short)-2000);
                    vals[v][0] = vols[v][voffset];
                    if (ix < dimx - 1) {
                        vals[v][1] = vols[v][voffset + 1];
                    }
                    if (iy < dimy - 1) {
                        vals[v][2] = vols[v][voffset + dimx];
                    }
                    if (ix < dimx - 1 && iy < dimy - 1) {
                        vals[v][3] = vols[v][voffset + dimx + 1];
                    }
                    if (iz >= dimz - 1) continue;
                    vals[v][4] = vols[v][voffset + psize];
                    if (ix < dimx - 1) {
                        vals[v][5] = vols[v][voffset + psize + 1];
                    }
                    if (iy < dimy - 1) {
                        vals[v][6] = vols[v][voffset + psize + dimx];
                    }
                    if (ix >= dimx - 1 || iy >= dimy - 1) continue;
                    vals[v][7] = vols[v][voffset + psize + dimx + 1];
                }
                this.m_combiner.combine(threadNo, combined, vals, 0, 0, 1, 1, 8);
                v0 = combined[0];
                v1 = combined[1];
                v2 = combined[2];
                v3 = combined[3];
                v4 = combined[4];
                v5 = combined[5];
                v6 = combined[6];
                v7 = combined[7];
                if (vx < 0.0) {
                    v1 = -2000;
                    v3 = -2000;
                    v5 = -2000;
                    v7 = -2000;
                    fx = -fx;
                }
                if (vy < 0.0) {
                    v2 = -2000;
                    v3 = -2000;
                    v6 = -2000;
                    v7 = -2000;
                    fy = -fy;
                }
                if (vz < 0.0) {
                    v4 = -2000;
                    v5 = -2000;
                    v6 = -2000;
                    v7 = -2000;
                    fz = -fz;
                }
                double p00 = (double)v0 + (double)(v1 - v0) * fx;
                double p01 = (double)v2 + (double)(v3 - v2) * fx;
                double p02 = (double)v4 + (double)(v5 - v4) * fx;
                double p03 = (double)v6 + (double)(v7 - v6) * fx;
                double p0 = p00 + (p01 - p00) * fy;
                double p1 = p02 + (p03 - p02) * fy;
                double p = p0 + (p1 - p0) * fz;
                outimg[yoffset + j] = (short)p;
                ++npixels;
            }
            vx += xstep_x;
            vy += xstep_y;
            vz += xstep_z;
        }
        return npixels;
    }
}

