/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.terra.jami.j3d.mpr.VoxelSampler;

public class mpr
extends VoxelSampler {
    private int inIdx = -1;
    private int outIdx = -1;
    public static final int BINARY_SCALE_01 = 2048;

    public mpr() {
    }

    public mpr(int xyz_scooch) {
        super(xyz_scooch);
    }

    private static int startval(int vstart, int targetStart, int mod) {
        int v = vstart;
        int modres = targetStart % mod;
        while (v % mod != modres) {
            ++v;
        }
        return v;
    }

    public void mpr_nn(int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, byte[] seggrid, int vol_offset, short[] img, short[] overlay, int w, int h) {
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int psize = dx * dy;
        int[][] tidx = this.getViewPlaneIntersectBounds();
        double startX = mpr.getViewStartCoord(0, w, h, lookpt, xstep, ystep, dx);
        double startY = mpr.getViewStartCoord(1, w, h, lookpt, xstep, ystep, dy);
        double startZ = mpr.getViewStartCoord(2, w, h, lookpt, xstep, ystep, dz);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        int rix = (int)((startX + 0.5 + ystep[0] * (double)ystart) * 32768.0);
        int riy = (int)((startY + 0.5 + ystep[1] * (double)ystart) * 32768.0);
        int riz = (int)((startZ + 0.5 + ystep[2] * (double)ystart) * 32768.0);
        double round = 3.051850947599719E-5;
        try {
            int roffset0;
            int poffset0;
            int j;
            int i;
            ystart -= ystart % yskip;
            int ylast = ystart + y0;
            for (i = ystart + y0; i < yend; i += yskip) {
                int yoffset = i * w;
                int xstart = mpr.startval(tidx[i][0], x0, xskip);
                int xend = tidx[i][1];
                int six = rix + ixstep_x * xstart;
                int siy = riy + ixstep_y * xstart;
                int siz = riz + ixstep_z * xstart;
                ylast = i;
                int xlast = xstart;
                for (j = xstart; j < xend; j += xskip) {
                    ix = six >> 15;
                    iy = siy >> 15;
                    iz = siz >> 15;
                    poffset0 = vol_offset + iz * psize;
                    roffset0 = iy * dx;
                    short voxel0 = vol[poffset0 + roffset0 + ix];
                    img[yoffset + j] = voxel0;
                    xlast = j;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                }
                if (this.isMajorAxisView()) {
                    this.fillLineEdgesNN(vol, vol_offset, img, i, w, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep, 3.051850947599719E-5);
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
            if (this.isMajorAxisView()) {
                int npix;
                for (i = ylast + yskip; i < h && (npix = this.fillLine(vol, vol_offset, img, i, w, x0, w - 1, xskip, startX, startY, startZ, xstep, ystep)) > 0; i += yskip) {
                }
            }
            if (seggrid != null && (this.inIdx >= 0 || this.outIdx >= 0)) {
                iz = 0;
                iy = 0;
                ix = 0;
                rix = (int)((startX + ystep[0] * (double)ystart) * 32768.0);
                riy = (int)((startY + ystep[1] * (double)ystart) * 32768.0);
                riz = (int)((startZ + ystep[2] * (double)ystart) * 32768.0);
                int sum = 0;
                for (int i2 = ystart + y0; i2 < yend; i2 += yskip) {
                    int yoffset = i2 * w;
                    int xstart = tidx[i2][0];
                    int xend = tidx[i2][1];
                    int jix = rix + ixstep_x * xstart;
                    int jiy = riy + ixstep_y * xstart;
                    int jiz = riz + ixstep_z * xstart;
                    for (j = xstart + x0; j < xend; j += xskip) {
                        ix = jix >> 15;
                        iy = jiy >> 15;
                        iz = jiz >> 15;
                        poffset0 = iz * psize;
                        roffset0 = iy * dx;
                        int vidx = poffset0 + roffset0 + ix;
                        int bidx = vidx >> 3;
                        int bmod = vidx % 8;
                        byte value = (byte)this.outIdx;
                        if ((seggrid[bidx] & 1 << bmod) != 0) {
                            value = (byte)this.inIdx;
                            ++sum;
                        }
                        overlay[yoffset + j] = value;
                        jix += xskip_x;
                        jiy += xskip_y;
                        jiz += xskip_z;
                    }
                    rix += yskip_x;
                    riy += yskip_y;
                    riz += yskip_z;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("ERROR: mpr[nn] Bad array idx: [" + ix + "," + iy + "," + iz + "]");
            aie.printStackTrace();
        }
    }

    public void mpr_tl(int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, byte[] seggrid, int vol_offset, short[] img, short[] overlay, int w, int h) {
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int psize = dx * dy;
        int[][] tidx = this.getViewPlaneIntersectBounds();
        double startX = mpr.getViewStartCoord(0, w, h, lookpt, xstep, ystep, dx);
        double startY = mpr.getViewStartCoord(1, w, h, lookpt, xstep, ystep, dy);
        double startZ = mpr.getViewStartCoord(2, w, h, lookpt, xstep, ystep, dz);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        ystart -= ystart % yskip;
        try {
            int j;
            int i;
            int ybegin = ystart + y0;
            int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
            int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
            int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
            int ylast = ybegin;
            for (i = ybegin; i < yend; i += yskip) {
                int yoffset = i * w;
                int xstart = mpr.startval(tidx[i][0], x0, xskip);
                int xend = tidx[i][1];
                ylast = i;
                int six = rix + ixstep_x * xstart;
                int siy = riy + ixstep_y * xstart;
                int siz = riz + ixstep_z * xstart;
                int xlast = xstart;
                for (j = xstart; j < xend; j += xskip) {
                    int frac0_x = six & Short.MAX_VALUE;
                    int frac0_y = siy & Short.MAX_VALUE;
                    int frac0_z = siz & Short.MAX_VALUE;
                    ix = six >> 15;
                    iy = siy >> 15;
                    iz = siz >> 15;
                    int poffset0 = vol_offset + iz * psize;
                    int roffset0 = iy * dx;
                    int vidx = poffset0 + roffset0 + ix;
                    int vidx_n = vidx + psize;
                    short voxel0 = vol[vidx];
                    short voxel1 = vol[vidx + 1];
                    short voxel2 = vol[vidx + dx];
                    short voxel3 = vol[vidx + dx + 1];
                    short voxel4 = vol[vidx_n];
                    short voxel5 = vol[vidx_n + 1];
                    short voxel6 = vol[vidx_n + dx];
                    short voxel7 = vol[vidx_n + dx + 1];
                    int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                    int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                    int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                    int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                    int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                    int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                    int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                    img[yoffset + j] = (short)voxel;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                    xlast = j;
                }
                if (this.isMajorAxisView()) {
                    this.fillLineEdges(vol, vol_offset, img, i, w, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep);
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
            if (this.isMajorAxisView()) {
                int npix;
                for (i = ylast + yskip; i < h && (npix = this.fillLine(vol, vol_offset, img, i, w, x0, w - 1, xskip, startX, startY, startZ, xstep, ystep)) > 0; i += yskip) {
                }
            }
            if (seggrid != null && (this.inIdx >= 0 || this.outIdx >= 0)) {
                iz = 0;
                iy = 0;
                ix = 0;
                rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
                riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
                riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
                int sum = 0;
                for (int i2 = ybegin; i2 < yend; i2 += yskip) {
                    int yoffset = i2 * w;
                    int xstart = tidx[i2][0];
                    int xend = tidx[i2][1];
                    int six = rix + ixstep_x * xstart;
                    int siy = riy + ixstep_y * xstart;
                    int siz = riz + ixstep_z * xstart;
                    for (j = xstart + x0; j < xend; j += xskip) {
                        int bmod;
                        int roffset0;
                        int poffset0;
                        int vidx;
                        int bidx;
                        boolean jval = false;
                        int jix = six + 0;
                        int jiy = siy + 0;
                        int jiz = siz + 0;
                        ix = jix >> 15;
                        iy = jiy >> 15;
                        iz = jiz >> 15;
                        byte value = (byte)this.outIdx;
                        if (iz >= 0 && (seggrid[bidx = (vidx = (poffset0 = iz * psize) + (roffset0 = iy * dx) + ix) >> 3] & 1 << (bmod = vidx % 8)) != 0) {
                            value = (byte)this.inIdx;
                            ++sum;
                        }
                        overlay[yoffset + j] = value;
                        six += xskip_x;
                        siy += xskip_y;
                        siz += xskip_z;
                    }
                    rix += yskip_x;
                    riy += yskip_y;
                    riz += yskip_z;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            // empty catch block
        }
    }

    public void mpr_tl(int x0, int y0, int x1, int y1, int xskip, int yskip, byte[] vol, byte[] seggrid, int vol_offset, short[] img, short[] overlay, int w, int h) {
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int psize = dx * dy;
        int[][] tidx = this.getViewPlaneIntersectBounds();
        double startX = mpr.getViewStartCoord(0, w, h, lookpt, xstep, ystep, dx);
        double startY = mpr.getViewStartCoord(1, w, h, lookpt, xstep, ystep, dy);
        double startZ = mpr.getViewStartCoord(2, w, h, lookpt, xstep, ystep, dz);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        ystart -= ystart % yskip;
        try {
            int j;
            int i;
            int ybegin = ystart + y0;
            int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
            int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
            int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
            int ylast = ybegin;
            for (i = ybegin; i < yend; i += yskip) {
                int yoffset = i * w;
                int xstart = mpr.startval(tidx[i][0], x0, xskip);
                int xend = tidx[i][1];
                ylast = i;
                int six = rix + ixstep_x * xstart;
                int siy = riy + ixstep_y * xstart;
                int siz = riz + ixstep_z * xstart;
                int xlast = xstart;
                for (j = xstart; j < xend; j += xskip) {
                    int frac0_x = six & Short.MAX_VALUE;
                    int frac0_y = siy & Short.MAX_VALUE;
                    int frac0_z = siz & Short.MAX_VALUE;
                    ix = six >> 15;
                    iy = siy >> 15;
                    iz = siz >> 15;
                    int poffset0 = vol_offset + iz * psize;
                    int roffset0 = iy * dx;
                    int vidx = poffset0 + roffset0 + ix;
                    int vidx_n = vidx + psize;
                    int voxel0 = vol[vidx] & 0xFF;
                    int voxel1 = vol[vidx + 1] & 0xFF;
                    int voxel2 = vol[vidx + dx] & 0xFF;
                    int voxel3 = vol[vidx + dx + 1] & 0xFF;
                    int voxel4 = vol[vidx_n] & 0xFF;
                    int voxel5 = vol[vidx_n + 1] & 0xFF;
                    int voxel6 = vol[vidx_n + dx] & 0xFF;
                    int voxel7 = vol[vidx_n + dx + 1] & 0xFF;
                    int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                    int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                    int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                    int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                    int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                    int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                    int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                    img[yoffset + j] = (short)voxel;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                    xlast = j;
                }
                if (this.isMajorAxisView()) {
                    // empty if block
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
            if (this.isMajorAxisView()) {
                for (i = ylast + yskip; i < h; i += yskip) {
                }
            }
            if (seggrid != null && (this.inIdx >= 0 || this.outIdx >= 0)) {
                iz = 0;
                iy = 0;
                ix = 0;
                rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
                riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
                riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
                int sum = 0;
                for (int i2 = ybegin; i2 < yend; i2 += yskip) {
                    int yoffset = i2 * w;
                    int xstart = tidx[i2][0];
                    int xend = tidx[i2][1];
                    int six = rix + ixstep_x * xstart;
                    int siy = riy + ixstep_y * xstart;
                    int siz = riz + ixstep_z * xstart;
                    for (j = xstart + x0; j < xend; j += xskip) {
                        int bmod;
                        int roffset0;
                        int poffset0;
                        int vidx;
                        int bidx;
                        boolean jval = false;
                        int jix = six + 0;
                        int jiy = siy + 0;
                        int jiz = siz + 0;
                        ix = jix >> 15;
                        iy = jiy >> 15;
                        iz = jiz >> 15;
                        byte value = (byte)this.outIdx;
                        if (iz >= 0 && (seggrid[bidx = (vidx = (poffset0 = iz * psize) + (roffset0 = iy * dx) + ix) >> 3] & 1 << (bmod = vidx % 8)) != 0) {
                            value = (byte)this.inIdx;
                            ++sum;
                        }
                        overlay[yoffset + j] = value;
                        six += xskip_x;
                        siy += xskip_y;
                        siz += xskip_z;
                    }
                    rix += yskip_x;
                    riy += yskip_y;
                    riz += yskip_z;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("ERROR: mpr_byte[trilinear] Bad array idx: [" + ix + "," + iy + "," + iz + "]");
            aie.printStackTrace();
        }
    }

    public void mpr_tl(int x0, int y0, int x1, int y1, int xskip, int yskip, byte[] vol, int[] cmap, int vol_offset, int[] img, int w, int h) {
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int psize = dx * dy;
        int[][] tidx = this.getViewPlaneIntersectBounds();
        double startX = mpr.getViewStartCoord(0, w, h, lookpt, xstep, ystep, dx);
        double startY = mpr.getViewStartCoord(1, w, h, lookpt, xstep, ystep, dy);
        double startZ = mpr.getViewStartCoord(2, w, h, lookpt, xstep, ystep, dz);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int RMASK = 0xFF0000;
        int GMASK = 65280;
        int BMASK = 255;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        ystart -= ystart % yskip;
        try {
            int ybegin = ystart + y0;
            int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
            int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
            int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
            for (int i = ybegin; i < yend; i += yskip) {
                int yoffset = i * w;
                int xstart = mpr.startval(tidx[i][0], x0, xskip);
                int xend = tidx[i][1];
                int six = rix + ixstep_x * xstart;
                int siy = riy + ixstep_y * xstart;
                int siz = riz + ixstep_z * xstart;
                for (int j = xstart; j < xend; j += xskip) {
                    int frac0_x = six & Short.MAX_VALUE;
                    int frac0_y = siy & Short.MAX_VALUE;
                    int frac0_z = siz & Short.MAX_VALUE;
                    ix = six >> 15;
                    iy = siy >> 15;
                    iz = siz >> 15;
                    int poffset0 = vol_offset + iz * psize;
                    int roffset0 = iy * dx;
                    int roffset1 = roffset0 + dx;
                    int poffset1 = poffset0 + psize;
                    int vidx = poffset0 + roffset0 + ix;
                    int vox0 = cmap[vol[vidx] & 0xFF];
                    int vox1 = cmap[vol[vidx + 1] & 0xFF];
                    int vox2 = cmap[vol[poffset0 + roffset1 + ix] & 0xFF];
                    int vox3 = cmap[vol[poffset0 + roffset1 + ix + 1] & 0xFF];
                    int vox4 = cmap[vol[poffset1 + roffset0 + ix] & 0xFF];
                    int vox5 = cmap[vol[poffset1 + roffset0 + ix + 1] & 0xFF];
                    int vox6 = cmap[vol[poffset1 + roffset1 + ix] & 0xFF];
                    int vox7 = cmap[vol[poffset1 + roffset1 + ix + 1] & 0xFF];
                    int red_voxel = 0;
                    int green_voxel = 0;
                    int blue_voxel = 0;
                    int voxel0 = (vox0 & 0xFF0000) >> 16;
                    int voxel1 = (vox1 & 0xFF0000) >> 16;
                    int voxel2 = (vox2 & 0xFF0000) >> 16;
                    int voxel3 = (vox3 & 0xFF0000) >> 16;
                    int voxel4 = (vox4 & 0xFF0000) >> 16;
                    int voxel5 = (vox5 & 0xFF0000) >> 16;
                    int voxel6 = (vox6 & 0xFF0000) >> 16;
                    int voxel7 = (vox7 & 0xFF0000) >> 16;
                    int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                    int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                    int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                    int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                    int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                    int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                    red_voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                    voxel0 = (vox0 & 0xFF00) >> 8;
                    voxel1 = (vox1 & 0xFF00) >> 8;
                    voxel2 = (vox2 & 0xFF00) >> 8;
                    voxel3 = (vox3 & 0xFF00) >> 8;
                    voxel4 = (vox4 & 0xFF00) >> 8;
                    voxel5 = (vox5 & 0xFF00) >> 8;
                    voxel6 = (vox6 & 0xFF00) >> 8;
                    voxel7 = (vox7 & 0xFF00) >> 8;
                    voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                    voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                    voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                    voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                    voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                    voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                    green_voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                    voxel0 = vox0 & 0xFF;
                    voxel1 = vox1 & 0xFF;
                    voxel2 = vox2 & 0xFF;
                    voxel3 = vox3 & 0xFF;
                    voxel4 = vox4 & 0xFF;
                    voxel5 = vox5 & 0xFF;
                    voxel6 = vox6 & 0xFF;
                    voxel7 = vox7 & 0xFF;
                    voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                    voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                    voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                    voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                    voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                    voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                    blue_voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                    img[yoffset + j] = 0xFF000000 | (red_voxel & 0xFF) << 16 | (green_voxel & 0xFF) << 8 | blue_voxel & 0xFF;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("mpr-8bit[trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "]");
            aie.printStackTrace();
        }
    }

    public void mpr_fused_tl(int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol0, short[] seggrid, int vol_offset, short[] img, short[] overlay, int w, int h) {
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int psize = dx * dy;
        int[][] tidx = this.getViewPlaneIntersectBounds();
        double startX = mpr.getViewStartCoord(0, w, h, lookpt, xstep, ystep, dx);
        double startY = mpr.getViewStartCoord(1, w, h, lookpt, xstep, ystep, dy);
        double startZ = mpr.getViewStartCoord(2, w, h, lookpt, xstep, ystep, dz);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        ystart -= ystart % yskip;
        try {
            int j;
            int xlast;
            int siz;
            int siy;
            int six;
            int xend;
            int xstart;
            int yoffset;
            int i;
            int ybegin = ystart + y0;
            int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
            int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
            int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
            for (i = ybegin; i < yend; i += yskip) {
                yoffset = i * w;
                xstart = mpr.startval(tidx[i][0], x0, xskip);
                xend = tidx[i][1];
                six = rix + ixstep_x * xstart;
                siy = riy + ixstep_y * xstart;
                siz = riz + ixstep_z * xstart;
                xlast = xstart;
                for (j = xstart; j < xend; j += xskip) {
                    int frac0_x = six & Short.MAX_VALUE;
                    int frac0_y = siy & Short.MAX_VALUE;
                    int frac0_z = siz & Short.MAX_VALUE;
                    ix = six >> 15;
                    iy = siy >> 15;
                    iz = siz >> 15;
                    int poffset0 = vol_offset + iz * psize;
                    int roffset0 = iy * dx;
                    int roffset1 = roffset0 + dx;
                    int poffset1 = poffset0 + psize;
                    int vidx = poffset0 + roffset0 + ix;
                    short voxel0 = vol0[vidx];
                    short voxel1 = vol0[vidx + 1];
                    short voxel2 = vol0[poffset0 + roffset1 + ix];
                    short voxel3 = vol0[poffset0 + roffset1 + ix + 1];
                    short voxel4 = vol0[poffset1 + roffset0 + ix];
                    short voxel5 = vol0[poffset1 + roffset0 + ix + 1];
                    short voxel6 = vol0[poffset1 + roffset1 + ix];
                    short voxel7 = vol0[poffset1 + roffset1 + ix + 1];
                    int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                    int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                    int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                    int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                    int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                    int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                    int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                    img[yoffset + j] = (short)voxel;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                    xlast = j;
                }
                if (this.isMajorAxisView()) {
                    this.fillLineEdges(vol0, vol_offset, img, i, w, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep);
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
            if (seggrid != null) {
                rix = (int)((startX + 0.5 + ystep[0] * (double)ybegin) * 32768.0);
                riy = (int)((startY + 0.5 + ystep[1] * (double)ybegin) * 32768.0);
                riz = (int)((startZ + 0.5 + ystep[2] * (double)ybegin) * 32768.0);
                for (i = ybegin; i < yend; i += yskip) {
                    yoffset = i * w;
                    xstart = mpr.startval(tidx[i][0], x0, xskip);
                    xend = tidx[i][1];
                    six = rix + ixstep_x * xstart;
                    siy = riy + ixstep_y * xstart;
                    siz = riz + ixstep_z * xstart;
                    xlast = xstart;
                    for (j = xstart; j < xend; j += xskip) {
                        ix = six >> 15;
                        iy = siy >> 15;
                        iz = siz >> 15;
                        int poffset0 = vol_offset + iz * psize;
                        int roffset0 = iy * dx;
                        int vidx = poffset0 + roffset0 + ix;
                        short voxel = seggrid[vidx];
                        overlay[yoffset + j] = voxel;
                        six += xskip_x;
                        siy += xskip_y;
                        siz += xskip_z;
                        xlast = j;
                    }
                    if (this.isMajorAxisView()) {
                        this.fillLineEdges(vol0, vol_offset, img, i, w, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep);
                    }
                    rix += yskip_x;
                    riy += yskip_y;
                    riz += yskip_z;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("mpr[fused-trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "]");
        }
    }

    public void mpr_fused_tl(int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol0, byte[] seggrid, int vol_offset, short[] img, short[] overlay, int w, int h) {
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int psize = dx * dy;
        int[][] tidx = this.getViewPlaneIntersectBounds();
        double startX = mpr.getViewStartCoord(0, w, h, lookpt, xstep, ystep, dx);
        double startY = mpr.getViewStartCoord(1, w, h, lookpt, xstep, ystep, dy);
        double startZ = mpr.getViewStartCoord(2, w, h, lookpt, xstep, ystep, dz);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        ystart -= ystart % yskip;
        try {
            int j;
            int xlast;
            int siz;
            int siy;
            int six;
            int xend;
            int xstart;
            int yoffset;
            int i;
            int ybegin = ystart + y0;
            int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
            int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
            int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
            for (i = ybegin; i < yend; i += yskip) {
                yoffset = i * w;
                xstart = mpr.startval(tidx[i][0], x0, xskip);
                xend = tidx[i][1];
                six = rix + ixstep_x * xstart;
                siy = riy + ixstep_y * xstart;
                siz = riz + ixstep_z * xstart;
                xlast = xstart;
                for (j = xstart; j < xend; j += xskip) {
                    int frac0_x = six & Short.MAX_VALUE;
                    int frac0_y = siy & Short.MAX_VALUE;
                    int frac0_z = siz & Short.MAX_VALUE;
                    ix = six >> 15;
                    iy = siy >> 15;
                    iz = siz >> 15;
                    int poffset0 = vol_offset + iz * psize;
                    int roffset0 = iy * dx;
                    int roffset1 = roffset0 + dx;
                    int poffset1 = poffset0 + psize;
                    int vidx = poffset0 + roffset0 + ix;
                    short voxel0 = vol0[vidx];
                    short voxel1 = vol0[vidx + 1];
                    short voxel2 = vol0[poffset0 + roffset1 + ix];
                    short voxel3 = vol0[poffset0 + roffset1 + ix + 1];
                    short voxel4 = vol0[poffset1 + roffset0 + ix];
                    short voxel5 = vol0[poffset1 + roffset0 + ix + 1];
                    short voxel6 = vol0[poffset1 + roffset1 + ix];
                    short voxel7 = vol0[poffset1 + roffset1 + ix + 1];
                    int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                    int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                    int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                    int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                    int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                    int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                    int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                    img[yoffset + j] = (short)voxel;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                    xlast = j;
                }
                if (this.isMajorAxisView()) {
                    this.fillLineEdges(vol0, vol_offset, img, i, w, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep);
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
            if (seggrid != null) {
                rix = (int)((startX + 0.5 + ystep[0] * (double)ybegin) * 32768.0);
                riy = (int)((startY + 0.5 + ystep[1] * (double)ybegin) * 32768.0);
                riz = (int)((startZ + 0.5 + ystep[2] * (double)ybegin) * 32768.0);
                for (i = ybegin; i < yend; i += yskip) {
                    yoffset = i * w;
                    xstart = mpr.startval(tidx[i][0], x0, xskip);
                    xend = tidx[i][1];
                    six = rix + ixstep_x * xstart;
                    siy = riy + ixstep_y * xstart;
                    siz = riz + ixstep_z * xstart;
                    xlast = xstart;
                    for (j = xstart; j < xend; j += xskip) {
                        ix = six >> 15;
                        iy = siy >> 15;
                        iz = siz >> 15;
                        int poffset0 = vol_offset + iz * psize;
                        int roffset0 = iy * dx;
                        int vidx = poffset0 + roffset0 + ix;
                        byte voxel = seggrid[vidx];
                        overlay[yoffset + j] = voxel;
                        six += xskip_x;
                        siy += xskip_y;
                        siz += xskip_z;
                        xlast = j;
                    }
                    if (this.isMajorAxisView()) {
                        this.fillLineEdges(vol0, vol_offset, img, i, w, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep);
                    }
                    rix += yskip_x;
                    riy += yskip_y;
                    riz += yskip_z;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("mpr[fused-trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "]");
        }
    }

    public void mpr_tc(int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w, int h) {
        this.mpr_tc_float(x0, y0, x1, y1, xskip, yskip, vol, vol_offset, img, w, h);
    }

    private void mpr_tc_float(int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w, int h) {
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int psize = dx * dy;
        int[][] tidx = this.getViewPlaneIntersectBounds();
        double startX = mpr.getViewStartCoord(0, w, h, lookpt, xstep, ystep, dx) + (double)x0 * xstep[0] + (double)y0 * ystep[0];
        double startY = mpr.getViewStartCoord(1, w, h, lookpt, xstep, ystep, dy) + (double)x0 * xstep[1] + (double)y0 * ystep[1];
        double startZ = mpr.getViewStartCoord(2, w, h, lookpt, xstep, ystep, dz) + (double)x0 * xstep[2] + (double)y0 * ystep[2];
        double xskip_x = xstep[0] * (double)xskip;
        double xskip_y = xstep[1] * (double)xskip;
        double xskip_z = xstep[2] * (double)xskip;
        double yskip_x = ystep[0] * (double)yskip;
        double yskip_y = ystep[1] * (double)yskip;
        double yskip_z = ystep[2] * (double)yskip;
        ystart -= ystart % yskip;
        double xx = startX + ystep[0] * (double)ystart;
        double yy = startY + ystep[1] * (double)ystart;
        double zz = startZ + ystep[2] * (double)ystart;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        try {
            boolean majorAxisView = this.isMajorAxisView();
            int ylast = ystart + y0;
            for (int i = ystart + y0; i < yend; i += yskip) {
                int yoffset = i * w;
                int xstart = tidx[i][0];
                int xend = tidx[i][1];
                ylast = i;
                if (majorAxisView) {
                    xstart = Math.max(0, xstart - 5);
                    xend = Math.min(w, xend + 5);
                }
                xstart -= xstart % xskip;
                double sx = xx + xstep[0] * (double)xstart;
                double sy = yy + xstep[1] * (double)xstart;
                double sz = zz + xstep[2] * (double)xstart;
                for (int j = xstart + x0; j < xend; j += xskip) {
                    ix = (int)sx;
                    iy = (int)sy;
                    iz = (int)sz;
                    double fracX = sx - (double)ix;
                    double fracY = sy - (double)iy;
                    double fracZ = sz - (double)iz;
                    int poffset0 = vol_offset + iz * psize;
                    int roffset0 = iy * dx;
                    double result = 0.0;
                    for (int iw = 0; iw < 4; ++iw) {
                        double ww = mpr.tricubicKernel(fracZ, iw);
                        int iiz = iw - 1 + iz;
                        if (iiz < 0) {
                            iiz = -iiz;
                        } else if (iiz > dz - 1) {
                            iiz = 2 * dz - 1 - iiz;
                        }
                        int nzoffset = vol_offset + iiz * psize;
                        for (int it = 0; it < 4; ++it) {
                            double tt = mpr.tricubicKernel(fracY, it);
                            double wwtt = ww * tt;
                            int iiy = it - 1 + iy;
                            if (iiy < 0) {
                                iiy = -iiy;
                            } else if (iiy > dy - 1) {
                                iiy = 2 * dy - 1 - iiy;
                            }
                            int noffset = nzoffset + iiy * dx;
                            for (int is = 0; is < 4; ++is) {
                                double ss = mpr.tricubicKernel(fracX, is);
                                int iix = is - 1 + ix;
                                if (iix < 0) {
                                    iix = -iix;
                                } else if (iix > dx - 1) {
                                    iix = 2 * dx - 1 - iix;
                                }
                                result += (double)vol[noffset + iix] * ss * wwtt;
                            }
                        }
                    }
                    img[yoffset + j] = (short)(result / 8.0);
                    sx += xskip_x;
                    sy += xskip_y;
                    sz += xskip_z;
                }
                xx += yskip_x;
                yy += yskip_y;
                zz += yskip_z;
            }
            if (this.isMajorAxisView()) {
                int npix;
                double sX = mpr.getViewStartCoord(0, w, h, lookpt, xstep, ystep, dx);
                double sY = mpr.getViewStartCoord(1, w, h, lookpt, xstep, ystep, dy);
                double sZ = mpr.getViewStartCoord(2, w, h, lookpt, xstep, ystep, dz);
                for (int i = ylast + yskip; i < h && (npix = this.fillLine(vol, vol_offset, img, i, w, x0, w - 1, xskip, sX, sY, sZ, xstep, ystep)) > 0; i += yskip) {
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("mpr[tricubic]: Bad array idx: [" + ix + "," + iy + "," + iz + "]");
        }
    }

    private void mpr_tc_int(int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w, int h) {
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int psize = dx * dy;
        int[][] tidx = this.getViewPlaneIntersectBounds();
        double startX = mpr.getViewStartCoord(0, w, h, lookpt, xstep, ystep, dx) + (double)x0 * xstep[0] + (double)y0 * ystep[0];
        double startY = mpr.getViewStartCoord(1, w, h, lookpt, xstep, ystep, dy) + (double)x0 * xstep[1] + (double)y0 * ystep[1];
        double startZ = mpr.getViewStartCoord(2, w, h, lookpt, xstep, ystep, dz) + (double)x0 * xstep[2] + (double)y0 * ystep[2];
        double xskip_x = xstep[0] * (double)xskip;
        double xskip_y = xstep[1] * (double)xskip;
        double xskip_z = xstep[2] * (double)xskip;
        double yskip_x = ystep[0] * (double)yskip;
        double yskip_y = ystep[1] * (double)yskip;
        double yskip_z = ystep[2] * (double)yskip;
        ystart -= ystart % yskip;
        double xx = startX + ystep[0] * (double)ystart;
        double yy = startY + ystep[1] * (double)ystart;
        double zz = startZ + ystep[2] * (double)ystart;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        try {
            boolean majorAxisView = this.isMajorAxisView();
            for (int i = ystart + y0; i < yend; i += yskip) {
                int yoffset = i * w;
                int xstart = tidx[i][0];
                int xend = tidx[i][1];
                xstart -= xstart % xskip;
                double sx = xx + xstep[0] * (double)xstart;
                double sy = yy + xstep[1] * (double)xstart;
                double sz = zz + xstep[2] * (double)xstart;
                int xlast = xstart;
                int xlast_idx = xstart + x0;
                for (int j = xstart + x0; j < xend; j += xskip) {
                    ix = (int)sx;
                    iy = (int)sy;
                    iz = (int)sz;
                    double fX = sx - (double)ix;
                    double fY = sy - (double)iy;
                    double fZ = sz - (double)iz;
                    double fX2 = fX * fX;
                    double fY2 = fY * fY;
                    double fZ2 = fZ * fZ;
                    double fX3 = fX2 * fX;
                    double fY3 = fY2 * fY;
                    double fZ3 = fZ2 * fZ;
                    int poffset0 = vol_offset + iz * psize;
                    int roffset0 = iy * dx;
                    int vidx = poffset0 + roffset0 + ix;
                    double result = 0.0;
                    for (int iw = 0; iw < 4; ++iw) {
                        double ww = mpr.tricubicKernel2(fZ, fZ2, fZ3, iw);
                        for (int it = 0; it < 4; ++it) {
                            double tt = mpr.tricubicKernel2(fY, fY2, fY3, it);
                            double wwtt = ww * tt;
                            for (int is = 0; is < 4; ++is) {
                                double ss = mpr.tricubicKernel2(fX, fX2, fX3, is);
                                result += (double)vol[vidx + (is - 1 + (it - 1) * dx + (iw - 1) * psize)] * ss * wwtt;
                            }
                        }
                    }
                    img[yoffset + j] = (short)(result / 8.0);
                    sx += xskip_x;
                    sy += xskip_y;
                    sz += xskip_z;
                    xlast += xskip;
                    xlast_idx = j;
                }
                if (majorAxisView) {
                    int iiz;
                    int iiy;
                    int iix;
                    double ss;
                    double wwtt;
                    double tt;
                    double ww;
                    double result;
                    int roffset0;
                    int poffset0;
                    double fZ3;
                    double fY3;
                    double fX3;
                    double fZ2;
                    double fY2;
                    double fX2;
                    double fZ;
                    double fY;
                    double fX;
                    int j;
                    int xbegin = xstart - xskip;
                    sx = xx + xstep[0] * (double)xbegin;
                    sy = yy + xstep[1] * (double)xbegin;
                    sz = zz + xstep[2] * (double)xbegin;
                    for (j = xstart + x0 - xskip; j >= 0; j -= xskip) {
                        ix = (int)sx;
                        iy = (int)sy;
                        iz = (int)sz;
                        fX = sx - (double)ix;
                        fY = sy - (double)iy;
                        fZ = sz - (double)iz;
                        fX2 = fX * fX;
                        fY2 = fY * fY;
                        fZ2 = fZ * fZ;
                        fX3 = fX2 * fX;
                        fY3 = fY2 * fY;
                        fZ3 = fZ2 * fZ;
                        poffset0 = vol_offset + iz * psize;
                        roffset0 = iy * dx;
                        int vidx = poffset0 + roffset0 + ix;
                        result = 0.0;
                        for (int iw = 0; iw < 4; ++iw) {
                            ww = mpr.tricubicKernel2(fZ, fZ2, fZ3, iw);
                            for (int it = 0; it < 4; ++it) {
                                tt = mpr.tricubicKernel2(fY, fY2, fY3, it);
                                wwtt = ww * tt;
                                for (int is = 0; is < 4; ++is) {
                                    ss = mpr.tricubicKernel2(fX, fX2, fX3, is);
                                    iix = is - 1 + ix;
                                    iiy = it - 1 + iy;
                                    iiz = iw - 1 + iz;
                                    if (iix < 0 || iix > dx - 1 || iiy < 0 || iiy > dy - 1 || iiz < 0 || iiz > dz - 1) continue;
                                    result += (double)vol[vidx + (is - 1 + (it - 1) * dx + (iw - 1) * psize)] * ss * wwtt;
                                }
                            }
                        }
                        img[yoffset + j] = (short)(result / 8.0);
                        sx -= xskip_x;
                        sy -= xskip_y;
                        sz -= xskip_z;
                    }
                    sx = xx + xstep[0] * (double)xlast;
                    sy = yy + xstep[1] * (double)xlast;
                    sz = zz + xstep[2] * (double)xlast;
                    for (j = xlast_idx + xskip; j < w; j += xskip) {
                        ix = (int)sx;
                        iy = (int)sy;
                        iz = (int)sz;
                        fX = sx - (double)ix;
                        fY = sy - (double)iy;
                        fZ = sz - (double)iz;
                        fX2 = fX * fX;
                        fY2 = fY * fY;
                        fZ2 = fZ * fZ;
                        fX3 = fX2 * fX;
                        fY3 = fY2 * fY;
                        fZ3 = fZ2 * fZ;
                        poffset0 = vol_offset + iz * psize;
                        roffset0 = iy * dx;
                        int vidx = poffset0 + roffset0 + ix;
                        result = 0.0;
                        for (int iw = 0; iw < 4; ++iw) {
                            ww = mpr.tricubicKernel2(fZ, fZ2, fZ3, iw);
                            for (int it = 0; it < 4; ++it) {
                                tt = mpr.tricubicKernel2(fY, fY2, fY3, it);
                                wwtt = ww * tt;
                                for (int is = 0; is < 4; ++is) {
                                    ss = mpr.tricubicKernel2(fX, fX2, fX3, is);
                                    iix = is - 1 + ix;
                                    iiy = it - 1 + iy;
                                    iiz = iw - 1 + iz;
                                    if (iix < 0 || iix > dx - 1 || iiy < 0 || iiy > dy - 1 || iiz < 0 || iiz > dz - 1) continue;
                                    result += (double)vol[vidx + (is - 1 + (it - 1) * dx + (iw - 1) * psize)] * ss * wwtt;
                                }
                            }
                        }
                        img[yoffset + j] = (short)(result / 8.0);
                        sx += xskip_x;
                        sy += xskip_y;
                        sz += xskip_z;
                    }
                }
                xx += yskip_x;
                yy += yskip_y;
                zz += yskip_z;
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("mpr[tricubic]: Bad array idx: [" + ix + "," + iy + "," + iz + "]");
        }
    }

    public static final double tricubicKernel(double x, int iter) {
        switch (iter) {
            case 0: {
                return ((2.0 - x) * x - 1.0) * x;
            }
            case 1: {
                return (3.0 * x - 5.0) * x * x + 2.0;
            }
            case 2: {
                return ((4.0 - 3.0 * x) * x + 1.0) * x;
            }
            case 3: {
                return (x - 1.0) * x * x;
            }
        }
        return 0.0;
    }

    public static final double tricubicKernel2(double x, double x2, double x3, int iter) {
        switch (iter) {
            case 0: {
                return 2.0 * x2 - x3 - x;
            }
            case 1: {
                return 3.0 * x3 - 5.0 * x2 + 2.0;
            }
            case 2: {
                return 4.0 * x2 - 3.0 * x3 + x;
            }
            case 3: {
                return x3 - x2;
            }
        }
        return 0.0;
    }

    public final void setSegmentationIndex(int inIndex, int outIndex) {
        this.inIdx = inIndex;
        this.outIdx = outIndex;
    }

    public void mpr_nn(int x0, int y0, int x1, int y1, int xskip, int yskip, byte[] bvol, short[] img, int w, int h) {
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int rowsize = dx + 7 >> 3;
        int bpsize = rowsize * dy;
        int[][] tidx = this.getViewPlaneIntersectBounds();
        double startX = mpr.getViewStartCoord(0, w, h, lookpt, xstep, ystep, dx);
        double startY = mpr.getViewStartCoord(1, w, h, lookpt, xstep, ystep, dy);
        double startZ = mpr.getViewStartCoord(2, w, h, lookpt, xstep, ystep, dz);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        int rix = (int)((startX + ystep[0] * (double)ystart) * 32768.0);
        int riy = (int)((startY + ystep[1] * (double)ystart) * 32768.0);
        int riz = (int)((startZ + ystep[2] * (double)ystart) * 32768.0);
        try {
            ystart -= ystart % yskip;
            int ylast = ystart + y0;
            for (int i = ystart + y0; i < yend; i += yskip) {
                int yoffset = i * w;
                int xstart = mpr.startval(tidx[i][0], x0, xskip);
                int xend = tidx[i][1];
                int six = rix + ixstep_x * xstart;
                int siy = riy + ixstep_y * xstart;
                int siz = riz + ixstep_z * xstart;
                ylast = i;
                int xlast = xstart;
                for (int j = xstart; j < xend; j += xskip) {
                    iz = siz >> 15;
                    int poffset0 = iz * bpsize;
                    iy = siy >> 15;
                    int roffset0 = iy * rowsize;
                    ix = six >> 15;
                    byte volitem = bvol[poffset0 + roffset0 + (ix >> 3)];
                    int bmod0 = ix % 8;
                    boolean voxel0 = (volitem & 1 << bmod0) != 0;
                    img[yoffset + j] = (short)(voxel0 ? 1 : 0);
                    xlast = j;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("ERROR: mpr-bingrid[nn] Bad array idx: [" + ix + "," + iy + "," + iz + "]");
            aie.printStackTrace();
        }
    }

    public void mpr_tl(int x0, int y0, int x1, int y1, int xskip, int yskip, byte[] bvol, short[] img, int w, int h) {
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int rowsize = dx + 7 >> 3;
        int bpsize = rowsize * dy;
        int[][] tidx = this.getViewPlaneIntersectBounds();
        double startX = mpr.getViewStartCoord(0, w, h, lookpt, xstep, ystep, dx);
        double startY = mpr.getViewStartCoord(1, w, h, lookpt, xstep, ystep, dy);
        double startZ = mpr.getViewStartCoord(2, w, h, lookpt, xstep, ystep, dz);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        ystart -= ystart % yskip;
        try {
            int ybegin = ystart + y0;
            int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
            int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
            int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
            int ylast = ybegin;
            for (int i = ybegin; i < yend; i += yskip) {
                int yoffset = i * w;
                int xstart = mpr.startval(tidx[i][0], x0, xskip);
                int xend = tidx[i][1];
                ylast = i;
                int six = rix + ixstep_x * xstart;
                int siy = riy + ixstep_y * xstart;
                int siz = riz + ixstep_z * xstart;
                int xlast = xstart;
                for (int j = xstart; j < xend; j += xskip) {
                    int frac0_x = six & Short.MAX_VALUE;
                    int frac0_y = siy & Short.MAX_VALUE;
                    int frac0_z = siz & Short.MAX_VALUE;
                    ix = six >> 15;
                    iy = siy >> 15;
                    iz = siz >> 15;
                    int bdiv0 = ix >> 3;
                    int bdiv1 = ix + 1 >> 3;
                    int bmod0 = ix % 8;
                    int bmod1 = (ix + 1) % 8;
                    int poffset0 = iz * bpsize;
                    int roffset0 = iy * rowsize;
                    int vboffset = poffset0 + roffset0;
                    int vboffset_n = vboffset + bpsize;
                    int idx_voxel0 = vboffset + bdiv0;
                    int idx_voxel1 = vboffset + bdiv1;
                    int idx_voxel2 = vboffset + rowsize + bdiv0;
                    int idx_voxel3 = vboffset + rowsize + bdiv1;
                    int idx_voxel4 = vboffset_n + bdiv0;
                    int idx_voxel5 = vboffset_n + bdiv1;
                    int idx_voxel6 = vboffset_n + rowsize + bdiv0;
                    int idx_voxel7 = vboffset_n + rowsize + bdiv1;
                    int voxel0 = (bvol[idx_voxel0] & 1 << bmod0) != 0 ? 2048 : 0;
                    int voxel1 = (bvol[idx_voxel1] & 1 << bmod1) != 0 ? 2048 : 0;
                    int voxel2 = (bvol[idx_voxel2] & 1 << bmod0) != 0 ? 2048 : 0;
                    int voxel3 = (bvol[idx_voxel3] & 1 << bmod1) != 0 ? 2048 : 0;
                    int voxel4 = (bvol[idx_voxel4] & 1 << bmod0) != 0 ? 2048 : 0;
                    int voxel5 = (bvol[idx_voxel5] & 1 << bmod1) != 0 ? 2048 : 0;
                    int voxel6 = (bvol[idx_voxel6] & 1 << bmod0) != 0 ? 2048 : 0;
                    int voxel7 = (bvol[idx_voxel7] & 1 << bmod1) != 0 ? 2048 : 0;
                    int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                    int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                    int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                    int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                    int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                    int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                    int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                    img[yoffset + j] = (short)voxel;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                    xlast = j;
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("ERROR: mpr-bingrid[trilinear] Bad array idx: [" + ix + "," + iy + "," + iz + "]");
        }
    }

    private int fillLineEdges(short[] vol, int vol_offset, short[] outimg, int y, int width, int x0, int x1, int xskip, double sx, double sy, double sz, double[] xstep, double[] ystep) {
        double p;
        double p1;
        double p0;
        double p03;
        double p02;
        double p01;
        double p00;
        int voffset;
        double fz;
        double fy;
        double fx;
        int iz;
        int iy;
        int ix;
        int v7;
        int v6;
        int v5;
        int v4;
        int v3;
        int v2;
        int v1;
        int v0;
        double siz;
        double siy;
        double six;
        int j;
        int dimx = this.getVolDimX();
        int dimy = this.getVolDimY();
        int dimz = this.getVolDimZ();
        int noContent = this.getNoContentPixel();
        int psize = dimx * dimy;
        int npixels = 0;
        double rix = sx + ystep[0] * (double)y;
        double riy = sy + ystep[1] * (double)y;
        double riz = sz + ystep[2] * (double)y;
        int yoffset = y * width;
        for (j = x0 - xskip; j >= 0; j -= xskip) {
            six = rix + xstep[0] * (double)j;
            siy = riy + xstep[1] * (double)j;
            siz = riz + xstep[2] * (double)j;
            v0 = noContent;
            v1 = noContent;
            v2 = noContent;
            v3 = noContent;
            v4 = noContent;
            v5 = noContent;
            v6 = noContent;
            v7 = noContent;
            ix = (int)six;
            iy = (int)siy;
            iz = (int)siz;
            fx = six - (double)ix;
            fy = siy - (double)iy;
            fz = siz - (double)iz;
            voffset = vol_offset + psize * iz + iy * dimx + ix;
            if (ix < 0 || ix >= dimx || iy < 0 || iy >= dimy || iz < 0 || iz >= dimz) continue;
            v0 = vol[voffset];
            if (ix < dimx - 1) {
                v1 = vol[voffset + 1];
            }
            if (iy < dimy - 1) {
                v2 = vol[voffset + dimx];
            }
            if (ix < dimx - 1 && iy < dimy - 1) {
                v3 = vol[voffset + dimx + 1];
            }
            if (iz < dimz - 1) {
                v4 = vol[voffset + psize];
                if (ix < dimx - 1) {
                    v5 = vol[voffset + psize + 1];
                }
                if (iy < dimy - 1) {
                    v6 = vol[voffset + psize + dimx];
                }
                if (ix < dimx - 1 && iy < dimy - 1) {
                    v7 = vol[voffset + psize + dimx + 1];
                }
            }
            if (six < 0.0) {
                v1 = noContent;
                v3 = noContent;
                v5 = noContent;
                v7 = noContent;
                fx = -fx;
            }
            if (siy < 0.0) {
                v2 = noContent;
                v3 = noContent;
                v6 = noContent;
                v7 = noContent;
                fy = -fy;
            }
            if (siz < 0.0) {
                v4 = noContent;
                v5 = noContent;
                v6 = noContent;
                v7 = noContent;
                fz = -fz;
            }
            p00 = (double)v0 + (double)(v1 - v0) * fx;
            p01 = (double)v2 + (double)(v3 - v2) * fx;
            p02 = (double)v4 + (double)(v5 - v4) * fx;
            p03 = (double)v6 + (double)(v7 - v6) * fx;
            p0 = p00 + (p01 - p00) * fy;
            p1 = p02 + (p03 - p02) * fy;
            p = p0 + (p1 - p0) * fz;
            outimg[yoffset + j] = (short)p;
            ++npixels;
        }
        for (j = x1 + xskip; j < width; j += xskip) {
            six = rix + xstep[0] * (double)j;
            siy = riy + xstep[1] * (double)j;
            siz = riz + xstep[2] * (double)j;
            v0 = noContent;
            v1 = noContent;
            v2 = noContent;
            v3 = noContent;
            v4 = noContent;
            v5 = noContent;
            v6 = noContent;
            v7 = noContent;
            ix = (int)six;
            iy = (int)siy;
            iz = (int)siz;
            fx = six - (double)ix;
            fy = siy - (double)iy;
            fz = siz - (double)iz;
            voffset = vol_offset + psize * iz + iy * dimx + ix;
            if (ix >= 0 && ix < dimx && iy >= 0 && iy < dimy && iz >= 0 && iz < dimz) {
                v0 = vol[voffset];
                if (ix < dimx - 1) {
                    v1 = vol[voffset + 1];
                }
                if (iy < dimy - 1) {
                    v2 = vol[voffset + dimx];
                }
                if (ix < dimx - 1 && iy < dimy - 1) {
                    v3 = vol[voffset + dimx + 1];
                }
                if (iz < dimz - 1) {
                    v4 = vol[voffset + psize];
                    if (ix < dimx - 1) {
                        v5 = vol[voffset + psize + 1];
                    }
                    if (iy < dimy - 1) {
                        v6 = vol[voffset + psize + dimx];
                    }
                    if (ix < dimx - 1 && iy < dimy - 1) {
                        v7 = vol[voffset + psize + dimx + 1];
                    }
                }
                if (six < 0.0) {
                    v1 = noContent;
                    v3 = noContent;
                    v5 = noContent;
                    v7 = noContent;
                    fx = -fx;
                }
                if (siy < 0.0) {
                    v2 = noContent;
                    v3 = noContent;
                    v6 = noContent;
                    v7 = noContent;
                    fy = -fy;
                }
                if (siz < 0.0) {
                    v4 = noContent;
                    v5 = noContent;
                    v6 = noContent;
                    v7 = noContent;
                    fz = -fz;
                }
                p00 = (double)v0 + (double)(v1 - v0) * fx;
                p01 = (double)v2 + (double)(v3 - v2) * fx;
                p02 = (double)v4 + (double)(v5 - v4) * fx;
                p03 = (double)v6 + (double)(v7 - v6) * fx;
                p0 = p00 + (p01 - p00) * fy;
                p1 = p02 + (p03 - p02) * fy;
                p = p0 + (p1 - p0) * fz;
                outimg[yoffset + j] = (short)p;
            }
            ++npixels;
        }
        return npixels;
    }

    private int fillLineEdgesNN(short[] vol, int vol_offset, short[] outimg, int y, int width, int x0, int x1, int xskip, double sx, double sy, double sz, double[] xstep, double[] ystep, double ROUND) {
        short v0;
        int voffset;
        int iz;
        int iy;
        int ix;
        double siz;
        double siy;
        double six;
        int j;
        int dimx = this.getVolDimX();
        int dimy = this.getVolDimY();
        int dimz = this.getVolDimZ();
        int psize = dimx * dimy;
        int npixels = 0;
        double rix = sx + ystep[0] * (double)y + ROUND;
        double riy = sy + ystep[1] * (double)y + ROUND;
        double riz = sz + ystep[2] * (double)y + ROUND;
        int yoffset = y * width;
        for (j = x0 - xskip; j >= 0; j -= xskip) {
            six = rix + xstep[0] * (double)j;
            siy = riy + xstep[1] * (double)j;
            siz = riz + xstep[2] * (double)j;
            ix = (int)Math.round(six);
            iy = (int)Math.round(siy);
            iz = (int)Math.round(siz);
            if (ix < 0 || ix >= dimx || iy < 0 || iy >= dimy || iz < 0 || iz >= dimz) continue;
            voffset = vol_offset + psize * iz + iy * dimx + ix;
            v0 = vol[voffset];
            outimg[yoffset + j] = v0;
            ++npixels;
        }
        for (j = x1 + xskip; j < width; j += xskip) {
            six = rix + xstep[0] * (double)j;
            siy = riy + xstep[1] * (double)j;
            siz = riz + xstep[2] * (double)j;
            ix = (int)Math.round(six);
            iy = (int)Math.round(siy);
            iz = (int)Math.round(siz);
            if (ix >= 0 && ix < dimx && iy >= 0 && iy < dimy && iz >= 0 && iz < dimz) {
                voffset = vol_offset + psize * iz + iy * dimx + ix;
                v0 = vol[voffset];
                outimg[yoffset + j] = v0;
            }
            ++npixels;
        }
        return npixels;
    }

    private int fillLine(short[] vol, int vol_offset, short[] outimg, int y, int width, int x0, int x1, int xskip, double sx, double sy, double sz, double[] xstep, double[] ystep) {
        int dimx = this.getVolDimX();
        int dimy = this.getVolDimY();
        int dimz = this.getVolDimZ();
        int psize = dimx * dimy;
        int npixels = 0;
        int noContent = this.getNoContentPixel();
        double rix = sx + ystep[0] * (double)y;
        double riy = sy + ystep[1] * (double)y;
        double riz = sz + ystep[2] * (double)y;
        double xstep_x = xstep[0] * (double)xskip;
        double xstep_y = xstep[1] * (double)xskip;
        double xstep_z = xstep[2] * (double)xskip;
        double vx = rix + xstep[0] * (double)x0;
        double vy = riy + xstep[1] * (double)x0;
        double vz = riz + xstep[2] * (double)x0;
        int yoffset = y * width;
        for (int j = x0; j <= x1; j += xskip) {
            int ix = (int)vx;
            int iy = (int)vy;
            int iz = (int)vz;
            double fx = vx - (double)ix;
            double fy = vy - (double)iy;
            double fz = vz - (double)iz;
            int voffset = vol_offset + psize * iz + iy * dimx + ix;
            int v0 = noContent;
            int v1 = noContent;
            int v2 = noContent;
            int v3 = noContent;
            int v4 = noContent;
            int v5 = noContent;
            int v6 = noContent;
            int v7 = noContent;
            if (vx >= 0.0 && vx < (double)dimx && vy >= 0.0 && vy < (double)dimy && vz >= 0.0 && vz < (double)dimz) {
                v0 = vol[voffset];
                if (ix < dimx - 1) {
                    v1 = vol[voffset + 1];
                }
                if (iy < dimy - 1) {
                    v2 = vol[voffset + dimx];
                }
                if (ix < dimx - 1 && iy < dimy - 1) {
                    v3 = vol[voffset + dimx + 1];
                }
                if (iz < dimz - 1) {
                    v4 = vol[voffset + psize];
                    if (ix < dimx - 1) {
                        v5 = vol[voffset + psize + 1];
                    }
                    if (iy < dimy - 1) {
                        v6 = vol[voffset + psize + dimx];
                    }
                    if (ix < dimx - 1 && iy < dimy - 1) {
                        v7 = vol[voffset + psize + dimx + 1];
                    }
                }
                if (vx < 0.0) {
                    v1 = noContent;
                    v3 = noContent;
                    v5 = noContent;
                    v7 = noContent;
                    fx = -fx;
                }
                if (vx < 0.0) {
                    v2 = noContent;
                    v3 = noContent;
                    v6 = noContent;
                    v7 = noContent;
                    fy = -fy;
                }
                if (vz < 0.0) {
                    v4 = noContent;
                    v5 = noContent;
                    v6 = noContent;
                    v7 = noContent;
                    fz = -fz;
                }
                double p00 = (double)v0 + (double)(v1 - v0) * fx;
                double p01 = (double)v2 + (double)(v3 - v2) * fx;
                double p02 = (double)v4 + (double)(v5 - v4) * fx;
                double p03 = (double)v6 + (double)(v7 - v6) * fx;
                double p0 = p00 + (p01 - p00) * fy;
                double p1 = p02 + (p03 - p02) * fy;
                double p = p0 + (p1 - p0) * fz;
                outimg[yoffset + j] = (short)p;
                ++npixels;
            }
            vx += xstep_x;
            vy += xstep_y;
            vz += xstep_z;
        }
        return npixels;
    }
}

