/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.Worker;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.mpr.MprQuad;
import com.ge.med.terra.jami.j3d.mpr.mpr;
import com.ge.med.terra.jami.render.PixelWindowing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProjectedMPR {
    private static ParallelTaskManager pmpr_ptm = new ParallelTaskManager();
    private static final short BORDER_VALUE = -1024;
    private static final short NO_CONTENT_VALUE = -8192;
    private List<MprQuad> mquads = new ArrayList<MprQuad>();
    private BufferedImage outimg = null;
    private BufferedImage filled_bmap = null;
    private BufferedImage outline_bmap = null;
    private BufferedImage lumimg = null;
    private short[] zbuffer = null;
    private short[] _lumbuffer = null;
    private byte[] _hitmap = null;
    private int width = 0;
    private int height = 0;
    private J3DVolumeModel jvm = null;
    private CPoint[] vox_pts = new CPoint[4];
    private CPoint[] disp_pts = new CPoint[4];
    private PixelWindowing pw = new PixelWindowing();
    private int[] rgb = new int[65536];
    private double wl = 600.0;
    private double ww = 1200.0;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private boolean iv_video = false;
    private IndexColorModel cmap = null;
    private PMprWorker[] pmpr_workers = null;
    private mpr mpr_engine = new mpr();
    private Color borderColor = new Color(0, 255, 0, 128);
    private Color backgroundColor = new Color(0, 0, 0);
    private double backgroundAlpha = 1.0;
    private double occlusionAlpha = 0.0;

    public ProjectedMPR() {
        int i;
        this.pmpr_workers = new PMprWorker[ParallelTaskManager.NCPUS];
        for (i = 0; i < this.pmpr_workers.length; ++i) {
            this.pmpr_workers[i] = new PMprWorker(pmpr_ptm, i, this.mpr_engine);
        }
        for (i = 0; i < this.vox_pts.length; ++i) {
            this.vox_pts[i] = new CPoint(0);
            this.disp_pts[i] = new CPoint(1);
        }
        this.setWindowing(750.0, 150.0, false, null, 1.0, -1024.0);
    }

    public int contains(int x, int y) {
        if (this._hitmap != null) {
            return this._hitmap[y * this.width + x];
        }
        return -1;
    }

    public void setWindowing(double ww, double wl, boolean iv_video, IndexColorModel cmap, double rescaleSlope, double rescaleIntercept) {
        if (ww != this.ww || wl != this.wl || rescaleSlope != this.rescaleSlope || rescaleIntercept != this.rescaleIntercept || iv_video != this.iv_video || cmap != this.cmap) {
            this.pw.fillColorTable(ww, wl, false, cmap, this.rgb, rescaleSlope, rescaleIntercept, 1);
        }
        this.cmap = cmap;
        this.iv_video = iv_video;
        this.ww = ww;
        this.wl = wl;
        this.rescaleIntercept = rescaleIntercept;
        this.rescaleSlope = rescaleSlope;
    }

    public boolean isInverseVideo() {
        return this.iv_video;
    }

    public double getWW() {
        return this.ww;
    }

    public double getWL() {
        return this.wl;
    }

    public int getNumQuads() {
        return this.mquads.size();
    }

    public int addQuad(CPoint ul, CPoint ur, CPoint br) {
        int id = this.mquads.size();
        MprQuad quad = new MprQuad(ul, ur, br);
        this.mquads.add(quad);
        return id;
    }

    public void setQuad(int id, CPoint ul, CPoint ur, CPoint br) {
        this.mquads.get(id).set(ul, ur, br);
    }

    public MprQuad getQuad(int id) {
        return this.mquads.get(id);
    }

    public void syncBuffers(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.outimg == null || this.outimg.getWidth() != width || this.outimg.getHeight() != height) {
            this.outimg = new BufferedImage(width, height, 2);
            this.filled_bmap = new BufferedImage(width, height, 12);
            this.outline_bmap = new BufferedImage(width, height, 12);
            this.lumimg = new BufferedImage(width, height, 11);
            this.zbuffer = new short[width * height];
            this._lumbuffer = new short[width * height];
            this._hitmap = new byte[width * height];
        }
    }

    public void initView(J3DVolumeModel jvm) {
        this.jvm = jvm;
        int[] outdata = ((DataBufferInt)this.outimg.getRaster().getDataBuffer()).getData();
        Arrays.fill(outdata, 0);
        byte[] fbmdata = ((DataBufferByte)this.filled_bmap.getRaster().getDataBuffer()).getData();
        Arrays.fill(fbmdata, (byte)0);
        byte[] obmdata = ((DataBufferByte)this.outline_bmap.getRaster().getDataBuffer()).getData();
        Arrays.fill(obmdata, (byte)0);
    }

    private static void calcDirVectors(JnMatrix4d m, double[] xdir, double[] ydir, double[] p) {
        p[0] = 0.0;
        p[1] = 0.0;
        p[2] = 1.0;
        double[] px = new double[]{1.0, 0.0, 1.0};
        double[] py = new double[]{0.0, 1.0, 1.0};
        m.transform(p);
        m.transform(px);
        m.transform(py);
        JnVector3d.sub(px, p, xdir);
        JnVector3d.sub(py, p, ydir);
    }

    private static double vlen(double[] v) {
        return Math.sqrt(v[0] * v[0] + v[1] * v[1]);
    }

    public void paintPolys(JnMatrix4d ras2display) {
        if (this.jvm != null) {
            JnMatrix4d display2vox = new JnMatrix4d(ras2display);
            display2vox.invert();
            JnMatrix4d ras2vox = this.jvm.getRAS2VoxelTransform();
            display2vox.mul(ras2vox);
            int PAD = this.jvm.j_vol.PAD;
            int dx = this.jvm.j_vol.dx;
            int dy = this.jvm.j_vol.dy;
            int dz = this.jvm.j_vol.dz;
            int pgsize = dx * dy;
            short[] voldata = ((JVolume.LinearShort)this.jvm.j_vol).volume;
            int width = this.outimg.getWidth();
            int height = this.outimg.getHeight();
            JnMatrix4d ras2voxel = this.jvm.getRAS2VoxelTransform();
            GeneralPath poly = new GeneralPath();
            double[] d_xdir = new double[3];
            double[] d_ydir = new double[3];
            JnMatrix4d tx_m = new JnMatrix4d();
            JnMatrix4d mm = new JnMatrix4d();
            Graphics2D gf_bmap = (Graphics2D)this.filled_bmap.getGraphics();
            gf_bmap.setColor(Color.white);
            Graphics2D go_bmap = (Graphics2D)this.outline_bmap.getGraphics();
            go_bmap.setColor(Color.white);
            go_bmap.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            go_bmap.setStroke(new BasicStroke(2.0f));
            Arrays.fill(this._hitmap, (byte)-1);
            Arrays.fill(this._lumbuffer, (short)-8192);
            Arrays.fill(this.zbuffer, (short)8192);
            short[] lumbuffer = ((DataBufferUShort)this.lumimg.getRaster().getDataBuffer()).getData();
            PMprWorkData pmpr_wd = new PMprWorkData(width, height, PAD, voldata, lumbuffer);
            pmpr_ptm.setWorkers(this.pmpr_workers);
            CPoint tx_raspt = new CPoint(2);
            for (int i = 0; i < this.mquads.size(); ++i) {
                int yoffset;
                int y;
                MprQuad q = this.mquads.get(i);
                byte[] fbmdata = ((DataBufferByte)this.filled_bmap.getRaster().getDataBuffer()).getData();
                Arrays.fill(fbmdata, (byte)0);
                byte[] obmdata = ((DataBufferByte)this.outline_bmap.getRaster().getDataBuffer()).getData();
                Arrays.fill(obmdata, (byte)0);
                for (int j = 0; j < q.getNumPoints(); ++j) {
                    q.getPoint(j, tx_raspt);
                    ras2voxel.transform(tx_raspt, this.vox_pts[j]);
                    ras2display.transform(tx_raspt, this.disp_pts[j]);
                }
                ProjectedMPR.dirCalc(this.disp_pts[0], this.disp_pts[1], d_xdir);
                ProjectedMPR.dirCalc(this.disp_pts[0], this.disp_pts[3], d_ydir);
                mm.set(d_xdir[0], d_ydir[0], this.disp_pts[0].x, 0.0, d_xdir[1], d_ydir[1], this.disp_pts[0].y, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
                if (ProjectedMPR.vlen(d_xdir) < 1.0E-7 || ProjectedMPR.vlen(d_ydir) < 1.0E-7) continue;
                tx_m.invert(mm);
                poly.reset();
                poly.moveTo((float)this.disp_pts[0].x, (float)this.disp_pts[0].y);
                poly.lineTo((float)this.disp_pts[1].x, (float)this.disp_pts[1].y);
                poly.lineTo((float)this.disp_pts[2].x, (float)this.disp_pts[2].y);
                poly.lineTo((float)this.disp_pts[3].x, (float)this.disp_pts[3].y);
                poly.closePath();
                gf_bmap.fill(poly);
                go_bmap.draw(poly);
                mm.set(d_xdir[0], d_ydir[0], this.disp_pts[0].x, 0.0, d_xdir[1], d_ydir[1], this.disp_pts[0].y, 0.0, d_xdir[2], d_ydir[2], this.disp_pts[0].z, 0.0, 0.0, 0.0, 0.0, 1.0);
                tx_m.mul(mm);
                mm.mul(display2vox, tx_m);
                int rowlen = width + 7 >> 3;
                double[] d2v_xdir = new double[3];
                double[] d2v_ydir = new double[3];
                double[] d2v_rowpt = new double[3];
                double[] d2v_lookpt = new double[3];
                ProjectedMPR.calcDirVectors(mm, d2v_xdir, d2v_ydir, d2v_rowpt);
                d2v_lookpt[0] = d2v_rowpt[0] + 0.5 * (double)width * d2v_xdir[0] + 0.5 * (double)height * d2v_ydir[0];
                d2v_lookpt[1] = d2v_rowpt[1] + 0.5 * (double)width * d2v_xdir[1] + 0.5 * (double)height * d2v_ydir[1];
                d2v_lookpt[2] = d2v_rowpt[2] + 0.5 * (double)width * d2v_xdir[2] + 0.5 * (double)height * d2v_ydir[2];
                double[] d2d_xdir = new double[3];
                double[] d2d_ydir = new double[3];
                double[] d2d_pt = new double[3];
                ProjectedMPR.calcDirVectors(tx_m, d2d_xdir, d2d_ydir, d2d_pt);
                double row_z = d2d_pt[2];
                Arrays.fill(lumbuffer, (short)-8192);
                this.mpr_engine.setView(d2v_lookpt, d2v_xdir, d2v_ydir, new double[3], 0.0, width, height, dx, dy, dz, 1, -8192);
                pmpr_ptm.launch(pmpr_wd);
                for (y = 0; y < height; ++y) {
                    yoffset = y * rowlen;
                    double _z = row_z;
                    for (int x = 0; x < width; ++x) {
                        int idx = yoffset + (x >> 3);
                        int mod = 7 - x % 8;
                        int modmask = 1 << mod;
                        int zidx = y * width + x;
                        if (!((fbmdata[idx] & modmask) == 0 && (obmdata[idx] & modmask) == 0 || this.zbuffer[zidx] != 8192 && !(_z < (double)this.zbuffer[zidx]))) {
                            this.zbuffer[zidx] = (short)_z;
                            int voxval = lumbuffer[zidx];
                            this._hitmap[zidx] = (byte)i;
                            this._lumbuffer[zidx] = (obmdata[idx] & modmask) != 0 ? -1024 : voxval;
                        }
                        _z += d2d_xdir[2];
                    }
                    row_z += d2d_ydir[2];
                    JnVector3d.add(d2v_rowpt, d2v_ydir, d2v_rowpt);
                }
                for (y = 1; y < height - 1; ++y) {
                    yoffset = y * width;
                    for (int x = 1; x < width - 1; ++x) {
                        int idx = yoffset + x;
                        int up = idx - width;
                        int down = idx + width;
                        int left = idx - 1;
                        int right = idx + 1;
                        if (this._lumbuffer[idx] == -1024) continue;
                        byte hval = this._hitmap[idx];
                        byte upval = this._hitmap[up];
                        byte downval = this._hitmap[down];
                        byte leftval = this._hitmap[left];
                        short upvox = this._lumbuffer[up];
                        short downvox = this._lumbuffer[down];
                        short leftvox = this._lumbuffer[left];
                        if (hval == upval && hval == leftval && hval == downval || upvox == -1024 || leftvox == -1024 || downvox == -1024) continue;
                        this._lumbuffer[idx] = -1024;
                    }
                }
            }
        }
    }

    public void wwwlPolys() {
        int[] outdata = ((DataBufferInt)this.outimg.getRaster().getDataBuffer()).getData();
        double alpha = (double)this.borderColor.getAlpha() / 255.0;
        double _alpha = 1.0 - alpha;
        double ared = (double)this.borderColor.getRed() * alpha;
        double agreen = (double)this.borderColor.getGreen() * alpha;
        double ablue = (double)this.borderColor.getBlue() * alpha;
        for (int idx = 0; idx < outdata.length; ++idx) {
            int wwwl_idx = this._lumbuffer[idx] & 0xFFFF;
            if (this._lumbuffer[idx] == -1024) {
                int rgb;
                int rgbimg = this.rgb[wwwl_idx];
                int ired = rgbimg >> 16 & 0xFF;
                int igreen = rgbimg >> 8 & 0xFF;
                int iblue = rgbimg & 0xFF;
                int red = (int)((double)ired * _alpha + ared) & 0xFF;
                int green = (int)((double)igreen * _alpha + agreen) & 0xFF;
                int blue = (int)((double)iblue * _alpha + ablue) & 0xFF;
                outdata[idx] = rgb = 0xFF000000 | red << 16 | green << 8 | blue;
                continue;
            }
            outdata[idx] = this.rgb[wwwl_idx];
        }
    }

    public void blendToT3D(float[] rasbuff, JnMatrix4d ras2display, boolean blend) {
        int width = this.outimg.getWidth();
        int height = this.outimg.getHeight();
        int[] outdata = ((DataBufferInt)this.outimg.getRaster().getDataBuffer()).getData();
        double z0 = ras2display.m20;
        double z1 = ras2display.m21;
        double z2 = ras2display.m22;
        double z3 = ras2display.m23;
        if (rasbuff == null) {
            return;
        }
        int ibgColor = 0xFF000000 | this.backgroundColor.getRGB();
        int backAlpha = (int)(255.0 * this.backgroundAlpha);
        int occlAlpha = (int)(255.0 * this.occlusionAlpha);
        for (int y = 0; y < height; ++y) {
            int yoffset = y * width;
            int ryoffset = y * 3 * width;
            for (int x = 0; x < width; ++x) {
                int idx = yoffset + x;
                int ridx = ryoffset + 3 * x;
                int alpha = blend ? 0 : 255;
                int rgbval = outdata[idx];
                if (blend && this.zbuffer[idx] != 8192) {
                    float rx = rasbuff[ridx];
                    float ry = rasbuff[ridx + 1];
                    float rz = rasbuff[ridx + 2];
                    double _z = (double)rx * z0 + (double)ry * z1 + (double)rz * z2 + z3;
                    if ((double)this.zbuffer[idx] < _z || rx < -99999.0f) {
                        boolean isBackground;
                        alpha = 255;
                        boolean bl = isBackground = rgbval == ibgColor;
                        if (isBackground) {
                            alpha = backAlpha;
                        }
                    } else {
                        this._hitmap[idx] = -1;
                        alpha = occlAlpha;
                    }
                }
                outdata[idx] = alpha << 24 | 0xFFFFFF & rgbval;
            }
        }
    }

    private static void dirCalc(JnVector3d v0, JnVector3d v1, double[] dir) {
        dir[0] = v1.x - v0.x;
        dir[1] = v1.y - v0.y;
        dir[2] = v1.z - v0.z;
        double len = Math.sqrt(dir[0] * dir[0] + dir[1] * dir[1] + dir[2] * dir[2]);
        dir[0] = dir[0] / len;
        dir[1] = dir[1] / len;
        dir[2] = dir[2] / len;
    }

    public BufferedImage getOutput() {
        return this.outimg;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public double getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(double backgroundAlpha) {
        this.backgroundAlpha = backgroundAlpha;
    }

    public double getOcclusionAlpha() {
        return this.occlusionAlpha;
    }

    public void setOcclusionAlpha(double occlusionAlpha) {
        this.occlusionAlpha = occlusionAlpha;
    }

    private static class PMprWorker
    extends Worker {
        private mpr mpr_engine = null;

        public PMprWorker(ParallelTaskManager ptm, int workerId, mpr mpr_engine) {
            super(ptm, workerId);
            this.mpr_engine = mpr_engine;
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            PMprWorkData wd = (PMprWorkData)data;
            this.mpr_engine.mpr_tl(workerId, 0, wd.width - 1, wd.height - 1, nWorkers, 1, wd.voldata, null, wd.vol_offset, wd.outimg, null, wd.width, wd.height);
        }
    }

    private static class PMprWorkData {
        public int width;
        public int height;
        public int vol_offset;
        public short[] voldata;
        public short[] outimg;

        public PMprWorkData(int width, int height, int vol_offset, short[] voldata, short[] outimg) {
            this.width = width;
            this.height = height;
            this.vol_offset = vol_offset;
            this.voldata = voldata;
            this.outimg = outimg;
        }
    }
}

