/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.XpResponseCurve;
import com.ge.med.terra.jami.j3d.T3DTrackball;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class MPRController
extends T3DTrackball {
    private XpResponseCurve wlResponse = new XpResponseCurve();
    private double wlSensitivity = 0.7;
    private double wwSensitivity = 0.7;
    private Point prev_pt = new Point();
    private Point start_pt = null;
    private double startWW = 0.0;
    private double startWL = 0.0;
    private double startMax = 0.0;
    private XpImageRenderAttributesOwner iraOwner = null;
    private T3DViewport vp = null;
    private final int NAV_RESOLUTION = 300;
    private double[] eye_pt = new double[3];
    private double[] look = new double[3];
    private JnVector3d nav_view = new JnVector3d();
    private JnVector3d nav_lookat = new JnVector3d();
    private JnVector3d nav_eyept = new JnVector3d();
    private double[] ulc = new double[3];
    private double[] xside = new double[3];
    private double[] yside = new double[3];
    private double[] zside = new double[3];

    @Override
    public void setTarget(JComponent vc) {
        super.setTarget(vc);
        if (vc instanceof XpImageRenderAttributesOwner) {
            this.iraOwner = (XpImageRenderAttributesOwner)((Object)vc);
        }
        this.vp = (T3DViewport)vc;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int b = me.getModifiers();
        boolean shift = 0 != (b & 1);
        boolean ctrl = 0 != (b & 2);
        boolean alt = 0 != (b & 8);
        Point p = me.getPoint();
        this.prev_pt.setLocation(p);
        this.start_pt = p;
        XpImageRenderAttributes ira = this.iraOwner.getImageRenderAttributes();
        this.startWW = ira.getWindowWidth();
        this.startWL = ira.getWindowLevel();
        this.startMax = this.startWL + this.startWW * 0.5;
        if (!(shift || ctrl || alt)) {
            super.mousePressed(me);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.vp.repaint();
    }

    private double length(double[] v) {
        return Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int mod = me.getModifiers();
        boolean b1 = 0 != (mod & 0x10);
        boolean b2 = 0 != (mod & 8);
        boolean b3 = 0 != (mod & 4);
        boolean shift = 0 != (mod & 1);
        Point p = me.getPoint();
        if (b1 && shift) {
            T3DCapable t3d = this.getT3DCapable();
            t3d.getWorldBounds(this.ulc, this.xside, this.yside, this.zside);
            t3d.getEyePoint(this.eye_pt);
            t3d.getLookPoint(this.look);
            double zlen = this.length(this.zside);
            double delta = 0.1 * (zlen / 300.0) * (double)(p.y - this.prev_pt.y);
            this.nav_view.set(this.look[0] - this.eye_pt[0], this.look[1] - this.eye_pt[1], this.look[2] - this.eye_pt[2]);
            this.nav_view.normalize();
            this.nav_view.scale(delta);
            this.nav_lookat.set(this.look);
            this.nav_lookat.add(this.nav_view);
            this.nav_eyept.set(this.eye_pt);
            this.nav_eyept.add(this.nav_view);
            t3d.setEyePoint(this.nav_eyept.generateArray());
            t3d.setLookPoint(this.nav_lookat.generateArray());
            this.getTarget().repaint();
        } else if (b3 && shift) {
            double dx = p.x - this.start_pt.x;
            double dy = p.y - this.start_pt.y;
            this.wwwl(dx, dy);
        } else {
            super.mouseDragged(me);
        }
        this.prev_pt.setLocation(p);
    }

    private void wwwl(double dx, double dy) {
        XpImageRenderAttributes ira = this.iraOwner.getImageRenderAttributes();
        XjVolumeInfo vol = this.vp.getT3DComponent().getVolume();
        String modality = "";
        if (vol != null) {
            modality = "" + vol.getValue(8, 96);
        }
        if (modality.equals("PT")) {
            double mdelta = this.wlSensitivity * -dy;
            double min = ira.getWindowMin();
            double max = this.wlResponse.response(this.startMax, mdelta);
            double ww = max - min;
            double wl = (max + min) * 0.5;
            ira.setWindowing(ww, wl);
        } else {
            double wwdelta = this.wwSensitivity * dx;
            double wldelta = this.wlSensitivity * dy;
            double ww = this.wlResponse.response(this.startWW, wwdelta);
            double wl = this.wlResponse.response(this.startWL, wldelta);
            ira.setWindowing(ww, wl);
        }
        this.iraOwner.setImageRenderAttributes(ira);
        this.getTarget().repaint();
    }
}

