/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.Capable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpResponseCurve;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class WLMouseController
extends MouseInputAdapter
implements XpMouseController {
    Point prev_pt = new Point();
    Point start_pt = new Point();
    private WindowLevelCapable wlCapable = null;
    private double startWW = 0.0;
    private double startWL = 0.0;
    private double startMin = 0.0;
    private double startMax = 0.0;
    private static final double wlSensitivity = 0.7;
    private static final double wwSensitivity = 0.7;
    private static XpResponseCurve wlResponse = new XpResponseCurve();
    private T3DViewport vp;

    @Override
    public void mouseDragged(MouseEvent me) {
        Point p = me.getPoint();
        double dx = p.x - this.start_pt.x;
        double dy = p.y - this.start_pt.y;
        this.wwwl(dx, dy);
        this.prev_pt.setLocation(p);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Point p = me.getPoint();
        this.prev_pt.setLocation(p);
        this.start_pt = p;
        this.startMin = this.wlCapable.getWinMin();
        this.startMax = this.wlCapable.getWinMax();
        this.startWW = this.startMax - this.startMin;
        this.startWL = (this.startMax + this.startMin) / 2.0;
    }

    protected void wwwl(double dx, double dy) {
        XjVolumeInfo vol = null;
        if (this.vp != null) {
            vol = this.vp.getT3DComponent().getVolume();
        }
        String modality = "";
        if (vol != null) {
            modality = "" + vol.getValue(8, 96);
        }
        if (modality.equals("PT")) {
            double mdelta = 0.7 * -dy;
            double min = this.wlCapable.getWinMin();
            double max = wlResponse.response(this.startMax, mdelta);
            this.wlCapable.setWinMinMax(min, max);
        } else {
            double wwdelta = 0.7 * dx;
            double wldelta = 0.7 * dy;
            double ww = wlResponse.response(this.startWW, wwdelta);
            double wl = wlResponse.response(this.startWL, wldelta);
            double min = wl - ww / 2.0;
            double max = min + ww;
            this.wlCapable.setWinMinMax(min, max);
        }
        this.wlCapable.repaint();
    }

    @Override
    public void setTarget(JComponent vc) {
        this.wlCapable = vc instanceof Capable ? (WindowLevelCapable)((Capable)((Object)vc)).getCapable(WindowLevelCapable.class.getName()) : null;
        this.vp = vc instanceof T3DViewport ? (T3DViewport)vc : null;
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }
}

