/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.Capable;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjChangeListener;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.capable.SegmentationCapable;
import com.ge.med.terra.jami.j3d.J3DRenderEngine;
import com.ge.med.terra.jami.j3d.ViewResetAction;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventObject;

public class T3DRenderEngineDriver
implements T3DCapable,
T3DRenderStyleCapable,
PropertyChangeListener,
XjChangeListener,
SegmentationCapable {
    private static int t3ddriver_id_cnt = 0;
    public static final String VOLUME_PROPERTY = "VOLUME_PROPERTY";
    public static final String VOLUME_DOWNSAMPLEXY = "VOLUME_DOWNSAMPLEXY";
    public static final String VOLUME_DOWNSAMPLEZ = "VOLUME_DOWNSAMPLEZ";
    private T3DRenderEngine engine = null;
    private int t3ddriver_id = t3ddriver_id_cnt++;
    private int[] rgb_image = null;
    private short[] lum_image = null;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private int nOutputs = 0;
    private short[] outoverlay = null;
    private boolean startIRE = true;
    private boolean ire = true;
    private boolean renderFinal = true;
    private boolean debug = false;
    private boolean t3dReady = false;
    private boolean ignoreRenderEngineEvents = false;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private transient boolean changeDisplay = false;
    private boolean keeprunning = true;
    private Object lock = new Object();
    private Object ireDone = new Object();
    private MultipassAlgorithm[] mp_alg = new MultipassAlgorithm[16];
    private short[][] lum_display = null;
    private int[][] rgb_display = null;

    public T3DRenderEngineDriver() {
        this(new J3DRenderEngine());
    }

    public T3DRenderEngineDriver(T3DRenderEngine engine) {
        this.engine = engine;
        this.init();
    }

    public void setSize(int width, int height) {
        this.resizeBuffers(width, height);
        if (this.startIRE) {
            this.startIRE = false;
            this.startRenderThread();
        }
    }

    public int getWidth() {
        return this.engine.getBufferWidth();
    }

    public int getHeight() {
        return this.engine.getBufferHeight();
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propertyName, pcl);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propertyName, pcl);
    }

    @Override
    public boolean isAutoRepaint() {
        return false;
    }

    @Override
    public void repaint() {
    }

    @Override
    public void setAutoRepaint(boolean autoRepaint) {
    }

    private void init() {
        this.engine.addPropertyChangeListener(this);
        this.engine.addChangeListener(this);
        this.setInitialView(ViewResetAction.A_VECTOR.toArray());
        this.setInitialUp(ViewResetAction.A_UP_VECTOR.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderThread() {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                while (!this.changeDisplay) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ex) {}
                }
            }
            if (!this.keeprunning) break;
            if (this.rgb_image == null || this.lum_image == null) {
                this.changeDisplay = false;
                continue;
            }
            int w = this.getWidth();
            int h = this.getHeight();
            int nouts = this.getNumOutputLayers();
            if (w != this.imgWidth || h != this.imgHeight || nouts != this.nOutputs) {
                this.resizeBuffers(w, h);
            }
            this.engine.clearBuffers();
            XjVolumeInfo vol = this.getVolume();
            if (vol == null) {
                this.changeDisplay = false;
                this.repaint();
                continue;
            }
            this.changeDisplay = false;
            this.renderFinal = false;
            int nengineoutputs = this.engine.getNumOutputs();
            try {
                this.engine.initRender();
                this.firePropertyChange("RENDER_START", null, this.engine);
                if (this.ire) {
                    int remainingPassMask = (1 << nengineoutputs) - 1;
                    for (int layer = 0; layer < nengineoutputs; ++layer) {
                        this.mp_alg[layer] = this.engine.getMultipassAlgorithm(layer);
                    }
                    int passno = 0;
                    while (true) {
                        boolean donerender = false;
                        boolean rendercancel = false;
                        for (int layer = 0; layer < nengineoutputs; ++layer) {
                            int layerBit;
                            if (nengineoutputs > 1) {
                                this.restoreFromOutput(layer);
                            }
                            if ((remainingPassMask & (layerBit = 1 << layer)) == 0) continue;
                            MultipassAlgorithm ma = this.mp_alg[layer];
                            int rempasses = ma.render(0, 0, w, h, layer, passno);
                            if (rempasses == 0) {
                                remainingPassMask &= ~layerBit;
                            }
                            ma.fill(0, 0, w, h, layer, passno);
                            if (rempasses == -99999) {
                                rendercancel = true;
                                break;
                            }
                            this.sendToOutput(layer);
                            if (!this.changeDisplay && remainingPassMask != 0) continue;
                            donerender = true;
                        }
                        if (!rendercancel) {
                            this.firePropertyChange("ALL_LAYERS_COMPLETE_PROPERTY", null, this.engine.getPixelBuffer());
                            if (!donerender) {
                                ++passno;
                                continue;
                            }
                        }
                        break;
                    }
                } else {
                    for (int layer = 0; layer < nengineoutputs; ++layer) {
                        this.engine.render(layer);
                        this.sendToOutput(layer);
                    }
                    this.firePropertyChange("ALL_LAYERS_COMPLETE_PROPERTY", null, this.engine.getPixelBuffer());
                }
            }
            catch (Exception ex1) {
                this.handleRenderThreadException(ex1);
            }
            Object object2 = this.ireDone;
            synchronized (object2) {
                this.renderFinal = true;
                this.ireDone.notifyAll();
            }
            this.firePropertyChange("RENDER_FINISH", null, this.engine);
        }
        XpLog.logger().fine("-- Goodbye T3DRenderEngineDriver thread.");
    }

    protected void handleRenderThreadException(Exception ex) {
        ex.printStackTrace();
    }

    private void restoreFromOutput(int layerNo) {
        Object pbuffer = this.engine.getPixelBuffer();
        int[][] _rgb_display = this.rgb_display;
        short[][] _lum_display = this.lum_display;
        if (layerNo >= _lum_display.length) {
            return;
        }
        if (pbuffer instanceof int[]) {
            System.arraycopy(_rgb_display[layerNo], 0, pbuffer, 0, _rgb_display[layerNo].length);
        } else {
            System.arraycopy(_lum_display[layerNo], 0, pbuffer, 0, _lum_display[layerNo].length);
        }
    }

    private void sendToOutput(int layerNo) {
        Object pbuffer = this.engine.getPixelBuffer();
        if (pbuffer instanceof int[]) {
            System.arraycopy(pbuffer, 0, this.rgb_display[layerNo], 0, this.rgb_display[layerNo].length);
        } else {
            System.arraycopy(pbuffer, 0, this.lum_display[layerNo], 0, this.lum_display[layerNo].length);
        }
        Buffer b = new Buffer(layerNo, pbuffer);
        this.firePropertyChange("SINGLE_LAYER_COMPLETE_PROPERTY", null, b);
    }

    public void setDisplayBuffers(short[][] lum_display, int[][] rgb_display) {
        this.lum_display = lum_display;
        this.rgb_display = rgb_display;
    }

    public void render() {
        this.refresh();
        this.waitForIRE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIRE() {
        Object object = this.ireDone;
        synchronized (object) {
            while (!this.renderFinal || this.changeDisplay) {
                try {
                    this.ireDone.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int getNumOutputLayers() {
        return this.engine.getNumOutputs();
    }

    public boolean isRenderFinal() {
        return this.renderFinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDisplay() {
        Object object = this.lock;
        synchronized (object) {
            this.changeDisplay = true;
            this.lock.notify();
        }
    }

    public void shutdown() {
        this.keeprunning = false;
        this.updateDisplay();
    }

    private void startRenderThread() {
        Thread rt = new Thread(){

            @Override
            public void run() {
                T3DRenderEngineDriver.this.renderThread();
            }
        };
        rt.setName("T3DRenderEngineDriver[" + this.t3ddriver_id + "]_RenderThread");
        rt.setDaemon(true);
        rt.start();
        this.refresh();
    }

    public T3DRenderEngine getT3DRenderEngine() {
        return this.engine;
    }

    @Override
    public Capable getCapable(String capableIFName) {
        Capable c = null;
        try {
            Class<?> cl = Class.forName(capableIFName);
            if (cl.isInstance(this)) {
                c = this;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (c == null) {
            c = this.engine.getCapable(capableIFName);
        }
        return c;
    }

    @Override
    public String[] getSupportedRenderStyles() {
        return this.engine.getSupportedRenderStyles();
    }

    public XjVolumeInfo getVolume() {
        return this.engine.getVolume();
    }

    public XjVolumeModel getVolumeModel() {
        return this.engine.getVolumeModel();
    }

    public XjVolumeModel getVolumeModel(int idx) {
        return this.engine.getVolumeModel(idx);
    }

    public void setVolumeModel(XjVolumeModel vm) {
        this.t3dReady = false;
        this.engine.setVolumeModel(vm);
        this.t3dReady = true;
    }

    public void setProperty(String propName, Object value) {
        this.engine.setProperty(propName, value);
    }

    public Object getProperty(String propName) {
        return this.engine.getProperty(propName);
    }

    @Override
    public void setRenderStyle(String style) {
        String old_rstyle = this.getRenderStyle();
        this.engine.setRenderStyle(style);
        if (old_rstyle.equals("FUSED_REFORMAT")) {
            this.setSegmentationVisible(false);
        }
        if (style.equals("FUSED_REFORMAT")) {
            this.setSegmentationVisible(true);
        }
    }

    @Override
    public String getRenderStyle() {
        return this.engine.getRenderStyle();
    }

    protected final void setT3DReady(boolean ready) {
        this.t3dReady = ready;
    }

    public final boolean isT3DReady() {
        return this.t3dReady;
    }

    public void refresh() {
        if (!this.isT3DReady()) {
            return;
        }
        this.updateDisplay();
    }

    public void setVolume(XjVolumeInfo volume) {
        XjVolumeInfo volToLoad = volume;
        this.loadVolume(volToLoad);
    }

    private void loadVolume(XjVolumeInfo volume) {
        this.t3dReady = false;
        this.engine.setVolume(volume);
        this.t3dReady = true;
        this.firePropertyChange(VOLUME_PROPERTY, null, this.getVolumeModel());
    }

    protected static double calcVolumeRescaleSlope(XjVolumeInfo vol) {
        return XjVolumeUtils.calcVolumeRescaleSlope(vol);
    }

    protected static double calcVolumeRescaleIntercept(XjVolumeInfo vol) {
        return XjVolumeUtils.calcVolumeRescaleIntercept(vol);
    }

    protected static double calcVolumeDefWW(XjVolumeInfo vol) {
        return XjVolumeUtils.calcVolumeDefWW(vol);
    }

    protected static double calcVolumeDefWL(XjVolumeInfo vol) {
        return XjVolumeUtils.calcVolumeDefWL(vol);
    }

    protected void resizeBuffers(int width, int height) {
        int len = width * height;
        if (this.rgb_image == null || this.rgb_image.length != len) {
            this.rgb_image = new int[len];
            this.lum_image = new short[len];
            this.outoverlay = new short[len];
        }
        this.engine.setOutput(this.rgb_image, this.lum_image, width, height);
        this.engine.setOverlay(this.outoverlay);
        this.imgWidth = width;
        this.imgHeight = height;
    }

    public void setOutput(int[] rgb_image, short[] luminance_img, short[] outoverlay, int width, int height) {
        int len = width * height;
        if (len != rgb_image.length) {
            return;
        }
        if (len != luminance_img.length) {
            return;
        }
        if (len != outoverlay.length) {
            return;
        }
        this.rgb_image = rgb_image;
        this.lum_image = luminance_img;
        this.outoverlay = outoverlay;
        this.engine.setOutput(rgb_image, luminance_img, width, height);
        this.engine.setOverlay(outoverlay);
        if (this.startIRE) {
            this.startIRE = false;
            this.startRenderThread();
        }
    }

    @Override
    public void getWorldBounds(double[] ulc, double[] xside, double[] yside, double[] zside) {
        this.engine.getWorldBounds(ulc, xside, yside, zside);
    }

    @Override
    public void setLookPoint(double[] point) {
        this.engine.setLookPoint(point);
    }

    @Override
    public double[] getLookPoint(double[] look_pt) {
        return this.engine.getLookPoint(look_pt);
    }

    @Override
    public void setEyePoint(double[] point) {
        this.engine.setEyePoint(point);
    }

    @Override
    public double[] getEyePoint(double[] eye_pt) {
        return this.engine.getEyePoint(eye_pt);
    }

    @Override
    public void setUp(double[] vec) {
        this.engine.setUp(vec);
    }

    @Override
    public double[] getUp(double[] up_v) {
        return this.engine.getUp(up_v);
    }

    @Override
    public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
        this.engine.setCamera(eyepoint, lookpoint, up);
    }

    @Override
    public void setViewHeight(double height) {
        this.engine.setViewHeight(height);
    }

    @Override
    public double getViewHeight() {
        return this.engine.getViewHeight();
    }

    @Override
    public void setAspectRatio(double aspect) {
        this.engine.setAspectRatio(aspect);
    }

    @Override
    public double getAspectRatio() {
        return this.engine.getAspectRatio();
    }

    @Override
    public void setViewClip(double[] clipOffsets) {
        this.engine.setViewClip(clipOffsets);
    }

    @Override
    public double[] getViewClip(double[] view_clip) {
        return this.engine.getViewClip(view_clip);
    }

    @Override
    public void setPerspective(boolean b) {
        this.engine.setPerspective(b);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isPerspective() {
        return this.engine.isPerspective();
    }

    public final boolean isDebug() {
        return this.debug;
    }

    public void addTaskMonitor(TaskMonitor tm) {
        this.engine.addTaskMonitor(tm);
    }

    public void removeTaskMonitor(TaskMonitor tm) {
        this.engine.removeTaskMonitor(tm);
    }

    public void dispose() {
    }

    public void setBackground(int argb) {
        this.engine.setBackground(argb, 0);
    }

    public double[] getInitialUp() {
        return this.engine.getInitialUp();
    }

    public void setInitialUp(double[] initialUp) {
        this.engine.setInitialUp(initialUp);
    }

    public double[] getInitialView() {
        return this.engine.getInitialView();
    }

    public void setInitialView(double[] initialView) {
        this.engine.setInitialView(initialView);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (source instanceof T3DRenderEngine) {
            boolean doUpdate = false;
            if (propertyName.equalsIgnoreCase("camera") || propertyName.equalsIgnoreCase("viewHeight") || propertyName.equalsIgnoreCase("perspective") || propertyName.equalsIgnoreCase("viewClip")) {
                doUpdate = true;
            }
            if (propertyName.equalsIgnoreCase("renderStyle")) {
                doUpdate = true;
            }
            if (doUpdate && !this.ignoreRenderEngineEvents) {
                this.refresh();
            }
            this.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void stateChanged(EventObject e) {
        boolean refresh = true;
        if (e.getSource() instanceof T3DRenderEngine && this.ignoreRenderEngineEvents) {
            refresh = false;
        }
        if (refresh) {
            this.refresh();
        }
    }

    public boolean isIre() {
        return this.ire;
    }

    public void setIre(boolean ire) {
        this.ire = ire;
    }

    @Override
    public void setSegmentationVisible(boolean segVisible) {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        sc.setSegmentationVisible(segVisible);
        this.refresh();
    }

    @Override
    public boolean isSegmentationVisible() {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        boolean ret = false;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.isSegmentationVisible();
        return ret;
    }

    @Override
    public void setSegmentationColorMap(int[] cmap) {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        sc.setSegmentationColorMap(cmap);
    }

    @Override
    public int[] getSegmentationColorMap() {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        int[] ret = null;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.getSegmentationColorMap();
        return ret;
    }

    @Override
    public boolean applySegmentation(short[] labels, int offset) {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        boolean ret = false;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.applySegmentation(labels, offset);
        this.refresh();
        return ret;
    }

    @Override
    public boolean applySegmentation(byte[] bgrid) {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        boolean ret = false;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.applySegmentation(bgrid);
        this.refresh();
        return ret;
    }

    @Override
    public boolean intersect(byte[] bgrid) {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        boolean ret = false;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.intersect(bgrid);
        this.refresh();
        return ret;
    }

    @Override
    public boolean union(byte[] bgrid) {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        boolean ret = false;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.union(bgrid);
        this.refresh();
        return ret;
    }

    @Override
    public boolean negation() {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        boolean ret = false;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.negation();
        this.refresh();
        return ret;
    }

    @Override
    public void clearSegmentation() {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        sc.clearSegmentation();
        this.refresh();
    }

    public int addVolumeLayer(XjVolumeInfo volInfo) {
        int nlayer = this.engine.addVolume(volInfo);
        return nlayer;
    }

    public int addVolumeLayer(XjVolumeModel volModel) {
        int nlayer = this.engine.addVolumeModel(volModel);
        return nlayer;
    }

    public int removeVolumeLayer(int layer) {
        return this.engine.removeVolumeModel(layer);
    }

    public int getNumVolumeLayers() {
        return this.engine.getNumVolumes();
    }

    public void setIgnoreRenderEngineEvents(boolean ignore) {
        this.ignoreRenderEngineEvents = ignore;
    }

    public static class Buffer {
        public int layerNo = 0;
        public Object buffer = null;

        public Buffer(int layerNo, Object buffer) {
            this.layerNo = layerNo;
            this.buffer = buffer;
        }
    }
}

