/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.Capable;
import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjChangeListener;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.capable.T3DRenderer;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.j3d.J3DRenderEngine;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.render.XpImage2DRenderer;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class T3DReformatter
implements T3DRenderer,
WindowLevelCapable,
XpImageRenderAttributesOwner,
XjChangeListener,
PropertyChangeListener,
TaskMonitor {
    static boolean rayjitter = true;
    private ImageBlitter renderer = new ImageBlitter();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private XpBufferedImage lum_img = null;
    private short[] lum_data = null;
    private T3DRenderEngine engine = new J3DRenderEngine();
    private JnMatrix3d view = new JnMatrix3d();
    private JnMatrix3d t = new JnMatrix3d();
    private JnVector3d v = new JnVector3d();
    private JnVector3d u = new JnVector3d();
    private JnVector3d r = new JnVector3d();
    private static String[] renderStyles = new String[]{"REFORMAT", "REFORMAT.TC", "REFORMAT.NN", "MIP", "MINIP", "AVERAGE", "FULLBODY_MIP", "FULLBODY_MINIP", "MAJOR_AXIS_MIP", "MAJOR_AXIS_MINIP", "MAJOR_AXIS_AVERAGE"};
    private Rectangle viewport = new Rectangle();
    private CPoint ul = new CPoint(2);
    private CPoint ur = new CPoint(2);
    private CPoint br = new CPoint(2);
    private List change_listeners = new Vector();
    private BufferedImage rgbImage = null;
    private double winUpperLimit = Double.MAX_VALUE;
    private double winLowerLimit = -1.7976931348623157E308;

    public T3DReformatter() {
        this.engine.addPropertyChangeListener(this);
        this.engine.addChangeListener(this);
        ((J3DRenderEngine)this.engine).setRayJitter(rayjitter);
        this.setRenderStyle("REFORMAT");
    }

    public int getWidth() {
        return this.engine.getBufferWidth();
    }

    public int getHeight() {
        return this.engine.getBufferHeight();
    }

    private void syncImageParams() {
        XjVolumeModel vol_model = this.engine.getVolumeModel();
        if (vol_model != null && this.lum_img != null) {
            double ri = this.getRescaleIntercept();
            double rs = this.getRescaleSlope();
            this.lum_img.setRescaleSlope(rs);
            this.lum_img.setRescaleIntercept(ri);
        }
    }

    @Override
    public String[] getSupportedRenderStyles() {
        return renderStyles;
    }

    @Override
    public void setRenderStyle(String style) {
        this.engine.setRenderStyle(style);
        this.refresh();
    }

    @Override
    public String getRenderStyle() {
        return this.engine.getRenderStyle();
    }

    @Override
    public XjVolumeModel getVolumeModel() {
        return this.engine.getVolumeModel();
    }

    public XpSlice getSlice() {
        return this.lum_img.getSlice();
    }

    @Override
    public void sample() {
        this.updateSlice();
        this.engine.initRender();
        this.engine.render(0);
    }

    @Override
    public void render() {
        this.sample();
        this.blit2D();
    }

    private void blit2D() {
        this.renderer.dirty();
        this.viewport.setBounds(0, 0, this.engine.getBufferWidth(), this.engine.getBufferHeight());
        this.renderer.render(null, this.viewport);
    }

    @Override
    public void setVolumeModel(XjVolumeModel vm) {
        this.engine.setVolumeModel(vm);
    }

    protected void updateSlice() {
        double winWidth = this.getWidth();
        double winHeight = this.getHeight();
        XpSlice slice = this.lum_img.getSlice();
        double viewHeight = this.engine.getViewHeight();
        double[] lookPoint = this.engine.getLookPoint(null);
        double aratio = winWidth / winHeight;
        double viewWidth = viewHeight * aratio;
        int w = slice.width;
        int h = slice.height;
        double spx = viewWidth / (double)w;
        double spy = viewHeight / (double)h;
        this.ul.x = lookPoint[0] - (double)w * 0.5 * this.r.x * spx + (double)h * 0.5 * this.u.x * spy;
        this.ul.y = lookPoint[1] - (double)w * 0.5 * this.r.y * spx + (double)h * 0.5 * this.u.y * spy;
        this.ul.z = lookPoint[2] - (double)w * 0.5 * this.r.z * spx + (double)h * 0.5 * this.u.z * spy;
        this.ur.x = lookPoint[0] + (double)w * 0.5 * this.r.x * spx + (double)h * 0.5 * this.u.x * spy;
        this.ur.y = lookPoint[1] + (double)w * 0.5 * this.r.y * spx + (double)h * 0.5 * this.u.y * spy;
        this.ur.z = lookPoint[2] + (double)w * 0.5 * this.r.z * spx + (double)h * 0.5 * this.u.z * spy;
        this.br.x = lookPoint[0] + (double)w * 0.5 * this.r.x * spx - (double)h * 0.5 * this.u.x * spy;
        this.br.y = lookPoint[1] + (double)w * 0.5 * this.r.y * spx - (double)h * 0.5 * this.u.y * spy;
        this.br.z = lookPoint[2] + (double)w * 0.5 * this.r.z * spx - (double)h * 0.5 * this.u.z * spy;
        slice.pixelSizeX = spx;
        slice.pixelSizeY = spy;
        slice.setCorners(this.ul, this.ur, this.br);
    }

    private void setRotation(JnMatrix3d rot) {
        this.view.setIdentity();
        this.view.mul(rot);
        this.refresh();
    }

    public final void refresh() {
    }

    @Override
    public void setLookPoint(double[] point) {
        this.engine.setLookPoint(point);
    }

    @Override
    public void setEyePoint(double[] point) {
        this.engine.setEyePoint(point);
    }

    @Override
    public void setUp(double[] vec) {
        this.engine.setUp(vec);
    }

    @Override
    public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
        this.engine.setCamera(eyepoint, lookpoint, up);
        this.calc_cam(eyepoint, lookpoint, up);
    }

    private void calc_cam(double[] eyepoint, double[] lookpoint, double[] up) {
        this.v.set(lookpoint[0] - eyepoint[0], lookpoint[1] - eyepoint[1], lookpoint[2] - eyepoint[2]);
        this.v.normalize();
        this.u.set(-up[0], -up[1], -up[2]);
        this.u.normalize();
        JnVector3d.cross(this.u, this.v, this.r);
        this.r.normalize();
        JnVector3d.cross(this.v, this.r, this.u);
        this.u.normalize();
        this.t.set(this.r.x, this.r.y, this.r.z, this.u.x, this.u.y, this.u.z, this.v.x, this.v.y, this.v.z);
        this.setRotation(this.t);
    }

    @Override
    public void setViewHeight(double height) {
        this.engine.setViewHeight(height);
    }

    @Override
    public void setAspectRatio(double aspect) {
        this.engine.setAspectRatio(aspect);
    }

    @Override
    public void setViewClip(double[] clipOffsets) {
        this.engine.setViewClip(clipOffsets);
    }

    @Override
    public XjVolumeInfo getVolume() {
        XjVolumeModel vol_model = this.engine.getVolumeModel();
        if (vol_model != null) {
            return vol_model.getVolume();
        }
        return null;
    }

    protected final XpImage2DRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void setImageRenderAttributes(XpImageRenderAttributes ira) {
        this.renderer.setImageRenderAttributes(ira);
    }

    @Override
    public XpImageRenderAttributes getImageRenderAttributes() {
        return this.renderer.getImageRenderAttributes();
    }

    public void dispose() {
        this.engine.setVolumeModel(null);
    }

    @Override
    public void stateChanged(EventObject e) {
        for (int i = 0; i < this.change_listeners.size(); ++i) {
            ((XjChangeListener)this.change_listeners.get(i)).stateChanged(new EventObject(this));
        }
    }

    @Override
    public void setOutput(BufferedImage lum16, BufferedImage rgb32) {
        XjVolumeInfo vol = this.engine.getVolumeModel().getVolume();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("40,256", XpImageUtils.getBitsAllocated(vol));
        props.put("40,257", XpImageUtils.getBitsStored(vol));
        props.put("40,259", XpImageUtils.getPixelRepresentation(vol));
        props.put("8,96", XpImageUtils.getModality(vol));
        this.lum_img = new XpBufferedImage(lum16, props);
        this.lum_data = ((DataBufferUShort)lum16.getRaster().getDataBuffer()).getData();
        int width = lum16.getWidth();
        int height = lum16.getHeight();
        this.syncImageParams();
        this.rgbImage = rgb32;
        int[] rgb_data = null;
        if (rgb32 != null) {
            rgb_data = ((DataBufferInt)rgb32.getRaster().getDataBuffer()).getData();
        } else {
            this.rgbImage = new BufferedImage(lum16.getWidth(), lum16.getHeight(), 1);
        }
        this.engine.setOutput(rgb_data, this.lum_data, width, height);
        this.renderer.setImage(this.lum_img);
        this.renderer.setRGBDrawable(this.rgbImage);
    }

    public BufferedImage getLuminanceImage() {
        return (BufferedImage)this.lum_img.getPixelData();
    }

    public BufferedImage getRGB() {
        return this.rgbImage;
    }

    @Override
    public void setVolume(XjVolumeInfo vol) {
        this.engine.setVolume(vol);
        this.loadVolume(vol);
    }

    @Override
    public double getRescaleSlope() {
        J3DVolumeModel vol_model = (J3DVolumeModel)this.engine.getVolumeModel();
        if (vol_model != null) {
            return vol_model.j_vol.rescaleSlope;
        }
        return 1.0;
    }

    @Override
    public double getRescaleIntercept() {
        J3DVolumeModel vol_model = (J3DVolumeModel)this.engine.getVolumeModel();
        if (vol_model != null) {
            return vol_model.j_vol.rescaleIntercept;
        }
        return 0.0;
    }

    private void loadVolume(XjVolumeInfo volume) {
        if (volume != null) {
            String modality = XpImageUtils.getModality(volume);
            if (modality != null) {
                if ((modality = modality.toUpperCase()).equals("PT")) {
                    double rescaleSlope = this.calcVolumeRescaleSlope(volume);
                    XpImageRenderAttributes ira = this.renderer.getImageRenderAttributes();
                    ira.setVideoInverted(true);
                    double min = 0.0;
                    double max = 32767.0 * rescaleSlope * 0.4;
                    double ww = max - min;
                    double wl = (max + min) * 0.5;
                    ira.setWindowing(ww, wl);
                    this.renderer.setImageRenderAttributes(ira);
                } else {
                    XpImageRenderAttributes ira = this.renderer.getImageRenderAttributes();
                    double ww = this.calcVolumeDefWW(volume);
                    double wl = this.calcVolumeDefWL(volume);
                    ira.setWindowing(ww, wl);
                    this.renderer.setImageRenderAttributes(ira);
                    if (modality.equals("MR")) {
                        this.setBackgroundValue(0);
                    } else if (modality.equals("CT")) {
                        this.setBackgroundValue(-2048);
                    } else {
                        this.setBackgroundValue(0);
                    }
                    System.err.println(">>>> T3DReformatter:: modality = " + modality + "   using air value=" + this.getBackgroundValue());
                }
            } else {
                String string = "";
            }
        }
    }

    @Override
    public void getWorldBounds(double[] ulc, double[] xside, double[] yside, double[] zside) {
        this.engine.getWorldBounds(ulc, xside, yside, zside);
    }

    @Override
    public double[] getLookPoint(double[] look_pt) {
        return this.engine.getLookPoint(look_pt);
    }

    @Override
    public double[] getEyePoint(double[] eye_pt) {
        return this.engine.getEyePoint(eye_pt);
    }

    @Override
    public double[] getUp(double[] up_v) {
        return this.engine.getUp(up_v);
    }

    @Override
    public double getViewHeight() {
        return this.engine.getViewHeight();
    }

    @Override
    public double getAspectRatio() {
        return this.engine.getAspectRatio();
    }

    @Override
    public double[] getViewClip(double[] view_clip) {
        return this.engine.getViewClip(view_clip);
    }

    @Override
    public void setPerspective(boolean b) {
        this.engine.setPerspective(b);
    }

    @Override
    public boolean isPerspective() {
        return this.engine.isPerspective();
    }

    public short getLuminance(int x, int y) {
        int w = this.getWidth();
        short val = this.lum_data[y * w + x];
        return val;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(prop, l);
    }

    @Override
    public void repaint() {
        this.render();
    }

    @Override
    public boolean isAutoRepaint() {
        return false;
    }

    @Override
    public void setAutoRepaint(boolean autoRepaint) {
    }

    @Override
    public Capable getCapable(String capableIFName) {
        return null;
    }

    protected double calcVolumeRescaleSlope(XjVolumeInfo vol) {
        double rs = 1.0;
        String modality = "" + vol.getValue(8, 96);
        if (modality.equals("PT")) {
            int[] dims = vol.getVolumeDimensions(null);
            int dz = dims[2];
            for (int i = 0; i < dz; ++i) {
                Object o = vol.getVSliceValue(i, 40, 4179);
                double d = XpImageUtils.parseImageRescaleSlope(o);
                if (i == 0) {
                    rs = d;
                    continue;
                }
                if (!(rs < d)) continue;
                rs = d;
            }
        } else {
            double d;
            Object o = vol.getValue(40, 4179);
            rs = d = XpImageUtils.parseImageRescaleSlope(o);
        }
        return rs;
    }

    protected double calcVolumeRescaleIntercept(XjVolumeInfo vol) {
        Object obj = vol.getValue(40, 4178);
        double rescaleIntercept = XpImageUtils.parseImageRescaleIntercept(obj);
        return rescaleIntercept;
    }

    protected double calcVolumeDefWW(XjVolumeInfo vol) {
        Object obj = vol.getValue(40, 4177);
        double ww = XpImageUtils.parseImageWW(obj);
        return ww;
    }

    protected double calcVolumeDefWL(XjVolumeInfo vol) {
        Object obj = vol.getValue(40, 4176);
        double wl = XpImageUtils.parseImageWL(obj);
        return wl;
    }

    @Override
    public void taskBegin(String taskName, int totalWork) {
    }

    @Override
    public void taskDone(String taskName) {
    }

    @Override
    public void taskProgress(String taskName, int units) {
    }

    @Override
    public void taskFailed(String taskName, String reason, Exception e) {
    }

    public void setBackgroundValue(int value) {
        this.engine.setBackground(-16777216, value);
    }

    public int getBackgroundValue() {
        return this.engine.getBackgroundColor();
    }

    public synchronized void setWindowing(double width, double level) {
        if (width < 0.0) {
            return;
        }
        double hw = width * 0.5;
        double min = level - hw;
        double max = level + hw;
        if (min < this.winLowerLimit) {
            min = this.winLowerLimit;
        } else if (min > this.winUpperLimit) {
            min = this.winUpperLimit;
        }
        if (max > this.winUpperLimit) {
            max = this.winUpperLimit;
        } else if (max < this.winLowerLimit) {
            max = this.winLowerLimit;
        }
        double newWidth = max - min;
        double newLevel = (max + min) * 0.5;
        double oldMin = 0.0;
        double oldMax = 0.0;
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        oldMin = ira.getWindowMin();
        oldMax = ira.getWindowMax();
        ira.setWindowing(newWidth, newLevel);
        this.setImageRenderAttributes(ira);
        if (min != oldMin) {
            this.pcs.firePropertyChange("winMin", new Double(oldMin), new Double(min));
        }
        if (max != oldMax) {
            this.pcs.firePropertyChange("winMax", new Double(oldMax), new Double(max));
        }
        this.blit2D();
    }

    @Override
    public void setWinMinMax(double min, double max) {
        double ww = max - min;
        double wl = (max + min) * 0.5;
        this.setWindowing(ww, wl);
    }

    @Override
    public double getWinMin() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        return kir.getWindowMin();
    }

    @Override
    public final void setWinMin(double min) {
        double winMax = this.getWinMax();
        this.setWinMinMax(min, winMax);
    }

    @Override
    public double getWinMax() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        return kir.getWindowMax();
    }

    @Override
    public final void setWinMax(double max) {
        double winMin = this.getWinMin();
        this.setWinMinMax(winMin, max);
    }

    @Override
    public void resetWindowing() {
        J3DVolumeModel vol_model = (J3DVolumeModel)this.engine.getVolumeModel();
        if (vol_model != null) {
            this.setWindowing(vol_model.j_vol.initWW, vol_model.j_vol.initWL);
        }
    }

    @Override
    public final void setWinUpperLimit(double wuLimit) {
        if (wuLimit >= this.winLowerLimit) {
            this.winUpperLimit = wuLimit;
            double max = this.getWinMax();
            if (max > this.winUpperLimit) {
                this.setWinMax(this.winUpperLimit);
            }
        }
    }

    @Override
    public final double getWinUpperLimit() {
        return this.winUpperLimit;
    }

    @Override
    public final void setWinLowerLimit(double wlLimit) {
        if (wlLimit <= this.winUpperLimit) {
            this.winLowerLimit = wlLimit;
            double min = this.getWinMin();
            if (min < this.winLowerLimit) {
                this.setWinMin(this.winLowerLimit);
            }
        }
    }

    @Override
    public final double getWinLowerLimit() {
        return this.winLowerLimit;
    }

    @Override
    public void setVideoInverted(boolean inverted) {
        boolean old_ivvideo = this.isVideoInverted();
        if (old_ivvideo != inverted) {
            XpImageRenderAttributes kir = this.getImageRenderAttributes();
            kir.setVideoInverted(inverted);
            this.setImageRenderAttributes(kir);
            this.pcs.firePropertyChange("videoInverted", old_ivvideo, inverted);
            this.blit2D();
        }
    }

    @Override
    public boolean isVideoInverted() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        return kir.isVideoInverted();
    }

    @Override
    public double[] getRange() {
        double[] range = new double[2];
        J3DVolumeModel vol_model = (J3DVolumeModel)this.engine.getVolumeModel();
        if (vol_model != null) {
            double min = vol_model.j_vol.initWL - vol_model.j_vol.initWW * 0.5;
            double max = vol_model.j_vol.initWL + vol_model.j_vol.initWW * 0.5;
            range[0] = min;
            range[1] = max;
        }
        return range;
    }

    @Override
    public void removePropertyChangeListener(String s, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(s, l);
    }

    static {
        String jitterProperty = XpPropertiesManager.getProperty("jami.rayjitter", "true");
        rayjitter = Boolean.parseBoolean(jitterProperty);
    }

    private static class ImageBlitter
    extends XpImage2DRenderer {
        private static final int TABLE_SIZE = 65536;
        private int[] colorTable = new int[65536];
        private BufferedImage srcImage = null;
        private BufferedImage drawable = null;
        private double zoom = 0.0;
        private double ww = 0.0;
        private double wl = 0.0;
        private boolean ivideo = false;
        private boolean dirtyWWWL = true;
        private int type = 11;

        private ImageBlitter() {
        }

        public final void dirty() {
            this.dirtyWWWL = true;
        }

        @Override
        public final void newImageCB(RenderedImage image) {
            this.srcImage = (BufferedImage)image;
            this.type = this.srcImage.getType();
        }

        public final void setRGBDrawable(BufferedImage drawable) {
            this.drawable = drawable;
        }

        @Override
        public void newImageRenderAttributesCB(XpImageRenderAttributes attr) {
            if (this.zoom != attr.getZoom()) {
                this.zoom = attr.getZoom();
            }
            if (this.ww != attr.getWindowWidth() || this.wl != attr.getWindowLevel() || this.ivideo != attr.isVideoInverted()) {
                this.ww = attr.getWindowWidth();
                this.wl = attr.getWindowLevel();
                this.ivideo = attr.isVideoInverted();
                this.dirtyWWWL = true;
            }
        }

        public void fillDrawable() {
            short[] sData = ((DataBufferUShort)this.srcImage.getRaster().getDataBuffer()).getData();
            int[] pixels = ((DataBufferInt)this.drawable.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < sData.length; ++i) {
                short v = sData[i];
                int pixIdx = v & 0xFFFF;
                int pixVal = this.colorTable[pixIdx];
                pixels[i] = pixVal & 0xFFFFFFFF;
            }
        }

        private void loadPixelData() {
            XpImage theImage = this.getFrame();
            if (theImage != null) {
                RenderedImage ri = theImage.getPixelData();
                this.newImageCB(ri);
            }
        }

        @Override
        public void render(Graphics graphics, Rectangle viewport) {
            this.loadPixelData();
            XpImageRenderAttributes ira = this.getAttributes();
            if (this.dirtyWWWL && this.type == 11) {
                this.fillColorTable(ira, this.colorTable);
                this.fillDrawable();
            }
        }
    }
}

