/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class StatusPanel
extends JPanel
implements TaskMonitor {
    private Map taskMap_ = new HashMap();
    private JLabel message_ = new JLabel();
    private JProgressBar progressBar_ = new JProgressBar();
    private String activeTask_;

    public StatusPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Box b = Box.createHorizontalBox();
                StatusPanel.this.setLayout(new BorderLayout());
                StatusPanel.this.setBorder(new EmptyBorder(3, 3, 3, 3));
                StatusPanel.this.add((Component)new JSeparator(), "North");
                StatusPanel.this.add(b);
                b.add(StatusPanel.this.message_);
                b.add(Box.createHorizontalGlue());
                StatusPanel.this.progressBar_.setMaximumSize(StatusPanel.this.progressBar_.getPreferredSize());
                b.add(StatusPanel.this.progressBar_);
                StatusPanel.this.message_.setVisible(false);
                StatusPanel.this.progressBar_.setVisible(false);
                b.setPreferredSize(StatusPanel.this.progressBar_.getPreferredSize());
            }
        });
    }

    @Override
    public void taskBegin(final String taskName, final int totalWork) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusPanel.this.taskMap_.put(taskName, new int[]{totalWork, 0});
                StatusPanel.this.message_.setText(taskName);
                StatusPanel.this.progressBar_.setIndeterminate(totalWork == -1);
                if (totalWork != -1) {
                    StatusPanel.this.progressBar_.setMaximum(totalWork);
                }
                StatusPanel.this.message_.setVisible(true);
                StatusPanel.this.progressBar_.setVisible(true);
                StatusPanel.this.activeTask_ = taskName;
            }
        });
    }

    @Override
    public void taskDone(final String taskName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusPanel.this.taskMap_.remove(taskName);
                Iterator it = StatusPanel.this.taskMap_.keySet().iterator();
                if (it.hasNext()) {
                    String task = (String)it.next();
                    int[] taskInfo = (int[])StatusPanel.this.taskMap_.get(task);
                    StatusPanel.this.message_.setText(task);
                    StatusPanel.this.progressBar_.setIndeterminate(taskInfo[0] == -1);
                    if (taskInfo[0] != -1) {
                        StatusPanel.this.progressBar_.setValue(taskInfo[1]);
                    }
                } else {
                    StatusPanel.this.progressBar_.setVisible(false);
                    StatusPanel.this.message_.setVisible(false);
                }
            }
        });
    }

    @Override
    public void taskProgress(final String taskName, final int units) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int[] taskInfo = (int[])StatusPanel.this.taskMap_.get(taskName);
                if (taskInfo != null) {
                    taskInfo[1] = units;
                }
                if (StatusPanel.this.activeTask_.equals(taskName)) {
                    StatusPanel.this.progressBar_.setValue(units);
                }
            }
        });
    }

    @Override
    public void taskFailed(String taskName, String reason, Exception e) {
    }
}

