/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.XjMemVolume;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolume;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.Worker;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.render.Bicubic;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ResampledVolume
implements XjMemVolume {
    private static final double SPACING_EPSILON = 0.001;
    private static final int INIT_VAL = -99;
    private static ParallelTaskManager ptm = new ParallelTaskManager();
    private XjVolumeInfo vol = null;
    private double spacing_xy = 1.0;
    private double[] zdir = new double[3];
    private double[] slopes = null;
    private int PAD = 0;
    private Object voldata = null;
    private boolean normalize = false;
    private int pixelRepresentation = 1;
    private double rescaleSlope = 1.0;
    private String modality = "";
    private VolumeGeom origVol = new VolumeGeom();
    private VolumeGeom newVol = new VolumeGeom();

    public ResampledVolume(XjVolumeInfo vol, int zMultiplicity) {
        this.init(vol);
        this.newVol.dz = this.origVol.dz * zMultiplicity;
        this.newVol.spz = this.origVol.spz / (double)zMultiplicity;
        this.initNewVol();
        System.err.println("ResampledMultVolume:: Resampling to new dimensions: dz=" + this.newVol.dz + "  z-spacing=" + this.newVol.spz + "  (old-dz=" + this.origVol.dz + ", old-spz=" + this.origVol.spz + ")");
        long t0 = System.currentTimeMillis();
        Worker[] workers = new BicubicMultWorker[ParallelTaskManager.NCPUS];
        for (int i = 0; i < ParallelTaskManager.NCPUS; ++i) {
            workers[i] = new BicubicMultWorker(ptm, i);
        }
        ptm.setWorkers(workers);
        if (vol.getBitsPerVoxel() == 8) {
            this.voldata = new byte[2 * this.PAD + this.newVol.dx * this.newVol.dy * this.newVol.dz];
            this.resampleMultByte((byte[])this.voldata, zMultiplicity);
        } else {
            this.voldata = new short[2 * this.PAD + this.newVol.dx * this.newVol.dy * this.newVol.dz];
            this.resampleMultShort((short[])this.voldata, zMultiplicity);
        }
        long time = System.currentTimeMillis() - t0;
        System.err.println("ResampledMultVolume:: Resampling time = " + time);
    }

    public ResampledVolume(XjVolumeInfo vol) {
        this.init(vol);
        if (this.origVol.spz <= this.origVol.spx) {
            if (vol.getBitsPerVoxel() == 8) {
                JVolume.LinearByte jlb = new JVolume.LinearByte(vol);
                this.PAD = jlb.PAD;
                this.voldata = jlb.volume;
            } else {
                JVolume.LinearShort jls = new JVolume.LinearShort(vol);
                this.PAD = jls.PAD;
                this.voldata = jls.volume;
            }
            this.newVol.dz = this.origVol.dz;
            this.newVol.spz = this.origVol.spz;
        }
        this.newVol.spz = this.spacing_xy;
        double zside = (double)(this.origVol.dz - 1) * this.origVol.spz;
        this.newVol.dz = (int)(zside / this.newVol.spz) + 1;
        this.initNewVol();
        System.err.println("ResampledVolume:: Resampling to new dimensions: dz=" + this.newVol.dz + "  z-spacing=" + this.newVol.spz + "  (old-dz=" + this.origVol.dz + ", old-spz=" + this.origVol.spz + ")");
        long t0 = System.currentTimeMillis();
        Worker[] workers = new BicubicWorker[ParallelTaskManager.NCPUS];
        for (int i = 0; i < ParallelTaskManager.NCPUS; ++i) {
            workers[i] = new BicubicWorker(ptm, i);
        }
        ptm.setWorkers(workers);
        if (vol.getBitsPerVoxel() == 8) {
            this.voldata = new byte[2 * this.PAD + this.newVol.dx * this.newVol.dy * this.newVol.dz];
            this.resampleByte((byte[])this.voldata);
        } else {
            this.voldata = new short[2 * this.PAD + this.newVol.dx * this.newVol.dy * this.newVol.dz];
            this.resampleShort((short[])this.voldata);
        }
        long time = System.currentTimeMillis() - t0;
        System.err.println("ResampledVolume:: Resampling time = " + time);
    }

    private void init(XjVolumeInfo vol) {
        this.vol = vol;
        Object obj = vol.getValue(40, 4179);
        if (obj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)obj, "\\");
            this.rescaleSlope = Double.parseDouble(st.nextToken());
        } else if (obj instanceof Number) {
            this.rescaleSlope = ((Number)obj).doubleValue();
        }
        try {
            Object val = vol.getValue(40, 259);
            if (val != null) {
                this.pixelRepresentation = Integer.parseInt(val.toString());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.modality = ("" + vol.getValue(8, 96)).toUpperCase();
        double[] xdir = this.vol.getXDirectionRAS(null);
        double[] ydir = this.vol.getYDirectionRAS(null);
        this.vol.getZDirectionRAS(this.zdir);
        double spx = JnVector3d.length(xdir);
        double spy = JnVector3d.length(ydir);
        double spz = JnVector3d.length(this.zdir);
        if (Math.abs(spx - spy) > 0.001) {
            throw new RuntimeException("Input volume not isotropic in X and Y dims : [" + spx + ", " + spy + "]");
        }
        int[] dims = this.vol.getVolumeDimensions(null);
        this.origVol.dx = dims[0];
        this.origVol.dy = dims[1];
        this.origVol.dz = dims[2];
        this.origVol.spx = spx;
        this.origVol.spy = spy;
        this.origVol.spz = spz;
        this.newVol.dx = dims[0];
        this.newVol.dy = dims[1];
        this.newVol.spx = spx;
        this.newVol.spy = spy;
        this.spacing_xy = (spx + spy) * 0.5;
        this.PAD = 2 * this.origVol.dx * this.origVol.dy;
    }

    private void initNewVol() {
        JnVector3d.normalize(this.zdir);
        JnVector3d.scale(this.zdir, this.newVol.spz);
        this.slopes = new double[this.newVol.dz];
        if (this.modality.equals("PT")) {
            for (int i = 0; i < this.newVol.dz; ++i) {
                double d;
                this.slopes[i] = d = this.getSliceRescaleSlope(i);
                if (i == 0) {
                    this.rescaleSlope = d;
                    continue;
                }
                if (this.rescaleSlope != d) {
                    this.normalize = true;
                }
                if (!(this.rescaleSlope < d)) continue;
                this.rescaleSlope = d;
            }
            XpLog.logger().config("-- PET RESCALE SLOPE=" + this.rescaleSlope);
        } else {
            Arrays.fill(this.slopes, 1.0);
        }
    }

    private void resampleByte(byte[] dest) {
        int dx = this.origVol.dx;
        int dy = this.origVol.dy;
        int pgsize = dx * dy;
        if (this.vol instanceof XjVolume) {
            XjVolume xjvol = (XjVolume)this.vol;
            byte[][] interp = new byte[4][];
            int base_zidx = -99;
            int[] zpos = new int[this.newVol.dz];
            for (int i = 0; i < this.newVol.dz; ++i) {
                double s = (double)i / (double)(this.newVol.dz - 1) * (double)(this.origVol.dz - 1);
                zpos[i] = (int)(s * 16384.0);
            }
            JVolume.fillVolumeSlice(xjvol, dest, pgsize, this.PAD, 0);
            JVolume.fillVolumeSlice(xjvol, dest, pgsize, this.PAD + (this.newVol.dz - 1) * pgsize, this.origVol.dz - 1);
            BicubicWorkData bwd = new BicubicWorkData();
            for (int i = 1; i < this.newVol.dz - 1; ++i) {
                int iz = zpos[i] >> 14;
                bwd.izfrac = zpos[i] & 0x3FFF;
                bwd.izfrac_1 = 16384 - bwd.izfrac;
                base_zidx = this.fillSlices(interp, xjvol, base_zidx, iz - 1);
                bwd.dest_offset = this.PAD + i * pgsize;
                bwd.interp_data = interp;
                bwd.dest_data = dest;
                ptm.launch(bwd);
            }
        }
    }

    private void resampleShort(short[] dest) {
        int dx = this.origVol.dx;
        int dy = this.origVol.dy;
        int pgsize = dx * dy;
        if (this.vol instanceof XjVolume) {
            XjVolume xjvol = (XjVolume)this.vol;
            short[][] interp = new short[4][];
            int base_zidx = -99;
            int[] zpos = new int[this.newVol.dz];
            for (int i = 0; i < this.newVol.dz; ++i) {
                double s = (double)i / (double)(this.newVol.dz - 1) * (double)(this.origVol.dz - 1);
                zpos[i] = (int)(s * 16384.0);
            }
            BicubicWorkData bwd = new BicubicWorkData();
            JVolume.fillVolumeSlice(xjvol, dest, pgsize, this.PAD, 0, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(0), this.normalize);
            JVolume.fillVolumeSlice(xjvol, dest, pgsize, this.PAD + (this.newVol.dz - 1) * pgsize, this.origVol.dz - 1, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(this.origVol.dz - 1), this.normalize);
            long bicubicTime = 0L;
            for (int i = 1; i < this.newVol.dz - 1; ++i) {
                int iz = zpos[i] >> 14;
                bwd.izfrac = zpos[i] & 0x3FFF;
                bwd.izfrac_1 = 16384 - bwd.izfrac;
                base_zidx = this.fillSlices(interp, xjvol, base_zidx, iz - 1);
                bwd.dest_offset = this.PAD + i * pgsize;
                bwd.interp_data = interp;
                bwd.dest_data = dest;
                long t0 = System.currentTimeMillis();
                ptm.launch(bwd);
                bicubicTime += System.currentTimeMillis() - t0;
            }
            System.err.println("ResampledVolume:: Bicubic Time (Short volume): " + bicubicTime);
        }
    }

    private void resampleMultByte(byte[] dest, int zMult) {
        int dx = this.origVol.dx;
        int dy = this.origVol.dy;
        int pgsize = dx * dy;
        if (this.vol instanceof XjVolume) {
            XjVolume xjvol = (XjVolume)this.vol;
            int[] zpos = new int[this.newVol.dz];
            double deltaZ = 1.0 / (double)zMult;
            double s = 0.0;
            int i = 0;
            while (i < this.newVol.dz) {
                zpos[i] = (int)(s * 16384.0);
                ++i;
                s += deltaZ;
            }
            int index = 0;
            int i2 = 0;
            while (i2 < this.newVol.dz) {
                JVolume.fillVolumeSlice(xjvol, dest, pgsize, this.PAD + i2 * pgsize, index);
                i2 += zMult;
                ++index;
            }
            BicubicWorkData bwd = new BicubicWorkData();
            bwd.zMult = zMult;
            for (int i3 = 1; i3 < this.newVol.dz; ++i3) {
                int iz;
                if (i3 % zMult == 0) continue;
                bwd.iz = iz = zpos[i3] >> 14;
                bwd.offset = this.PAD + iz * zMult * pgsize;
                bwd.izfrac = zpos[i3] & 0x3FFF;
                bwd.izfrac_1 = 16384 - bwd.izfrac;
                bwd.dest_offset = this.PAD + i3 * pgsize;
                bwd.interp_data = null;
                bwd.dest_data = dest;
                ptm.launch(bwd);
            }
        }
    }

    private void resampleMultShort(short[] dest, int zMult) {
        int dx = this.origVol.dx;
        int dy = this.origVol.dy;
        int pgsize = dx * dy;
        if (this.vol instanceof XjVolume) {
            XjVolume xjvol = (XjVolume)this.vol;
            int[] zpos = new int[this.newVol.dz];
            double deltaZ = 1.0 / (double)zMult;
            double s = 0.0;
            int i = 0;
            while (i < this.newVol.dz) {
                zpos[i] = (int)(s * 16384.0);
                ++i;
                s += deltaZ;
            }
            int index = 0;
            int i2 = 0;
            while (i2 < this.newVol.dz) {
                JVolume.fillVolumeSlice(xjvol, dest, pgsize, this.PAD + i2 * pgsize, index, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(index), this.normalize);
                i2 += zMult;
                ++index;
            }
            BicubicWorkData bwd = new BicubicWorkData();
            bwd.zMult = zMult;
            long bicubicTime = 0L;
            for (int i3 = 1; i3 < this.newVol.dz; ++i3) {
                int iz;
                if (i3 % zMult == 0) continue;
                bwd.iz = iz = zpos[i3] >> 14;
                bwd.offset = this.PAD + iz * zMult * pgsize;
                bwd.izfrac = zpos[i3] & 0x3FFF;
                bwd.izfrac_1 = 16384 - bwd.izfrac;
                bwd.dest_offset = this.PAD + i3 * pgsize;
                bwd.interp_data = null;
                bwd.dest_data = dest;
                long t0 = System.currentTimeMillis();
                ptm.launch(bwd);
                bicubicTime += System.currentTimeMillis() - t0;
            }
            System.err.println("ResampledMultVolume:: Bicubic Time (Short volume): " + bicubicTime);
        }
    }

    private int fillSlices(short[][] interp, XjVolume xjvol, int base_idx, int load_idx) {
        block4: {
            int dy;
            int dx;
            block3: {
                dx = this.origVol.dx;
                dy = this.origVol.dy;
                if (base_idx != -99) break block3;
                for (int i = 0; i < 4; ++i) {
                    int sliceIdx = i + load_idx;
                    interp[i] = new short[dx * dy];
                    if (sliceIdx < 0 || sliceIdx >= this.origVol.dz - 1) continue;
                    JVolume.fillVolumeSlice(xjvol, interp[i], dx * dy, 0, sliceIdx, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(sliceIdx), this.normalize);
                }
                break block4;
            }
            if (load_idx <= base_idx) break block4;
            for (int i = 0; i < 4; ++i) {
                int sliceIdx = i + load_idx;
                if (sliceIdx - base_idx < 4) {
                    interp[i] = interp[sliceIdx - base_idx];
                    continue;
                }
                interp[i] = new short[dx * dy];
                if (sliceIdx < 0 || sliceIdx >= this.origVol.dz - 1) continue;
                JVolume.fillVolumeSlice(xjvol, interp[i], dx * dy, 0, sliceIdx, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(sliceIdx), this.normalize);
            }
        }
        return load_idx;
    }

    private int fillSlices(byte[][] interp, XjVolume xjvol, int base_idx, int load_idx) {
        block4: {
            int dy;
            int dx;
            block3: {
                dx = this.origVol.dx;
                dy = this.origVol.dy;
                if (base_idx != -99) break block3;
                for (int i = 0; i < 4; ++i) {
                    int sliceIdx = i + load_idx;
                    interp[i] = new byte[dx * dy];
                    if (sliceIdx < 0 || sliceIdx >= this.origVol.dz - 1) continue;
                    JVolume.fillVolumeSlice(xjvol, interp[i], dx * dy, 0, sliceIdx);
                }
                break block4;
            }
            if (load_idx <= base_idx) break block4;
            for (int i = 0; i < 4; ++i) {
                int sliceIdx = i + load_idx;
                if (sliceIdx - base_idx < 4) {
                    interp[i] = interp[sliceIdx - base_idx];
                    continue;
                }
                interp[i] = new byte[dx * dy];
                if (sliceIdx < 0 || sliceIdx >= this.origVol.dz - 1) continue;
                JVolume.fillVolumeSlice(xjvol, interp[i], dx * dy, 0, sliceIdx);
            }
        }
        return load_idx;
    }

    @Override
    public Object getSliceData(int sliceNo) {
        return this.voldata;
    }

    @Override
    public int getSliceOffset(int sliceNo) {
        return this.PAD + sliceNo * (this.origVol.dx * this.origVol.dy);
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    @Override
    public int getBitsPerVoxel() {
        return this.vol.getBitsPerVoxel();
    }

    @Override
    public int getPixelType() {
        return this.vol.getPixelType();
    }

    @Override
    public Object getVSliceValue(int sliceNo, int group, int element) {
        int effSlice = (int)((double)sliceNo / (double)this.newVol.dz * (double)this.origVol.dz);
        if (effSlice >= this.origVol.dz) {
            effSlice = this.origVol.dz - 1;
        }
        return this.vol.getVSliceValue(effSlice, group, element);
    }

    @Override
    public String getRelatedComposite() {
        return this.vol.getRelatedComposite();
    }

    @Override
    public Object getValue(int group, int element) {
        return this.vol.getValue(group, element);
    }

    @Override
    public int getValues(XjTagValue[] tv) {
        return this.vol.getValues(tv);
    }

    @Override
    public int[] getVolumeDimensions(int[] dims) {
        if (dims == null) {
            dims = new int[]{this.newVol.dx, this.newVol.dy, this.newVol.dz};
        }
        return dims;
    }

    @Override
    public double[] getRASOfOrigin(double[] ras_ulc) {
        return this.vol.getRASOfOrigin(ras_ulc);
    }

    @Override
    public double[] getXDirectionRAS(double[] ras_dx) {
        return this.vol.getXDirectionRAS(ras_dx);
    }

    @Override
    public double[] getYDirectionRAS(double[] ras_dy) {
        return this.vol.getYDirectionRAS(ras_dy);
    }

    @Override
    public double[] getZDirectionRAS(double[] ras_dz) {
        if (ras_dz == null) {
            ras_dz = new double[3];
        }
        System.arraycopy(this.zdir, 0, ras_dz, 0, 3);
        return ras_dz;
    }

    private double getSliceRescaleSlope(int idx) {
        Object o = this.vol.getVSliceValue(idx, 40, 4179);
        double d = 1.0;
        if (o != null) {
            d = o instanceof String ? Double.parseDouble((String)o) : ((Number)o).doubleValue();
        }
        return d;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            DMSession dms = new DMSession(new String[]{"file", args[0]});
            DMObject[] dmo = dms.getRelated("series");
            DMVolume vol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[0]});
            ResampledVolume rsv = new ResampledVolume(vol, 2);
            J3DVolumeModel jvm = new J3DVolumeModel(rsv);
            jvm.init();
            JFrame jf = new JFrame("Resampled Volume");
            JPanel contentPanel = new JPanel();
            contentPanel.setLayout(new GridLayout(1, 2));
            contentPanel.setPreferredSize(new Dimension(1400, 700));
            T3DViewport vp0 = new T3DViewport();
            vp0.setVolumeModel(jvm);
            vp0.setRenderStyle("VOLUME");
            T3DViewport vp1 = new T3DViewport();
            vp1.setVolume(vol);
            vp1.setRenderStyle("VOLUME");
            contentPanel.add(vp0);
            contentPanel.add(vp1);
            jf.setContentPane(contentPanel);
            jf.pack();
            jf.setDefaultCloseOperation(3);
            jf.setVisible(true);
        } else {
            System.err.println("Usage: ResampledVolume <volumePath>");
        }
    }

    private class BicubicMultWorker
    extends Worker {
        public BicubicMultWorker(ParallelTaskManager ptm, int workerId) {
            super(ptm, workerId);
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            BicubicWorkData bwd = (BicubicWorkData)data;
            int dx = ((ResampledVolume)ResampledVolume.this).origVol.dx;
            int dy = ((ResampledVolume)ResampledVolume.this).origVol.dy;
            int pgsize = dx * dy;
            int k0 = Bicubic.ctable[bwd.izfrac];
            int k1 = Bicubic.ctable[bwd.izfrac + 16384];
            int k2 = Bicubic.ctable[bwd.izfrac_1];
            int k3 = Bicubic.ctable[bwd.izfrac_1 + 16384];
            int idx_1 = bwd.offset;
            int idx_0 = idx_1 - bwd.zMult * pgsize;
            int idx_2 = idx_1 + bwd.zMult * pgsize;
            int idx_3 = idx_2 + bwd.zMult * pgsize;
            if (bwd.dest_data instanceof short[]) {
                short[] vol = (short[])ResampledVolume.this.voldata;
                short[] dest = (short[])bwd.dest_data;
                idx_0 = idx_0 < 0 ? 0 : idx_0;
                idx_2 = idx_2 > vol.length - 1 ? 0 : idx_2;
                idx_3 = idx_3 > vol.length - 1 ? 0 : idx_3;
                for (int y = 0; y < dy; ++y) {
                    int yoffset = y * dx;
                    for (int x = workerId; x < dx; x += nWorkers) {
                        int idx = yoffset + x;
                        short v0 = vol[idx_0 + idx];
                        short v1 = vol[idx_1 + idx];
                        short v2 = vol[idx_2 + idx];
                        short v3 = vol[idx_3 + idx];
                        dest[bwd.dest_offset + yoffset + x] = (short)(k0 * v1 + k1 * v0 + k2 * v2 + k3 * v3 >> 14);
                    }
                }
            } else {
                byte[] vol = (byte[])ResampledVolume.this.voldata;
                byte[] dest = (byte[])bwd.dest_data;
                idx_0 = idx_0 < 0 ? 0 : idx_0;
                idx_2 = idx_2 > vol.length - 1 ? 0 : idx_2;
                idx_3 = idx_3 > vol.length - 1 ? 0 : idx_3;
                for (int y = 0; y < dy; ++y) {
                    int yoffset = y * dx;
                    for (int x = workerId; x < dx; x += nWorkers) {
                        int idx = yoffset + x;
                        int v0 = vol[idx_0 + idx] & 0xFF;
                        int v1 = vol[idx_1 + idx] & 0xFF;
                        int v2 = vol[idx_2 + idx] & 0xFF;
                        int v3 = vol[idx_3 + idx] & 0xFF;
                        dest[bwd.dest_offset + yoffset + x] = (byte)(k0 * v1 + k1 * v0 + k2 * v2 + k3 * v3 >> 14);
                    }
                }
            }
        }
    }

    private class BicubicWorker
    extends Worker {
        public BicubicWorker(ParallelTaskManager ptm, int workerId) {
            super(ptm, workerId);
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            BicubicWorkData bwd = (BicubicWorkData)data;
            int dx = ((ResampledVolume)ResampledVolume.this).origVol.dx;
            int dy = ((ResampledVolume)ResampledVolume.this).origVol.dy;
            int k0 = Bicubic.ctable[bwd.izfrac];
            int k1 = Bicubic.ctable[bwd.izfrac + 16384];
            int k2 = Bicubic.ctable[bwd.izfrac_1];
            int k3 = Bicubic.ctable[bwd.izfrac_1 + 16384];
            if (bwd.dest_data instanceof short[]) {
                short[][] interp = (short[][])bwd.interp_data;
                short[] dest = (short[])bwd.dest_data;
                for (int y = 0; y < dy; ++y) {
                    int yoffset = y * dx;
                    for (int x = workerId; x < dx; x += nWorkers) {
                        int idx = yoffset + x;
                        short v0 = interp[0][idx];
                        short v1 = interp[1][idx];
                        short v2 = interp[2][idx];
                        short v3 = interp[3][idx];
                        dest[bwd.dest_offset + idx] = (short)(k0 * v1 + k1 * v0 + k2 * v2 + k3 * v3 >> 14);
                    }
                }
            } else {
                byte[][] interp = (byte[][])bwd.interp_data;
                byte[] dest = (byte[])bwd.dest_data;
                for (int y = 0; y < dy; ++y) {
                    int yoffset = y * dx;
                    for (int x = workerId; x < dx; x += nWorkers) {
                        int idx = yoffset + x;
                        int v0 = interp[0][idx] & 0xFF;
                        int v1 = interp[1][idx] & 0xFF;
                        int v2 = interp[2][idx] & 0xFF;
                        int v3 = interp[3][idx] & 0xFF;
                        dest[bwd.dest_offset + idx] = (byte)(k0 * v1 + k1 * v0 + k2 * v2 + k3 * v3 >> 14);
                    }
                }
            }
        }
    }

    private static class BicubicWorkData {
        public int dest_offset = 0;
        public int izfrac = 0;
        public int izfrac_1 = 0;
        public int iz = 0;
        public int offset = 0;
        public int zMult = 1;
        public Object interp_data = null;
        public Object dest_data = null;

        private BicubicWorkData() {
        }
    }

    private static class VolumeGeom {
        public double spx = 0.0;
        public double spy = 0.0;
        public double spz = 0.0;
        public int dx = 0;
        public int dy = 0;
        public int dz = 0;

        private VolumeGeom() {
        }
    }
}

