/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.RayBox;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.j3d.SlabLocationRangeModel;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import javax.swing.DefaultBoundedRangeModel;

public class DefaultSlabLocationRangeModel
extends DefaultBoundedRangeModel
implements SlabLocationRangeModel {
    private CPoint refPoint_ = new CPoint(2);
    private RayBox rayBox = new RayBox();
    private JnVector3d planeNormal_ = new JnVector3d(0.0, 0.0, 1.0);
    private JnVector3d minPt_ = new JnVector3d();
    private JnVector3d maxPt_ = new JnVector3d();
    private double stepSize_ = 1.0;
    private XjVolumeGeometry volume_;

    @Override
    public CPoint getReferencePoint() {
        return new CPoint(this.refPoint_.x, this.refPoint_.y, this.refPoint_.z, 2);
    }

    @Override
    public void setReferencePoint(CPoint refPt) {
        if (refPt == null || this.refPoint_.equals(refPt)) {
            return;
        }
        this.refPoint_.set(refPt);
        this.updateModel();
    }

    private void updateModel() {
        if (this.volume_ == null) {
            return;
        }
        double[] xdir = this.volume_.getXDirectionRAS(null);
        double[] ydir = this.volume_.getYDirectionRAS(null);
        double[] zdir = this.volume_.getZDirectionRAS(null);
        double[] orig = this.volume_.getRASOfOrigin(null);
        int[] dims = this.volume_.getVolumeDimensions(null);
        JnVector3d xv = new JnVector3d(xdir);
        JnVector3d yv = new JnVector3d(ydir);
        JnVector3d zv = new JnVector3d(zdir);
        double xlen = xv.length();
        double ylen = yv.length();
        double zlen = zv.length();
        double[] refVolume = XjVolumeUtils.RAStoVoxelIndex(this.refPoint_.generateArray(), xdir, ydir, zdir, orig, null);
        refVolume[0] = refVolume[0] * xlen;
        refVolume[1] = refVolume[1] * ylen;
        refVolume[2] = refVolume[2] * zlen;
        JnVector3d refVolumeV = new JnVector3d(refVolume);
        this.minPt_.set(0.0, 0.0, 0.0);
        this.maxPt_.set((double)dims[0] * xlen, (double)dims[1] * ylen, (double)dims[2] * zlen);
        xv.scale(1.0 / xlen);
        yv.scale(1.0 / ylen);
        zv.scale(1.0 / zlen);
        JnVector3d planeNormalVolume = new JnVector3d(this.planeNormal_.generateArray());
        JnMatrix3d rasToVolumeXform = new JnMatrix3d(new double[]{xv.x, xv.y, xv.z, yv.x, yv.y, yv.z, zv.x, zv.y, zv.z});
        rasToVolumeXform.transform(planeNormalVolume);
        double size = this.maxPt_.x - this.minPt_.x + this.maxPt_.y - this.minPt_.y + this.maxPt_.z - this.minPt_.z;
        JnVector3d intersection1 = new JnVector3d();
        JnVector3d intersection2 = new JnVector3d();
        JnVector3d orig1 = new JnVector3d(refVolume[0], refVolume[1], refVolume[2]);
        JnVector3d orig2 = new JnVector3d(refVolume[0], refVolume[1], refVolume[2]);
        orig1.scaleAdd(size, planeNormalVolume);
        orig2.scaleAdd(-size, planeNormalVolume);
        this.rayBox.hitBoundingBox(this.minPt_, this.maxPt_, orig1, new JnVector3d(-planeNormalVolume.x, -planeNormalVolume.y, -planeNormalVolume.z), intersection1);
        this.rayBox.hitBoundingBox(this.minPt_, this.maxPt_, orig2, planeNormalVolume, intersection2);
        intersection1.sub(refVolumeV);
        double t1 = intersection1.dot(planeNormalVolume);
        intersection2.sub(refVolumeV);
        double t2 = intersection2.dot(planeNormalVolume);
        this.setRangeProperties(0, 0, Math.min((int)(t2 / this.stepSize_) + 1, 0), Math.max((int)(t1 / this.stepSize_) - 1, 0), this.getValueIsAdjusting());
        this.fireStateChanged();
    }

    @Override
    public JnVector3d getPlaneNormal() {
        return new JnVector3d(this.planeNormal_.x, this.planeNormal_.y, this.planeNormal_.z);
    }

    @Override
    public void setPlaneNormal(JnVector3d direction) {
        if (direction == null) {
            return;
        }
        JnVector3d v = new JnVector3d(this.planeNormal_.x, this.planeNormal_.y, this.planeNormal_.z);
        v.sub(direction);
        if (v.lengthSquared() < 0.001) {
            return;
        }
        this.planeNormal_.set(direction.x, direction.y, direction.z);
        this.updateModel();
    }

    @Override
    public double getStepSize() {
        return this.stepSize_;
    }

    @Override
    public void setStepSize(double step) {
        if (step == this.stepSize_) {
            return;
        }
        this.stepSize_ = step;
        this.updateModel();
    }

    public DefaultSlabLocationRangeModel(JnVector3d refPoint, JnVector3d normal, XjVolumeGeometry volume, double stepSize) {
        if (refPoint == null || normal == null || stepSize <= 0.0) {
            throw new IllegalArgumentException("invalid individual parameters");
        }
        this.volume_ = volume;
        this.refPoint_.set(refPoint.x, refPoint.y, refPoint.z);
        this.planeNormal_.set(normal.x, normal.y, normal.z);
        this.planeNormal_.normalize();
        this.stepSize_ = stepSize;
        this.updateModel();
    }

    @Override
    public String toString() {
        return super.toString() + ", ref=" + this.refPoint_ + ", norm=" + this.planeNormal_ + ", step=" + this.stepSize_;
    }

    @Override
    public void setVolume(XjVolumeGeometry volume) {
        this.volume_ = volume;
        this.updateModel();
    }

    @Override
    public XjVolumeGeometry getVolume() {
        return this.volume_;
    }
}

