/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image.patterns;

import java.awt.Point;

public class Hazed3DCone {
    private int w;
    private int h;

    public void create(byte[] d, int w, int h, int solidR, int decayR, double decayX, int angle, int slice, boolean invert) {
        this.w = w;
        this.h = h;
        int max = -1;
        boolean min = false;
        int bgcolor = 0xFFCCCC;
        d = this.fillBackGround(d, bgcolor);
        Point center = new Point(w / 2, h / 2);
        d = this.drawHazed3DCone(d, solidR, decayR, angle, decayX, invert, slice);
        int radius = solidR < decayR ? decayR : solidR + decayR;
        center.setLocation(w / 2, 6 * h / 8);
    }

    private byte[] drawSolidEllipse(byte[] d, int solidR, Point center, int color, int angle) {
        int x0 = (int)center.getX();
        int y0 = (int)center.getY();
        double cos = Math.cos((double)angle * Math.PI / 180.0);
        if (cos < 0.0) {
            cos = -cos;
        }
        int compress = (int)(cos * (double)solidR);
        int ytop = y0 - compress;
        int ybottom = y0 + compress;
        for (int y = ytop; y < ybottom; ++y) {
            int w = (int)(Math.sqrt(1.0 - Math.pow(y - y0, 2.0) / Math.pow(compress, 2.0)) * (double)solidR);
            int startPixel = y * this.w * 3 + (x0 - w) * 3;
            int endPixel = startPixel + 2 * w * 3;
            for (int i = startPixel; i < endPixel; i += 3) {
                d[i] = (byte)(color >> 16 & 0xFF);
                d[i + 1] = (byte)(color >> 8 & 0xFF);
                d[i + 2] = (byte)(color >> 0 & 0xFF);
            }
        }
        return d;
    }

    private byte[] drawHazedEllipse(byte[] d, int solidR, int decayR, Point center, int angle, double decayX, boolean invert) {
        int x = decayR - solidR;
        int b = 0;
        if (x < 0) {
            x = decayR;
        }
        for (int i = 0; i < x; ++i) {
            b = invert ? (int)(255.0 * (1.0 - Math.exp((double)(-i) / decayX))) & 0xFF : (int)(255.0 * Math.exp((double)(-i) / decayX)) & 0xFF;
            int color = (b << 16) + (b << 8) + 0;
            d = this.drawSolidEllipse(d, solidR + (x - i), center, color, angle);
        }
        d = this.drawSolidEllipse(d, solidR, center, 0, angle);
        return d;
    }

    private byte[] drawHazed3DCone(byte[] d, int solidR, int decayR, int angle, double decayX, boolean invert, double slice) {
        int temp;
        int top = 4 * this.h / 8 - (int)((double)(3 * this.h / 8) * Math.sin((double)angle * Math.PI / 180.0));
        int bottom = 4 * this.h / 8;
        if (angle > 90 && angle < 270) {
            int temp2 = top;
            top = bottom;
            bottom = temp2;
        }
        Point center = new Point(this.w / 2, 0);
        if (slice < 100.0) {
            slice = 100.0;
        }
        if ((double)(temp = this.h / (int)slice) - (double)this.h / slice != 0.0) {
            slice = this.h / temp;
        }
        if (slice >= (double)this.h) {
            slice = 3 * this.h / 8;
        }
        double posIndex = (double)(bottom - top) / slice;
        double rIndex = (double)solidR / slice;
        double rdIndex = (double)decayR / slice;
        int i = 0;
        while ((double)i < slice) {
            int dradius;
            int radius;
            center.y = (int)((double)bottom - posIndex * (double)i);
            if (angle < 90 || angle > 270) {
                radius = (int)((double)solidR - rIndex * (double)i);
                dradius = (int)((double)decayR - rdIndex * (double)i);
            } else {
                radius = (int)(rIndex * (double)i);
                dradius = (int)(rdIndex * (double)i);
            }
            d = this.drawHazedEllipse(d, radius, dradius, center, angle, decayX, invert);
            ++i;
        }
        return d;
    }

    private byte[] fillBackGround(byte[] d, int color) {
        for (int i = 0; i < d.length; i += 3) {
            d[i] = (byte)(color >> 16 & 0xFF);
            d[i + 1] = (byte)(color >> 8 & 0xFF);
            d[i + 2] = (byte)(color >> 0 & 0xFF);
        }
        return d;
    }

    private byte[] drawDottedLine(byte[] d, int radius, Point center, int color, int angle) {
        int x0 = (int)center.getX();
        int y0 = (int)center.getY();
        int compress = (int)(Math.cos(angle) * (double)radius);
        int ytop = y0 - compress;
        int ybottom = y0 + compress;
        for (int y = ytop; y < ybottom; y += 2) {
            int w = (int)(Math.sqrt(1.0 - Math.pow(y - y0, 2.0) / Math.pow(compress, 2.0)) * (double)radius);
            int startPixel = y * this.w * 3 + (x0 - w) * 3;
            int endPixel = startPixel + 2 * w * 3 - 3;
            d[startPixel] = (byte)(color >> 16 & 0xFF);
            d[startPixel + 1] = (byte)(color >> 8 & 0xFF);
            d[startPixel + 2] = (byte)(color >> 0 & 0xFF);
            d[endPixel] = (byte)(color >> 16 & 0xFF);
            d[endPixel + 1] = (byte)(color >> 8 & 0xFF);
            d[endPixel + 2] = (byte)(color >> 0 & 0xFF);
        }
        return d;
    }
}

