/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image;

import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.image.XpImageData;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.RenderedImage;

public class XpFileMedicalImage
implements XpMedicalImage {
    private Image img = null;
    private RenderedImage rImg = null;
    private boolean loadedDefWWWL = false;
    private double defwidth = 256.0;
    private double deflevel = 128.0;
    private double[] minmax = new double[2];
    private XpSlice slice;

    public XpFileMedicalImage(String fileName) {
        this.img = Toolkit.getDefaultToolkit().createImage(fileName);
        this.rImg = XpImageData.createBufferedImage(this.img);
        this.slice = new XpSlice(this);
    }

    @Override
    public int getValues(XpDicomElement[] values) {
        boolean allLoaded = true;
        for (int i = 0; i < values.length; ++i) {
            int result = this.getValue(values[i]);
            if (result != 1) continue;
            allLoaded = false;
        }
        if (allLoaded) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getValue(XpDicomElement value) {
        int retval = 1;
        if (value.group == 40 && value.element == 256) {
            int[] cc = this.rImg.getColorModel().getComponentSize();
            value.value = "" + cc[0];
            retval = 0;
        } else if (value.group == 40 && value.element == 257) {
            int[] cc = this.rImg.getColorModel().getComponentSize();
            value.value = "" + cc[0];
            retval = 0;
        } else if (value.group == 40 && value.element == 259) {
            value.value = "1";
            retval = 0;
        } else if (value.group == 40 && value.element == 288) {
            value.value = "65500";
            retval = 0;
        }
        return retval;
    }

    @Override
    public RenderedImage getPixelData() {
        return this.rImg;
    }

    @Override
    public double getPixelDimensionX() {
        return this.slice.pixelSizeX;
    }

    @Override
    public double getPixelDimensionY() {
        return this.slice.pixelSizeY;
    }

    @Override
    public XpSlice getSlice() {
        return this.slice;
    }

    @Override
    public double getDefaultWindowWidth() {
        if (!this.loadedDefWWWL) {
            XpImageUtils.getMinMax(this, 17, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = (int)ww;
            this.deflevel = (int)wl;
            this.loadedDefWWWL = true;
        }
        return this.defwidth;
    }

    @Override
    public double getDefaultWindowLevel() {
        if (!this.loadedDefWWWL) {
            XpImageUtils.getMinMax(this, 17, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = (int)ww;
            this.deflevel = (int)wl;
            this.loadedDefWWWL = true;
        }
        return this.deflevel;
    }

    @Override
    public final double getRescaleIntercept() {
        return 0.0;
    }

    @Override
    public final double getRescaleSlope() {
        return 1.0;
    }

    @Override
    public final double getAzimuth() {
        return 0.0;
    }
}

