/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image;

import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import java.util.Map;

public class XpBufferedImage
implements XpMedicalImage {
    private static int IMG_NUM = 0;
    private BufferedImage _bi;
    private XpSlice _slice;
    private double deflevel;
    private double defwidth;
    private Map ht = null;
    private double rescaleIntercept = -2.147483648E9;
    private double rescaleSlope = -2.147483648E9;
    private double azimuth = 0.0;
    private boolean loadedDefWL = false;
    private boolean loadedDefWW = false;
    private double[] minmax = new double[2];

    public XpBufferedImage(BufferedImage bi, Map propTable) {
        this.ht = new HashMap();
        this.ht.putAll(propTable);
        this._bi = bi;
        this._slice = new XpSlice(this);
        this.initImage();
    }

    public XpBufferedImage(BufferedImage bi, double rescaleIntercept, double rescaleSlope) {
        this._bi = bi;
        this.rescaleIntercept = rescaleIntercept;
        this.rescaleSlope = rescaleSlope;
        this._slice = new XpSlice(this);
        this.initImage();
    }

    public XpBufferedImage(BufferedImage bi, double rescaleIntercept, double rescaleSlope, double defWW, double defWL) {
        this._bi = bi;
        this.rescaleIntercept = rescaleIntercept;
        this.rescaleSlope = rescaleSlope;
        this.deflevel = defWL;
        this.defwidth = defWW;
        this.loadedDefWL = true;
        this.loadedDefWW = true;
        this._slice = new XpSlice(this);
        this.initImage();
    }

    public XpBufferedImage(BufferedImage bi) {
        this._bi = bi;
        this._slice = new XpSlice(this);
        this.initImage();
    }

    private Object getValue(String key) {
        Object o = this._bi.getProperty(key);
        if (o != Image.UndefinedProperty) {
            return o;
        }
        o = this.ht != null ? this.ht.get(key) : null;
        return o;
    }

    protected void initImage() {
        double defwidth;
        double deflevel;
        if (!this.loadedDefWL && (deflevel = XpImageUtils.parseImageWL(this.getValue("40,4176"))) > -32767.0) {
            this.deflevel = deflevel;
            this.loadedDefWL = true;
        }
        if (!this.loadedDefWW && (defwidth = XpImageUtils.parseImageWW(this.getValue("40,4177"))) >= 0.0) {
            this.defwidth = defwidth;
            this.loadedDefWW = true;
        }
        if (this.rescaleIntercept == -2.147483648E9) {
            this.rescaleIntercept = XpImageUtils.parseImageRescaleIntercept(this.getValue("40,4178"));
        }
        if (this.rescaleSlope == -2.147483648E9) {
            this.rescaleSlope = XpImageUtils.parseImageRescaleSlope(this.getValue("40,4179"));
        }
        this.azimuth = XpImageUtils.gehcAzimuth(this);
        if (this._slice.width == 0 || this._slice.height == 0) {
            this._slice.width = this._bi.getWidth();
            this._slice.height = this._bi.getHeight();
        }
    }

    public final void setPropertyTable(Map ht) {
        if (this.ht == null) {
            this.ht = new HashMap();
        }
        this.ht.putAll(ht);
        this.initImage();
    }

    @Override
    public RenderedImage getPixelData() {
        return this._bi;
    }

    @Override
    public XpSlice getSlice() {
        return this._slice;
    }

    @Override
    public double getDefaultWindowWidth() {
        if (!this.loadedDefWW) {
            int subsample = 17;
            if (this._slice.width <= 128 && this._slice.height <= 128) {
                subsample = 5;
            }
            XpImageUtils.getMinMax(this, subsample, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.defwidth;
    }

    @Override
    public double getDefaultWindowLevel() {
        if (!this.loadedDefWL) {
            int subsample = 16;
            if (this._slice.width <= 128 && this._slice.height <= 128) {
                subsample = 4;
            }
            XpImageUtils.getMinMax(this, subsample, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.deflevel;
    }

    @Override
    public double getPixelDimensionX() {
        return this._slice.pixelSizeX;
    }

    @Override
    public double getPixelDimensionY() {
        return this._slice.pixelSizeY;
    }

    public int getDefaultValue(XpDicomElement value) {
        switch (value.group) {
            case 40: {
                if (value.element == 4) {
                    value.value = "MONOCHROME2";
                    break;
                }
                if (value.element == 16) {
                    value.value = "" + this._bi.getHeight();
                    break;
                }
                if (value.element == 17) {
                    value.value = "" + this._bi.getWidth();
                    break;
                }
                if (value.element == 256) {
                    int[] cc = this._bi.getColorModel().getComponentSize();
                    value.value = "" + cc[0];
                    break;
                }
                if (value.element == 257) {
                    int[] cc = this._bi.getColorModel().getComponentSize();
                    value.value = "" + cc[0];
                    break;
                }
                if (value.element == 259) {
                    value.value = "1";
                    break;
                }
                if (value.element != 288) break;
                value.value = "65500";
            }
        }
        return 0;
    }

    @Override
    public int getValue(XpDicomElement value) {
        String key = "" + value.group + "," + value.element;
        value.value = value.group == 0 ? this._bi.getProperty(key) : this.getValue(key);
        int retCode = 0;
        if (value.value == null) {
            retCode = this.getDefaultValue(value);
        }
        return retCode;
    }

    @Override
    public int getValues(XpDicomElement[] values) {
        boolean allLoaded = true;
        for (int i = 0; i < values.length; ++i) {
            int result = this.getValue(values[i]);
            if (result != 1) continue;
            allLoaded = false;
        }
        if (allLoaded) {
            return 0;
        }
        return 1;
    }

    public void setRescaleIntercept(double ri) {
        this.rescaleIntercept = ri;
    }

    public void setRescaleSlope(double rs) {
        this.rescaleSlope = rs;
    }

    @Override
    public double getRescaleIntercept() {
        return this.rescaleIntercept;
    }

    @Override
    public double getRescaleSlope() {
        return this.rescaleSlope;
    }

    @Override
    public double getAzimuth() {
        return this.azimuth;
    }

    public static XpMedicalImage[] wrapBufferedImages(BufferedImage[] bis) {
        XpMedicalImage[] imgs = new XpMedicalImage[bis.length];
        for (int i = 0; i < bis.length; ++i) {
            imgs[i] = new XpBufferedImage(bis[i]);
        }
        return imgs;
    }

    public static XpMedicalImage[] wrapBufferedImages(BufferedImage[] bis, Map[] props) {
        if (bis.length != props.length) {
            return null;
        }
        XpMedicalImage[] imgs = new XpMedicalImage[bis.length];
        for (int i = 0; i < bis.length; ++i) {
            imgs[i] = new XpBufferedImage(bis[i], props[i]);
        }
        return imgs;
    }
}

