/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image;

import com.ge.med.idc.RemoteImage;
import com.ge.med.idc.XjDicomObjectFrame;
import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.remote.XpRemoteMedicalImage;
import java.awt.Shape;
import java.awt.image.RenderedImage;

public class XjMedicalImage
implements XpMedicalImage,
XjDicomObjectFrame {
    private XjImage image = null;
    private XpSlice slice = null;
    private double deflevel = 0.0;
    private double defwidth = 0.0;
    private double rescaleIntercept = 0.0;
    private double rescaleSlope = 1.0;
    private double azimuth = 0.0;
    private boolean loadedDefWL = false;
    private boolean loadedDefWW = false;
    private double[] minmax = new double[2];
    private boolean init = false;

    public String getFilePath() {
        return this.image.getFilePath();
    }

    protected XjImage getXjImage() {
        return this.image;
    }

    public XjMedicalImage(XjImage image) {
        this.image = image;
    }

    @Override
    public final int getValues(XpDicomElement[] values) {
        boolean allLoaded = true;
        for (int i = 0; i < values.length; ++i) {
            int result = this.getValue(values[i]);
            if (result != 1) continue;
            allLoaded = false;
        }
        if (allLoaded) {
            return 0;
        }
        return 1;
    }

    @Override
    public final int getValue(XpDicomElement value) {
        value.value = this.image.getValue(value.group, value.element);
        return value.value != null ? 0 : 1;
    }

    @Override
    public RenderedImage getPixelData() {
        this.initImage();
        return this.image.getImageData();
    }

    @Override
    public final double getPixelDimensionX() {
        return this.getSlice().pixelSizeX;
    }

    @Override
    public final double getPixelDimensionY() {
        return this.getSlice().pixelSizeY;
    }

    @Override
    public final XpSlice getSlice() {
        this.initImage();
        return this.slice;
    }

    @Override
    public final double getDefaultWindowWidth() {
        this.initImage();
        if (!this.loadedDefWW) {
            XpImageUtils.getMinMax(this, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.defwidth;
    }

    @Override
    public final double getDefaultWindowLevel() {
        this.initImage();
        if (!this.loadedDefWL) {
            XpImageUtils.getMinMax(this, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.deflevel;
    }

    @Override
    public final double getRescaleIntercept() {
        this.initImage();
        return this.rescaleIntercept;
    }

    @Override
    public final double getRescaleSlope() {
        this.initImage();
        return this.rescaleSlope;
    }

    @Override
    public final double getAzimuth() {
        this.initImage();
        return this.azimuth;
    }

    protected void initImage() {
        if (this.init) {
            return;
        }
        this.slice = new XpSlice(this);
        this.deflevel = XpImageUtils.parseImageWL(this.image.getValue(40, 4176));
        if (this.deflevel > -32767.0) {
            this.loadedDefWL = true;
        }
        this.defwidth = XpImageUtils.parseImageWW(this.image.getValue(40, 4177));
        if (this.defwidth >= 0.0) {
            this.loadedDefWW = true;
        }
        this.rescaleIntercept = XpImageUtils.parseImageRescaleIntercept(this.image.getValue(40, 4178));
        this.rescaleSlope = XpImageUtils.parseImageRescaleSlope(this.image.getValue(40, 4179));
        this.azimuth = XpImageUtils.gehcAzimuth(this);
        if (this.slice.width == 0 || this.slice.height == 0) {
            this.slice.width = this.image.getWidth();
            this.slice.height = this.image.getHeight();
        }
        this.init = true;
    }

    @Override
    public int getFrameNumber() {
        if (this.image instanceof XjDicomObjectFrame) {
            return ((XjDicomObjectFrame)((Object)this.image)).getFrameNumber();
        }
        return 0;
    }

    @Override
    public int getNumberOfFrames() {
        if (this.image instanceof XjDicomObjectFrame) {
            return ((XjDicomObjectFrame)((Object)this.image)).getNumberOfFrames();
        }
        return 1;
    }

    @Override
    public XjDicomObjectFrame.MultiFrameType getMultiFrameType() {
        if (this.image instanceof XjDicomObjectFrame) {
            return ((XjDicomObjectFrame)((Object)this.image)).getMultiFrameType();
        }
        return XjDicomObjectFrame.MultiFrameType.SINGLE_FRAME;
    }

    @Override
    public Object getValue(String tagPath) {
        if (this.image instanceof XjDicomObjectFrame) {
            return ((XjDicomObjectFrame)((Object)this.image)).getValue(tagPath);
        }
        return null;
    }

    @Override
    public Object getValue(XjTagValue tag2) {
        if (this.image instanceof XjDicomObjectFrame) {
            return ((XjDicomObjectFrame)((Object)this.image)).getValue(tag2);
        }
        return this.image.getValue(tag2.group, tag2.element);
    }

    @Override
    public Object getValue(int frameNumber, int group, int element) {
        if (this.image instanceof XjDicomObjectFrame) {
            return ((XjDicomObjectFrame)((Object)this.image)).getValue(frameNumber, group, element);
        }
        if (frameNumber == 0) {
            return this.image.getValue(group, element);
        }
        return null;
    }

    @Override
    public Object getValue(int frameNumber, XjTagValue tag2) {
        if (this.image instanceof XjDicomObjectFrame) {
            return ((XjDicomObjectFrame)((Object)this.image)).getValue(frameNumber, tag2);
        }
        if (frameNumber == 0) {
            return this.image.getValue(tag2.group, tag2.element);
        }
        return null;
    }

    @Override
    public int getValues(int frameNumber, XjTagValue[] tags) {
        if (this.image instanceof XjDicomObjectFrame) {
            return ((XjDicomObjectFrame)((Object)this.image)).getValues(frameNumber, tags);
        }
        if (frameNumber == 0 && tags != null) {
            for (int i = 0; i < tags.length; ++i) {
                tags[i].value = this.image.getValue(tags[i].group, tags[i].element);
            }
            return tags.length;
        }
        return 0;
    }

    public static XpMedicalImage[] createImages(XjImage[] imgs) {
        XpMedicalImage[] retimgs = new XpMedicalImage[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            retimgs[i] = XjMedicalImage.createImage(imgs[i]);
        }
        return retimgs;
    }

    public static XpMedicalImage createImage(XjImage img) {
        if (img instanceof RemoteImage) {
            return new Remote((RemoteImage)img);
        }
        if (img != null) {
            return new XjMedicalImage(img);
        }
        return null;
    }

    @Override
    public Object getValue(int group, int element) {
        return this.image.getValue(group, element);
    }

    @Override
    public int getValues(XjTagValue[] tv) {
        return this.image.getValues(tv);
    }

    private static class Remote
    extends XjMedicalImage
    implements XpRemoteMedicalImage {
        public Remote(RemoteImage img) {
            super(img);
        }

        @Override
        public String getRemoteDescriptor() {
            return ((RemoteImage)this.getXjImage()).getRemoteDescriptor();
        }

        @Override
        public double[] getStatistics(Shape s, double angle) {
            return ((RemoteImage)this.getXjImage()).getStatistics(s, angle);
        }

        @Override
        public int[] getPixels(int x, int y, int w, int h, int[] pixels) {
            return ((RemoteImage)this.getXjImage()).getPixels(x, y, w, h, pixels);
        }
    }
}

