/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.filter;

import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.filter.XpBufferedImageProducer;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;

public class XpOperatorImage
implements XpImage {
    public static final int HIST_EQUALIZE = 0;
    public static final int POSITIVE_STRETCH = 1;
    private XpBufferedImageProducer bip = null;
    private int bipKey = -1;
    private BufferedImage bi = null;
    private XpSlice slice = null;
    private boolean loadedDefWWWL = false;
    private double defwidth = 1200.0;
    private double deflevel = 600.0;
    private double azimuth = 0.0;
    private XpPixelStatistics pixStats = null;
    private int stretchPolicy = 0;
    private double rescaleIntercept = 0.0;
    private double rescaleSlope = 1.0;
    private double[] minmax = new double[2];

    public XpOperatorImage(BufferedImage bi, XpSlice slice) {
        this.bi = bi;
        this.slice = slice;
        slice.width = bi.getWidth();
        slice.height = bi.getHeight();
    }

    public XpOperatorImage(XpBufferedImageProducer bip, int key, XpSlice slice) {
        this.bipKey = key;
        this.bip = bip;
        this.slice = slice;
        slice.width = bip.getWidth();
        slice.height = bip.getHeight();
    }

    @Override
    public final RenderedImage getPixelData() {
        if (this.bi == null && this.bip != null && this.bipKey >= 0) {
            int w = this.bip.getWidth();
            int h = this.bip.getHeight();
            int type = this.bip.getBufferedImageType();
            this.bi = new BufferedImage(w, h, type);
            this.bip.fillBufferedImage(this.bi, this.bipKey);
        }
        return this.bi;
    }

    public final DataBuffer getDataBuffer() {
        BufferedImage tbi = (BufferedImage)this.getPixelData();
        return tbi.getRaster().getDataBuffer();
    }

    @Override
    public double getPixelDimensionX() {
        return this.slice.pixelSizeX;
    }

    @Override
    public double getPixelDimensionY() {
        return this.slice.pixelSizeY;
    }

    @Override
    public XpSlice getSlice() {
        return this.slice;
    }

    public void setStretchPolicy(int stretch) {
        this.stretchPolicy = stretch;
    }

    @Override
    public final double getDefaultWindowWidth() {
        if (!this.loadedDefWWWL) {
            this.stretchWWWL();
            this.loadedDefWWWL = true;
        }
        return this.defwidth;
    }

    @Override
    public final double getDefaultWindowLevel() {
        if (!this.loadedDefWWWL) {
            this.stretchWWWL();
            this.loadedDefWWWL = true;
        }
        return this.deflevel;
    }

    @Override
    public final double getRescaleIntercept() {
        return this.rescaleIntercept;
    }

    @Override
    public final double getRescaleSlope() {
        return this.rescaleSlope;
    }

    public final void resetWWWL() {
        this.loadedDefWWWL = false;
    }

    public final void stretchWWWL() {
        XpPixelStatistics ps = this.getPixelStatistics(16);
        double min = this.pixStats.getMin();
        double max = this.pixStats.getMax();
        double oldmin = min;
        if (this.stretchPolicy == 1 && max > 0.0) {
            min = 0.0;
        }
        double ww = max - min;
        double wl = (max + min) / 2.0;
        this.defwidth = (int)ww;
        this.deflevel = (int)wl;
    }

    private XpPixelStatistics getPixelStatistics(int subSampleFactor) {
        if (this.pixStats == null) {
            this.pixStats = XpImageUtils.calcStats(this, subSampleFactor, null);
        } else {
            XpImageUtils.calcStats(this, subSampleFactor, this.pixStats);
        }
        return this.pixStats;
    }

    @Override
    public final double getAzimuth() {
        return this.azimuth;
    }

    public final void setRescaleIntercept(double rIntercept) {
        this.rescaleIntercept = rIntercept;
    }

    public final void setRescaleSlope(double rSlope) {
        this.rescaleSlope = rSlope;
    }
}

